/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PopUpHelper;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class EditPartTipHelper
extends PopUpHelper {
    private static EditPartTipHelper currentHelper;
    private ShellListener shellListener;

    private static void setHelper(EditPartTipHelper helper) {
        if (currentHelper != null && currentHelper != helper && currentHelper.isShowing()) {
            currentHelper.hide();
        }
        currentHelper = helper;
    }

    public EditPartTipHelper(Control c) {
        super(c, 16396);
    }

    public void displayToolTipAt(IFigure tip, int tipPosX, int tipPosY) {
        if (tip != null) {
            int shiftX = 0;
            int shiftY = 0;
            Dimension tipSize = tip.getPreferredSize();
            this.getShell();
            tipSize = tipSize.getExpanded(this.getShellTrimSize());
            Rectangle area = this.control.getDisplay().getClientArea();
            Point end = new Point(tipPosX + tipSize.width, tipPosY + tipSize.height);
            if (!area.contains(end)) {
                shiftX = end.x - (area.x + area.width);
                shiftY = end.y - (area.y + area.height);
                shiftX = shiftX < 0 ? 0 : shiftX;
                shiftY = shiftY < 0 ? 0 : shiftY;
            }
            EditPartTipHelper.setHelper(this);
            this.getLightweightSystem().setContents(tip);
            tip.translateToAbsolute((Translatable)tipSize);
            this.setShellBounds(tipPosX -= shiftX, tipPosY -= shiftY, tipSize.width, tipSize.height);
            this.show();
            this.getShell().setCapture(true);
        }
    }

    public void dispose() {
        if (this.shellListener != null) {
            this.control.getShell().removeShellListener(this.shellListener);
            this.shellListener = null;
        }
        super.dispose();
    }

    protected void hide() {
        super.hide();
        currentHelper = null;
    }

    protected void hookShellListeners() {
        this.getShell().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                EditPartTipHelper.this.getShell().setCapture(false);
                EditPartTipHelper.this.dispose();
            }
        });
        this.getShell().addMouseMoveListener(e -> {
            Point eventPoint = this.getShell().toDisplay(new Point(e.x, e.y));
            if (!this.getShell().getBounds().contains(eventPoint)) {
                if (this.isShowing()) {
                    this.getShell().setCapture(false);
                }
                this.dispose();
            }
        });
        if (this.shellListener == null) {
            this.shellListener = new ShellAdapter(){

                public void shellDeactivated(ShellEvent event) {
                    Display.getCurrent().asyncExec(() -> {
                        Shell active = Display.getCurrent().getActiveShell();
                        if (EditPartTipHelper.this.getShell() == active || EditPartTipHelper.this.control.isDisposed() || EditPartTipHelper.this.control.getShell() == active || EditPartTipHelper.this.getShell().isDisposed()) {
                            return;
                        }
                        if (EditPartTipHelper.this.isShowing()) {
                            EditPartTipHelper.this.getShell().setCapture(false);
                        }
                        EditPartTipHelper.this.dispose();
                    });
                }
            };
            this.control.getShell().addShellListener(this.shellListener);
            this.getShell().addShellListener(this.shellListener);
        }
        if (SWT.getPlatform().equals("gtk")) {
            this.getShell().addPaintListener(event -> {
                Point cursorLoc = Display.getCurrent().getCursorLocation();
                if (!this.getShell().getBounds().contains(cursorLoc)) {
                    Display.getCurrent().asyncExec(() -> {
                        if (this.isShowing()) {
                            this.getShell().setCapture(false);
                        }
                        this.dispose();
                    });
                }
            });
        }
    }

    public static boolean isCurrent(EditPartTipHelper helper) {
        return currentHelper != null && helper == currentHelper;
    }
}

