/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.menu;

import java.awt.event.MouseMotionListener;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.action.DisplayTileTextAction;
import net.sf.freecol.client.gui.menu.DebugMenu;
import net.sf.freecol.client.gui.menu.FreeColMenuBar;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.debug.FreeColDebugger;

public class MapEditorMenuBar
extends FreeColMenuBar {
    private static final Logger logger = Logger.getLogger(MapEditorMenuBar.class.getName());

    public MapEditorMenuBar(FreeColClient freeColClient, MouseMotionListener listener) {
        super(freeColClient, listener);
        this.reset();
    }

    @Override
    public final void reset() {
        this.removeAll();
        this.buildGameMenu();
        this.buildViewMenu();
        this.buildToolsMenu();
        this.buildColopediaMenu();
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
            this.add(new DebugMenu(this.freeColClient));
        }
        this.update();
    }

    private void buildGameMenu() {
        JMenu menu = Utility.localizedMenu("menuBar.game");
        menu.setOpaque(false);
        menu.setMnemonic(71);
        menu.add(this.getMenuItem("newAction"));
        menu.add(this.getMenuItem("newEmptyMapAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("openAction"));
        menu.add(this.getMenuItem("saveAction"));
        menu.add(this.getMenuItem("startMapAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("preferencesAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("showMainAction"));
        menu.add(this.getMenuItem("quitAction"));
        this.add(menu);
    }

    private void buildViewMenu() {
        JMenu menu = Utility.localizedMenu("menuBar.view");
        menu.setOpaque(false);
        menu.setMnemonic(86);
        menu.add(this.getCheckBoxMenuItem("mapControlsAction"));
        menu.add(this.getCheckBoxMenuItem("mapEditorToolboxPanelAction"));
        menu.add(this.getCheckBoxMenuItem("mapEditorTransformPanelAction"));
        menu.add(this.getCheckBoxMenuItem("displayGridAction"));
        menu.add(this.getCheckBoxMenuItem("changeWindowedModeAction"));
        menu.addSeparator();
        ButtonGroup tileTextGroup = new ButtonGroup();
        for (DisplayTileTextAction.DisplayText type : DisplayTileTextAction.DisplayText.values()) {
            menu.add(this.getRadioButtonMenuItem("displayTileTextAction." + type.getKey(), tileTextGroup));
        }
        menu.addSeparator();
        menu.add(this.getMenuItem("zoomInAction"));
        menu.add(this.getMenuItem("zoomOutAction"));
        this.add(menu);
    }

    private void buildToolsMenu() {
        JMenu menu = Utility.localizedMenu("menuBar.tools");
        menu.setOpaque(false);
        menu.setMnemonic(84);
        menu.add(this.getMenuItem("scaleMapAction"));
        menu.add(this.getMenuItem("determineHighSeasAction"));
        this.add(menu);
    }
}

