/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.persister;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.DeleteShareGroupStateRequestData;
import org.apache.kafka.server.share.persister.GroupTopicPartitionData;
import org.apache.kafka.server.share.persister.PartitionFactory;
import org.apache.kafka.server.share.persister.PartitionIdData;
import org.apache.kafka.server.share.persister.PersisterParameters;
import org.apache.kafka.server.share.persister.TopicData;

public class DeleteShareGroupStateParameters
implements PersisterParameters {
    private final GroupTopicPartitionData<PartitionIdData> groupTopicPartitionData;
    public static final DeleteShareGroupStateParameters EMPTY_PARAMS = new DeleteShareGroupStateParameters(new GroupTopicPartitionData.Builder().setGroupId("").setTopicsData(List.of()).build());

    private DeleteShareGroupStateParameters(GroupTopicPartitionData<PartitionIdData> groupTopicPartitionData) {
        this.groupTopicPartitionData = groupTopicPartitionData;
    }

    public static DeleteShareGroupStateParameters from(DeleteShareGroupStateRequestData data) {
        return new Builder().setGroupTopicPartitionData(new GroupTopicPartitionData<PartitionIdData>(data.groupId(), data.topics().stream().map(deleteStateData -> new TopicData(deleteStateData.topicId(), deleteStateData.partitions().stream().map(partitionData -> PartitionFactory.newPartitionIdData(partitionData.partition())).collect(Collectors.toList()))).collect(Collectors.toList()))).build();
    }

    public GroupTopicPartitionData<PartitionIdData> groupTopicPartitionData() {
        return this.groupTopicPartitionData;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteShareGroupStateParameters that = (DeleteShareGroupStateParameters)o;
        return Objects.equals(this.groupTopicPartitionData, that.groupTopicPartitionData);
    }

    public int hashCode() {
        return Objects.hashCode(this.groupTopicPartitionData);
    }

    public static class Builder {
        private GroupTopicPartitionData<PartitionIdData> groupTopicPartitionData;

        public Builder setGroupTopicPartitionData(GroupTopicPartitionData<PartitionIdData> groupTopicPartitionData) {
            this.groupTopicPartitionData = groupTopicPartitionData;
            return this;
        }

        public DeleteShareGroupStateParameters build() {
            return new DeleteShareGroupStateParameters(this.groupTopicPartitionData);
        }
    }
}

