/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.util.Objects;

public class LagInfo {
    private final long currentOffsetPosition;
    private final long endOffsetPosition;
    private final long offsetLag;

    LagInfo(long currentOffsetPosition, long endOffsetPosition) {
        this.currentOffsetPosition = currentOffsetPosition;
        this.endOffsetPosition = endOffsetPosition;
        this.offsetLag = Math.max(0L, endOffsetPosition - currentOffsetPosition);
    }

    public long currentOffsetPosition() {
        return this.currentOffsetPosition;
    }

    public long endOffsetPosition() {
        return this.endOffsetPosition;
    }

    public long offsetLag() {
        return this.offsetLag;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LagInfo)) {
            return false;
        }
        LagInfo other = (LagInfo)obj;
        return this.currentOffsetPosition == other.currentOffsetPosition && this.endOffsetPosition == other.endOffsetPosition && this.offsetLag == other.offsetLag;
    }

    public int hashCode() {
        return Objects.hash(this.currentOffsetPosition, this.endOffsetPosition, this.offsetLag);
    }

    public String toString() {
        return "LagInfo { currentOffsetPosition=" + this.currentOffsetPosition + ", endOffsetPosition=" + this.endOffsetPosition + ", offsetLag=" + this.offsetLag + "}";
    }
}

