/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli;

import java.util.Optional;
import org.kordamp.ikonli.DefaultIkonResolver;
import org.kordamp.ikonli.FontLoader;
import org.kordamp.ikonli.IkonResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class IkonResolverProvider {
    private static volatile IkonResolver instance;

    private IkonResolverProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IkonResolver getInstance(FontLoader fontLoader) {
        IkonResolver localInstance = instance;
        if (localInstance != null) return localInstance;
        Class<IkonResolverProvider> clazz = IkonResolverProvider.class;
        synchronized (IkonResolverProvider.class) {
            localInstance = instance;
            if (localInstance != null) return localInstance;
            instance = localInstance = IkonResolverProvider.createIkonResolver(fontLoader);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    private static IkonResolver createIkonResolver(FontLoader fontLoader) {
        return IkonResolverProvider.tryGetOSGiResolver().orElseGet(() -> DefaultIkonResolver.getInstance(fontLoader));
    }

    private static Optional<IkonResolver> tryGetOSGiResolver() {
        try {
            if (!IkonResolverProvider.isOSGiAvailable()) {
                return Optional.empty();
            }
            Bundle bundle = FrameworkUtil.getBundle(IkonResolverProvider.class);
            if (bundle == null) {
                return Optional.empty();
            }
            BundleContext context = bundle.getBundleContext();
            if (context == null) {
                return Optional.empty();
            }
            ServiceReference ref = context.getServiceReference(IkonResolver.class);
            if (ref == null) {
                return Optional.empty();
            }
            IkonResolver resolver = (IkonResolver)context.getService(ref);
            return Optional.ofNullable(resolver);
        }
        catch (IllegalStateException | NoClassDefFoundError e) {
            return Optional.empty();
        }
    }

    private static boolean isOSGiAvailable() {
        try {
            Class.forName("org.osgi.framework.BundleContext");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

