/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom.props;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.Document;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.hints.pom.PomModelUtils;
import org.netbeans.modules.maven.hints.pom.props.Bundle;
import org.netbeans.modules.maven.hints.pom.spi.Configuration;
import org.netbeans.modules.maven.hints.pom.spi.SelectionPOMFixProvider;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.text.Line;

public class TurnToPropertyHint
implements SelectionPOMFixProvider {
    private static final Logger LOG = Logger.getLogger(TurnToPropertyHint.class.getName());
    private Configuration configuration = new Configuration("TurnToPropertyHint", Bundle.TIT_TurnToPropertyHint(), Bundle.DESC_TurnToPropertyHint(), true, Configuration.HintSeverity.WARNING);

    @Override
    public List<ErrorDescription> getErrorsForDocument(POMModel model, Project prj, int selectionStart, int selectionEnd, int caretPosition) {
        ArrayList<ErrorDescription> err = new ArrayList<ErrorDescription>();
        if (prj == null) {
            return err;
        }
        DocumentComponent comp1 = model.findComponent(selectionStart);
        DocumentComponent comp2 = model.findComponent(selectionEnd);
        if (comp1 == null || comp2 == null) {
            return err;
        }
        if (comp1 == comp2 && comp1 instanceof POMExtensibilityElement) {
            int endOffset;
            int offset;
            String s;
            POMExtensibilityElement el = (POMExtensibilityElement)comp1;
            int startPos = el.findPosition();
            startPos = startPos + el.getQName().getLocalPart().length() + 2;
            String text = el.getElementText();
            int endPos = startPos + text.length();
            if (selectionStart >= startPos && selectionEnd <= endPos && (s = text.substring(offset = selectionStart - startPos, endOffset = selectionEnd - startPos)).length() > 0) {
                ArrayList<PropFix> fixes = new ArrayList<PropFix>();
                String elementName = el.getQName().getLocalPart();
                Map<String, String> props = this.loadAllProperties(prj, model, el, selectionStart);
                for (Map.Entry<String, String> ent : props.entrySet()) {
                    if (!s.equals(ent.getValue()) || elementName.equals(ent.getKey())) continue;
                    fixes.add(new PropFix(text, offset, endOffset, el, model, ent.getKey()));
                }
                fixes.add(new PropFix(text, offset, endOffset, el, model));
                try {
                    Line line = NbEditorUtilities.getLine((Document)model.getBaseDocument(), (int)selectionEnd, (boolean)false);
                    err.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)Bundle.TIT_TurnToPropertyHint(), fixes, (Document)model.getBaseDocument(), (int)(line.getLineNumber() + 1)));
                }
                catch (IndexOutOfBoundsException iiob) {
                    LOG.log(Level.FINE, "document changed", iiob);
                }
            }
        }
        return err;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    private Map<String, String> loadAllProperties(Project prj, POMModel mdl, POMExtensibilityElement el, int position) {
        org.netbeans.modules.maven.model.pom.Properties pp;
        Map mdlprops;
        Profile prof;
        Properties p;
        HashMap<String, String> props = new HashMap<String, String>();
        NbMavenProject nbprj = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        if (nbprj != null) {
            MavenProject mp = nbprj.getMavenProject();
            p = mp.getProperties();
            if (p != null) {
                for (Map.Entry<Object, Object> ent : p.entrySet()) {
                    if (ent.getKey() == null || ent.getValue() == null) continue;
                    props.put(ent.getKey().toString(), ent.getValue().toString());
                }
            }
            props.put("project.groupId", mp.getGroupId());
            props.put("project.artifactId", mp.getArtifactId());
            props.put("project.version", mp.getVersion());
        }
        if ((prof = (Profile)mdl.findComponent(position, Profile.class, true)) != null && (p = prof.getProperties()) != null && (mdlprops = p.getProperties()) != null) {
            props.putAll(mdlprops);
        }
        if ((pp = mdl.getProject().getProperties()) != null && (mdlprops = pp.getProperties()) != null) {
            props.putAll(mdlprops);
        }
        return props;
    }

    private static class PropFix
    implements Fix {
        private POMModel mdl;
        private final int start;
        private final int end;
        private String key;
        private final String old;
        private final POMExtensibilityElement element;

        PropFix(String oldValue, int offset, int endOffset, POMExtensibilityElement el, POMModel model) {
            this(oldValue, offset, endOffset, el, model, null);
        }

        private PropFix(String oldValue, int offset, int endOffset, POMExtensibilityElement el, POMModel model, String key) {
            this.mdl = model;
            this.old = oldValue;
            this.start = offset;
            this.end = endOffset;
            this.key = key;
            this.element = el;
        }

        public String getText() {
            return this.key != null ? Bundle.TXT_Replace("${" + this.key + "}") : Bundle.TXT_Create();
        }

        public ChangeInfo implement() throws Exception {
            ChangeInfo info = new ChangeInfo();
            if (!this.mdl.getState().equals((Object)Model.State.VALID)) {
                return info;
            }
            final Boolean[] create = new Boolean[]{Boolean.FALSE};
            if (this.key == null) {
                NotifyDescriptor.InputLine nd = new NotifyDescriptor.InputLine(Bundle.TXT_Enter(), Bundle.TIT_Enter());
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.OK_OPTION) {
                    this.key = nd.getInputText();
                    create[0] = Boolean.TRUE;
                } else {
                    return info;
                }
            }
            PomModelUtils.implementInTransaction((Model)this.mdl, new Runnable(){
                final /* synthetic */ PropFix this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    String newVal = this.this$0.old.substring(0, this.this$0.start) + "${" + this.this$0.key + "}" + this.this$0.old.substring(this.this$0.end);
                    this.this$0.element.setElementText(newVal);
                    if (create[0].equals(Boolean.TRUE)) {
                        Profile prof = (Profile)this.this$0.mdl.findComponent(this.this$0.element.findPosition(), Profile.class, true);
                        if (prof != null) {
                            org.netbeans.modules.maven.model.pom.Properties props = prof.getProperties();
                            if (props == null) {
                                props = this.this$0.mdl.getFactory().createProperties();
                                prof.setProperties(props);
                            }
                            props.setProperty(this.this$0.key, this.this$0.old.substring(this.this$0.start, this.this$0.end));
                        } else {
                            org.netbeans.modules.maven.model.pom.Properties props = this.this$0.mdl.getProject().getProperties();
                            if (props == null) {
                                props = this.this$0.mdl.getFactory().createProperties();
                                this.this$0.mdl.getProject().setProperties(props);
                            }
                            props.setProperty(this.this$0.key, this.this$0.old.substring(this.this$0.start, this.this$0.end));
                        }
                    }
                }
            });
            return info;
        }
    }
}

