/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import com.sun.tools.classfile.Attribute;
import com.sun.tools.classfile.ClassReader;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Attributes
implements Iterable<Attribute> {
    public final Attribute[] attrs;
    public final Map<String, Attribute> map;

    Attributes(ClassReader cr) throws IOException {
        this.map = new HashMap<String, Attribute>();
        int attrs_count = cr.readUnsignedShort();
        this.attrs = new Attribute[attrs_count];
        for (int i = 0; i < attrs_count; ++i) {
            Attribute attr;
            this.attrs[i] = attr = Attribute.read(cr);
            try {
                this.map.put(attr.getName(cr.getConstantPool()), attr);
                continue;
            }
            catch (ConstantPoolException constantPoolException) {
                // empty catch block
            }
        }
    }

    public Attributes(ConstantPool constant_pool, Attribute[] attrs) {
        this.attrs = attrs;
        this.map = new HashMap<String, Attribute>();
        for (Attribute attr : attrs) {
            try {
                this.map.put(attr.getName(constant_pool), attr);
            }
            catch (ConstantPoolException constantPoolException) {
                // empty catch block
            }
        }
    }

    public Attributes(Map<String, Attribute> attributes) {
        this.attrs = attributes.values().toArray(new Attribute[attributes.size()]);
        this.map = attributes;
    }

    @Override
    public Iterator<Attribute> iterator() {
        return Arrays.asList(this.attrs).iterator();
    }

    public Attribute get(int index) {
        return this.attrs[index];
    }

    public Attribute get(String name) {
        return this.map.get(name);
    }

    public int getIndex(ConstantPool constant_pool, String name) {
        for (int i = 0; i < this.attrs.length; ++i) {
            Attribute attr = this.attrs[i];
            try {
                if (attr == null || !attr.getName(constant_pool).equals(name)) continue;
                return i;
            }
            catch (ConstantPoolException constantPoolException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int size() {
        return this.attrs.length;
    }

    public int byteLength() {
        int length = 2;
        for (Attribute a : this.attrs) {
            length += a.byteLength();
        }
        return length;
    }
}

