/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ClusterMigrateToNativeVcnStatus
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeDecommissionScheduled")
    private final Date timeDecommissionScheduled;
    @JsonProperty(value="state")
    private final State state;

    @Deprecated
    @ConstructorProperties(value={"timeDecommissionScheduled", "state"})
    public ClusterMigrateToNativeVcnStatus(Date timeDecommissionScheduled, State state) {
        this.timeDecommissionScheduled = timeDecommissionScheduled;
        this.state = state;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeDecommissionScheduled() {
        return this.timeDecommissionScheduled;
    }

    public State getState() {
        return this.state;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ClusterMigrateToNativeVcnStatus(");
        sb.append("super=").append(super.toString());
        sb.append("timeDecommissionScheduled=").append(String.valueOf(this.timeDecommissionScheduled));
        sb.append(", state=").append(String.valueOf((Object)this.state));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterMigrateToNativeVcnStatus)) {
            return false;
        }
        ClusterMigrateToNativeVcnStatus other = (ClusterMigrateToNativeVcnStatus)((Object)o);
        return Objects.equals(this.timeDecommissionScheduled, other.timeDecommissionScheduled) && Objects.equals((Object)this.state, (Object)other.state) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeDecommissionScheduled == null ? 43 : this.timeDecommissionScheduled.hashCode());
        result = result * 59 + (this.state == null ? 43 : this.state.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum State implements BmcEnum
    {
        NotStarted("NOT_STARTED"),
        Requested("REQUESTED"),
        InProgress("IN_PROGRESS"),
        PendingDecommission("PENDING_DECOMMISSION"),
        Completed("COMPLETED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, State> map;

        private State(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static State create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'State', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(State.class);
            map = new HashMap<String, State>();
            for (State v : State.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeDecommissionScheduled")
        private Date timeDecommissionScheduled;
        @JsonProperty(value="state")
        private State state;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeDecommissionScheduled(Date timeDecommissionScheduled) {
            this.timeDecommissionScheduled = timeDecommissionScheduled;
            this.__explicitlySet__.add("timeDecommissionScheduled");
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }

        public ClusterMigrateToNativeVcnStatus build() {
            ClusterMigrateToNativeVcnStatus model = new ClusterMigrateToNativeVcnStatus(this.timeDecommissionScheduled, this.state);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ClusterMigrateToNativeVcnStatus model) {
            if (model.wasPropertyExplicitlySet("timeDecommissionScheduled")) {
                this.timeDecommissionScheduled(model.getTimeDecommissionScheduled());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            return this;
        }
    }
}

