/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cloud.oracle.Bundle;
import org.netbeans.modules.cloud.oracle.OCIProfile;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ConnectProfilePanel
extends JPanel {
    private List<OCIProfile> allProfiles;
    private DefaultListModel<OCIProfile> model = new DefaultListModel();
    private JPanel cards;
    private JScrollPane jScrollPane1;
    private JLabel lblConfig;
    private JLabel lblMessageIcon;
    private JLabel lblProfiles;
    private JList<OCIProfile> lstProfiles;
    private JPanel message;
    private JPanel profilesSelection;
    private JScrollPane scrProfiles;
    private JTextPane textMessage;
    private JTextField txConfigPath;

    public ConnectProfilePanel() {
        this.initComponents();
        ((CardLayout)this.cards.getLayout()).show(this.cards, "msg");
        this.lblMessageIcon.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cloud/oracle/resources/info.png", (boolean)false));
        this.lstProfiles.setCellRenderer(new R());
        this.textMessage.setEditable(false);
        this.textMessage.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        desktop.browse(hle.getURL().toURI());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    public void setProfiles(List<OCIProfile> profiles) {
        DefaultListModel<OCIProfile> mdl = new DefaultListModel<OCIProfile>();
        for (OCIProfile p : profiles) {
            mdl.addElement(p);
        }
        this.lstProfiles.setModel(mdl);
        this.model = mdl;
        ((CardLayout)this.cards.getLayout()).show(this.cards, "profiles");
    }

    public void showErrorMessage(String msg) {
        this.lblMessageIcon.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cloud/oracle/resources/error.png", (boolean)false));
        this.textMessage.setContentType("text/html");
        this.textMessage.setText(msg);
        ((CardLayout)this.cards.getLayout()).show(this.cards, "msg");
    }

    public void setSelectedProfiles(List<OCIProfile> profiles) {
        this.lstProfiles.clearSelection();
        for (OCIProfile p : profiles) {
            int index = this.model.indexOf(p);
            if (index < 0) continue;
            this.lstProfiles.getSelectionModel().addSelectionInterval(index, index);
        }
    }

    public boolean isContentValid() {
        return !this.lstProfiles.getSelectedValuesList().isEmpty();
    }

    public List<OCIProfile> getSelectedProfiles() {
        return new ArrayList<OCIProfile>(this.lstProfiles.getSelectedValuesList());
    }

    private void initComponents() {
        this.txConfigPath = new JTextField();
        this.lblConfig = new JLabel();
        this.cards = new JPanel();
        this.profilesSelection = new JPanel();
        this.lblProfiles = new JLabel();
        this.scrProfiles = new JScrollPane();
        this.lstProfiles = new JList();
        this.message = new JPanel();
        this.lblMessageIcon = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.textMessage = new JTextPane();
        this.txConfigPath.setEditable(false);
        this.txConfigPath.setText(NbBundle.getMessage(ConnectProfilePanel.class, (String)"ConnectProfilePanel.txConfigPath.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblConfig, (String)NbBundle.getMessage(ConnectProfilePanel.class, (String)"ConnectProfilePanel.lblConfig.text"));
        this.cards.setLayout(new CardLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblProfiles, (String)NbBundle.getMessage(ConnectProfilePanel.class, (String)"ConnectProfilePanel.lblProfiles.text"));
        this.lstProfiles.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ConnectProfilePanel.this.lstProfilesValueChanged(evt);
            }
        });
        this.scrProfiles.setViewportView(this.lstProfiles);
        GroupLayout profilesSelectionLayout = new GroupLayout(this.profilesSelection);
        this.profilesSelection.setLayout(profilesSelectionLayout);
        profilesSelectionLayout.setHorizontalGroup(profilesSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(profilesSelectionLayout.createSequentialGroup().addContainerGap().addComponent(this.lblProfiles).addGap(61, 61, 61).addComponent(this.scrProfiles, -1, 292, Short.MAX_VALUE).addContainerGap()));
        profilesSelectionLayout.setVerticalGroup(profilesSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(profilesSelectionLayout.createSequentialGroup().addContainerGap().addGroup(profilesSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrProfiles, -1, 125, Short.MAX_VALUE).addGroup(profilesSelectionLayout.createSequentialGroup().addComponent(this.lblProfiles).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.cards.add((Component)this.profilesSelection, "profiles");
        Mnemonics.setLocalizedText((JLabel)this.lblMessageIcon, (String)NbBundle.getMessage(ConnectProfilePanel.class, (String)"ConnectProfilePanel.lblMessageIcon.text"));
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.textMessage.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.textMessage.setText(NbBundle.getMessage(ConnectProfilePanel.class, (String)"ConnectProfilePanel.textMessage.text"));
        this.jScrollPane1.setViewportView(this.textMessage);
        GroupLayout messageLayout = new GroupLayout(this.message);
        this.message.setLayout(messageLayout);
        messageLayout.setHorizontalGroup(messageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(messageLayout.createSequentialGroup().addGap(97, 97, 97).addComponent(this.lblMessageIcon, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 291, -2).addContainerGap()));
        messageLayout.setVerticalGroup(messageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(messageLayout.createSequentialGroup().addContainerGap().addGroup(messageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(messageLayout.createSequentialGroup().addComponent(this.lblMessageIcon).addContainerGap(112, Short.MAX_VALUE)).addComponent(this.jScrollPane1))));
        this.cards.add((Component)this.message, "msg");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cards, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.lblConfig).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txConfigPath).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txConfigPath, -2, -1, -2).addComponent(this.lblConfig)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cards, -1, -1, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void lstProfilesValueChanged(ListSelectionEvent evt) {
        this.firePropertyChange("contentValid", null, null);
    }

    static class R
    extends DefaultListCellRenderer {
        R() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            OCIProfile p = (OCIProfile)value;
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (!(c instanceof JLabel)) {
                return c;
            }
            JLabel l = (JLabel)c;
            l.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cloud/oracle/resources/tenancy.svg", (boolean)false));
            if (p.isDefaultConfig()) {
                l.setText(Bundle.LBL_DefaultConfigProfile(p.getTenancyData().getName(), p.getId()));
            } else {
                l.setText(Bundle.LBL_CustomConfigProfile(p.getTenancyData().getName(), p.getId(), p.getConfigPath().getFileName().toString()));
                l.setToolTipText(p.getConfigPath().toString());
            }
            l.setToolTipText(p.getTenancy().get().getDescription());
            return c;
        }
    }
}

