/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.commons;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.openide.awt.UndoRedo;
import org.openide.util.ChangeSupport;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class UndoRedoSupport {
    private static final Pattern DELIMITER_PATTERN = Pattern.compile("[ ,:;.!?\n\t]");
    private final DelegateManager delegateManager;
    private static final String ACTION_NAME_UNDO = "undo.action";
    private static final String ACTION_NAME_REDO = "redo.action";
    private final RequestProcessor rp = new RequestProcessor("Bugtracking undoredo", 50);
    private static final String REGISTER_TASK = "hyperlink.task";
    private final UndoRedoListener undoRedoListener = new UndoRedoListener();
    private final RegisterTask registerTask = new RegisterTask();

    public UndoRedoSupport() {
        this.delegateManager = new DelegateManager();
    }

    public synchronized UndoRedo getUndoRedo() {
        return this.delegateManager;
    }

    public void register(final TopComponent tc, boolean register) {
        if (register) {
            tc.removeContainerListener((ContainerListener)this.undoRedoListener);
            tc.addContainerListener((ContainerListener)this.undoRedoListener);
            RequestProcessor.Task task = this.rp.create(new Runnable(){
                final /* synthetic */ UndoRedoSupport this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.undoRedoListener.register((Component)tc, true);
                }
            });
            tc.putClientProperty((Object)REGISTER_TASK, (Object)task);
            task.schedule(1000);
        } else {
            this.unregisterAll();
        }
    }

    private void register(JTextComponent component) {
        this.delegateManager.add(new CompoundUndoManager(component));
    }

    private void unregisterAll() {
        this.delegateManager.removeAll();
    }

    private void unregister(JTextComponent component) {
        this.delegateManager.remove(component);
    }

    private class RegisterTask
    implements Runnable {
        private final ConcurrentLinkedQueue<JTextComponent> toRegister = new ConcurrentLinkedQueue();
        private final ConcurrentLinkedQueue<JTextComponent> toUnregister = new ConcurrentLinkedQueue();
        private final RequestProcessor.Task task;

        public RegisterTask() {
            this.task = UndoRedoSupport.this.rp.create((Runnable)this);
        }

        void add(JTextComponent tx) {
            this.toRegister.add(tx);
            this.task.schedule(500);
        }

        void remove(JTextComponent tx) {
            this.toUnregister.add(tx);
            this.task.schedule(500);
        }

        @Override
        public void run() {
            for (JTextComponent txt : this.toHandle(this.toRegister)) {
                UndoRedoSupport.this.register(txt);
            }
            for (JTextComponent txt : this.toHandle(this.toUnregister)) {
                UndoRedoSupport.this.unregister(txt);
            }
        }

        public List<JTextComponent> toHandle(ConcurrentLinkedQueue<JTextComponent> q) {
            JTextComponent tx;
            LinkedList<JTextComponent> rs = new LinkedList<JTextComponent>();
            while ((tx = q.poll()) != null) {
                rs.add(tx);
            }
            return rs;
        }
    }

    private class DelegateManager
    implements UndoRedo {
        private final List<CompoundUndoManager> delegates = new LinkedList<CompoundUndoManager>();

        private DelegateManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean canUndo() {
            List<CompoundUndoManager> list = this.delegates;
            synchronized (list) {
                for (CompoundUndoManager cm : this.delegates) {
                    if (!cm.hasFocus()) continue;
                    return cm.canUndo();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean canRedo() {
            List<CompoundUndoManager> list = this.delegates;
            synchronized (list) {
                for (CompoundUndoManager cm : this.delegates) {
                    if (!cm.hasFocus()) continue;
                    return cm.canRedo();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undo() throws CannotUndoException {
            List<CompoundUndoManager> list = this.delegates;
            synchronized (list) {
                for (CompoundUndoManager cm : this.delegates) {
                    if (!cm.hasFocus()) continue;
                    cm.undo();
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void redo() throws CannotRedoException {
            List<CompoundUndoManager> list = this.delegates;
            synchronized (list) {
                for (CompoundUndoManager cm : this.delegates) {
                    if (!cm.hasFocus()) continue;
                    cm.redo();
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener l) {
            List<CompoundUndoManager> list = this.delegates;
            synchronized (list) {
                for (CompoundUndoManager cm : this.delegates) {
                    cm.addChangeListener(l);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener l) {
            List<CompoundUndoManager> list = this.delegates;
            synchronized (list) {
                for (CompoundUndoManager cm : this.delegates) {
                    cm.removeChangeListener(l);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void discardAllEdits() {
            List<CompoundUndoManager> list = this.delegates;
            synchronized (list) {
                for (CompoundUndoManager cm : this.delegates) {
                    cm.discardAllEdits();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getUndoPresentationName() {
            List<CompoundUndoManager> list = this.delegates;
            synchronized (list) {
                for (CompoundUndoManager cm : this.delegates) {
                    if (!cm.hasFocus()) continue;
                    return cm.getUndoPresentationName();
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getRedoPresentationName() {
            List<CompoundUndoManager> list = this.delegates;
            synchronized (list) {
                for (CompoundUndoManager cm : this.delegates) {
                    if (!cm.hasFocus()) continue;
                    return cm.getRedoPresentationName();
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(CompoundUndoManager cum) {
            cum.component.getDocument().addUndoableEditListener((UndoableEditListener)((Object)cum));
            cum.component.addFocusListener(cum);
            cum.component.getInputMap().put(KeyStroke.getKeyStroke(90, 128), UndoRedoSupport.ACTION_NAME_UNDO);
            cum.component.getInputMap().put(KeyStroke.getKeyStroke(90, 256), UndoRedoSupport.ACTION_NAME_UNDO);
            cum.component.getInputMap().put(KeyStroke.getKeyStroke(65483, 0), UndoRedoSupport.ACTION_NAME_UNDO);
            cum.component.getActionMap().put(UndoRedoSupport.ACTION_NAME_UNDO, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (UndoRedoSupport.this.delegateManager.canUndo()) {
                        UndoRedoSupport.this.delegateManager.undo();
                    }
                }
            });
            cum.component.getInputMap().put(KeyStroke.getKeyStroke(89, 128), UndoRedoSupport.ACTION_NAME_REDO);
            cum.component.getInputMap().put(KeyStroke.getKeyStroke(89, 256), UndoRedoSupport.ACTION_NAME_REDO);
            cum.component.getInputMap().put(KeyStroke.getKeyStroke(65481, 0), UndoRedoSupport.ACTION_NAME_UNDO);
            cum.component.getActionMap().put(UndoRedoSupport.ACTION_NAME_REDO, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (UndoRedoSupport.this.delegateManager.canRedo()) {
                        UndoRedoSupport.this.delegateManager.redo();
                    }
                }
            });
            List<CompoundUndoManager> list = this.delegates;
            synchronized (list) {
                this.delegates.add(cum);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeAll() {
            this.discardAllEdits();
            List<CompoundUndoManager> list = this.delegates;
            synchronized (list) {
                Iterator<CompoundUndoManager> it = this.delegates.iterator();
                while (it.hasNext()) {
                    CompoundUndoManager cum = it.next();
                    cum.component.getDocument().removeUndoableEditListener((UndoableEditListener)((Object)cum));
                    cum.component.removeFocusListener(cum);
                    cum.component.getActionMap().remove(UndoRedoSupport.ACTION_NAME_UNDO);
                    cum.component.getActionMap().remove(UndoRedoSupport.ACTION_NAME_REDO);
                    it.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(JTextComponent component) {
            List<CompoundUndoManager> list = this.delegates;
            synchronized (list) {
                Iterator<CompoundUndoManager> it = this.delegates.iterator();
                while (it.hasNext()) {
                    CompoundUndoManager cum = it.next();
                    if (component != cum.component) continue;
                    cum.component.getDocument().removeUndoableEditListener((UndoableEditListener)((Object)cum));
                    cum.component.removeFocusListener(cum);
                    cum.component.getActionMap().remove(UndoRedoSupport.ACTION_NAME_UNDO);
                    cum.component.getActionMap().remove(UndoRedoSupport.ACTION_NAME_REDO);
                    it.remove();
                    break;
                }
            }
        }
    }

    private class UndoRedoListener
    implements ContainerListener {
        private UndoRedoListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            Component c = e.getChild();
            while ((c = c.getParent()) != null) {
                if (!(c instanceof TopComponent)) continue;
                RequestProcessor.Task t = (RequestProcessor.Task)((TopComponent)c).getClientProperty((Object)UndoRedoSupport.REGISTER_TASK);
                if (t == null) break;
                t.schedule(1000);
                break;
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            this.register((Container)e.getComponent(), false);
        }

        private void register(Component c, boolean register) {
            if (c instanceof JTextComponent) {
                JTextComponent tx = (JTextComponent)c;
                if (register) {
                    UndoRedoSupport.this.registerTask.add(tx);
                } else {
                    UndoRedoSupport.this.registerTask.remove(tx);
                }
            }
            if (c instanceof Container) {
                Component[] components;
                Container container = (Container)c;
                container.removeContainerListener(this);
                if (register) {
                    container.addContainerListener(this);
                }
                for (Component cmp : components = container.getComponents()) {
                    this.register(cmp, register);
                }
            }
        }
    }

    private class CompoundUndoManager
    extends UndoRedo.Manager
    implements FocusListener {
        private final ChangeSupport support = new ChangeSupport((Object)this);
        private CompoundEdit edit;
        private int lastOffset;
        private int lastLength;
        private final JTextComponent component;

        public CompoundUndoManager(JTextComponent component) {
            this.component = component;
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            assert (this.component != null);
            if (this.edit == null) {
                this.startNewEdit(this.component, e.getEdit());
                this.processDocumentChange(this.component);
                return;
            }
            UndoableEdit event = e.getEdit();
            if (event instanceof DocumentEvent && ((DocumentEvent)((Object)event)).getType().equals(DocumentEvent.EventType.CHANGE)) {
                this.edit.addEdit(e.getEdit());
                return;
            }
            int offsetChange = this.component.getCaretPosition() - this.lastOffset;
            int lengthChange = this.component.getDocument().getLength() - this.lastLength;
            if (Math.abs(offsetChange) == 1 && Math.abs(lengthChange) == 1) {
                this.lastOffset = this.component.getCaretPosition();
                this.lastLength = this.component.getDocument().getLength();
                super.undoableEditHappened(e);
                this.processDocumentChange(this.component);
            } else {
                this.startNewEdit(this.component, e.getEdit());
            }
        }

        private void startNewEdit(JTextComponent component, UndoableEdit atomicEdit) {
            if (this.edit != null) {
                this.edit.end();
            }
            this.edit = new MyCompoundEdit();
            this.edit.addEdit(atomicEdit);
            super.undoableEditHappened(new UndoableEditEvent(component, this.edit));
            this.lastOffset = component.getCaretPosition();
            this.lastLength = component.getDocument().getLength();
        }

        private void processDocumentChange(JTextComponent component) {
            boolean endEdit;
            boolean bl = endEdit = this.lastOffset == 0;
            if (!endEdit) {
                try {
                    String lastChar = component.getDocument().getText(this.lastOffset - 1, 1);
                    endEdit = DELIMITER_PATTERN.matcher(lastChar).matches();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (endEdit) {
                this.edit.end();
                this.edit = null;
            }
        }

        public void addChangeListener(ChangeListener l) {
            super.addChangeListener(l);
            this.support.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            super.removeChangeListener(l);
            this.support.removeChangeListener(l);
        }

        public synchronized boolean canRedo() {
            boolean can = super.canRedo();
            if (!can) {
                return can;
            }
            return super.canRedo() && this.component != null && this.component.hasFocus();
        }

        public synchronized boolean canUndo() {
            return super.canUndo() && this.component != null && this.component.hasFocus();
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.support.fireChange();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.support.fireChange();
        }

        boolean hasFocus() {
            return this.component.hasFocus();
        }

        private class MyCompoundEdit
        extends CompoundEdit {
            private MyCompoundEdit() {
            }

            @Override
            public boolean isInProgress() {
                return false;
            }

            @Override
            public void undo() throws CannotUndoException {
                if (CompoundUndoManager.this.edit != null) {
                    CompoundUndoManager.this.edit.end();
                }
                super.undo();
                CompoundUndoManager.this.edit = null;
            }
        }
    }
}

