/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.codegeneration;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestination;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.ActivationConfig;
import org.netbeans.modules.j2ee.dd.api.ejb.ActivationConfigProperty;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.ContainerTransaction;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Method;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.EjbGenerationUtil;
import org.netbeans.modules.j2ee.ejbcore.api.codegeneration.JmsDestinationDefinition;
import org.netbeans.modules.j2ee.ejbcore.naming.EJBNameOptions;
import org.netbeans.modules.javaee.specs.support.api.JmsSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class MessageGenerator {
    private static final String EJB21_EJBCLASS = "Templates/J2EE/EJB21/MessageDrivenEjbClass.java";
    private static final String EJB30_MESSAGE_DRIVEN_BEAN = "Templates/J2EE/EJB30/MessageDrivenBean.java";
    private static final String DESTINATION_LOOKUP = "destinationLookup";
    private static final String QUEUE_INTERFACE = "javax.jms.Queue";
    private static final String TOPIC_INTERFACE = "javax.jms.Topic";
    private final FileObject pkg;
    private final org.netbeans.modules.j2ee.deployment.common.api.MessageDestination messageDestination;
    private final boolean isSimplified;
    private final boolean isXmlBased;
    private final Profile profile;
    private final JmsSupport jmsSupport;
    private final EJBNameOptions ejbNameOptions;
    private final String ejbName;
    private final String ejbClassName;
    private final String displayName;
    private final String packageName;
    private final String packageNameWithDot;
    private final Map<String, Object> templateParameters;

    public static MessageGenerator create(Profile profile, String wizardTargetName, FileObject pkg, org.netbeans.modules.j2ee.deployment.common.api.MessageDestination messageDestination, boolean isSimplified, Map<String, String> properties, JmsSupport jmsSupport) {
        return new MessageGenerator(profile, wizardTargetName, pkg, messageDestination, isSimplified, properties, jmsSupport, false);
    }

    protected MessageGenerator(Profile profile, String wizardTargetName, FileObject pkg, org.netbeans.modules.j2ee.deployment.common.api.MessageDestination messageDestination, boolean isSimplified, Map<String, String> properties, JmsSupport jmsSupport, boolean isTest) {
        this.pkg = pkg;
        this.messageDestination = messageDestination;
        this.isSimplified = isSimplified;
        this.isXmlBased = !isSimplified;
        this.ejbNameOptions = new EJBNameOptions();
        this.ejbName = this.ejbNameOptions.getMessageDrivenEjbNamePrefix() + wizardTargetName + this.ejbNameOptions.getMessageDrivenEjbNameSuffix();
        this.ejbClassName = this.ejbNameOptions.getMessageDrivenEjbClassPrefix() + wizardTargetName + this.ejbNameOptions.getMessageDrivenEjbClassSuffix();
        this.displayName = this.ejbNameOptions.getMessageDrivenDisplayNamePrefix() + wizardTargetName + this.ejbNameOptions.getMessageDrivenDisplayNameSuffix();
        this.packageName = EjbGenerationUtil.getSelectedPackageName(pkg);
        this.packageNameWithDot = this.packageName + ".";
        this.templateParameters = new HashMap<String, Object>();
        this.profile = profile;
        this.jmsSupport = jmsSupport;
        boolean useMappedName = this.useMappedName();
        if (profile != null && profile.isAtLeast(Profile.JAVA_EE_7_WEB) && jmsSupport.useDestinationLookup()) {
            String destination = properties.get(DESTINATION_LOOKUP) == null || properties.get(DESTINATION_LOOKUP).isEmpty() ? messageDestination.getName() : properties.get(DESTINATION_LOOKUP);
            properties.put(DESTINATION_LOOKUP, destination);
        } else if (!useMappedName) {
            properties.put(jmsSupport.activationConfigProperty(), messageDestination.getName());
        }
        this.templateParameters.put("package", this.packageName);
        this.templateParameters.put("messageDestinationName", messageDestination.getName());
        this.templateParameters.put("activationConfigProperties", MessageGenerator.transformProperties(properties));
        this.templateParameters.put("useMappedName", useMappedName);
        if (isTest) {
            this.templateParameters.put("date", "{date}");
            this.templateParameters.put("time", "{time}");
            this.templateParameters.put("user", "{user}");
        }
    }

    private static List<KeyValuePair> transformProperties(Map<String, String> properties) {
        ArrayList<KeyValuePair> props = new ArrayList<KeyValuePair>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            props.add(new KeyValuePair(entry.getKey(), entry.getValue()));
        }
        return props;
    }

    public FileObject generate() throws IOException {
        FileObject resultFileObject = null;
        if (this.isSimplified) {
            resultFileObject = this.generateEJB30Classes();
            if (this.isXmlBased) {
                this.generateEJB30Xml();
            }
        } else {
            resultFileObject = this.generateEJB21Classes();
            if (this.isXmlBased) {
                try {
                    this.generateEJB21Xml();
                }
                catch (VersionNotSupportedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            try {
                Project project = FileOwnerQuery.getOwner((FileObject)this.pkg);
                J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
                j2eeModuleProvider.getConfigSupport().bindMdbToMessageDestination(this.ejbName, this.messageDestination.getName(), this.messageDestination.getType());
            }
            catch (ConfigurationException ce) {
                Exceptions.printStackTrace((Throwable)ce);
            }
        }
        return resultFileObject;
    }

    private FileObject generateEJB21Classes() throws IOException {
        return GenerationUtils.createClass((String)EJB21_EJBCLASS, (FileObject)this.pkg, (String)this.ejbClassName, null, this.templateParameters);
    }

    private boolean isQueue() {
        return MessageDestination.Type.QUEUE.equals((Object)this.messageDestination.getType());
    }

    private FileObject generateEJB30Classes() throws IOException {
        FileObject mdb = GenerationUtils.createClass((String)EJB30_MESSAGE_DRIVEN_BEAN, (FileObject)this.pkg, (String)this.ejbClassName, null, this.templateParameters);
        if (this.messageDestination instanceof JmsDestinationDefinition && ((JmsDestinationDefinition)this.messageDestination).isToGenerate()) {
            this.generateJMSDestinationDefinition(mdb, (JmsDestinationDefinition)this.messageDestination);
        }
        return mdb;
    }

    private void generateJMSDestinationDefinition(FileObject classFile, final JmsDestinationDefinition def) throws IOException {
        JavaSource js = JavaSource.forFileObject((FileObject)classFile);
        js.runModificationTask((Task)new Task<WorkingCopy>(){
            final /* synthetic */ MessageGenerator this$0;
            {
                this.this$0 = this$0;
            }

            public void run(WorkingCopy parameter) throws Exception {
                parameter.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement classElement = parameter.getElements().getTypeElement(this.this$0.packageNameWithDot + this.this$0.ejbClassName);
                ClassTree classTree = parameter.getTrees().getTree(classElement);
                ModifiersTree modifiers = classTree.getModifiers();
                TypeElement el = parameter.getElements().getTypeElement("javax.jms.JMSDestinationDefinition");
                TreeMaker tm = parameter.getTreeMaker();
                ArrayList<AssignmentTree> values = new ArrayList<AssignmentTree>(2);
                ExpressionTree nameQualIdent = tm.QualIdent("name");
                values.add(tm.Assignment(nameQualIdent, (ExpressionTree)tm.Literal((Object)def.getName())));
                ExpressionTree classnameQualIdent = tm.QualIdent("interfaceName");
                values.add(tm.Assignment(classnameQualIdent, (ExpressionTree)tm.Literal((Object)MessageGenerator.getInterfaceName(def))));
                ExpressionTree resourceAdapterQualIdent = tm.QualIdent("resourceAdapter");
                values.add(tm.Assignment(resourceAdapterQualIdent, (ExpressionTree)tm.Literal((Object)"jmsra")));
                ExpressionTree destinationNameQualIdent = tm.QualIdent("destinationName");
                values.add(tm.Assignment(destinationNameQualIdent, (ExpressionTree)tm.Literal((Object)MessageGenerator.getPhysicalName(def.getName()))));
                ArrayList<? extends AnnotationTree> annotations = new ArrayList<AnnotationTree>(modifiers.getAnnotations());
                annotations.add(0, tm.Annotation((Tree)tm.QualIdent((Element)el), values));
                ModifiersTree nueMods = tm.Modifiers(modifiers, annotations);
                parameter.rewrite((Tree)modifiers, (Tree)nueMods);
            }
        }).commit();
    }

    private static String getPhysicalName(String jndiName) {
        int lastSlashIndex = jndiName.lastIndexOf("/");
        if (lastSlashIndex == -1) {
            return jndiName;
        }
        return jndiName.substring(lastSlashIndex + 1);
    }

    private static String getInterfaceName(JmsDestinationDefinition def) {
        String interfaceName = null;
        switch (def.getType()) {
            case QUEUE: {
                interfaceName = QUEUE_INTERFACE;
                break;
            }
            case TOPIC: {
                interfaceName = TOPIC_INTERFACE;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return interfaceName;
    }

    private void generateEJB21Xml() throws IOException, VersionNotSupportedException {
        org.netbeans.modules.j2ee.api.ejbjar.EjbJar ejbModule = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)this.pkg);
        EjbJar ejbJar = DDProvider.getDefault().getDDRoot(ejbModule.getDeploymentDescriptor());
        EnterpriseBeans beans = ejbJar.getEnterpriseBeans();
        MessageDriven messageDriven = null;
        if (beans == null) {
            beans = ejbJar.newEnterpriseBeans();
            ejbJar.setEnterpriseBeans(beans);
        }
        messageDriven = beans.newMessageDriven();
        ActivationConfig config = messageDriven.newActivationConfig();
        ActivationConfigProperty destProp = config.newActivationConfigProperty();
        destProp.setActivationConfigPropertyName("destinationType");
        ActivationConfigProperty ackProp = config.newActivationConfigProperty();
        ackProp.setActivationConfigPropertyName("acknowledgeMode");
        ackProp.setActivationConfigPropertyValue("Auto-acknowledge");
        config.addActivationConfigProperty(ackProp);
        if (this.isQueue()) {
            String queue = QUEUE_INTERFACE;
            messageDriven.setMessageDestinationType(queue);
            destProp.setActivationConfigPropertyValue(queue);
        } else {
            String topic = TOPIC_INTERFACE;
            messageDriven.setMessageDestinationType(topic);
            destProp.setActivationConfigPropertyValue(topic);
            ActivationConfigProperty durabilityProp = config.newActivationConfigProperty();
            durabilityProp.setActivationConfigPropertyName("subscriptionDurability");
            durabilityProp.setActivationConfigPropertyValue("Durable");
            config.addActivationConfigProperty(durabilityProp);
            ActivationConfigProperty clientIdProp = config.newActivationConfigProperty();
            clientIdProp.setActivationConfigPropertyName("clientId");
            clientIdProp.setActivationConfigPropertyValue(this.ejbName);
            config.addActivationConfigProperty(clientIdProp);
            ActivationConfigProperty subscriptionNameProp = config.newActivationConfigProperty();
            subscriptionNameProp.setActivationConfigPropertyName("subscriptionName");
            subscriptionNameProp.setActivationConfigPropertyValue(this.ejbName);
            config.addActivationConfigProperty(subscriptionNameProp);
        }
        config.addActivationConfigProperty(destProp);
        messageDriven.setActivationConfig(config);
        messageDriven.setEjbName(this.ejbName);
        messageDriven.setDisplayName(this.displayName);
        messageDriven.setEjbClass(this.packageNameWithDot + this.ejbClassName);
        messageDriven.setTransactionType("Container");
        beans.addMessageDriven(messageDriven);
        AssemblyDescriptor assemblyDescriptor = ejbJar.getSingleAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            assemblyDescriptor = ejbJar.newAssemblyDescriptor();
            ejbJar.setAssemblyDescriptor(assemblyDescriptor);
        }
        MessageDestination ddMessageDestination = assemblyDescriptor.newMessageDestination();
        String destinationLink = this.messageDestination.getName();
        ddMessageDestination.setDisplayName("Destination for " + this.displayName);
        ddMessageDestination.setMessageDestinationName(destinationLink);
        assemblyDescriptor.addMessageDestination(ddMessageDestination);
        messageDriven.setMessageDestinationLink(destinationLink);
        ContainerTransaction containerTransaction = assemblyDescriptor.newContainerTransaction();
        containerTransaction.setTransAttribute("Required");
        Method method = containerTransaction.newMethod();
        method.setEjbName(this.ejbName);
        method.setMethodName("*");
        containerTransaction.addMethod(method);
        assemblyDescriptor.addContainerTransaction(containerTransaction);
        ejbJar.write(ejbModule.getDeploymentDescriptor());
    }

    private void generateEJB30Xml() throws IOException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    private boolean useMappedName() {
        if (this.profile != null && this.profile.isAtLeast(Profile.JAVA_EE_7_WEB) && this.jmsSupport.useDestinationLookup()) {
            return false;
        }
        return this.jmsSupport.useMappedName();
    }

    public static final class KeyValuePair {
        private String key;
        private String value;

        public KeyValuePair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

