/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.core;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.AbstractErrorReporter;
import org.eclipse.mylyn.commons.core.StatusHandler;

public class ErrorReporterManager {
    private static final String EXTENSION_ID_ERROR_REPORTERS = "org.eclipse.mylyn.commons.core.errorReporters";
    private static final String ELEMENT_ERROR_REPORTER = "errorReporter";
    private final List<AbstractErrorReporter> errorReporters = new CopyOnWriteArrayList<AbstractErrorReporter>();
    private boolean readExtensions;
    private static final String ELEMENT_CLASS = "class";

    public void addErrorReporter(AbstractErrorReporter errorReporter) {
        this.errorReporters.add(errorReporter);
    }

    public void removeErrorReporter(AbstractErrorReporter errorReporter) {
        this.errorReporters.remove(errorReporter);
    }

    public void fail(IStatus status) {
        AbstractErrorReporter reporter2;
        this.readExtensions();
        int priority = AbstractErrorReporter.PRIORITY_NONE;
        ArrayList<AbstractErrorReporter> interestedReporters = new ArrayList<AbstractErrorReporter>();
        for (AbstractErrorReporter reporter2 : this.errorReporters) {
            int newPriority = reporter2.getPriority(status);
            if (newPriority <= AbstractErrorReporter.PRIORITY_NONE) continue;
            if (newPriority > priority) {
                interestedReporters.clear();
                interestedReporters.add(reporter2);
                priority = newPriority;
                continue;
            }
            if (newPriority != priority) continue;
            interestedReporters.add(reporter2);
        }
        if (interestedReporters.isEmpty()) {
            return;
        }
        reporter2 = interestedReporters.size() > 1 ? (AbstractErrorReporter)interestedReporters.get(0) : (AbstractErrorReporter)interestedReporters.get(0);
        reporter2.handle(status);
    }

    private synchronized void readExtensions() {
        IExtension[] extensions;
        if (this.readExtensions) {
            return;
        }
        this.readExtensions = true;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_ERROR_REPORTERS);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(ELEMENT_ERROR_REPORTER)) {
                    this.readErrorReporter(element);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void readErrorReporter(IConfigurationElement element) {
        try {
            Object object = element.createExecutableExtension(ELEMENT_CLASS);
            if (object instanceof AbstractErrorReporter) {
                this.errorReporters.add((AbstractErrorReporter)object);
            } else {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.commons.core", "Could not load error reporter extenstion: \"" + object.getClass().getCanonicalName() + "\"" + " does not implement \"" + AbstractErrorReporter.class.getCanonicalName() + "\""));
            }
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.commons.core", "Could not load error reporter extension", e));
        }
    }
}

