/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.DiffResponseEntry;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DiffResponse
extends ExplicitlySetBmcModel {
    @JsonProperty(value="areAllChangesIncluded")
    private final Boolean areAllChangesIncluded;
    @JsonProperty(value="changeTypeCount")
    private final Map<String, Integer> changeTypeCount;
    @JsonProperty(value="commonCommit")
    private final String commonCommit;
    @JsonProperty(value="commitsAheadCount")
    private final Integer commitsAheadCount;
    @JsonProperty(value="commitsBehindCount")
    private final Integer commitsBehindCount;
    @JsonProperty(value="addedLinesCount")
    private final Integer addedLinesCount;
    @JsonProperty(value="deletedLinesCount")
    private final Integer deletedLinesCount;
    @JsonProperty(value="changes")
    private final List<DiffResponseEntry> changes;

    @Deprecated
    @ConstructorProperties(value={"areAllChangesIncluded", "changeTypeCount", "commonCommit", "commitsAheadCount", "commitsBehindCount", "addedLinesCount", "deletedLinesCount", "changes"})
    public DiffResponse(Boolean areAllChangesIncluded, Map<String, Integer> changeTypeCount, String commonCommit, Integer commitsAheadCount, Integer commitsBehindCount, Integer addedLinesCount, Integer deletedLinesCount, List<DiffResponseEntry> changes) {
        this.areAllChangesIncluded = areAllChangesIncluded;
        this.changeTypeCount = changeTypeCount;
        this.commonCommit = commonCommit;
        this.commitsAheadCount = commitsAheadCount;
        this.commitsBehindCount = commitsBehindCount;
        this.addedLinesCount = addedLinesCount;
        this.deletedLinesCount = deletedLinesCount;
        this.changes = changes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getAreAllChangesIncluded() {
        return this.areAllChangesIncluded;
    }

    public Map<String, Integer> getChangeTypeCount() {
        return this.changeTypeCount;
    }

    public String getCommonCommit() {
        return this.commonCommit;
    }

    public Integer getCommitsAheadCount() {
        return this.commitsAheadCount;
    }

    public Integer getCommitsBehindCount() {
        return this.commitsBehindCount;
    }

    public Integer getAddedLinesCount() {
        return this.addedLinesCount;
    }

    public Integer getDeletedLinesCount() {
        return this.deletedLinesCount;
    }

    public List<DiffResponseEntry> getChanges() {
        return this.changes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DiffResponse(");
        sb.append("super=").append(super.toString());
        sb.append("areAllChangesIncluded=").append(String.valueOf(this.areAllChangesIncluded));
        sb.append(", changeTypeCount=").append(String.valueOf(this.changeTypeCount));
        sb.append(", commonCommit=").append(String.valueOf(this.commonCommit));
        sb.append(", commitsAheadCount=").append(String.valueOf(this.commitsAheadCount));
        sb.append(", commitsBehindCount=").append(String.valueOf(this.commitsBehindCount));
        sb.append(", addedLinesCount=").append(String.valueOf(this.addedLinesCount));
        sb.append(", deletedLinesCount=").append(String.valueOf(this.deletedLinesCount));
        sb.append(", changes=").append(String.valueOf(this.changes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiffResponse)) {
            return false;
        }
        DiffResponse other = (DiffResponse)((Object)o);
        return Objects.equals(this.areAllChangesIncluded, other.areAllChangesIncluded) && Objects.equals(this.changeTypeCount, other.changeTypeCount) && Objects.equals(this.commonCommit, other.commonCommit) && Objects.equals(this.commitsAheadCount, other.commitsAheadCount) && Objects.equals(this.commitsBehindCount, other.commitsBehindCount) && Objects.equals(this.addedLinesCount, other.addedLinesCount) && Objects.equals(this.deletedLinesCount, other.deletedLinesCount) && Objects.equals(this.changes, other.changes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.areAllChangesIncluded == null ? 43 : this.areAllChangesIncluded.hashCode());
        result = result * 59 + (this.changeTypeCount == null ? 43 : this.changeTypeCount.hashCode());
        result = result * 59 + (this.commonCommit == null ? 43 : this.commonCommit.hashCode());
        result = result * 59 + (this.commitsAheadCount == null ? 43 : this.commitsAheadCount.hashCode());
        result = result * 59 + (this.commitsBehindCount == null ? 43 : this.commitsBehindCount.hashCode());
        result = result * 59 + (this.addedLinesCount == null ? 43 : this.addedLinesCount.hashCode());
        result = result * 59 + (this.deletedLinesCount == null ? 43 : this.deletedLinesCount.hashCode());
        result = result * 59 + (this.changes == null ? 43 : this.changes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="areAllChangesIncluded")
        private Boolean areAllChangesIncluded;
        @JsonProperty(value="changeTypeCount")
        private Map<String, Integer> changeTypeCount;
        @JsonProperty(value="commonCommit")
        private String commonCommit;
        @JsonProperty(value="commitsAheadCount")
        private Integer commitsAheadCount;
        @JsonProperty(value="commitsBehindCount")
        private Integer commitsBehindCount;
        @JsonProperty(value="addedLinesCount")
        private Integer addedLinesCount;
        @JsonProperty(value="deletedLinesCount")
        private Integer deletedLinesCount;
        @JsonProperty(value="changes")
        private List<DiffResponseEntry> changes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder areAllChangesIncluded(Boolean areAllChangesIncluded) {
            this.areAllChangesIncluded = areAllChangesIncluded;
            this.__explicitlySet__.add("areAllChangesIncluded");
            return this;
        }

        public Builder changeTypeCount(Map<String, Integer> changeTypeCount) {
            this.changeTypeCount = changeTypeCount;
            this.__explicitlySet__.add("changeTypeCount");
            return this;
        }

        public Builder commonCommit(String commonCommit) {
            this.commonCommit = commonCommit;
            this.__explicitlySet__.add("commonCommit");
            return this;
        }

        public Builder commitsAheadCount(Integer commitsAheadCount) {
            this.commitsAheadCount = commitsAheadCount;
            this.__explicitlySet__.add("commitsAheadCount");
            return this;
        }

        public Builder commitsBehindCount(Integer commitsBehindCount) {
            this.commitsBehindCount = commitsBehindCount;
            this.__explicitlySet__.add("commitsBehindCount");
            return this;
        }

        public Builder addedLinesCount(Integer addedLinesCount) {
            this.addedLinesCount = addedLinesCount;
            this.__explicitlySet__.add("addedLinesCount");
            return this;
        }

        public Builder deletedLinesCount(Integer deletedLinesCount) {
            this.deletedLinesCount = deletedLinesCount;
            this.__explicitlySet__.add("deletedLinesCount");
            return this;
        }

        public Builder changes(List<DiffResponseEntry> changes) {
            this.changes = changes;
            this.__explicitlySet__.add("changes");
            return this;
        }

        public DiffResponse build() {
            DiffResponse model = new DiffResponse(this.areAllChangesIncluded, this.changeTypeCount, this.commonCommit, this.commitsAheadCount, this.commitsBehindCount, this.addedLinesCount, this.deletedLinesCount, this.changes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DiffResponse model) {
            if (model.wasPropertyExplicitlySet("areAllChangesIncluded")) {
                this.areAllChangesIncluded(model.getAreAllChangesIncluded());
            }
            if (model.wasPropertyExplicitlySet("changeTypeCount")) {
                this.changeTypeCount(model.getChangeTypeCount());
            }
            if (model.wasPropertyExplicitlySet("commonCommit")) {
                this.commonCommit(model.getCommonCommit());
            }
            if (model.wasPropertyExplicitlySet("commitsAheadCount")) {
                this.commitsAheadCount(model.getCommitsAheadCount());
            }
            if (model.wasPropertyExplicitlySet("commitsBehindCount")) {
                this.commitsBehindCount(model.getCommitsBehindCount());
            }
            if (model.wasPropertyExplicitlySet("addedLinesCount")) {
                this.addedLinesCount(model.getAddedLinesCount());
            }
            if (model.wasPropertyExplicitlySet("deletedLinesCount")) {
                this.deletedLinesCount(model.getDeletedLinesCount());
            }
            if (model.wasPropertyExplicitlySet("changes")) {
                this.changes(model.getChanges());
            }
            return this;
        }
    }
}

