/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.ui.util.FormLabel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.classexpression.OWLExpressionParserException;
import org.protege.editor.owl.model.lang.LangCode;
import org.protege.editor.owl.model.lang.LangCodeRegistry;
import org.protege.editor.owl.model.parser.OWLLiteralParser;
import org.protege.editor.owl.model.util.LiteralChecker;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLAutoCompleter;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditorHandler;
import org.protege.editor.owl.ui.lang.LangTagEditor;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWLConstantEditor
extends JPanel
implements OWLObjectEditor<OWLLiteral> {
    private final OWLEditorKit editorKit;
    private final JTextArea lexicalValueField = new JTextArea(8, 40);
    private final LangTagEditor langTagField;
    private final JComboBox<OWLDatatype> datatypeField;
    private final OWLDataFactory dataFactory;
    private OWLDatatype lastDatatype;
    private OWLDatatype overridingDatatype;
    private LangCodeRegistry langCodeRegistry = LangCodeRegistry.get();
    private final JLabel messageLabel = new JLabel();

    public OWLConstantEditor(OWLEditorKit owlEditorKit) {
        this.editorKit = owlEditorKit;
        this.dataFactory = owlEditorKit.getModelManager().getOWLDataFactory();
        this.lexicalValueField.setWrapStyleWord(true);
        this.lexicalValueField.setLineWrap(true);
        this.lexicalValueField.setBorder(null);
        UIHelper uiHelper = new UIHelper(owlEditorKit);
        this.langTagField = new LangTagEditor(LangCodeRegistry.get());
        this.langTagField.setChangeListener(e -> this.handleLangTagChanged());
        this.datatypeField = uiHelper.getDatatypeSelector();
        this.datatypeField.addActionListener(e -> this.validateContent());
        this.lexicalValueField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                OWLConstantEditor.this.handleLexicalValueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OWLConstantEditor.this.handleLexicalValueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.addHierarchyListener(e -> {
            if (this.isShowing()) {
                this.lexicalValueField.requestFocus();
            }
        });
        OWLConstantEditor.removeNonSelectableDatatypes(this.datatypeField);
        this.setupAutoCompleter(owlEditorKit);
        this.layoutComponents();
    }

    public void setOverridingDatatype(@Nonnull OWLDatatype overridingDatatype) {
        this.overridingDatatype = (OWLDatatype)Preconditions.checkNotNull((Object)overridingDatatype);
        this.updateDatatype();
    }

    public void clearOverridingDatatype() {
        this.overridingDatatype = null;
        this.datatypeField.setSelectedItem(null);
        this.updateDatatype();
    }

    private void handleLangTagChanged() {
        this.updateDatatype();
    }

    private void handleLexicalValueChanged() {
        this.updateDatatype();
    }

    private void updateDatatype() {
        if (this.overridingDatatype != null) {
            this.datatypeField.setSelectedItem(this.overridingDatatype);
            this.langTagField.clear();
        } else if (this.isLangSelected()) {
            this.datatypeField.setSelectedItem(OWL2Datatype.RDF_PLAIN_LITERAL.getDatatype(this.dataFactory));
            this.datatypeField.setEnabled(false);
        } else {
            this.datatypeField.setEnabled(true);
            OWLDatatype selDatatype = (OWLDatatype)this.datatypeField.getSelectedItem();
            if (this.isBuiltInParseableDatatpe(selDatatype) || selDatatype == null) {
                OWLLiteralParser parser = new OWLLiteralParser(this.dataFactory);
                OWLLiteral parsedLiteral = parser.parseLiteral(this.lexicalValueField.getText().trim());
                this.datatypeField.setSelectedItem(parsedLiteral.getDatatype());
            }
        }
        this.validateContent();
    }

    private boolean isBuiltInParseableDatatpe(OWLDatatype selDatatype) {
        return selDatatype != null && (selDatatype.isString() || selDatatype.isInteger() || selDatatype.isBoolean() || selDatatype.isFloat());
    }

    private void validateContent() {
        this.clearErrorMessage();
        if (this.getLexicalValue().isEmpty()) {
            return;
        }
        Optional<OWLDatatype> datatype = Optional.ofNullable(this.getSelectedDatatype());
        datatype.ifPresent(d -> {
            if (!LiteralChecker.isLiteralIsInLexicalSpace(this.getEditedObject())) {
                this.lexicalValueField.setForeground(Color.RED);
                String message = String.format("The entered value is not valid for the specified datatype (%s)", this.editorKit.getOWLModelManager().getRendering((OWLObject)d));
                this.displayErrorMessage(message);
            }
        });
    }

    private void displayErrorMessage(String message) {
        this.messageLabel.setText(message);
        this.messageLabel.setForeground(Color.RED);
        this.lexicalValueField.setToolTipText(message);
    }

    private void clearErrorMessage() {
        this.messageLabel.setText("");
        this.messageLabel.setForeground(null);
        this.lexicalValueField.setToolTipText(null);
        this.lexicalValueField.setForeground(null);
    }

    private static void removeNonSelectableDatatypes(JComboBox<OWLDatatype> datatypeComboBox) {
        for (int i = 0; i < datatypeComboBox.getItemCount(); ++i) {
            OWLDatatype datatype = datatypeComboBox.getItemAt(i);
            if (datatype == null) continue;
            if (datatype.isRDFPlainLiteral()) {
                datatypeComboBox.removeItemAt(i);
                continue;
            }
            if (!datatype.isBuiltIn() || !datatype.getBuiltInDatatype().equals((Object)OWL2Datatype.OWL_REAL)) continue;
            datatypeComboBox.removeItemAt(i);
        }
    }

    @Override
    public boolean canEdit(Object object) {
        return object instanceof OWLLiteral;
    }

    @Override
    @Nonnull
    public JComponent getEditorComponent() {
        return this;
    }

    @Override
    @Nonnull
    public OWLLiteral getEditedObject() {
        this.lastDatatype = null;
        String value = this.getLexicalValue();
        if (this.isLangSelected()) {
            return this.dataFactory.getOWLLiteral(value, (String)this.getSelectedLang().map(LangCode::getLangCode).orElse(null));
        }
        if (this.isDatatypeSelected()) {
            this.lastDatatype = this.getSelectedDatatype();
            if (this.lastDatatype.isBoolean()) {
                if (OWL2Datatype.XSD_BOOLEAN.getPattern().matcher(value).matches()) {
                    this.dataFactory.getOWLLiteral(value, OWL2Datatype.XSD_BOOLEAN);
                } else {
                    this.dataFactory.getOWLLiteral(value, OWL2Datatype.XSD_STRING);
                }
            } else {
                return this.dataFactory.getOWLLiteral(value, this.getSelectedDatatype());
            }
        }
        OWLLiteralParser parser = new OWLLiteralParser(this.dataFactory);
        return parser.parseLiteral(value);
    }

    private String getLexicalValue() {
        return this.lexicalValueField.getText().trim();
    }

    @Override
    public Set<OWLLiteral> getEditedObjects() {
        return Collections.singleton(this.getEditedObject());
    }

    @Override
    public boolean setEditedObject(OWLLiteral literal) {
        this.clear();
        if (literal == null) {
            return true;
        }
        this.lexicalValueField.setText(literal.getLiteral());
        if (literal.isRDFPlainLiteral()) {
            this.langCodeRegistry.getLangCode(literal.getLang()).ifPresent(this.langTagField::setLangCode);
            this.datatypeField.setSelectedItem(null);
        } else {
            this.datatypeField.setSelectedItem(literal.getDatatype());
        }
        return true;
    }

    @Override
    public boolean isMultiEditSupported() {
        return false;
    }

    @Override
    @Nonnull
    public String getEditorTypeName() {
        return "Literal";
    }

    @Override
    public void clear() {
        this.lexicalValueField.setText("");
        this.datatypeField.setSelectedItem(this.lastDatatype);
        this.langTagField.clear();
    }

    private boolean isLangSelected() {
        return this.langTagField.getLangCode().isPresent();
    }

    private boolean isDatatypeSelected() {
        return this.datatypeField.getSelectedItem() != null;
    }

    private Optional<LangCode> getSelectedLang() {
        return this.langTagField.getLangCode();
    }

    private OWLDatatype getSelectedDatatype() {
        return (OWLDatatype)this.datatypeField.getSelectedItem();
    }

    private void setupAutoCompleter(OWLEditorKit owlEditorKit) {
        new OWLAutoCompleter(owlEditorKit, this.lexicalValueField, new OWLExpressionChecker(){

            @Override
            public void check(String text) throws OWLExpressionParserException {
                throw new OWLExpressionParserException(text, 0, text.length(), true, true, true, true, true, true, new HashSet<String>());
            }

            public Object createObject(String text) {
                return null;
            }
        });
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        Insets formLabelInsets = new Insets(7, 0, 0, 0);
        this.add((Component)new FormLabel("Value"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 512, 0, formLabelInsets, 0, 0));
        this.add((Component)new JScrollPane(this.lexicalValueField), new GridBagConstraints(1, 1, 1, 1, 100.0, 100.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.messageLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new FormLabel("Language Tag"), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 512, 0, formLabelInsets, 0, 0));
        this.add((Component)this.langTagField, new GridBagConstraints(1, 4, 1, 1, 100.0, 0.0, 512, 2, new Insets(0, 0, 0, 0), 40, 0));
        this.add((Component)new FormLabel("Datatype"), new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 512, 0, formLabelInsets, 0, 0));
        this.add(this.datatypeField, new GridBagConstraints(1, 6, 1, 1, 100.0, 0.0, 256, 2, new Insets(0, 0, 0, 0), 40, 0));
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setHandler(OWLObjectEditorHandler<OWLLiteral> owlLiteralOWLObjectEditorHandler) {
    }

    @Override
    public OWLObjectEditorHandler<OWLLiteral> getHandler() {
        return null;
    }
}

