/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.JdbcTypeConverter;
import org.firebirdsql.jdbc.field.TypeConversionException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

final class FBBigDecimalField
extends FBField {
    private static final BigInteger MAX_SHORT = BigInteger.valueOf(32767L);
    private static final BigInteger MIN_SHORT = BigInteger.valueOf(-32768L);
    private static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigDecimal BD_MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigDecimal BD_MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal BD_MAX_DOUBLE = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal BD_MIN_DOUBLE = new BigDecimal(-1.7976931348623157E308);
    private final @NonNull FieldDataSize fieldDataSize;

    @NullMarked
    FBBigDecimalField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
        this.fieldDataSize = FieldDataSize.getFieldDataSize(fieldDescriptor);
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getBigDecimal();
    }

    @Override
    public boolean getBoolean() throws SQLException {
        return this.getByte() == 1;
    }

    @Override
    public byte getByte() throws SQLException {
        long longValue = this.getLong();
        if (longValue > 127L || longValue < -128L) {
            throw this.outOfRangeGetConversion("byte", longValue);
        }
        return (byte)longValue;
    }

    @NullMarked
    private SQLException outOfRangeGetConversion(String type, long value) {
        return this.invalidGetConversion(type, "value %d out of range".formatted(value));
    }

    @Override
    public double getDouble() throws SQLException {
        BigDecimal value = this.getBigDecimal();
        return value != null ? value.doubleValue() : 0.0;
    }

    @Override
    public float getFloat() throws SQLException {
        BigDecimal value = this.getBigDecimal();
        return value != null ? value.floatValue() : 0.0f;
    }

    @Override
    public int getInt() throws SQLException {
        long longValue = this.getLong();
        if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
            throw this.outOfRangeGetConversion("int", longValue);
        }
        return (int)longValue;
    }

    @Override
    public long getLong() throws SQLException {
        BigDecimal value = this.getBigDecimal();
        if (value == null) {
            return 0L;
        }
        if (BD_MIN_LONG.compareTo(value) > 0 || value.compareTo(BD_MAX_LONG) > 0) {
            throw this.invalidGetConversion("long", String.format("value %f out of range", value));
        }
        return value.longValue();
    }

    @Override
    public short getShort() throws SQLException {
        long longValue = this.getLong();
        if (longValue > 32767L || longValue < -32768L) {
            throw this.outOfRangeGetConversion("short", longValue);
        }
        return (short)longValue;
    }

    @Override
    public String getString() throws SQLException {
        BigDecimal value = this.getBigDecimal();
        return value != null ? value.toString() : null;
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        return this.fieldDataSize.decode(this.fieldDescriptor, this.getFieldData());
    }

    @Override
    public BigInteger getBigInteger() throws SQLException {
        BigDecimal value = this.getBigDecimal();
        return value != null ? value.toBigInteger() : null;
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        this.setLong(value ? 1L : 0L);
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setLong(value);
    }

    @Override
    public void setDouble(double value) throws SQLException {
        this.setBigDecimal(BigDecimal.valueOf(value));
    }

    @Override
    public void setFloat(float value) throws SQLException {
        this.setDouble(value);
    }

    @Override
    public void setInteger(int value) throws SQLException {
        this.setLong(value);
    }

    @Override
    public void setLong(long value) throws SQLException {
        this.setBigDecimal(BigDecimal.valueOf(value));
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setLong(value);
    }

    @Override
    public void setString(String value) throws SQLException {
        this.setBigDecimal(this.fromString(value, BigDecimal::new));
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        this.setFieldData(this.fieldDataSize.encode(this.fieldDescriptor, value));
    }

    @Override
    public void setBigInteger(BigInteger value) throws SQLException {
        this.setBigDecimal(value != null ? new BigDecimal(value) : null);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @NullMarked
    private static enum FieldDataSize {
        SHORT{

            @Override
            protected @Nullable BigDecimal decode(FieldDescriptor fieldDescriptor, byte @Nullable [] fieldData) {
                if (fieldData == null) {
                    return null;
                }
                long value = fieldDescriptor.getDatatypeCoder().decodeShort(fieldData);
                return BigDecimal.valueOf(value, -1 * fieldDescriptor.getScale());
            }

            @Override
            protected byte @Nullable [] encode(FieldDescriptor fieldDescriptor, @Nullable BigDecimal value) throws SQLException {
                if (value == null) {
                    return null;
                }
                BigInteger unscaledValue = FieldDataSize.normalize(value, -1 * fieldDescriptor.getScale());
                if (unscaledValue.compareTo(MAX_SHORT) > 0 || unscaledValue.compareTo(MIN_SHORT) < 0) {
                    throw 1.bigDecimalConversionError(fieldDescriptor, value);
                }
                return fieldDescriptor.getDatatypeCoder().encodeShort(unscaledValue.shortValue());
            }
        }
        ,
        INTEGER{

            @Override
            protected @Nullable BigDecimal decode(FieldDescriptor fieldDescriptor, byte @Nullable [] fieldData) {
                if (fieldData == null) {
                    return null;
                }
                long value = fieldDescriptor.getDatatypeCoder().decodeInt(fieldData);
                return BigDecimal.valueOf(value, -1 * fieldDescriptor.getScale());
            }

            @Override
            protected byte @Nullable [] encode(FieldDescriptor fieldDescriptor, @Nullable BigDecimal value) throws SQLException {
                if (value == null) {
                    return null;
                }
                BigInteger unscaledValue = FieldDataSize.normalize(value, -1 * fieldDescriptor.getScale());
                if (unscaledValue.compareTo(MAX_INT) > 0 || unscaledValue.compareTo(MIN_INT) < 0) {
                    throw 2.bigDecimalConversionError(fieldDescriptor, value);
                }
                return fieldDescriptor.getDatatypeCoder().encodeInt(unscaledValue.intValue());
            }
        }
        ,
        LONG{

            @Override
            protected @Nullable BigDecimal decode(FieldDescriptor fieldDescriptor, byte @Nullable [] fieldData) {
                if (fieldData == null) {
                    return null;
                }
                long value = fieldDescriptor.getDatatypeCoder().decodeLong(fieldData);
                return BigDecimal.valueOf(value, -1 * fieldDescriptor.getScale());
            }

            @Override
            protected byte @Nullable [] encode(FieldDescriptor fieldDescriptor, @Nullable BigDecimal value) throws SQLException {
                if (value == null) {
                    return null;
                }
                BigInteger unscaledValue = FieldDataSize.normalize(value, -1 * fieldDescriptor.getScale());
                if (unscaledValue.compareTo(MAX_LONG) > 0 || unscaledValue.compareTo(MIN_LONG) < 0) {
                    throw 3.bigDecimalConversionError(fieldDescriptor, value);
                }
                return fieldDescriptor.getDatatypeCoder().encodeLong(unscaledValue.longValue());
            }
        }
        ,
        DOUBLE{

            @Override
            protected @Nullable BigDecimal decode(FieldDescriptor fieldDescriptor, byte @Nullable [] fieldData) {
                if (fieldData == null) {
                    return null;
                }
                BigDecimal value = BigDecimal.valueOf(fieldDescriptor.getDatatypeCoder().decodeDouble(fieldData));
                return value.setScale(Math.abs(fieldDescriptor.getScale()), RoundingMode.HALF_EVEN);
            }

            @Override
            protected byte @Nullable [] encode(FieldDescriptor fieldDescriptor, @Nullable BigDecimal value) throws SQLException {
                if (value == null) {
                    return null;
                }
                if (value.compareTo(BD_MAX_DOUBLE) > 0 || value.compareTo(BD_MIN_DOUBLE) < 0) {
                    throw 4.bigDecimalConversionError(fieldDescriptor, value);
                }
                return fieldDescriptor.getDatatypeCoder().encodeDouble(value.doubleValue());
            }
        }
        ,
        INT128{

            @Override
            protected @Nullable BigDecimal decode(FieldDescriptor fieldDescriptor, byte @Nullable [] fieldData) {
                if (fieldData == null) {
                    return null;
                }
                BigInteger int128Value = fieldDescriptor.getDatatypeCoder().decodeInt128(fieldData);
                return new BigDecimal(int128Value, -1 * fieldDescriptor.getScale());
            }

            @Override
            protected byte @Nullable [] encode(FieldDescriptor fieldDescriptor, @Nullable BigDecimal value) throws SQLException {
                if (value == null) {
                    return null;
                }
                BigInteger unscaledValue = FieldDataSize.normalize(value, -1 * fieldDescriptor.getScale());
                if (unscaledValue.bitLength() > 127) {
                    throw 5.bigDecimalConversionError(fieldDescriptor, value);
                }
                return fieldDescriptor.getDatatypeCoder().encodeInt128(unscaledValue);
            }
        };


        protected abstract @Nullable BigDecimal decode(FieldDescriptor var1, byte @Nullable [] var2) throws SQLException;

        protected abstract byte @Nullable [] encode(FieldDescriptor var1, @Nullable BigDecimal var2) throws SQLException;

        private static BigInteger normalize(BigDecimal value, int scale) {
            BigDecimal valueToScale = value.setScale(scale, RoundingMode.HALF_UP);
            return valueToScale.unscaledValue();
        }

        protected static FieldDataSize getFieldDataSize(FieldDescriptor fieldDescriptor) throws SQLException {
            return switch (fieldDescriptor.getType() & 0xFFFFFFFE) {
                case 500 -> SHORT;
                case 496 -> INTEGER;
                case 580 -> LONG;
                case 480 -> DOUBLE;
                case 32752 -> INT128;
                default -> throw FbExceptionBuilder.forException(337248277).messageParameter(fieldDescriptor.getType()).toSQLException();
            };
        }

        static SQLException bigDecimalConversionError(FieldDescriptor fieldDescriptor, @Nullable BigDecimal value) {
            String message = String.format("Unsupported set conversion requested for field %s at index %d (JDBC type %s), source type: java.math.BigDecimal, reason: value %f out of range", fieldDescriptor.getFieldName(), fieldDescriptor.getPosition() + 1, FBField.getJdbcTypeName(JdbcTypeConverter.toJdbcType(fieldDescriptor)), value);
            return new TypeConversionException(message);
        }
    }
}

