/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.math;

import org.sunflow.math.Vector3;

public final class OrthoNormalBasis {
    private Vector3 u = new Vector3();
    private Vector3 v = new Vector3();
    private Vector3 w = new Vector3();

    private OrthoNormalBasis() {
    }

    public void flipU() {
        this.u.negate();
    }

    public void flipV() {
        this.v.negate();
    }

    public void flipW() {
        this.w.negate();
    }

    public void swapUV() {
        Vector3 vector3 = this.u;
        this.u = this.v;
        this.v = vector3;
    }

    public void swapVW() {
        Vector3 vector3 = this.v;
        this.v = this.w;
        this.w = vector3;
    }

    public void swapWU() {
        Vector3 vector3 = this.w;
        this.w = this.u;
        this.u = vector3;
    }

    public Vector3 transform(Vector3 vector3, Vector3 vector32) {
        vector32.x = vector3.x * this.u.x + vector3.y * this.v.x + vector3.z * this.w.x;
        vector32.y = vector3.x * this.u.y + vector3.y * this.v.y + vector3.z * this.w.y;
        vector32.z = vector3.x * this.u.z + vector3.y * this.v.z + vector3.z * this.w.z;
        return vector32;
    }

    public Vector3 transform(Vector3 vector3) {
        float f = vector3.x * this.u.x + vector3.y * this.v.x + vector3.z * this.w.x;
        float f2 = vector3.x * this.u.y + vector3.y * this.v.y + vector3.z * this.w.y;
        float f3 = vector3.x * this.u.z + vector3.y * this.v.z + vector3.z * this.w.z;
        return vector3.set(f, f2, f3);
    }

    public Vector3 untransform(Vector3 vector3, Vector3 vector32) {
        vector32.x = Vector3.dot(vector3, this.u);
        vector32.y = Vector3.dot(vector3, this.v);
        vector32.z = Vector3.dot(vector3, this.w);
        return vector32;
    }

    public Vector3 untransform(Vector3 vector3) {
        float f = Vector3.dot(vector3, this.u);
        float f2 = Vector3.dot(vector3, this.v);
        float f3 = Vector3.dot(vector3, this.w);
        return vector3.set(f, f2, f3);
    }

    public float untransformX(Vector3 vector3) {
        return Vector3.dot(vector3, this.u);
    }

    public float untransformY(Vector3 vector3) {
        return Vector3.dot(vector3, this.v);
    }

    public float untransformZ(Vector3 vector3) {
        return Vector3.dot(vector3, this.w);
    }

    public static final OrthoNormalBasis makeFromW(Vector3 vector3) {
        OrthoNormalBasis orthoNormalBasis = new OrthoNormalBasis();
        vector3.normalize(orthoNormalBasis.w);
        if (Math.abs(orthoNormalBasis.w.x) < Math.abs(orthoNormalBasis.w.y) && Math.abs(orthoNormalBasis.w.x) < Math.abs(orthoNormalBasis.w.z)) {
            orthoNormalBasis.v.x = 0.0f;
            orthoNormalBasis.v.y = orthoNormalBasis.w.z;
            orthoNormalBasis.v.z = -orthoNormalBasis.w.y;
        } else if (Math.abs(orthoNormalBasis.w.y) < Math.abs(orthoNormalBasis.w.z)) {
            orthoNormalBasis.v.x = orthoNormalBasis.w.z;
            orthoNormalBasis.v.y = 0.0f;
            orthoNormalBasis.v.z = -orthoNormalBasis.w.x;
        } else {
            orthoNormalBasis.v.x = orthoNormalBasis.w.y;
            orthoNormalBasis.v.y = -orthoNormalBasis.w.x;
            orthoNormalBasis.v.z = 0.0f;
        }
        Vector3.cross(orthoNormalBasis.v.normalize(), orthoNormalBasis.w, orthoNormalBasis.u);
        return orthoNormalBasis;
    }

    public static final OrthoNormalBasis makeFromWV(Vector3 vector3, Vector3 vector32) {
        OrthoNormalBasis orthoNormalBasis = new OrthoNormalBasis();
        vector3.normalize(orthoNormalBasis.w);
        Vector3.cross(vector32, orthoNormalBasis.w, orthoNormalBasis.u).normalize();
        Vector3.cross(orthoNormalBasis.w, orthoNormalBasis.u, orthoNormalBasis.v);
        return orthoNormalBasis;
    }
}

