#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Renowned Explorers: International Society expansions:
# - More To Explore
# - The Emperor's Challenge
###

script_version=20250401.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='renowned-explorers'
GAME_NAME='Renowned Explorers: International Society'

EXPANSION_ID_MORETOEXPLORE='more-to-explore'
EXPANSION_NAME_MORETOEXPLORE='More To Explore'

EXPANSION_ID_EMPERORSCHALLENGE='emperors-challenge'
EXPANSION_NAME_EMPERORSCHALLENGE='The Emperorʼs Challenge'

# Archives

## More To Explore

ARCHIVE_BASE_MORETOEXPLORE_LINUX_7_NAME='renowned_explorers_international_society_more_to_explore_dlc_522_26056.sh'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_7_MD5='46b6534ff70a9efa4fc21b2ba139b52f'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_7_SIZE='68263'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_7_VERSION='522-gog26056'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_7_URL='https://www.gog.com/game/renowned_explorers_more_to_explore'

ARCHIVE_BASE_MORETOEXPLORE_LINUX_6_NAME='renowned_explorers_international_society_more_to_explore_dlc_520_25983.sh'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_6_MD5='3d3e97fc73e63ac992c9afa9f620282e'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_6_SIZE='69000'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_6_VERSION='520-gog25983'

ARCHIVE_BASE_MORETOEXPLORE_LINUX_5_NAME='renowned_explorers_international_society_more_to_explore_dlc_516_25864.sh'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_5_MD5='db21406827c77caecb92c96bb2f4e473'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_5_SIZE='69000'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_5_VERSION='516-gog25864'

ARCHIVE_BASE_MORETOEXPLORE_LINUX_4_NAME='renowned_explorers_international_society_more_to_explore_dlc_512_25169.sh'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_4_MD5='94112f4cfc91fa67855a310618bdeacf'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_4_SIZE='69000'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_4_VERSION='512-gog25169'

ARCHIVE_BASE_MORETOEXPLORE_LINUX_3_NAME='renowned_explorers_international_society_more_to_explore_dlc_508_23701.sh'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_3_MD5='5f43443fc81111bc27461e39145c6db6'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_3_SIZE='69000'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_3_VERSION='508-gog23701'

ARCHIVE_BASE_MORETOEXPLORE_LINUX_2_NAME='renowned_explorers_international_society_more_to_explore_dlc_503_23529.sh'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_2_MD5='058fa329bbeeb0f8b3a3e7e60dc472bf'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_2_SIZE='69000'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_2_VERSION='503-gog23529'

ARCHIVE_BASE_MORETOEXPLORE_LINUX_1_NAME='renowned_explorers_more_to_explore_dlc_en_489_20916.sh'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_1_MD5='cc51077bdcb04086349f81da8b1d19ff'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_1_SIZE='69000'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_1_VERSION='489-gog20916'

ARCHIVE_BASE_MORETOEXPLORE_LINUX_0_NAME='renowned_explorers_more_to_explore_dlc_en_466_15616.sh'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_0_MD5='c99ca440cb312b90052939db49aeef03'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_0_SIZE='69000'
ARCHIVE_BASE_MORETOEXPLORE_LINUX_0_VERSION='466-gog15616'

ARCHIVE_BASE_MORETOEXPLORE_WINDOWS_0_NAME='setup_renowned_explorers_more_to_explore_525_(46550).exe'
ARCHIVE_BASE_MORETOEXPLORE_WINDOWS_0_MD5='cad29861f3bd3a74e0f8848a31f56845'
ARCHIVE_BASE_MORETOEXPLORE_WINDOWS_0_TYPE='innosetup'
ARCHIVE_BASE_MORETOEXPLORE_WINDOWS_0_SIZE='74726'
ARCHIVE_BASE_MORETOEXPLORE_WINDOWS_0_VERSION='525-gog46550'
ARCHIVE_BASE_MORETOEXPLORE_WINDOWS_0_URL='https://www.gog.com/game/renowned_explorers_more_to_explore'

## The Emperor's Challenge

ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_7_NAME='renowned_explorers_international_society_the_emperors_challenge_dlc_522_26056.sh'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_7_MD5='e87af99e5a726b06ee5b94d7f94d9f5a'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_7_SIZE='21170'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_7_VERSION='522-gog26056'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_7_URL='https://www.gog.com/game/renowned_explorers_the_emperors_challenge'

ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_6_NAME='renowned_explorers_international_society_the_emperors_challenge_dlc_520_25983.sh'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_6_MD5='a2ea1ff34a78c9d3cb389373b6948604'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_6_SIZE='22000'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_6_VERSION='520-gog25983'

ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_5_NAME='renowned_explorers_international_society_the_emperors_challenge_dlc_516_25864.sh'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_5_MD5='cd76b4c9b334d5b859c4dff171ec4c0f'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_5_SIZE='22000'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_5_VERSION='516-gog25864'

ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_4_NAME='renowned_explorers_international_society_the_emperors_challenge_dlc_512_25169.sh'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_4_MD5='b402cec7fbc05fec42be3ae4ff1a26ec'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_4_SIZE='22000'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_4_VERSION='512-gog25169'

ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_3_NAME='renowned_explorers_international_society_the_emperors_challenge_dlc_508_23701.sh'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_3_MD5='7f0b5df5318af767bfb306bd4e3f1e13'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_3_SIZE='22000'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_3_VERSION='508-gog23701'

ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_2_NAME='renowned_explorers_international_society_the_emperors_challenge_dlc_503_23529.sh'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_2_MD5='fb2c6bc1201a3346c47e01f0e7aa136c'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_2_SIZE='22000'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_2_VERSION='503-gog23529'

ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_1_NAME='renowned_explorers_the_emperor_s_challenge_dlc_en_489_20916.sh'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_1_MD5='553e0fa1ffed73c9c99022c20cfff707'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_1_SIZE='23000'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_1_VERSION='489-gog20916'

ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_0_NAME='renowned_explorers_the_emperor_s_challenge_dlc_en_466_15616.sh'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_0_MD5='12baa49b557c92e2f5eae7ff99623d34'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_0_SIZE='23000'
ARCHIVE_BASE_EMPERORSCHALLENGE_LINUX_0_VERSION='466-gog15616'

ARCHIVE_BASE_EMPERORSCHALLENGE_WINDOWS_0_NAME='setup_renowned_explorers_the_emperors_challenge_525_(46550).exe'
ARCHIVE_BASE_EMPERORSCHALLENGE_WINDOWS_0_MD5='13bb9e6b93eb98268f6a4be96d67c88a'
ARCHIVE_BASE_EMPERORSCHALLENGE_WINDOWS_0_TYPE='innosetup'
ARCHIVE_BASE_EMPERORSCHALLENGE_WINDOWS_0_SIZE='27910'
ARCHIVE_BASE_EMPERORSCHALLENGE_WINDOWS_0_VERSION='525-gog46550'
ARCHIVE_BASE_EMPERORSCHALLENGE_WINDOWS_0_URL='https://www.gog.com/game/renowned_explorers_the_emperors_challenge'


CONTENT_PATH_DEFAULT_LINUX='data/noarch/game'
CONTENT_PATH_DEFAULT_WINDOWS='.'
CONTENT_PATH_DEFAULT_MORETOEXPLORE_LINUX="$CONTENT_PATH_DEFAULT_LINUX"
CONTENT_PATH_DEFAULT_MORETOEXPLORE_WINDOWS="$CONTENT_PATH_DEFAULT_WINDOWS"
CONTENT_PATH_DEFAULT_EMPERORSCHALLENGE_LINUX="$CONTENT_PATH_DEFAULT_LINUX"
CONTENT_PATH_DEFAULT_EMPERORSCHALLENGE_WINDOWS="$CONTENT_PATH_DEFAULT_WINDOWS"
CONTENT_GAME_MAIN_FILES='
data/dlc_???.tim'

PKG_PARENT_ID_LINUX="${GAME_ID}-bin-linux"
PKG_PARENT_ID_WINDOWS="${GAME_ID}-bin-windows"
PKG_PARENT_ID_MORETOEXPLORE_LINUX="$PKG_PARENT_ID_LINUX"
PKG_PARENT_ID_MORETOEXPLORE_WINDOWS="$PKG_PARENT_ID_WINDOWS"
PKG_PARENT_ID_EMPERORSCHALLENGE_LINUX="$PKG_PARENT_ID_LINUX"
PKG_PARENT_ID_EMPERORSCHALLENGE_WINDOWS="$PKG_PARENT_ID_WINDOWS"

PKG_MAIN_ID_MORETOEXPLORE="${GAME_ID}-${EXPANSION_ID_MORETOEXPLORE}"
PKG_MAIN_ID_MORETOEXPLORE_LINUX="${PKG_MAIN_ID_MORETOEXPLORE}-linux"
PKG_MAIN_ID_MORETOEXPLORE_WINDOWS="${PKG_MAIN_ID_MORETOEXPLORE}-windows"
PKG_MAIN_ID_EMPERORSCHALLENGE="${GAME_ID}-${EXPANSION_ID_EMPERORSCHALLENGE}"
PKG_MAIN_ID_EMPERORSCHALLENGE_LINUX="${PKG_MAIN_ID_EMPERORSCHALLENGE}-linux"
PKG_MAIN_ID_EMPERORSCHALLENGE_WINDOWS="${PKG_MAIN_ID_EMPERORSCHALLENGE}-windows"
PKG_MAIN_PROVIDES_MORETOEXPLORE="
$PKG_MAIN_ID_MORETOEXPLORE"
PKG_MAIN_PROVIDES_EMPERORSCHALLENGE="
$PKG_MAIN_ID_EMPERORSCHALLENGE"
PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_PARENT'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
