/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.util;

import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.annotation.AnnotationAnalyzer;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class L {
    static boolean sEnableDebug = false;

    public static void setDebugLog(boolean enabled) {
        sEnableDebug = enabled;
    }

    public static void d(String msg, Object ... args) {
        if (sEnableDebug) {
            L.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
        }
    }

    public static void d(Throwable t, String msg, Object ... args) {
        if (sEnableDebug) {
            L.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args) + " " + ExceptionUtils.getStackTrace(t));
        }
    }

    public static void w(String msg, Object ... args) {
        L.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args));
    }

    public static void w(Throwable t, String msg, Object ... args) {
        L.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args) + " " + ExceptionUtils.getStackTrace(t));
    }

    public static void e(String msg, Object ... args) {
        L.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    public static void e(Throwable t, String msg, Object ... args) {
        L.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args) + " " + ExceptionUtils.getStackTrace(t));
    }

    private static void printMessage(Diagnostic.Kind kind, String message) {
        ModelAnalyzer modelAnalyzer = ModelAnalyzer.getInstance();
        System.out.println("[" + kind.name() + "]: " + message);
        if (modelAnalyzer instanceof AnnotationAnalyzer) {
            ((AnnotationAnalyzer)modelAnalyzer).getProcessingEnv().getMessager().printMessage(kind, message);
            if (kind == Diagnostic.Kind.ERROR) {
                throw new RuntimeException("failure, see logs for details.\n" + message);
            }
        } else if (kind == Diagnostic.Kind.ERROR) {
            throw new RuntimeException(message);
        }
    }
}

