//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _hrr_a0_55.cc
// Copyright (C) 2009 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <src/integral/hrrlist.h>
#include <array>
#include <algorithm>

using namespace std;
using namespace bagel;

void HRRList::perform_HRR_a0_55(const int nloop, const double* data_start, const array<double,3>& AB, double* data_out) {
  for (int c = 0; c != nloop; ++c) {
    auto current_data = &data_start[c * 251];
    auto current_out = &data_out[c * 441];
   {
     //current index a: xxxxx
      const auto a0_0 = current_data[0];
      const auto ax_0 = current_data[21];
      const auto ay_0 = current_data[22];
      const auto az_0 = current_data[28];
      const auto axx_0 = current_data[49];
      const auto axy_0 = current_data[50];
      const auto ayy_0 = current_data[51];
      const auto axz_0 = current_data[57];
      const auto ayz_0 = current_data[58];
      const auto azz_0 = current_data[64];
      const auto axxx_0 = current_data[85];
      const auto axxy_0 = current_data[86];
      const auto axyy_0 = current_data[87];
      const auto ayyy_0 = current_data[88];
      const auto axxz_0 = current_data[94];
      const auto axyz_0 = current_data[95];
      const auto ayyz_0 = current_data[96];
      const auto axzz_0 = current_data[102];
      const auto ayzz_0 = current_data[103];
      const auto azzz_0 = current_data[109];
      const auto axxxx_0 = current_data[130];
      const auto axxxy_0 = current_data[131];
      const auto axxyy_0 = current_data[132];
      const auto axyyy_0 = current_data[133];
      const auto ayyyy_0 = current_data[134];
      const auto axxxz_0 = current_data[140];
      const auto axxyz_0 = current_data[141];
      const auto axyyz_0 = current_data[142];
      const auto ayyyz_0 = current_data[143];
      const auto axxzz_0 = current_data[149];
      const auto axyzz_0 = current_data[150];
      const auto ayyzz_0 = current_data[151];
      const auto axzzz_0 = current_data[157];
      const auto ayzzz_0 = current_data[158];
      const auto azzzz_0 = current_data[164];
      const auto axxxxx_0 = current_data[185];
      const auto axxxxy_0 = current_data[186];
      const auto axxxyy_0 = current_data[187];
      const auto axxyyy_0 = current_data[188];
      const auto axyyyy_0 = current_data[189];
      const auto ayyyyy_0 = current_data[190];
      const auto axxxxz_0 = current_data[196];
      const auto axxxyz_0 = current_data[197];
      const auto axxyyz_0 = current_data[198];
      const auto axyyyz_0 = current_data[199];
      const auto ayyyyz_0 = current_data[200];
      const auto axxxzz_0 = current_data[206];
      const auto axxyzz_0 = current_data[207];
      const auto axyyzz_0 = current_data[208];
      const auto ayyyzz_0 = current_data[209];
      const auto axxzzz_0 = current_data[215];
      const auto axyzzz_0 = current_data[216];
      const auto ayyzzz_0 = current_data[217];
      const auto axzzzz_0 = current_data[223];
      const auto ayzzzz_0 = current_data[224];
      const auto azzzzz_0 = current_data[230];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[0] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[1] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[2] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[3] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[4] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[5] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[6] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[7] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[8] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[9] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[10] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[11] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[12] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[13] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[14] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[15] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[16] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[17] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[18] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[19] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[20] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xxxxy
      const auto a0_0 = current_data[1];
      const auto ax_0 = current_data[22];
      const auto ay_0 = current_data[23];
      const auto az_0 = current_data[29];
      const auto axx_0 = current_data[50];
      const auto axy_0 = current_data[51];
      const auto ayy_0 = current_data[52];
      const auto axz_0 = current_data[58];
      const auto ayz_0 = current_data[59];
      const auto azz_0 = current_data[65];
      const auto axxx_0 = current_data[86];
      const auto axxy_0 = current_data[87];
      const auto axyy_0 = current_data[88];
      const auto ayyy_0 = current_data[89];
      const auto axxz_0 = current_data[95];
      const auto axyz_0 = current_data[96];
      const auto ayyz_0 = current_data[97];
      const auto axzz_0 = current_data[103];
      const auto ayzz_0 = current_data[104];
      const auto azzz_0 = current_data[110];
      const auto axxxx_0 = current_data[131];
      const auto axxxy_0 = current_data[132];
      const auto axxyy_0 = current_data[133];
      const auto axyyy_0 = current_data[134];
      const auto ayyyy_0 = current_data[135];
      const auto axxxz_0 = current_data[141];
      const auto axxyz_0 = current_data[142];
      const auto axyyz_0 = current_data[143];
      const auto ayyyz_0 = current_data[144];
      const auto axxzz_0 = current_data[150];
      const auto axyzz_0 = current_data[151];
      const auto ayyzz_0 = current_data[152];
      const auto axzzz_0 = current_data[158];
      const auto ayzzz_0 = current_data[159];
      const auto azzzz_0 = current_data[165];
      const auto axxxxx_0 = current_data[186];
      const auto axxxxy_0 = current_data[187];
      const auto axxxyy_0 = current_data[188];
      const auto axxyyy_0 = current_data[189];
      const auto axyyyy_0 = current_data[190];
      const auto ayyyyy_0 = current_data[191];
      const auto axxxxz_0 = current_data[197];
      const auto axxxyz_0 = current_data[198];
      const auto axxyyz_0 = current_data[199];
      const auto axyyyz_0 = current_data[200];
      const auto ayyyyz_0 = current_data[201];
      const auto axxxzz_0 = current_data[207];
      const auto axxyzz_0 = current_data[208];
      const auto axyyzz_0 = current_data[209];
      const auto ayyyzz_0 = current_data[210];
      const auto axxzzz_0 = current_data[216];
      const auto axyzzz_0 = current_data[217];
      const auto ayyzzz_0 = current_data[218];
      const auto axzzzz_0 = current_data[224];
      const auto ayzzzz_0 = current_data[225];
      const auto azzzzz_0 = current_data[231];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[21] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[22] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[23] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[24] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[25] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[26] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[27] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[28] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[29] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[30] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[31] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[32] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[33] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[34] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[35] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[36] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[37] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[38] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[39] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[40] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[41] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xxxyy
      const auto a0_0 = current_data[2];
      const auto ax_0 = current_data[23];
      const auto ay_0 = current_data[24];
      const auto az_0 = current_data[30];
      const auto axx_0 = current_data[51];
      const auto axy_0 = current_data[52];
      const auto ayy_0 = current_data[53];
      const auto axz_0 = current_data[59];
      const auto ayz_0 = current_data[60];
      const auto azz_0 = current_data[66];
      const auto axxx_0 = current_data[87];
      const auto axxy_0 = current_data[88];
      const auto axyy_0 = current_data[89];
      const auto ayyy_0 = current_data[90];
      const auto axxz_0 = current_data[96];
      const auto axyz_0 = current_data[97];
      const auto ayyz_0 = current_data[98];
      const auto axzz_0 = current_data[104];
      const auto ayzz_0 = current_data[105];
      const auto azzz_0 = current_data[111];
      const auto axxxx_0 = current_data[132];
      const auto axxxy_0 = current_data[133];
      const auto axxyy_0 = current_data[134];
      const auto axyyy_0 = current_data[135];
      const auto ayyyy_0 = current_data[136];
      const auto axxxz_0 = current_data[142];
      const auto axxyz_0 = current_data[143];
      const auto axyyz_0 = current_data[144];
      const auto ayyyz_0 = current_data[145];
      const auto axxzz_0 = current_data[151];
      const auto axyzz_0 = current_data[152];
      const auto ayyzz_0 = current_data[153];
      const auto axzzz_0 = current_data[159];
      const auto ayzzz_0 = current_data[160];
      const auto azzzz_0 = current_data[166];
      const auto axxxxx_0 = current_data[187];
      const auto axxxxy_0 = current_data[188];
      const auto axxxyy_0 = current_data[189];
      const auto axxyyy_0 = current_data[190];
      const auto axyyyy_0 = current_data[191];
      const auto ayyyyy_0 = current_data[192];
      const auto axxxxz_0 = current_data[198];
      const auto axxxyz_0 = current_data[199];
      const auto axxyyz_0 = current_data[200];
      const auto axyyyz_0 = current_data[201];
      const auto ayyyyz_0 = current_data[202];
      const auto axxxzz_0 = current_data[208];
      const auto axxyzz_0 = current_data[209];
      const auto axyyzz_0 = current_data[210];
      const auto ayyyzz_0 = current_data[211];
      const auto axxzzz_0 = current_data[217];
      const auto axyzzz_0 = current_data[218];
      const auto ayyzzz_0 = current_data[219];
      const auto axzzzz_0 = current_data[225];
      const auto ayzzzz_0 = current_data[226];
      const auto azzzzz_0 = current_data[232];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[42] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[43] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[44] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[45] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[46] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[47] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[48] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[49] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[50] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[51] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[52] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[53] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[54] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[55] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[56] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[57] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[58] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[59] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[60] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[61] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[62] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xxyyy
      const auto a0_0 = current_data[3];
      const auto ax_0 = current_data[24];
      const auto ay_0 = current_data[25];
      const auto az_0 = current_data[31];
      const auto axx_0 = current_data[52];
      const auto axy_0 = current_data[53];
      const auto ayy_0 = current_data[54];
      const auto axz_0 = current_data[60];
      const auto ayz_0 = current_data[61];
      const auto azz_0 = current_data[67];
      const auto axxx_0 = current_data[88];
      const auto axxy_0 = current_data[89];
      const auto axyy_0 = current_data[90];
      const auto ayyy_0 = current_data[91];
      const auto axxz_0 = current_data[97];
      const auto axyz_0 = current_data[98];
      const auto ayyz_0 = current_data[99];
      const auto axzz_0 = current_data[105];
      const auto ayzz_0 = current_data[106];
      const auto azzz_0 = current_data[112];
      const auto axxxx_0 = current_data[133];
      const auto axxxy_0 = current_data[134];
      const auto axxyy_0 = current_data[135];
      const auto axyyy_0 = current_data[136];
      const auto ayyyy_0 = current_data[137];
      const auto axxxz_0 = current_data[143];
      const auto axxyz_0 = current_data[144];
      const auto axyyz_0 = current_data[145];
      const auto ayyyz_0 = current_data[146];
      const auto axxzz_0 = current_data[152];
      const auto axyzz_0 = current_data[153];
      const auto ayyzz_0 = current_data[154];
      const auto axzzz_0 = current_data[160];
      const auto ayzzz_0 = current_data[161];
      const auto azzzz_0 = current_data[167];
      const auto axxxxx_0 = current_data[188];
      const auto axxxxy_0 = current_data[189];
      const auto axxxyy_0 = current_data[190];
      const auto axxyyy_0 = current_data[191];
      const auto axyyyy_0 = current_data[192];
      const auto ayyyyy_0 = current_data[193];
      const auto axxxxz_0 = current_data[199];
      const auto axxxyz_0 = current_data[200];
      const auto axxyyz_0 = current_data[201];
      const auto axyyyz_0 = current_data[202];
      const auto ayyyyz_0 = current_data[203];
      const auto axxxzz_0 = current_data[209];
      const auto axxyzz_0 = current_data[210];
      const auto axyyzz_0 = current_data[211];
      const auto ayyyzz_0 = current_data[212];
      const auto axxzzz_0 = current_data[218];
      const auto axyzzz_0 = current_data[219];
      const auto ayyzzz_0 = current_data[220];
      const auto axzzzz_0 = current_data[226];
      const auto ayzzzz_0 = current_data[227];
      const auto azzzzz_0 = current_data[233];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[63] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[64] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[65] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[66] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[67] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[68] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[69] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[70] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[71] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[72] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[73] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[74] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[75] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[76] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[77] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[78] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[79] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[80] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[81] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[82] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[83] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xyyyy
      const auto a0_0 = current_data[4];
      const auto ax_0 = current_data[25];
      const auto ay_0 = current_data[26];
      const auto az_0 = current_data[32];
      const auto axx_0 = current_data[53];
      const auto axy_0 = current_data[54];
      const auto ayy_0 = current_data[55];
      const auto axz_0 = current_data[61];
      const auto ayz_0 = current_data[62];
      const auto azz_0 = current_data[68];
      const auto axxx_0 = current_data[89];
      const auto axxy_0 = current_data[90];
      const auto axyy_0 = current_data[91];
      const auto ayyy_0 = current_data[92];
      const auto axxz_0 = current_data[98];
      const auto axyz_0 = current_data[99];
      const auto ayyz_0 = current_data[100];
      const auto axzz_0 = current_data[106];
      const auto ayzz_0 = current_data[107];
      const auto azzz_0 = current_data[113];
      const auto axxxx_0 = current_data[134];
      const auto axxxy_0 = current_data[135];
      const auto axxyy_0 = current_data[136];
      const auto axyyy_0 = current_data[137];
      const auto ayyyy_0 = current_data[138];
      const auto axxxz_0 = current_data[144];
      const auto axxyz_0 = current_data[145];
      const auto axyyz_0 = current_data[146];
      const auto ayyyz_0 = current_data[147];
      const auto axxzz_0 = current_data[153];
      const auto axyzz_0 = current_data[154];
      const auto ayyzz_0 = current_data[155];
      const auto axzzz_0 = current_data[161];
      const auto ayzzz_0 = current_data[162];
      const auto azzzz_0 = current_data[168];
      const auto axxxxx_0 = current_data[189];
      const auto axxxxy_0 = current_data[190];
      const auto axxxyy_0 = current_data[191];
      const auto axxyyy_0 = current_data[192];
      const auto axyyyy_0 = current_data[193];
      const auto ayyyyy_0 = current_data[194];
      const auto axxxxz_0 = current_data[200];
      const auto axxxyz_0 = current_data[201];
      const auto axxyyz_0 = current_data[202];
      const auto axyyyz_0 = current_data[203];
      const auto ayyyyz_0 = current_data[204];
      const auto axxxzz_0 = current_data[210];
      const auto axxyzz_0 = current_data[211];
      const auto axyyzz_0 = current_data[212];
      const auto ayyyzz_0 = current_data[213];
      const auto axxzzz_0 = current_data[219];
      const auto axyzzz_0 = current_data[220];
      const auto ayyzzz_0 = current_data[221];
      const auto axzzzz_0 = current_data[227];
      const auto ayzzzz_0 = current_data[228];
      const auto azzzzz_0 = current_data[234];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[84] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[85] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[86] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[87] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[88] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[89] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[90] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[91] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[92] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[93] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[94] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[95] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[96] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[97] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[98] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[99] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[100] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[101] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[102] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[103] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[104] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: yyyyy
      const auto a0_0 = current_data[5];
      const auto ax_0 = current_data[26];
      const auto ay_0 = current_data[27];
      const auto az_0 = current_data[33];
      const auto axx_0 = current_data[54];
      const auto axy_0 = current_data[55];
      const auto ayy_0 = current_data[56];
      const auto axz_0 = current_data[62];
      const auto ayz_0 = current_data[63];
      const auto azz_0 = current_data[69];
      const auto axxx_0 = current_data[90];
      const auto axxy_0 = current_data[91];
      const auto axyy_0 = current_data[92];
      const auto ayyy_0 = current_data[93];
      const auto axxz_0 = current_data[99];
      const auto axyz_0 = current_data[100];
      const auto ayyz_0 = current_data[101];
      const auto axzz_0 = current_data[107];
      const auto ayzz_0 = current_data[108];
      const auto azzz_0 = current_data[114];
      const auto axxxx_0 = current_data[135];
      const auto axxxy_0 = current_data[136];
      const auto axxyy_0 = current_data[137];
      const auto axyyy_0 = current_data[138];
      const auto ayyyy_0 = current_data[139];
      const auto axxxz_0 = current_data[145];
      const auto axxyz_0 = current_data[146];
      const auto axyyz_0 = current_data[147];
      const auto ayyyz_0 = current_data[148];
      const auto axxzz_0 = current_data[154];
      const auto axyzz_0 = current_data[155];
      const auto ayyzz_0 = current_data[156];
      const auto axzzz_0 = current_data[162];
      const auto ayzzz_0 = current_data[163];
      const auto azzzz_0 = current_data[169];
      const auto axxxxx_0 = current_data[190];
      const auto axxxxy_0 = current_data[191];
      const auto axxxyy_0 = current_data[192];
      const auto axxyyy_0 = current_data[193];
      const auto axyyyy_0 = current_data[194];
      const auto ayyyyy_0 = current_data[195];
      const auto axxxxz_0 = current_data[201];
      const auto axxxyz_0 = current_data[202];
      const auto axxyyz_0 = current_data[203];
      const auto axyyyz_0 = current_data[204];
      const auto ayyyyz_0 = current_data[205];
      const auto axxxzz_0 = current_data[211];
      const auto axxyzz_0 = current_data[212];
      const auto axyyzz_0 = current_data[213];
      const auto ayyyzz_0 = current_data[214];
      const auto axxzzz_0 = current_data[220];
      const auto axyzzz_0 = current_data[221];
      const auto ayyzzz_0 = current_data[222];
      const auto axzzzz_0 = current_data[228];
      const auto ayzzzz_0 = current_data[229];
      const auto azzzzz_0 = current_data[235];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[105] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[106] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[107] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[108] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[109] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[110] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[111] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[112] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[113] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[114] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[115] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[116] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[117] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[118] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[119] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[120] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[121] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[122] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[123] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[124] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[125] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xxxxz
      const auto a0_0 = current_data[6];
      const auto ax_0 = current_data[28];
      const auto ay_0 = current_data[29];
      const auto az_0 = current_data[34];
      const auto axx_0 = current_data[57];
      const auto axy_0 = current_data[58];
      const auto ayy_0 = current_data[59];
      const auto axz_0 = current_data[64];
      const auto ayz_0 = current_data[65];
      const auto azz_0 = current_data[70];
      const auto axxx_0 = current_data[94];
      const auto axxy_0 = current_data[95];
      const auto axyy_0 = current_data[96];
      const auto ayyy_0 = current_data[97];
      const auto axxz_0 = current_data[102];
      const auto axyz_0 = current_data[103];
      const auto ayyz_0 = current_data[104];
      const auto axzz_0 = current_data[109];
      const auto ayzz_0 = current_data[110];
      const auto azzz_0 = current_data[115];
      const auto axxxx_0 = current_data[140];
      const auto axxxy_0 = current_data[141];
      const auto axxyy_0 = current_data[142];
      const auto axyyy_0 = current_data[143];
      const auto ayyyy_0 = current_data[144];
      const auto axxxz_0 = current_data[149];
      const auto axxyz_0 = current_data[150];
      const auto axyyz_0 = current_data[151];
      const auto ayyyz_0 = current_data[152];
      const auto axxzz_0 = current_data[157];
      const auto axyzz_0 = current_data[158];
      const auto ayyzz_0 = current_data[159];
      const auto axzzz_0 = current_data[164];
      const auto ayzzz_0 = current_data[165];
      const auto azzzz_0 = current_data[170];
      const auto axxxxx_0 = current_data[196];
      const auto axxxxy_0 = current_data[197];
      const auto axxxyy_0 = current_data[198];
      const auto axxyyy_0 = current_data[199];
      const auto axyyyy_0 = current_data[200];
      const auto ayyyyy_0 = current_data[201];
      const auto axxxxz_0 = current_data[206];
      const auto axxxyz_0 = current_data[207];
      const auto axxyyz_0 = current_data[208];
      const auto axyyyz_0 = current_data[209];
      const auto ayyyyz_0 = current_data[210];
      const auto axxxzz_0 = current_data[215];
      const auto axxyzz_0 = current_data[216];
      const auto axyyzz_0 = current_data[217];
      const auto ayyyzz_0 = current_data[218];
      const auto axxzzz_0 = current_data[223];
      const auto axyzzz_0 = current_data[224];
      const auto ayyzzz_0 = current_data[225];
      const auto axzzzz_0 = current_data[230];
      const auto ayzzzz_0 = current_data[231];
      const auto azzzzz_0 = current_data[236];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[126] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[127] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[128] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[129] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[130] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[131] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[132] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[133] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[134] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[135] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[136] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[137] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[138] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[139] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[140] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[141] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[142] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[143] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[144] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[145] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[146] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xxxyz
      const auto a0_0 = current_data[7];
      const auto ax_0 = current_data[29];
      const auto ay_0 = current_data[30];
      const auto az_0 = current_data[35];
      const auto axx_0 = current_data[58];
      const auto axy_0 = current_data[59];
      const auto ayy_0 = current_data[60];
      const auto axz_0 = current_data[65];
      const auto ayz_0 = current_data[66];
      const auto azz_0 = current_data[71];
      const auto axxx_0 = current_data[95];
      const auto axxy_0 = current_data[96];
      const auto axyy_0 = current_data[97];
      const auto ayyy_0 = current_data[98];
      const auto axxz_0 = current_data[103];
      const auto axyz_0 = current_data[104];
      const auto ayyz_0 = current_data[105];
      const auto axzz_0 = current_data[110];
      const auto ayzz_0 = current_data[111];
      const auto azzz_0 = current_data[116];
      const auto axxxx_0 = current_data[141];
      const auto axxxy_0 = current_data[142];
      const auto axxyy_0 = current_data[143];
      const auto axyyy_0 = current_data[144];
      const auto ayyyy_0 = current_data[145];
      const auto axxxz_0 = current_data[150];
      const auto axxyz_0 = current_data[151];
      const auto axyyz_0 = current_data[152];
      const auto ayyyz_0 = current_data[153];
      const auto axxzz_0 = current_data[158];
      const auto axyzz_0 = current_data[159];
      const auto ayyzz_0 = current_data[160];
      const auto axzzz_0 = current_data[165];
      const auto ayzzz_0 = current_data[166];
      const auto azzzz_0 = current_data[171];
      const auto axxxxx_0 = current_data[197];
      const auto axxxxy_0 = current_data[198];
      const auto axxxyy_0 = current_data[199];
      const auto axxyyy_0 = current_data[200];
      const auto axyyyy_0 = current_data[201];
      const auto ayyyyy_0 = current_data[202];
      const auto axxxxz_0 = current_data[207];
      const auto axxxyz_0 = current_data[208];
      const auto axxyyz_0 = current_data[209];
      const auto axyyyz_0 = current_data[210];
      const auto ayyyyz_0 = current_data[211];
      const auto axxxzz_0 = current_data[216];
      const auto axxyzz_0 = current_data[217];
      const auto axyyzz_0 = current_data[218];
      const auto ayyyzz_0 = current_data[219];
      const auto axxzzz_0 = current_data[224];
      const auto axyzzz_0 = current_data[225];
      const auto ayyzzz_0 = current_data[226];
      const auto axzzzz_0 = current_data[231];
      const auto ayzzzz_0 = current_data[232];
      const auto azzzzz_0 = current_data[237];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[147] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[148] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[149] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[150] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[151] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[152] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[153] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[154] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[155] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[156] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[157] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[158] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[159] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[160] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[161] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[162] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[163] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[164] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[165] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[166] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[167] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xxyyz
      const auto a0_0 = current_data[8];
      const auto ax_0 = current_data[30];
      const auto ay_0 = current_data[31];
      const auto az_0 = current_data[36];
      const auto axx_0 = current_data[59];
      const auto axy_0 = current_data[60];
      const auto ayy_0 = current_data[61];
      const auto axz_0 = current_data[66];
      const auto ayz_0 = current_data[67];
      const auto azz_0 = current_data[72];
      const auto axxx_0 = current_data[96];
      const auto axxy_0 = current_data[97];
      const auto axyy_0 = current_data[98];
      const auto ayyy_0 = current_data[99];
      const auto axxz_0 = current_data[104];
      const auto axyz_0 = current_data[105];
      const auto ayyz_0 = current_data[106];
      const auto axzz_0 = current_data[111];
      const auto ayzz_0 = current_data[112];
      const auto azzz_0 = current_data[117];
      const auto axxxx_0 = current_data[142];
      const auto axxxy_0 = current_data[143];
      const auto axxyy_0 = current_data[144];
      const auto axyyy_0 = current_data[145];
      const auto ayyyy_0 = current_data[146];
      const auto axxxz_0 = current_data[151];
      const auto axxyz_0 = current_data[152];
      const auto axyyz_0 = current_data[153];
      const auto ayyyz_0 = current_data[154];
      const auto axxzz_0 = current_data[159];
      const auto axyzz_0 = current_data[160];
      const auto ayyzz_0 = current_data[161];
      const auto axzzz_0 = current_data[166];
      const auto ayzzz_0 = current_data[167];
      const auto azzzz_0 = current_data[172];
      const auto axxxxx_0 = current_data[198];
      const auto axxxxy_0 = current_data[199];
      const auto axxxyy_0 = current_data[200];
      const auto axxyyy_0 = current_data[201];
      const auto axyyyy_0 = current_data[202];
      const auto ayyyyy_0 = current_data[203];
      const auto axxxxz_0 = current_data[208];
      const auto axxxyz_0 = current_data[209];
      const auto axxyyz_0 = current_data[210];
      const auto axyyyz_0 = current_data[211];
      const auto ayyyyz_0 = current_data[212];
      const auto axxxzz_0 = current_data[217];
      const auto axxyzz_0 = current_data[218];
      const auto axyyzz_0 = current_data[219];
      const auto ayyyzz_0 = current_data[220];
      const auto axxzzz_0 = current_data[225];
      const auto axyzzz_0 = current_data[226];
      const auto ayyzzz_0 = current_data[227];
      const auto axzzzz_0 = current_data[232];
      const auto ayzzzz_0 = current_data[233];
      const auto azzzzz_0 = current_data[238];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[168] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[169] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[170] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[171] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[172] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[173] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[174] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[175] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[176] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[177] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[178] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[179] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[180] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[181] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[182] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[183] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[184] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[185] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[186] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[187] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[188] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xyyyz
      const auto a0_0 = current_data[9];
      const auto ax_0 = current_data[31];
      const auto ay_0 = current_data[32];
      const auto az_0 = current_data[37];
      const auto axx_0 = current_data[60];
      const auto axy_0 = current_data[61];
      const auto ayy_0 = current_data[62];
      const auto axz_0 = current_data[67];
      const auto ayz_0 = current_data[68];
      const auto azz_0 = current_data[73];
      const auto axxx_0 = current_data[97];
      const auto axxy_0 = current_data[98];
      const auto axyy_0 = current_data[99];
      const auto ayyy_0 = current_data[100];
      const auto axxz_0 = current_data[105];
      const auto axyz_0 = current_data[106];
      const auto ayyz_0 = current_data[107];
      const auto axzz_0 = current_data[112];
      const auto ayzz_0 = current_data[113];
      const auto azzz_0 = current_data[118];
      const auto axxxx_0 = current_data[143];
      const auto axxxy_0 = current_data[144];
      const auto axxyy_0 = current_data[145];
      const auto axyyy_0 = current_data[146];
      const auto ayyyy_0 = current_data[147];
      const auto axxxz_0 = current_data[152];
      const auto axxyz_0 = current_data[153];
      const auto axyyz_0 = current_data[154];
      const auto ayyyz_0 = current_data[155];
      const auto axxzz_0 = current_data[160];
      const auto axyzz_0 = current_data[161];
      const auto ayyzz_0 = current_data[162];
      const auto axzzz_0 = current_data[167];
      const auto ayzzz_0 = current_data[168];
      const auto azzzz_0 = current_data[173];
      const auto axxxxx_0 = current_data[199];
      const auto axxxxy_0 = current_data[200];
      const auto axxxyy_0 = current_data[201];
      const auto axxyyy_0 = current_data[202];
      const auto axyyyy_0 = current_data[203];
      const auto ayyyyy_0 = current_data[204];
      const auto axxxxz_0 = current_data[209];
      const auto axxxyz_0 = current_data[210];
      const auto axxyyz_0 = current_data[211];
      const auto axyyyz_0 = current_data[212];
      const auto ayyyyz_0 = current_data[213];
      const auto axxxzz_0 = current_data[218];
      const auto axxyzz_0 = current_data[219];
      const auto axyyzz_0 = current_data[220];
      const auto ayyyzz_0 = current_data[221];
      const auto axxzzz_0 = current_data[226];
      const auto axyzzz_0 = current_data[227];
      const auto ayyzzz_0 = current_data[228];
      const auto axzzzz_0 = current_data[233];
      const auto ayzzzz_0 = current_data[234];
      const auto azzzzz_0 = current_data[239];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[189] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[190] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[191] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[192] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[193] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[194] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[195] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[196] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[197] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[198] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[199] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[200] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[201] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[202] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[203] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[204] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[205] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[206] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[207] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[208] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[209] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: yyyyz
      const auto a0_0 = current_data[10];
      const auto ax_0 = current_data[32];
      const auto ay_0 = current_data[33];
      const auto az_0 = current_data[38];
      const auto axx_0 = current_data[61];
      const auto axy_0 = current_data[62];
      const auto ayy_0 = current_data[63];
      const auto axz_0 = current_data[68];
      const auto ayz_0 = current_data[69];
      const auto azz_0 = current_data[74];
      const auto axxx_0 = current_data[98];
      const auto axxy_0 = current_data[99];
      const auto axyy_0 = current_data[100];
      const auto ayyy_0 = current_data[101];
      const auto axxz_0 = current_data[106];
      const auto axyz_0 = current_data[107];
      const auto ayyz_0 = current_data[108];
      const auto axzz_0 = current_data[113];
      const auto ayzz_0 = current_data[114];
      const auto azzz_0 = current_data[119];
      const auto axxxx_0 = current_data[144];
      const auto axxxy_0 = current_data[145];
      const auto axxyy_0 = current_data[146];
      const auto axyyy_0 = current_data[147];
      const auto ayyyy_0 = current_data[148];
      const auto axxxz_0 = current_data[153];
      const auto axxyz_0 = current_data[154];
      const auto axyyz_0 = current_data[155];
      const auto ayyyz_0 = current_data[156];
      const auto axxzz_0 = current_data[161];
      const auto axyzz_0 = current_data[162];
      const auto ayyzz_0 = current_data[163];
      const auto axzzz_0 = current_data[168];
      const auto ayzzz_0 = current_data[169];
      const auto azzzz_0 = current_data[174];
      const auto axxxxx_0 = current_data[200];
      const auto axxxxy_0 = current_data[201];
      const auto axxxyy_0 = current_data[202];
      const auto axxyyy_0 = current_data[203];
      const auto axyyyy_0 = current_data[204];
      const auto ayyyyy_0 = current_data[205];
      const auto axxxxz_0 = current_data[210];
      const auto axxxyz_0 = current_data[211];
      const auto axxyyz_0 = current_data[212];
      const auto axyyyz_0 = current_data[213];
      const auto ayyyyz_0 = current_data[214];
      const auto axxxzz_0 = current_data[219];
      const auto axxyzz_0 = current_data[220];
      const auto axyyzz_0 = current_data[221];
      const auto ayyyzz_0 = current_data[222];
      const auto axxzzz_0 = current_data[227];
      const auto axyzzz_0 = current_data[228];
      const auto ayyzzz_0 = current_data[229];
      const auto axzzzz_0 = current_data[234];
      const auto ayzzzz_0 = current_data[235];
      const auto azzzzz_0 = current_data[240];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[210] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[211] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[212] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[213] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[214] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[215] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[216] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[217] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[218] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[219] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[220] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[221] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[222] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[223] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[224] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[225] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[226] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[227] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[228] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[229] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[230] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xxxzz
      const auto a0_0 = current_data[11];
      const auto ax_0 = current_data[34];
      const auto ay_0 = current_data[35];
      const auto az_0 = current_data[39];
      const auto axx_0 = current_data[64];
      const auto axy_0 = current_data[65];
      const auto ayy_0 = current_data[66];
      const auto axz_0 = current_data[70];
      const auto ayz_0 = current_data[71];
      const auto azz_0 = current_data[75];
      const auto axxx_0 = current_data[102];
      const auto axxy_0 = current_data[103];
      const auto axyy_0 = current_data[104];
      const auto ayyy_0 = current_data[105];
      const auto axxz_0 = current_data[109];
      const auto axyz_0 = current_data[110];
      const auto ayyz_0 = current_data[111];
      const auto axzz_0 = current_data[115];
      const auto ayzz_0 = current_data[116];
      const auto azzz_0 = current_data[120];
      const auto axxxx_0 = current_data[149];
      const auto axxxy_0 = current_data[150];
      const auto axxyy_0 = current_data[151];
      const auto axyyy_0 = current_data[152];
      const auto ayyyy_0 = current_data[153];
      const auto axxxz_0 = current_data[157];
      const auto axxyz_0 = current_data[158];
      const auto axyyz_0 = current_data[159];
      const auto ayyyz_0 = current_data[160];
      const auto axxzz_0 = current_data[164];
      const auto axyzz_0 = current_data[165];
      const auto ayyzz_0 = current_data[166];
      const auto axzzz_0 = current_data[170];
      const auto ayzzz_0 = current_data[171];
      const auto azzzz_0 = current_data[175];
      const auto axxxxx_0 = current_data[206];
      const auto axxxxy_0 = current_data[207];
      const auto axxxyy_0 = current_data[208];
      const auto axxyyy_0 = current_data[209];
      const auto axyyyy_0 = current_data[210];
      const auto ayyyyy_0 = current_data[211];
      const auto axxxxz_0 = current_data[215];
      const auto axxxyz_0 = current_data[216];
      const auto axxyyz_0 = current_data[217];
      const auto axyyyz_0 = current_data[218];
      const auto ayyyyz_0 = current_data[219];
      const auto axxxzz_0 = current_data[223];
      const auto axxyzz_0 = current_data[224];
      const auto axyyzz_0 = current_data[225];
      const auto ayyyzz_0 = current_data[226];
      const auto axxzzz_0 = current_data[230];
      const auto axyzzz_0 = current_data[231];
      const auto ayyzzz_0 = current_data[232];
      const auto axzzzz_0 = current_data[236];
      const auto ayzzzz_0 = current_data[237];
      const auto azzzzz_0 = current_data[241];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[231] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[232] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[233] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[234] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[235] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[236] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[237] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[238] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[239] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[240] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[241] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[242] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[243] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[244] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[245] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[246] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[247] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[248] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[249] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[250] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[251] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xxyzz
      const auto a0_0 = current_data[12];
      const auto ax_0 = current_data[35];
      const auto ay_0 = current_data[36];
      const auto az_0 = current_data[40];
      const auto axx_0 = current_data[65];
      const auto axy_0 = current_data[66];
      const auto ayy_0 = current_data[67];
      const auto axz_0 = current_data[71];
      const auto ayz_0 = current_data[72];
      const auto azz_0 = current_data[76];
      const auto axxx_0 = current_data[103];
      const auto axxy_0 = current_data[104];
      const auto axyy_0 = current_data[105];
      const auto ayyy_0 = current_data[106];
      const auto axxz_0 = current_data[110];
      const auto axyz_0 = current_data[111];
      const auto ayyz_0 = current_data[112];
      const auto axzz_0 = current_data[116];
      const auto ayzz_0 = current_data[117];
      const auto azzz_0 = current_data[121];
      const auto axxxx_0 = current_data[150];
      const auto axxxy_0 = current_data[151];
      const auto axxyy_0 = current_data[152];
      const auto axyyy_0 = current_data[153];
      const auto ayyyy_0 = current_data[154];
      const auto axxxz_0 = current_data[158];
      const auto axxyz_0 = current_data[159];
      const auto axyyz_0 = current_data[160];
      const auto ayyyz_0 = current_data[161];
      const auto axxzz_0 = current_data[165];
      const auto axyzz_0 = current_data[166];
      const auto ayyzz_0 = current_data[167];
      const auto axzzz_0 = current_data[171];
      const auto ayzzz_0 = current_data[172];
      const auto azzzz_0 = current_data[176];
      const auto axxxxx_0 = current_data[207];
      const auto axxxxy_0 = current_data[208];
      const auto axxxyy_0 = current_data[209];
      const auto axxyyy_0 = current_data[210];
      const auto axyyyy_0 = current_data[211];
      const auto ayyyyy_0 = current_data[212];
      const auto axxxxz_0 = current_data[216];
      const auto axxxyz_0 = current_data[217];
      const auto axxyyz_0 = current_data[218];
      const auto axyyyz_0 = current_data[219];
      const auto ayyyyz_0 = current_data[220];
      const auto axxxzz_0 = current_data[224];
      const auto axxyzz_0 = current_data[225];
      const auto axyyzz_0 = current_data[226];
      const auto ayyyzz_0 = current_data[227];
      const auto axxzzz_0 = current_data[231];
      const auto axyzzz_0 = current_data[232];
      const auto ayyzzz_0 = current_data[233];
      const auto axzzzz_0 = current_data[237];
      const auto ayzzzz_0 = current_data[238];
      const auto azzzzz_0 = current_data[242];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[252] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[253] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[254] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[255] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[256] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[257] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[258] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[259] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[260] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[261] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[262] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[263] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[264] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[265] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[266] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[267] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[268] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[269] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[270] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[271] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[272] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xyyzz
      const auto a0_0 = current_data[13];
      const auto ax_0 = current_data[36];
      const auto ay_0 = current_data[37];
      const auto az_0 = current_data[41];
      const auto axx_0 = current_data[66];
      const auto axy_0 = current_data[67];
      const auto ayy_0 = current_data[68];
      const auto axz_0 = current_data[72];
      const auto ayz_0 = current_data[73];
      const auto azz_0 = current_data[77];
      const auto axxx_0 = current_data[104];
      const auto axxy_0 = current_data[105];
      const auto axyy_0 = current_data[106];
      const auto ayyy_0 = current_data[107];
      const auto axxz_0 = current_data[111];
      const auto axyz_0 = current_data[112];
      const auto ayyz_0 = current_data[113];
      const auto axzz_0 = current_data[117];
      const auto ayzz_0 = current_data[118];
      const auto azzz_0 = current_data[122];
      const auto axxxx_0 = current_data[151];
      const auto axxxy_0 = current_data[152];
      const auto axxyy_0 = current_data[153];
      const auto axyyy_0 = current_data[154];
      const auto ayyyy_0 = current_data[155];
      const auto axxxz_0 = current_data[159];
      const auto axxyz_0 = current_data[160];
      const auto axyyz_0 = current_data[161];
      const auto ayyyz_0 = current_data[162];
      const auto axxzz_0 = current_data[166];
      const auto axyzz_0 = current_data[167];
      const auto ayyzz_0 = current_data[168];
      const auto axzzz_0 = current_data[172];
      const auto ayzzz_0 = current_data[173];
      const auto azzzz_0 = current_data[177];
      const auto axxxxx_0 = current_data[208];
      const auto axxxxy_0 = current_data[209];
      const auto axxxyy_0 = current_data[210];
      const auto axxyyy_0 = current_data[211];
      const auto axyyyy_0 = current_data[212];
      const auto ayyyyy_0 = current_data[213];
      const auto axxxxz_0 = current_data[217];
      const auto axxxyz_0 = current_data[218];
      const auto axxyyz_0 = current_data[219];
      const auto axyyyz_0 = current_data[220];
      const auto ayyyyz_0 = current_data[221];
      const auto axxxzz_0 = current_data[225];
      const auto axxyzz_0 = current_data[226];
      const auto axyyzz_0 = current_data[227];
      const auto ayyyzz_0 = current_data[228];
      const auto axxzzz_0 = current_data[232];
      const auto axyzzz_0 = current_data[233];
      const auto ayyzzz_0 = current_data[234];
      const auto axzzzz_0 = current_data[238];
      const auto ayzzzz_0 = current_data[239];
      const auto azzzzz_0 = current_data[243];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[273] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[274] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[275] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[276] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[277] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[278] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[279] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[280] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[281] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[282] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[283] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[284] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[285] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[286] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[287] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[288] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[289] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[290] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[291] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[292] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[293] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: yyyzz
      const auto a0_0 = current_data[14];
      const auto ax_0 = current_data[37];
      const auto ay_0 = current_data[38];
      const auto az_0 = current_data[42];
      const auto axx_0 = current_data[67];
      const auto axy_0 = current_data[68];
      const auto ayy_0 = current_data[69];
      const auto axz_0 = current_data[73];
      const auto ayz_0 = current_data[74];
      const auto azz_0 = current_data[78];
      const auto axxx_0 = current_data[105];
      const auto axxy_0 = current_data[106];
      const auto axyy_0 = current_data[107];
      const auto ayyy_0 = current_data[108];
      const auto axxz_0 = current_data[112];
      const auto axyz_0 = current_data[113];
      const auto ayyz_0 = current_data[114];
      const auto axzz_0 = current_data[118];
      const auto ayzz_0 = current_data[119];
      const auto azzz_0 = current_data[123];
      const auto axxxx_0 = current_data[152];
      const auto axxxy_0 = current_data[153];
      const auto axxyy_0 = current_data[154];
      const auto axyyy_0 = current_data[155];
      const auto ayyyy_0 = current_data[156];
      const auto axxxz_0 = current_data[160];
      const auto axxyz_0 = current_data[161];
      const auto axyyz_0 = current_data[162];
      const auto ayyyz_0 = current_data[163];
      const auto axxzz_0 = current_data[167];
      const auto axyzz_0 = current_data[168];
      const auto ayyzz_0 = current_data[169];
      const auto axzzz_0 = current_data[173];
      const auto ayzzz_0 = current_data[174];
      const auto azzzz_0 = current_data[178];
      const auto axxxxx_0 = current_data[209];
      const auto axxxxy_0 = current_data[210];
      const auto axxxyy_0 = current_data[211];
      const auto axxyyy_0 = current_data[212];
      const auto axyyyy_0 = current_data[213];
      const auto ayyyyy_0 = current_data[214];
      const auto axxxxz_0 = current_data[218];
      const auto axxxyz_0 = current_data[219];
      const auto axxyyz_0 = current_data[220];
      const auto axyyyz_0 = current_data[221];
      const auto ayyyyz_0 = current_data[222];
      const auto axxxzz_0 = current_data[226];
      const auto axxyzz_0 = current_data[227];
      const auto axyyzz_0 = current_data[228];
      const auto ayyyzz_0 = current_data[229];
      const auto axxzzz_0 = current_data[233];
      const auto axyzzz_0 = current_data[234];
      const auto ayyzzz_0 = current_data[235];
      const auto axzzzz_0 = current_data[239];
      const auto ayzzzz_0 = current_data[240];
      const auto azzzzz_0 = current_data[244];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[294] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[295] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[296] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[297] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[298] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[299] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[300] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[301] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[302] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[303] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[304] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[305] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[306] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[307] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[308] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[309] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[310] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[311] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[312] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[313] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[314] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xxzzz
      const auto a0_0 = current_data[15];
      const auto ax_0 = current_data[39];
      const auto ay_0 = current_data[40];
      const auto az_0 = current_data[43];
      const auto axx_0 = current_data[70];
      const auto axy_0 = current_data[71];
      const auto ayy_0 = current_data[72];
      const auto axz_0 = current_data[75];
      const auto ayz_0 = current_data[76];
      const auto azz_0 = current_data[79];
      const auto axxx_0 = current_data[109];
      const auto axxy_0 = current_data[110];
      const auto axyy_0 = current_data[111];
      const auto ayyy_0 = current_data[112];
      const auto axxz_0 = current_data[115];
      const auto axyz_0 = current_data[116];
      const auto ayyz_0 = current_data[117];
      const auto axzz_0 = current_data[120];
      const auto ayzz_0 = current_data[121];
      const auto azzz_0 = current_data[124];
      const auto axxxx_0 = current_data[157];
      const auto axxxy_0 = current_data[158];
      const auto axxyy_0 = current_data[159];
      const auto axyyy_0 = current_data[160];
      const auto ayyyy_0 = current_data[161];
      const auto axxxz_0 = current_data[164];
      const auto axxyz_0 = current_data[165];
      const auto axyyz_0 = current_data[166];
      const auto ayyyz_0 = current_data[167];
      const auto axxzz_0 = current_data[170];
      const auto axyzz_0 = current_data[171];
      const auto ayyzz_0 = current_data[172];
      const auto axzzz_0 = current_data[175];
      const auto ayzzz_0 = current_data[176];
      const auto azzzz_0 = current_data[179];
      const auto axxxxx_0 = current_data[215];
      const auto axxxxy_0 = current_data[216];
      const auto axxxyy_0 = current_data[217];
      const auto axxyyy_0 = current_data[218];
      const auto axyyyy_0 = current_data[219];
      const auto ayyyyy_0 = current_data[220];
      const auto axxxxz_0 = current_data[223];
      const auto axxxyz_0 = current_data[224];
      const auto axxyyz_0 = current_data[225];
      const auto axyyyz_0 = current_data[226];
      const auto ayyyyz_0 = current_data[227];
      const auto axxxzz_0 = current_data[230];
      const auto axxyzz_0 = current_data[231];
      const auto axyyzz_0 = current_data[232];
      const auto ayyyzz_0 = current_data[233];
      const auto axxzzz_0 = current_data[236];
      const auto axyzzz_0 = current_data[237];
      const auto ayyzzz_0 = current_data[238];
      const auto axzzzz_0 = current_data[241];
      const auto ayzzzz_0 = current_data[242];
      const auto azzzzz_0 = current_data[245];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[315] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[316] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[317] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[318] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[319] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[320] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[321] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[322] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[323] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[324] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[325] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[326] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[327] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[328] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[329] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[330] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[331] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[332] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[333] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[334] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[335] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xyzzz
      const auto a0_0 = current_data[16];
      const auto ax_0 = current_data[40];
      const auto ay_0 = current_data[41];
      const auto az_0 = current_data[44];
      const auto axx_0 = current_data[71];
      const auto axy_0 = current_data[72];
      const auto ayy_0 = current_data[73];
      const auto axz_0 = current_data[76];
      const auto ayz_0 = current_data[77];
      const auto azz_0 = current_data[80];
      const auto axxx_0 = current_data[110];
      const auto axxy_0 = current_data[111];
      const auto axyy_0 = current_data[112];
      const auto ayyy_0 = current_data[113];
      const auto axxz_0 = current_data[116];
      const auto axyz_0 = current_data[117];
      const auto ayyz_0 = current_data[118];
      const auto axzz_0 = current_data[121];
      const auto ayzz_0 = current_data[122];
      const auto azzz_0 = current_data[125];
      const auto axxxx_0 = current_data[158];
      const auto axxxy_0 = current_data[159];
      const auto axxyy_0 = current_data[160];
      const auto axyyy_0 = current_data[161];
      const auto ayyyy_0 = current_data[162];
      const auto axxxz_0 = current_data[165];
      const auto axxyz_0 = current_data[166];
      const auto axyyz_0 = current_data[167];
      const auto ayyyz_0 = current_data[168];
      const auto axxzz_0 = current_data[171];
      const auto axyzz_0 = current_data[172];
      const auto ayyzz_0 = current_data[173];
      const auto axzzz_0 = current_data[176];
      const auto ayzzz_0 = current_data[177];
      const auto azzzz_0 = current_data[180];
      const auto axxxxx_0 = current_data[216];
      const auto axxxxy_0 = current_data[217];
      const auto axxxyy_0 = current_data[218];
      const auto axxyyy_0 = current_data[219];
      const auto axyyyy_0 = current_data[220];
      const auto ayyyyy_0 = current_data[221];
      const auto axxxxz_0 = current_data[224];
      const auto axxxyz_0 = current_data[225];
      const auto axxyyz_0 = current_data[226];
      const auto axyyyz_0 = current_data[227];
      const auto ayyyyz_0 = current_data[228];
      const auto axxxzz_0 = current_data[231];
      const auto axxyzz_0 = current_data[232];
      const auto axyyzz_0 = current_data[233];
      const auto ayyyzz_0 = current_data[234];
      const auto axxzzz_0 = current_data[237];
      const auto axyzzz_0 = current_data[238];
      const auto ayyzzz_0 = current_data[239];
      const auto axzzzz_0 = current_data[242];
      const auto ayzzzz_0 = current_data[243];
      const auto azzzzz_0 = current_data[246];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[336] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[337] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[338] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[339] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[340] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[341] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[342] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[343] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[344] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[345] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[346] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[347] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[348] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[349] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[350] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[351] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[352] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[353] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[354] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[355] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[356] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: yyzzz
      const auto a0_0 = current_data[17];
      const auto ax_0 = current_data[41];
      const auto ay_0 = current_data[42];
      const auto az_0 = current_data[45];
      const auto axx_0 = current_data[72];
      const auto axy_0 = current_data[73];
      const auto ayy_0 = current_data[74];
      const auto axz_0 = current_data[77];
      const auto ayz_0 = current_data[78];
      const auto azz_0 = current_data[81];
      const auto axxx_0 = current_data[111];
      const auto axxy_0 = current_data[112];
      const auto axyy_0 = current_data[113];
      const auto ayyy_0 = current_data[114];
      const auto axxz_0 = current_data[117];
      const auto axyz_0 = current_data[118];
      const auto ayyz_0 = current_data[119];
      const auto axzz_0 = current_data[122];
      const auto ayzz_0 = current_data[123];
      const auto azzz_0 = current_data[126];
      const auto axxxx_0 = current_data[159];
      const auto axxxy_0 = current_data[160];
      const auto axxyy_0 = current_data[161];
      const auto axyyy_0 = current_data[162];
      const auto ayyyy_0 = current_data[163];
      const auto axxxz_0 = current_data[166];
      const auto axxyz_0 = current_data[167];
      const auto axyyz_0 = current_data[168];
      const auto ayyyz_0 = current_data[169];
      const auto axxzz_0 = current_data[172];
      const auto axyzz_0 = current_data[173];
      const auto ayyzz_0 = current_data[174];
      const auto axzzz_0 = current_data[177];
      const auto ayzzz_0 = current_data[178];
      const auto azzzz_0 = current_data[181];
      const auto axxxxx_0 = current_data[217];
      const auto axxxxy_0 = current_data[218];
      const auto axxxyy_0 = current_data[219];
      const auto axxyyy_0 = current_data[220];
      const auto axyyyy_0 = current_data[221];
      const auto ayyyyy_0 = current_data[222];
      const auto axxxxz_0 = current_data[225];
      const auto axxxyz_0 = current_data[226];
      const auto axxyyz_0 = current_data[227];
      const auto axyyyz_0 = current_data[228];
      const auto ayyyyz_0 = current_data[229];
      const auto axxxzz_0 = current_data[232];
      const auto axxyzz_0 = current_data[233];
      const auto axyyzz_0 = current_data[234];
      const auto ayyyzz_0 = current_data[235];
      const auto axxzzz_0 = current_data[238];
      const auto axyzzz_0 = current_data[239];
      const auto ayyzzz_0 = current_data[240];
      const auto axzzzz_0 = current_data[243];
      const auto ayzzzz_0 = current_data[244];
      const auto azzzzz_0 = current_data[247];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[357] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[358] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[359] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[360] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[361] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[362] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[363] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[364] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[365] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[366] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[367] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[368] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[369] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[370] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[371] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[372] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[373] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[374] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[375] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[376] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[377] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xzzzz
      const auto a0_0 = current_data[18];
      const auto ax_0 = current_data[43];
      const auto ay_0 = current_data[44];
      const auto az_0 = current_data[46];
      const auto axx_0 = current_data[75];
      const auto axy_0 = current_data[76];
      const auto ayy_0 = current_data[77];
      const auto axz_0 = current_data[79];
      const auto ayz_0 = current_data[80];
      const auto azz_0 = current_data[82];
      const auto axxx_0 = current_data[115];
      const auto axxy_0 = current_data[116];
      const auto axyy_0 = current_data[117];
      const auto ayyy_0 = current_data[118];
      const auto axxz_0 = current_data[120];
      const auto axyz_0 = current_data[121];
      const auto ayyz_0 = current_data[122];
      const auto axzz_0 = current_data[124];
      const auto ayzz_0 = current_data[125];
      const auto azzz_0 = current_data[127];
      const auto axxxx_0 = current_data[164];
      const auto axxxy_0 = current_data[165];
      const auto axxyy_0 = current_data[166];
      const auto axyyy_0 = current_data[167];
      const auto ayyyy_0 = current_data[168];
      const auto axxxz_0 = current_data[170];
      const auto axxyz_0 = current_data[171];
      const auto axyyz_0 = current_data[172];
      const auto ayyyz_0 = current_data[173];
      const auto axxzz_0 = current_data[175];
      const auto axyzz_0 = current_data[176];
      const auto ayyzz_0 = current_data[177];
      const auto axzzz_0 = current_data[179];
      const auto ayzzz_0 = current_data[180];
      const auto azzzz_0 = current_data[182];
      const auto axxxxx_0 = current_data[223];
      const auto axxxxy_0 = current_data[224];
      const auto axxxyy_0 = current_data[225];
      const auto axxyyy_0 = current_data[226];
      const auto axyyyy_0 = current_data[227];
      const auto ayyyyy_0 = current_data[228];
      const auto axxxxz_0 = current_data[230];
      const auto axxxyz_0 = current_data[231];
      const auto axxyyz_0 = current_data[232];
      const auto axyyyz_0 = current_data[233];
      const auto ayyyyz_0 = current_data[234];
      const auto axxxzz_0 = current_data[236];
      const auto axxyzz_0 = current_data[237];
      const auto axyyzz_0 = current_data[238];
      const auto ayyyzz_0 = current_data[239];
      const auto axxzzz_0 = current_data[241];
      const auto axyzzz_0 = current_data[242];
      const auto ayyzzz_0 = current_data[243];
      const auto axzzzz_0 = current_data[245];
      const auto ayzzzz_0 = current_data[246];
      const auto azzzzz_0 = current_data[248];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[378] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[379] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[380] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[381] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[382] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[383] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[384] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[385] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[386] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[387] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[388] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[389] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[390] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[391] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[392] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[393] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[394] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[395] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[396] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[397] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[398] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: yzzzz
      const auto a0_0 = current_data[19];
      const auto ax_0 = current_data[44];
      const auto ay_0 = current_data[45];
      const auto az_0 = current_data[47];
      const auto axx_0 = current_data[76];
      const auto axy_0 = current_data[77];
      const auto ayy_0 = current_data[78];
      const auto axz_0 = current_data[80];
      const auto ayz_0 = current_data[81];
      const auto azz_0 = current_data[83];
      const auto axxx_0 = current_data[116];
      const auto axxy_0 = current_data[117];
      const auto axyy_0 = current_data[118];
      const auto ayyy_0 = current_data[119];
      const auto axxz_0 = current_data[121];
      const auto axyz_0 = current_data[122];
      const auto ayyz_0 = current_data[123];
      const auto axzz_0 = current_data[125];
      const auto ayzz_0 = current_data[126];
      const auto azzz_0 = current_data[128];
      const auto axxxx_0 = current_data[165];
      const auto axxxy_0 = current_data[166];
      const auto axxyy_0 = current_data[167];
      const auto axyyy_0 = current_data[168];
      const auto ayyyy_0 = current_data[169];
      const auto axxxz_0 = current_data[171];
      const auto axxyz_0 = current_data[172];
      const auto axyyz_0 = current_data[173];
      const auto ayyyz_0 = current_data[174];
      const auto axxzz_0 = current_data[176];
      const auto axyzz_0 = current_data[177];
      const auto ayyzz_0 = current_data[178];
      const auto axzzz_0 = current_data[180];
      const auto ayzzz_0 = current_data[181];
      const auto azzzz_0 = current_data[183];
      const auto axxxxx_0 = current_data[224];
      const auto axxxxy_0 = current_data[225];
      const auto axxxyy_0 = current_data[226];
      const auto axxyyy_0 = current_data[227];
      const auto axyyyy_0 = current_data[228];
      const auto ayyyyy_0 = current_data[229];
      const auto axxxxz_0 = current_data[231];
      const auto axxxyz_0 = current_data[232];
      const auto axxyyz_0 = current_data[233];
      const auto axyyyz_0 = current_data[234];
      const auto ayyyyz_0 = current_data[235];
      const auto axxxzz_0 = current_data[237];
      const auto axxyzz_0 = current_data[238];
      const auto axyyzz_0 = current_data[239];
      const auto ayyyzz_0 = current_data[240];
      const auto axxzzz_0 = current_data[242];
      const auto axyzzz_0 = current_data[243];
      const auto ayyzzz_0 = current_data[244];
      const auto axzzzz_0 = current_data[246];
      const auto ayzzzz_0 = current_data[247];
      const auto azzzzz_0 = current_data[249];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[399] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[400] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[401] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[402] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[403] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[404] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[405] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[406] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[407] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[408] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[409] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[410] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[411] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[412] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[413] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[414] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[415] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[416] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[417] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[418] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[419] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: zzzzz
      const auto a0_0 = current_data[20];
      const auto ax_0 = current_data[46];
      const auto ay_0 = current_data[47];
      const auto az_0 = current_data[48];
      const auto axx_0 = current_data[79];
      const auto axy_0 = current_data[80];
      const auto ayy_0 = current_data[81];
      const auto axz_0 = current_data[82];
      const auto ayz_0 = current_data[83];
      const auto azz_0 = current_data[84];
      const auto axxx_0 = current_data[120];
      const auto axxy_0 = current_data[121];
      const auto axyy_0 = current_data[122];
      const auto ayyy_0 = current_data[123];
      const auto axxz_0 = current_data[124];
      const auto axyz_0 = current_data[125];
      const auto ayyz_0 = current_data[126];
      const auto axzz_0 = current_data[127];
      const auto ayzz_0 = current_data[128];
      const auto azzz_0 = current_data[129];
      const auto axxxx_0 = current_data[170];
      const auto axxxy_0 = current_data[171];
      const auto axxyy_0 = current_data[172];
      const auto axyyy_0 = current_data[173];
      const auto ayyyy_0 = current_data[174];
      const auto axxxz_0 = current_data[175];
      const auto axxyz_0 = current_data[176];
      const auto axyyz_0 = current_data[177];
      const auto ayyyz_0 = current_data[178];
      const auto axxzz_0 = current_data[179];
      const auto axyzz_0 = current_data[180];
      const auto ayyzz_0 = current_data[181];
      const auto axzzz_0 = current_data[182];
      const auto ayzzz_0 = current_data[183];
      const auto azzzz_0 = current_data[184];
      const auto axxxxx_0 = current_data[230];
      const auto axxxxy_0 = current_data[231];
      const auto axxxyy_0 = current_data[232];
      const auto axxyyy_0 = current_data[233];
      const auto axyyyy_0 = current_data[234];
      const auto ayyyyy_0 = current_data[235];
      const auto axxxxz_0 = current_data[236];
      const auto axxxyz_0 = current_data[237];
      const auto axxyyz_0 = current_data[238];
      const auto axyyyz_0 = current_data[239];
      const auto ayyyyz_0 = current_data[240];
      const auto axxxzz_0 = current_data[241];
      const auto axxyzz_0 = current_data[242];
      const auto axyyzz_0 = current_data[243];
      const auto ayyyzz_0 = current_data[244];
      const auto axxzzz_0 = current_data[245];
      const auto axyzzz_0 = current_data[246];
      const auto ayyzzz_0 = current_data[247];
      const auto axzzzz_0 = current_data[248];
      const auto ayzzzz_0 = current_data[249];
      const auto azzzzz_0 = current_data[250];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[420] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[421] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[422] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[423] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[424] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[425] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[426] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[427] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[428] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[429] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[430] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[431] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[432] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[433] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[434] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[435] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[436] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[437] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[438] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[439] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[440] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
  }
}


void CHRRList::perform_HRR_a0_55(const int nloop, const complex<double>* data_start, const array<double,3>& AB, complex<double>* data_out) {
  for (int c = 0; c != nloop; ++c) {
    auto current_data = &data_start[c * 251];
    auto current_out = &data_out[c * 441];
   {
     //current index a: xxxxx
      const auto a0_0 = current_data[0];
      const auto ax_0 = current_data[21];
      const auto ay_0 = current_data[22];
      const auto az_0 = current_data[28];
      const auto axx_0 = current_data[49];
      const auto axy_0 = current_data[50];
      const auto ayy_0 = current_data[51];
      const auto axz_0 = current_data[57];
      const auto ayz_0 = current_data[58];
      const auto azz_0 = current_data[64];
      const auto axxx_0 = current_data[85];
      const auto axxy_0 = current_data[86];
      const auto axyy_0 = current_data[87];
      const auto ayyy_0 = current_data[88];
      const auto axxz_0 = current_data[94];
      const auto axyz_0 = current_data[95];
      const auto ayyz_0 = current_data[96];
      const auto axzz_0 = current_data[102];
      const auto ayzz_0 = current_data[103];
      const auto azzz_0 = current_data[109];
      const auto axxxx_0 = current_data[130];
      const auto axxxy_0 = current_data[131];
      const auto axxyy_0 = current_data[132];
      const auto axyyy_0 = current_data[133];
      const auto ayyyy_0 = current_data[134];
      const auto axxxz_0 = current_data[140];
      const auto axxyz_0 = current_data[141];
      const auto axyyz_0 = current_data[142];
      const auto ayyyz_0 = current_data[143];
      const auto axxzz_0 = current_data[149];
      const auto axyzz_0 = current_data[150];
      const auto ayyzz_0 = current_data[151];
      const auto axzzz_0 = current_data[157];
      const auto ayzzz_0 = current_data[158];
      const auto azzzz_0 = current_data[164];
      const auto axxxxx_0 = current_data[185];
      const auto axxxxy_0 = current_data[186];
      const auto axxxyy_0 = current_data[187];
      const auto axxyyy_0 = current_data[188];
      const auto axyyyy_0 = current_data[189];
      const auto ayyyyy_0 = current_data[190];
      const auto axxxxz_0 = current_data[196];
      const auto axxxyz_0 = current_data[197];
      const auto axxyyz_0 = current_data[198];
      const auto axyyyz_0 = current_data[199];
      const auto ayyyyz_0 = current_data[200];
      const auto axxxzz_0 = current_data[206];
      const auto axxyzz_0 = current_data[207];
      const auto axyyzz_0 = current_data[208];
      const auto ayyyzz_0 = current_data[209];
      const auto axxzzz_0 = current_data[215];
      const auto axyzzz_0 = current_data[216];
      const auto ayyzzz_0 = current_data[217];
      const auto axzzzz_0 = current_data[223];
      const auto ayzzzz_0 = current_data[224];
      const auto azzzzz_0 = current_data[230];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[0] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[1] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[2] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[3] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[4] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[5] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[6] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[7] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[8] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[9] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[10] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[11] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[12] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[13] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[14] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[15] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[16] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[17] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[18] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[19] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[20] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xxxxy
      const auto a0_0 = current_data[1];
      const auto ax_0 = current_data[22];
      const auto ay_0 = current_data[23];
      const auto az_0 = current_data[29];
      const auto axx_0 = current_data[50];
      const auto axy_0 = current_data[51];
      const auto ayy_0 = current_data[52];
      const auto axz_0 = current_data[58];
      const auto ayz_0 = current_data[59];
      const auto azz_0 = current_data[65];
      const auto axxx_0 = current_data[86];
      const auto axxy_0 = current_data[87];
      const auto axyy_0 = current_data[88];
      const auto ayyy_0 = current_data[89];
      const auto axxz_0 = current_data[95];
      const auto axyz_0 = current_data[96];
      const auto ayyz_0 = current_data[97];
      const auto axzz_0 = current_data[103];
      const auto ayzz_0 = current_data[104];
      const auto azzz_0 = current_data[110];
      const auto axxxx_0 = current_data[131];
      const auto axxxy_0 = current_data[132];
      const auto axxyy_0 = current_data[133];
      const auto axyyy_0 = current_data[134];
      const auto ayyyy_0 = current_data[135];
      const auto axxxz_0 = current_data[141];
      const auto axxyz_0 = current_data[142];
      const auto axyyz_0 = current_data[143];
      const auto ayyyz_0 = current_data[144];
      const auto axxzz_0 = current_data[150];
      const auto axyzz_0 = current_data[151];
      const auto ayyzz_0 = current_data[152];
      const auto axzzz_0 = current_data[158];
      const auto ayzzz_0 = current_data[159];
      const auto azzzz_0 = current_data[165];
      const auto axxxxx_0 = current_data[186];
      const auto axxxxy_0 = current_data[187];
      const auto axxxyy_0 = current_data[188];
      const auto axxyyy_0 = current_data[189];
      const auto axyyyy_0 = current_data[190];
      const auto ayyyyy_0 = current_data[191];
      const auto axxxxz_0 = current_data[197];
      const auto axxxyz_0 = current_data[198];
      const auto axxyyz_0 = current_data[199];
      const auto axyyyz_0 = current_data[200];
      const auto ayyyyz_0 = current_data[201];
      const auto axxxzz_0 = current_data[207];
      const auto axxyzz_0 = current_data[208];
      const auto axyyzz_0 = current_data[209];
      const auto ayyyzz_0 = current_data[210];
      const auto axxzzz_0 = current_data[216];
      const auto axyzzz_0 = current_data[217];
      const auto ayyzzz_0 = current_data[218];
      const auto axzzzz_0 = current_data[224];
      const auto ayzzzz_0 = current_data[225];
      const auto azzzzz_0 = current_data[231];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[21] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[22] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[23] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[24] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[25] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[26] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[27] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[28] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[29] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[30] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[31] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[32] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[33] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[34] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[35] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[36] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[37] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[38] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[39] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[40] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[41] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xxxyy
      const auto a0_0 = current_data[2];
      const auto ax_0 = current_data[23];
      const auto ay_0 = current_data[24];
      const auto az_0 = current_data[30];
      const auto axx_0 = current_data[51];
      const auto axy_0 = current_data[52];
      const auto ayy_0 = current_data[53];
      const auto axz_0 = current_data[59];
      const auto ayz_0 = current_data[60];
      const auto azz_0 = current_data[66];
      const auto axxx_0 = current_data[87];
      const auto axxy_0 = current_data[88];
      const auto axyy_0 = current_data[89];
      const auto ayyy_0 = current_data[90];
      const auto axxz_0 = current_data[96];
      const auto axyz_0 = current_data[97];
      const auto ayyz_0 = current_data[98];
      const auto axzz_0 = current_data[104];
      const auto ayzz_0 = current_data[105];
      const auto azzz_0 = current_data[111];
      const auto axxxx_0 = current_data[132];
      const auto axxxy_0 = current_data[133];
      const auto axxyy_0 = current_data[134];
      const auto axyyy_0 = current_data[135];
      const auto ayyyy_0 = current_data[136];
      const auto axxxz_0 = current_data[142];
      const auto axxyz_0 = current_data[143];
      const auto axyyz_0 = current_data[144];
      const auto ayyyz_0 = current_data[145];
      const auto axxzz_0 = current_data[151];
      const auto axyzz_0 = current_data[152];
      const auto ayyzz_0 = current_data[153];
      const auto axzzz_0 = current_data[159];
      const auto ayzzz_0 = current_data[160];
      const auto azzzz_0 = current_data[166];
      const auto axxxxx_0 = current_data[187];
      const auto axxxxy_0 = current_data[188];
      const auto axxxyy_0 = current_data[189];
      const auto axxyyy_0 = current_data[190];
      const auto axyyyy_0 = current_data[191];
      const auto ayyyyy_0 = current_data[192];
      const auto axxxxz_0 = current_data[198];
      const auto axxxyz_0 = current_data[199];
      const auto axxyyz_0 = current_data[200];
      const auto axyyyz_0 = current_data[201];
      const auto ayyyyz_0 = current_data[202];
      const auto axxxzz_0 = current_data[208];
      const auto axxyzz_0 = current_data[209];
      const auto axyyzz_0 = current_data[210];
      const auto ayyyzz_0 = current_data[211];
      const auto axxzzz_0 = current_data[217];
      const auto axyzzz_0 = current_data[218];
      const auto ayyzzz_0 = current_data[219];
      const auto axzzzz_0 = current_data[225];
      const auto ayzzzz_0 = current_data[226];
      const auto azzzzz_0 = current_data[232];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[42] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[43] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[44] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[45] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[46] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[47] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[48] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[49] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[50] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[51] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[52] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[53] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[54] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[55] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[56] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[57] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[58] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[59] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[60] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[61] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[62] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xxyyy
      const auto a0_0 = current_data[3];
      const auto ax_0 = current_data[24];
      const auto ay_0 = current_data[25];
      const auto az_0 = current_data[31];
      const auto axx_0 = current_data[52];
      const auto axy_0 = current_data[53];
      const auto ayy_0 = current_data[54];
      const auto axz_0 = current_data[60];
      const auto ayz_0 = current_data[61];
      const auto azz_0 = current_data[67];
      const auto axxx_0 = current_data[88];
      const auto axxy_0 = current_data[89];
      const auto axyy_0 = current_data[90];
      const auto ayyy_0 = current_data[91];
      const auto axxz_0 = current_data[97];
      const auto axyz_0 = current_data[98];
      const auto ayyz_0 = current_data[99];
      const auto axzz_0 = current_data[105];
      const auto ayzz_0 = current_data[106];
      const auto azzz_0 = current_data[112];
      const auto axxxx_0 = current_data[133];
      const auto axxxy_0 = current_data[134];
      const auto axxyy_0 = current_data[135];
      const auto axyyy_0 = current_data[136];
      const auto ayyyy_0 = current_data[137];
      const auto axxxz_0 = current_data[143];
      const auto axxyz_0 = current_data[144];
      const auto axyyz_0 = current_data[145];
      const auto ayyyz_0 = current_data[146];
      const auto axxzz_0 = current_data[152];
      const auto axyzz_0 = current_data[153];
      const auto ayyzz_0 = current_data[154];
      const auto axzzz_0 = current_data[160];
      const auto ayzzz_0 = current_data[161];
      const auto azzzz_0 = current_data[167];
      const auto axxxxx_0 = current_data[188];
      const auto axxxxy_0 = current_data[189];
      const auto axxxyy_0 = current_data[190];
      const auto axxyyy_0 = current_data[191];
      const auto axyyyy_0 = current_data[192];
      const auto ayyyyy_0 = current_data[193];
      const auto axxxxz_0 = current_data[199];
      const auto axxxyz_0 = current_data[200];
      const auto axxyyz_0 = current_data[201];
      const auto axyyyz_0 = current_data[202];
      const auto ayyyyz_0 = current_data[203];
      const auto axxxzz_0 = current_data[209];
      const auto axxyzz_0 = current_data[210];
      const auto axyyzz_0 = current_data[211];
      const auto ayyyzz_0 = current_data[212];
      const auto axxzzz_0 = current_data[218];
      const auto axyzzz_0 = current_data[219];
      const auto ayyzzz_0 = current_data[220];
      const auto axzzzz_0 = current_data[226];
      const auto ayzzzz_0 = current_data[227];
      const auto azzzzz_0 = current_data[233];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[63] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[64] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[65] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[66] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[67] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[68] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[69] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[70] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[71] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[72] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[73] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[74] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[75] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[76] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[77] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[78] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[79] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[80] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[81] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[82] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[83] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xyyyy
      const auto a0_0 = current_data[4];
      const auto ax_0 = current_data[25];
      const auto ay_0 = current_data[26];
      const auto az_0 = current_data[32];
      const auto axx_0 = current_data[53];
      const auto axy_0 = current_data[54];
      const auto ayy_0 = current_data[55];
      const auto axz_0 = current_data[61];
      const auto ayz_0 = current_data[62];
      const auto azz_0 = current_data[68];
      const auto axxx_0 = current_data[89];
      const auto axxy_0 = current_data[90];
      const auto axyy_0 = current_data[91];
      const auto ayyy_0 = current_data[92];
      const auto axxz_0 = current_data[98];
      const auto axyz_0 = current_data[99];
      const auto ayyz_0 = current_data[100];
      const auto axzz_0 = current_data[106];
      const auto ayzz_0 = current_data[107];
      const auto azzz_0 = current_data[113];
      const auto axxxx_0 = current_data[134];
      const auto axxxy_0 = current_data[135];
      const auto axxyy_0 = current_data[136];
      const auto axyyy_0 = current_data[137];
      const auto ayyyy_0 = current_data[138];
      const auto axxxz_0 = current_data[144];
      const auto axxyz_0 = current_data[145];
      const auto axyyz_0 = current_data[146];
      const auto ayyyz_0 = current_data[147];
      const auto axxzz_0 = current_data[153];
      const auto axyzz_0 = current_data[154];
      const auto ayyzz_0 = current_data[155];
      const auto axzzz_0 = current_data[161];
      const auto ayzzz_0 = current_data[162];
      const auto azzzz_0 = current_data[168];
      const auto axxxxx_0 = current_data[189];
      const auto axxxxy_0 = current_data[190];
      const auto axxxyy_0 = current_data[191];
      const auto axxyyy_0 = current_data[192];
      const auto axyyyy_0 = current_data[193];
      const auto ayyyyy_0 = current_data[194];
      const auto axxxxz_0 = current_data[200];
      const auto axxxyz_0 = current_data[201];
      const auto axxyyz_0 = current_data[202];
      const auto axyyyz_0 = current_data[203];
      const auto ayyyyz_0 = current_data[204];
      const auto axxxzz_0 = current_data[210];
      const auto axxyzz_0 = current_data[211];
      const auto axyyzz_0 = current_data[212];
      const auto ayyyzz_0 = current_data[213];
      const auto axxzzz_0 = current_data[219];
      const auto axyzzz_0 = current_data[220];
      const auto ayyzzz_0 = current_data[221];
      const auto axzzzz_0 = current_data[227];
      const auto ayzzzz_0 = current_data[228];
      const auto azzzzz_0 = current_data[234];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[84] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[85] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[86] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[87] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[88] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[89] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[90] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[91] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[92] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[93] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[94] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[95] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[96] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[97] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[98] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[99] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[100] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[101] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[102] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[103] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[104] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: yyyyy
      const auto a0_0 = current_data[5];
      const auto ax_0 = current_data[26];
      const auto ay_0 = current_data[27];
      const auto az_0 = current_data[33];
      const auto axx_0 = current_data[54];
      const auto axy_0 = current_data[55];
      const auto ayy_0 = current_data[56];
      const auto axz_0 = current_data[62];
      const auto ayz_0 = current_data[63];
      const auto azz_0 = current_data[69];
      const auto axxx_0 = current_data[90];
      const auto axxy_0 = current_data[91];
      const auto axyy_0 = current_data[92];
      const auto ayyy_0 = current_data[93];
      const auto axxz_0 = current_data[99];
      const auto axyz_0 = current_data[100];
      const auto ayyz_0 = current_data[101];
      const auto axzz_0 = current_data[107];
      const auto ayzz_0 = current_data[108];
      const auto azzz_0 = current_data[114];
      const auto axxxx_0 = current_data[135];
      const auto axxxy_0 = current_data[136];
      const auto axxyy_0 = current_data[137];
      const auto axyyy_0 = current_data[138];
      const auto ayyyy_0 = current_data[139];
      const auto axxxz_0 = current_data[145];
      const auto axxyz_0 = current_data[146];
      const auto axyyz_0 = current_data[147];
      const auto ayyyz_0 = current_data[148];
      const auto axxzz_0 = current_data[154];
      const auto axyzz_0 = current_data[155];
      const auto ayyzz_0 = current_data[156];
      const auto axzzz_0 = current_data[162];
      const auto ayzzz_0 = current_data[163];
      const auto azzzz_0 = current_data[169];
      const auto axxxxx_0 = current_data[190];
      const auto axxxxy_0 = current_data[191];
      const auto axxxyy_0 = current_data[192];
      const auto axxyyy_0 = current_data[193];
      const auto axyyyy_0 = current_data[194];
      const auto ayyyyy_0 = current_data[195];
      const auto axxxxz_0 = current_data[201];
      const auto axxxyz_0 = current_data[202];
      const auto axxyyz_0 = current_data[203];
      const auto axyyyz_0 = current_data[204];
      const auto ayyyyz_0 = current_data[205];
      const auto axxxzz_0 = current_data[211];
      const auto axxyzz_0 = current_data[212];
      const auto axyyzz_0 = current_data[213];
      const auto ayyyzz_0 = current_data[214];
      const auto axxzzz_0 = current_data[220];
      const auto axyzzz_0 = current_data[221];
      const auto ayyzzz_0 = current_data[222];
      const auto axzzzz_0 = current_data[228];
      const auto ayzzzz_0 = current_data[229];
      const auto azzzzz_0 = current_data[235];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[105] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[106] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[107] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[108] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[109] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[110] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[111] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[112] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[113] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[114] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[115] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[116] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[117] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[118] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[119] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[120] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[121] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[122] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[123] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[124] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[125] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xxxxz
      const auto a0_0 = current_data[6];
      const auto ax_0 = current_data[28];
      const auto ay_0 = current_data[29];
      const auto az_0 = current_data[34];
      const auto axx_0 = current_data[57];
      const auto axy_0 = current_data[58];
      const auto ayy_0 = current_data[59];
      const auto axz_0 = current_data[64];
      const auto ayz_0 = current_data[65];
      const auto azz_0 = current_data[70];
      const auto axxx_0 = current_data[94];
      const auto axxy_0 = current_data[95];
      const auto axyy_0 = current_data[96];
      const auto ayyy_0 = current_data[97];
      const auto axxz_0 = current_data[102];
      const auto axyz_0 = current_data[103];
      const auto ayyz_0 = current_data[104];
      const auto axzz_0 = current_data[109];
      const auto ayzz_0 = current_data[110];
      const auto azzz_0 = current_data[115];
      const auto axxxx_0 = current_data[140];
      const auto axxxy_0 = current_data[141];
      const auto axxyy_0 = current_data[142];
      const auto axyyy_0 = current_data[143];
      const auto ayyyy_0 = current_data[144];
      const auto axxxz_0 = current_data[149];
      const auto axxyz_0 = current_data[150];
      const auto axyyz_0 = current_data[151];
      const auto ayyyz_0 = current_data[152];
      const auto axxzz_0 = current_data[157];
      const auto axyzz_0 = current_data[158];
      const auto ayyzz_0 = current_data[159];
      const auto axzzz_0 = current_data[164];
      const auto ayzzz_0 = current_data[165];
      const auto azzzz_0 = current_data[170];
      const auto axxxxx_0 = current_data[196];
      const auto axxxxy_0 = current_data[197];
      const auto axxxyy_0 = current_data[198];
      const auto axxyyy_0 = current_data[199];
      const auto axyyyy_0 = current_data[200];
      const auto ayyyyy_0 = current_data[201];
      const auto axxxxz_0 = current_data[206];
      const auto axxxyz_0 = current_data[207];
      const auto axxyyz_0 = current_data[208];
      const auto axyyyz_0 = current_data[209];
      const auto ayyyyz_0 = current_data[210];
      const auto axxxzz_0 = current_data[215];
      const auto axxyzz_0 = current_data[216];
      const auto axyyzz_0 = current_data[217];
      const auto ayyyzz_0 = current_data[218];
      const auto axxzzz_0 = current_data[223];
      const auto axyzzz_0 = current_data[224];
      const auto ayyzzz_0 = current_data[225];
      const auto axzzzz_0 = current_data[230];
      const auto ayzzzz_0 = current_data[231];
      const auto azzzzz_0 = current_data[236];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[126] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[127] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[128] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[129] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[130] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[131] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[132] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[133] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[134] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[135] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[136] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[137] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[138] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[139] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[140] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[141] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[142] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[143] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[144] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[145] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[146] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xxxyz
      const auto a0_0 = current_data[7];
      const auto ax_0 = current_data[29];
      const auto ay_0 = current_data[30];
      const auto az_0 = current_data[35];
      const auto axx_0 = current_data[58];
      const auto axy_0 = current_data[59];
      const auto ayy_0 = current_data[60];
      const auto axz_0 = current_data[65];
      const auto ayz_0 = current_data[66];
      const auto azz_0 = current_data[71];
      const auto axxx_0 = current_data[95];
      const auto axxy_0 = current_data[96];
      const auto axyy_0 = current_data[97];
      const auto ayyy_0 = current_data[98];
      const auto axxz_0 = current_data[103];
      const auto axyz_0 = current_data[104];
      const auto ayyz_0 = current_data[105];
      const auto axzz_0 = current_data[110];
      const auto ayzz_0 = current_data[111];
      const auto azzz_0 = current_data[116];
      const auto axxxx_0 = current_data[141];
      const auto axxxy_0 = current_data[142];
      const auto axxyy_0 = current_data[143];
      const auto axyyy_0 = current_data[144];
      const auto ayyyy_0 = current_data[145];
      const auto axxxz_0 = current_data[150];
      const auto axxyz_0 = current_data[151];
      const auto axyyz_0 = current_data[152];
      const auto ayyyz_0 = current_data[153];
      const auto axxzz_0 = current_data[158];
      const auto axyzz_0 = current_data[159];
      const auto ayyzz_0 = current_data[160];
      const auto axzzz_0 = current_data[165];
      const auto ayzzz_0 = current_data[166];
      const auto azzzz_0 = current_data[171];
      const auto axxxxx_0 = current_data[197];
      const auto axxxxy_0 = current_data[198];
      const auto axxxyy_0 = current_data[199];
      const auto axxyyy_0 = current_data[200];
      const auto axyyyy_0 = current_data[201];
      const auto ayyyyy_0 = current_data[202];
      const auto axxxxz_0 = current_data[207];
      const auto axxxyz_0 = current_data[208];
      const auto axxyyz_0 = current_data[209];
      const auto axyyyz_0 = current_data[210];
      const auto ayyyyz_0 = current_data[211];
      const auto axxxzz_0 = current_data[216];
      const auto axxyzz_0 = current_data[217];
      const auto axyyzz_0 = current_data[218];
      const auto ayyyzz_0 = current_data[219];
      const auto axxzzz_0 = current_data[224];
      const auto axyzzz_0 = current_data[225];
      const auto ayyzzz_0 = current_data[226];
      const auto axzzzz_0 = current_data[231];
      const auto ayzzzz_0 = current_data[232];
      const auto azzzzz_0 = current_data[237];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[147] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[148] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[149] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[150] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[151] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[152] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[153] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[154] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[155] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[156] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[157] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[158] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[159] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[160] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[161] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[162] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[163] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[164] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[165] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[166] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[167] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xxyyz
      const auto a0_0 = current_data[8];
      const auto ax_0 = current_data[30];
      const auto ay_0 = current_data[31];
      const auto az_0 = current_data[36];
      const auto axx_0 = current_data[59];
      const auto axy_0 = current_data[60];
      const auto ayy_0 = current_data[61];
      const auto axz_0 = current_data[66];
      const auto ayz_0 = current_data[67];
      const auto azz_0 = current_data[72];
      const auto axxx_0 = current_data[96];
      const auto axxy_0 = current_data[97];
      const auto axyy_0 = current_data[98];
      const auto ayyy_0 = current_data[99];
      const auto axxz_0 = current_data[104];
      const auto axyz_0 = current_data[105];
      const auto ayyz_0 = current_data[106];
      const auto axzz_0 = current_data[111];
      const auto ayzz_0 = current_data[112];
      const auto azzz_0 = current_data[117];
      const auto axxxx_0 = current_data[142];
      const auto axxxy_0 = current_data[143];
      const auto axxyy_0 = current_data[144];
      const auto axyyy_0 = current_data[145];
      const auto ayyyy_0 = current_data[146];
      const auto axxxz_0 = current_data[151];
      const auto axxyz_0 = current_data[152];
      const auto axyyz_0 = current_data[153];
      const auto ayyyz_0 = current_data[154];
      const auto axxzz_0 = current_data[159];
      const auto axyzz_0 = current_data[160];
      const auto ayyzz_0 = current_data[161];
      const auto axzzz_0 = current_data[166];
      const auto ayzzz_0 = current_data[167];
      const auto azzzz_0 = current_data[172];
      const auto axxxxx_0 = current_data[198];
      const auto axxxxy_0 = current_data[199];
      const auto axxxyy_0 = current_data[200];
      const auto axxyyy_0 = current_data[201];
      const auto axyyyy_0 = current_data[202];
      const auto ayyyyy_0 = current_data[203];
      const auto axxxxz_0 = current_data[208];
      const auto axxxyz_0 = current_data[209];
      const auto axxyyz_0 = current_data[210];
      const auto axyyyz_0 = current_data[211];
      const auto ayyyyz_0 = current_data[212];
      const auto axxxzz_0 = current_data[217];
      const auto axxyzz_0 = current_data[218];
      const auto axyyzz_0 = current_data[219];
      const auto ayyyzz_0 = current_data[220];
      const auto axxzzz_0 = current_data[225];
      const auto axyzzz_0 = current_data[226];
      const auto ayyzzz_0 = current_data[227];
      const auto axzzzz_0 = current_data[232];
      const auto ayzzzz_0 = current_data[233];
      const auto azzzzz_0 = current_data[238];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[168] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[169] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[170] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[171] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[172] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[173] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[174] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[175] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[176] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[177] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[178] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[179] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[180] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[181] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[182] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[183] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[184] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[185] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[186] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[187] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[188] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xyyyz
      const auto a0_0 = current_data[9];
      const auto ax_0 = current_data[31];
      const auto ay_0 = current_data[32];
      const auto az_0 = current_data[37];
      const auto axx_0 = current_data[60];
      const auto axy_0 = current_data[61];
      const auto ayy_0 = current_data[62];
      const auto axz_0 = current_data[67];
      const auto ayz_0 = current_data[68];
      const auto azz_0 = current_data[73];
      const auto axxx_0 = current_data[97];
      const auto axxy_0 = current_data[98];
      const auto axyy_0 = current_data[99];
      const auto ayyy_0 = current_data[100];
      const auto axxz_0 = current_data[105];
      const auto axyz_0 = current_data[106];
      const auto ayyz_0 = current_data[107];
      const auto axzz_0 = current_data[112];
      const auto ayzz_0 = current_data[113];
      const auto azzz_0 = current_data[118];
      const auto axxxx_0 = current_data[143];
      const auto axxxy_0 = current_data[144];
      const auto axxyy_0 = current_data[145];
      const auto axyyy_0 = current_data[146];
      const auto ayyyy_0 = current_data[147];
      const auto axxxz_0 = current_data[152];
      const auto axxyz_0 = current_data[153];
      const auto axyyz_0 = current_data[154];
      const auto ayyyz_0 = current_data[155];
      const auto axxzz_0 = current_data[160];
      const auto axyzz_0 = current_data[161];
      const auto ayyzz_0 = current_data[162];
      const auto axzzz_0 = current_data[167];
      const auto ayzzz_0 = current_data[168];
      const auto azzzz_0 = current_data[173];
      const auto axxxxx_0 = current_data[199];
      const auto axxxxy_0 = current_data[200];
      const auto axxxyy_0 = current_data[201];
      const auto axxyyy_0 = current_data[202];
      const auto axyyyy_0 = current_data[203];
      const auto ayyyyy_0 = current_data[204];
      const auto axxxxz_0 = current_data[209];
      const auto axxxyz_0 = current_data[210];
      const auto axxyyz_0 = current_data[211];
      const auto axyyyz_0 = current_data[212];
      const auto ayyyyz_0 = current_data[213];
      const auto axxxzz_0 = current_data[218];
      const auto axxyzz_0 = current_data[219];
      const auto axyyzz_0 = current_data[220];
      const auto ayyyzz_0 = current_data[221];
      const auto axxzzz_0 = current_data[226];
      const auto axyzzz_0 = current_data[227];
      const auto ayyzzz_0 = current_data[228];
      const auto axzzzz_0 = current_data[233];
      const auto ayzzzz_0 = current_data[234];
      const auto azzzzz_0 = current_data[239];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[189] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[190] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[191] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[192] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[193] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[194] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[195] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[196] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[197] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[198] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[199] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[200] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[201] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[202] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[203] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[204] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[205] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[206] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[207] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[208] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[209] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: yyyyz
      const auto a0_0 = current_data[10];
      const auto ax_0 = current_data[32];
      const auto ay_0 = current_data[33];
      const auto az_0 = current_data[38];
      const auto axx_0 = current_data[61];
      const auto axy_0 = current_data[62];
      const auto ayy_0 = current_data[63];
      const auto axz_0 = current_data[68];
      const auto ayz_0 = current_data[69];
      const auto azz_0 = current_data[74];
      const auto axxx_0 = current_data[98];
      const auto axxy_0 = current_data[99];
      const auto axyy_0 = current_data[100];
      const auto ayyy_0 = current_data[101];
      const auto axxz_0 = current_data[106];
      const auto axyz_0 = current_data[107];
      const auto ayyz_0 = current_data[108];
      const auto axzz_0 = current_data[113];
      const auto ayzz_0 = current_data[114];
      const auto azzz_0 = current_data[119];
      const auto axxxx_0 = current_data[144];
      const auto axxxy_0 = current_data[145];
      const auto axxyy_0 = current_data[146];
      const auto axyyy_0 = current_data[147];
      const auto ayyyy_0 = current_data[148];
      const auto axxxz_0 = current_data[153];
      const auto axxyz_0 = current_data[154];
      const auto axyyz_0 = current_data[155];
      const auto ayyyz_0 = current_data[156];
      const auto axxzz_0 = current_data[161];
      const auto axyzz_0 = current_data[162];
      const auto ayyzz_0 = current_data[163];
      const auto axzzz_0 = current_data[168];
      const auto ayzzz_0 = current_data[169];
      const auto azzzz_0 = current_data[174];
      const auto axxxxx_0 = current_data[200];
      const auto axxxxy_0 = current_data[201];
      const auto axxxyy_0 = current_data[202];
      const auto axxyyy_0 = current_data[203];
      const auto axyyyy_0 = current_data[204];
      const auto ayyyyy_0 = current_data[205];
      const auto axxxxz_0 = current_data[210];
      const auto axxxyz_0 = current_data[211];
      const auto axxyyz_0 = current_data[212];
      const auto axyyyz_0 = current_data[213];
      const auto ayyyyz_0 = current_data[214];
      const auto axxxzz_0 = current_data[219];
      const auto axxyzz_0 = current_data[220];
      const auto axyyzz_0 = current_data[221];
      const auto ayyyzz_0 = current_data[222];
      const auto axxzzz_0 = current_data[227];
      const auto axyzzz_0 = current_data[228];
      const auto ayyzzz_0 = current_data[229];
      const auto axzzzz_0 = current_data[234];
      const auto ayzzzz_0 = current_data[235];
      const auto azzzzz_0 = current_data[240];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[210] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[211] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[212] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[213] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[214] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[215] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[216] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[217] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[218] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[219] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[220] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[221] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[222] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[223] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[224] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[225] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[226] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[227] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[228] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[229] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[230] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xxxzz
      const auto a0_0 = current_data[11];
      const auto ax_0 = current_data[34];
      const auto ay_0 = current_data[35];
      const auto az_0 = current_data[39];
      const auto axx_0 = current_data[64];
      const auto axy_0 = current_data[65];
      const auto ayy_0 = current_data[66];
      const auto axz_0 = current_data[70];
      const auto ayz_0 = current_data[71];
      const auto azz_0 = current_data[75];
      const auto axxx_0 = current_data[102];
      const auto axxy_0 = current_data[103];
      const auto axyy_0 = current_data[104];
      const auto ayyy_0 = current_data[105];
      const auto axxz_0 = current_data[109];
      const auto axyz_0 = current_data[110];
      const auto ayyz_0 = current_data[111];
      const auto axzz_0 = current_data[115];
      const auto ayzz_0 = current_data[116];
      const auto azzz_0 = current_data[120];
      const auto axxxx_0 = current_data[149];
      const auto axxxy_0 = current_data[150];
      const auto axxyy_0 = current_data[151];
      const auto axyyy_0 = current_data[152];
      const auto ayyyy_0 = current_data[153];
      const auto axxxz_0 = current_data[157];
      const auto axxyz_0 = current_data[158];
      const auto axyyz_0 = current_data[159];
      const auto ayyyz_0 = current_data[160];
      const auto axxzz_0 = current_data[164];
      const auto axyzz_0 = current_data[165];
      const auto ayyzz_0 = current_data[166];
      const auto axzzz_0 = current_data[170];
      const auto ayzzz_0 = current_data[171];
      const auto azzzz_0 = current_data[175];
      const auto axxxxx_0 = current_data[206];
      const auto axxxxy_0 = current_data[207];
      const auto axxxyy_0 = current_data[208];
      const auto axxyyy_0 = current_data[209];
      const auto axyyyy_0 = current_data[210];
      const auto ayyyyy_0 = current_data[211];
      const auto axxxxz_0 = current_data[215];
      const auto axxxyz_0 = current_data[216];
      const auto axxyyz_0 = current_data[217];
      const auto axyyyz_0 = current_data[218];
      const auto ayyyyz_0 = current_data[219];
      const auto axxxzz_0 = current_data[223];
      const auto axxyzz_0 = current_data[224];
      const auto axyyzz_0 = current_data[225];
      const auto ayyyzz_0 = current_data[226];
      const auto axxzzz_0 = current_data[230];
      const auto axyzzz_0 = current_data[231];
      const auto ayyzzz_0 = current_data[232];
      const auto axzzzz_0 = current_data[236];
      const auto ayzzzz_0 = current_data[237];
      const auto azzzzz_0 = current_data[241];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[231] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[232] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[233] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[234] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[235] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[236] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[237] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[238] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[239] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[240] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[241] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[242] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[243] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[244] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[245] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[246] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[247] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[248] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[249] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[250] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[251] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xxyzz
      const auto a0_0 = current_data[12];
      const auto ax_0 = current_data[35];
      const auto ay_0 = current_data[36];
      const auto az_0 = current_data[40];
      const auto axx_0 = current_data[65];
      const auto axy_0 = current_data[66];
      const auto ayy_0 = current_data[67];
      const auto axz_0 = current_data[71];
      const auto ayz_0 = current_data[72];
      const auto azz_0 = current_data[76];
      const auto axxx_0 = current_data[103];
      const auto axxy_0 = current_data[104];
      const auto axyy_0 = current_data[105];
      const auto ayyy_0 = current_data[106];
      const auto axxz_0 = current_data[110];
      const auto axyz_0 = current_data[111];
      const auto ayyz_0 = current_data[112];
      const auto axzz_0 = current_data[116];
      const auto ayzz_0 = current_data[117];
      const auto azzz_0 = current_data[121];
      const auto axxxx_0 = current_data[150];
      const auto axxxy_0 = current_data[151];
      const auto axxyy_0 = current_data[152];
      const auto axyyy_0 = current_data[153];
      const auto ayyyy_0 = current_data[154];
      const auto axxxz_0 = current_data[158];
      const auto axxyz_0 = current_data[159];
      const auto axyyz_0 = current_data[160];
      const auto ayyyz_0 = current_data[161];
      const auto axxzz_0 = current_data[165];
      const auto axyzz_0 = current_data[166];
      const auto ayyzz_0 = current_data[167];
      const auto axzzz_0 = current_data[171];
      const auto ayzzz_0 = current_data[172];
      const auto azzzz_0 = current_data[176];
      const auto axxxxx_0 = current_data[207];
      const auto axxxxy_0 = current_data[208];
      const auto axxxyy_0 = current_data[209];
      const auto axxyyy_0 = current_data[210];
      const auto axyyyy_0 = current_data[211];
      const auto ayyyyy_0 = current_data[212];
      const auto axxxxz_0 = current_data[216];
      const auto axxxyz_0 = current_data[217];
      const auto axxyyz_0 = current_data[218];
      const auto axyyyz_0 = current_data[219];
      const auto ayyyyz_0 = current_data[220];
      const auto axxxzz_0 = current_data[224];
      const auto axxyzz_0 = current_data[225];
      const auto axyyzz_0 = current_data[226];
      const auto ayyyzz_0 = current_data[227];
      const auto axxzzz_0 = current_data[231];
      const auto axyzzz_0 = current_data[232];
      const auto ayyzzz_0 = current_data[233];
      const auto axzzzz_0 = current_data[237];
      const auto ayzzzz_0 = current_data[238];
      const auto azzzzz_0 = current_data[242];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[252] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[253] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[254] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[255] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[256] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[257] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[258] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[259] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[260] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[261] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[262] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[263] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[264] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[265] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[266] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[267] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[268] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[269] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[270] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[271] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[272] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xyyzz
      const auto a0_0 = current_data[13];
      const auto ax_0 = current_data[36];
      const auto ay_0 = current_data[37];
      const auto az_0 = current_data[41];
      const auto axx_0 = current_data[66];
      const auto axy_0 = current_data[67];
      const auto ayy_0 = current_data[68];
      const auto axz_0 = current_data[72];
      const auto ayz_0 = current_data[73];
      const auto azz_0 = current_data[77];
      const auto axxx_0 = current_data[104];
      const auto axxy_0 = current_data[105];
      const auto axyy_0 = current_data[106];
      const auto ayyy_0 = current_data[107];
      const auto axxz_0 = current_data[111];
      const auto axyz_0 = current_data[112];
      const auto ayyz_0 = current_data[113];
      const auto axzz_0 = current_data[117];
      const auto ayzz_0 = current_data[118];
      const auto azzz_0 = current_data[122];
      const auto axxxx_0 = current_data[151];
      const auto axxxy_0 = current_data[152];
      const auto axxyy_0 = current_data[153];
      const auto axyyy_0 = current_data[154];
      const auto ayyyy_0 = current_data[155];
      const auto axxxz_0 = current_data[159];
      const auto axxyz_0 = current_data[160];
      const auto axyyz_0 = current_data[161];
      const auto ayyyz_0 = current_data[162];
      const auto axxzz_0 = current_data[166];
      const auto axyzz_0 = current_data[167];
      const auto ayyzz_0 = current_data[168];
      const auto axzzz_0 = current_data[172];
      const auto ayzzz_0 = current_data[173];
      const auto azzzz_0 = current_data[177];
      const auto axxxxx_0 = current_data[208];
      const auto axxxxy_0 = current_data[209];
      const auto axxxyy_0 = current_data[210];
      const auto axxyyy_0 = current_data[211];
      const auto axyyyy_0 = current_data[212];
      const auto ayyyyy_0 = current_data[213];
      const auto axxxxz_0 = current_data[217];
      const auto axxxyz_0 = current_data[218];
      const auto axxyyz_0 = current_data[219];
      const auto axyyyz_0 = current_data[220];
      const auto ayyyyz_0 = current_data[221];
      const auto axxxzz_0 = current_data[225];
      const auto axxyzz_0 = current_data[226];
      const auto axyyzz_0 = current_data[227];
      const auto ayyyzz_0 = current_data[228];
      const auto axxzzz_0 = current_data[232];
      const auto axyzzz_0 = current_data[233];
      const auto ayyzzz_0 = current_data[234];
      const auto axzzzz_0 = current_data[238];
      const auto ayzzzz_0 = current_data[239];
      const auto azzzzz_0 = current_data[243];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[273] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[274] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[275] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[276] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[277] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[278] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[279] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[280] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[281] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[282] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[283] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[284] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[285] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[286] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[287] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[288] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[289] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[290] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[291] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[292] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[293] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: yyyzz
      const auto a0_0 = current_data[14];
      const auto ax_0 = current_data[37];
      const auto ay_0 = current_data[38];
      const auto az_0 = current_data[42];
      const auto axx_0 = current_data[67];
      const auto axy_0 = current_data[68];
      const auto ayy_0 = current_data[69];
      const auto axz_0 = current_data[73];
      const auto ayz_0 = current_data[74];
      const auto azz_0 = current_data[78];
      const auto axxx_0 = current_data[105];
      const auto axxy_0 = current_data[106];
      const auto axyy_0 = current_data[107];
      const auto ayyy_0 = current_data[108];
      const auto axxz_0 = current_data[112];
      const auto axyz_0 = current_data[113];
      const auto ayyz_0 = current_data[114];
      const auto axzz_0 = current_data[118];
      const auto ayzz_0 = current_data[119];
      const auto azzz_0 = current_data[123];
      const auto axxxx_0 = current_data[152];
      const auto axxxy_0 = current_data[153];
      const auto axxyy_0 = current_data[154];
      const auto axyyy_0 = current_data[155];
      const auto ayyyy_0 = current_data[156];
      const auto axxxz_0 = current_data[160];
      const auto axxyz_0 = current_data[161];
      const auto axyyz_0 = current_data[162];
      const auto ayyyz_0 = current_data[163];
      const auto axxzz_0 = current_data[167];
      const auto axyzz_0 = current_data[168];
      const auto ayyzz_0 = current_data[169];
      const auto axzzz_0 = current_data[173];
      const auto ayzzz_0 = current_data[174];
      const auto azzzz_0 = current_data[178];
      const auto axxxxx_0 = current_data[209];
      const auto axxxxy_0 = current_data[210];
      const auto axxxyy_0 = current_data[211];
      const auto axxyyy_0 = current_data[212];
      const auto axyyyy_0 = current_data[213];
      const auto ayyyyy_0 = current_data[214];
      const auto axxxxz_0 = current_data[218];
      const auto axxxyz_0 = current_data[219];
      const auto axxyyz_0 = current_data[220];
      const auto axyyyz_0 = current_data[221];
      const auto ayyyyz_0 = current_data[222];
      const auto axxxzz_0 = current_data[226];
      const auto axxyzz_0 = current_data[227];
      const auto axyyzz_0 = current_data[228];
      const auto ayyyzz_0 = current_data[229];
      const auto axxzzz_0 = current_data[233];
      const auto axyzzz_0 = current_data[234];
      const auto ayyzzz_0 = current_data[235];
      const auto axzzzz_0 = current_data[239];
      const auto ayzzzz_0 = current_data[240];
      const auto azzzzz_0 = current_data[244];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[294] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[295] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[296] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[297] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[298] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[299] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[300] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[301] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[302] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[303] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[304] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[305] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[306] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[307] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[308] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[309] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[310] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[311] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[312] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[313] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[314] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xxzzz
      const auto a0_0 = current_data[15];
      const auto ax_0 = current_data[39];
      const auto ay_0 = current_data[40];
      const auto az_0 = current_data[43];
      const auto axx_0 = current_data[70];
      const auto axy_0 = current_data[71];
      const auto ayy_0 = current_data[72];
      const auto axz_0 = current_data[75];
      const auto ayz_0 = current_data[76];
      const auto azz_0 = current_data[79];
      const auto axxx_0 = current_data[109];
      const auto axxy_0 = current_data[110];
      const auto axyy_0 = current_data[111];
      const auto ayyy_0 = current_data[112];
      const auto axxz_0 = current_data[115];
      const auto axyz_0 = current_data[116];
      const auto ayyz_0 = current_data[117];
      const auto axzz_0 = current_data[120];
      const auto ayzz_0 = current_data[121];
      const auto azzz_0 = current_data[124];
      const auto axxxx_0 = current_data[157];
      const auto axxxy_0 = current_data[158];
      const auto axxyy_0 = current_data[159];
      const auto axyyy_0 = current_data[160];
      const auto ayyyy_0 = current_data[161];
      const auto axxxz_0 = current_data[164];
      const auto axxyz_0 = current_data[165];
      const auto axyyz_0 = current_data[166];
      const auto ayyyz_0 = current_data[167];
      const auto axxzz_0 = current_data[170];
      const auto axyzz_0 = current_data[171];
      const auto ayyzz_0 = current_data[172];
      const auto axzzz_0 = current_data[175];
      const auto ayzzz_0 = current_data[176];
      const auto azzzz_0 = current_data[179];
      const auto axxxxx_0 = current_data[215];
      const auto axxxxy_0 = current_data[216];
      const auto axxxyy_0 = current_data[217];
      const auto axxyyy_0 = current_data[218];
      const auto axyyyy_0 = current_data[219];
      const auto ayyyyy_0 = current_data[220];
      const auto axxxxz_0 = current_data[223];
      const auto axxxyz_0 = current_data[224];
      const auto axxyyz_0 = current_data[225];
      const auto axyyyz_0 = current_data[226];
      const auto ayyyyz_0 = current_data[227];
      const auto axxxzz_0 = current_data[230];
      const auto axxyzz_0 = current_data[231];
      const auto axyyzz_0 = current_data[232];
      const auto ayyyzz_0 = current_data[233];
      const auto axxzzz_0 = current_data[236];
      const auto axyzzz_0 = current_data[237];
      const auto ayyzzz_0 = current_data[238];
      const auto axzzzz_0 = current_data[241];
      const auto ayzzzz_0 = current_data[242];
      const auto azzzzz_0 = current_data[245];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[315] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[316] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[317] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[318] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[319] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[320] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[321] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[322] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[323] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[324] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[325] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[326] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[327] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[328] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[329] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[330] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[331] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[332] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[333] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[334] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[335] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xyzzz
      const auto a0_0 = current_data[16];
      const auto ax_0 = current_data[40];
      const auto ay_0 = current_data[41];
      const auto az_0 = current_data[44];
      const auto axx_0 = current_data[71];
      const auto axy_0 = current_data[72];
      const auto ayy_0 = current_data[73];
      const auto axz_0 = current_data[76];
      const auto ayz_0 = current_data[77];
      const auto azz_0 = current_data[80];
      const auto axxx_0 = current_data[110];
      const auto axxy_0 = current_data[111];
      const auto axyy_0 = current_data[112];
      const auto ayyy_0 = current_data[113];
      const auto axxz_0 = current_data[116];
      const auto axyz_0 = current_data[117];
      const auto ayyz_0 = current_data[118];
      const auto axzz_0 = current_data[121];
      const auto ayzz_0 = current_data[122];
      const auto azzz_0 = current_data[125];
      const auto axxxx_0 = current_data[158];
      const auto axxxy_0 = current_data[159];
      const auto axxyy_0 = current_data[160];
      const auto axyyy_0 = current_data[161];
      const auto ayyyy_0 = current_data[162];
      const auto axxxz_0 = current_data[165];
      const auto axxyz_0 = current_data[166];
      const auto axyyz_0 = current_data[167];
      const auto ayyyz_0 = current_data[168];
      const auto axxzz_0 = current_data[171];
      const auto axyzz_0 = current_data[172];
      const auto ayyzz_0 = current_data[173];
      const auto axzzz_0 = current_data[176];
      const auto ayzzz_0 = current_data[177];
      const auto azzzz_0 = current_data[180];
      const auto axxxxx_0 = current_data[216];
      const auto axxxxy_0 = current_data[217];
      const auto axxxyy_0 = current_data[218];
      const auto axxyyy_0 = current_data[219];
      const auto axyyyy_0 = current_data[220];
      const auto ayyyyy_0 = current_data[221];
      const auto axxxxz_0 = current_data[224];
      const auto axxxyz_0 = current_data[225];
      const auto axxyyz_0 = current_data[226];
      const auto axyyyz_0 = current_data[227];
      const auto ayyyyz_0 = current_data[228];
      const auto axxxzz_0 = current_data[231];
      const auto axxyzz_0 = current_data[232];
      const auto axyyzz_0 = current_data[233];
      const auto ayyyzz_0 = current_data[234];
      const auto axxzzz_0 = current_data[237];
      const auto axyzzz_0 = current_data[238];
      const auto ayyzzz_0 = current_data[239];
      const auto axzzzz_0 = current_data[242];
      const auto ayzzzz_0 = current_data[243];
      const auto azzzzz_0 = current_data[246];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[336] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[337] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[338] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[339] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[340] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[341] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[342] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[343] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[344] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[345] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[346] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[347] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[348] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[349] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[350] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[351] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[352] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[353] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[354] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[355] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[356] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: yyzzz
      const auto a0_0 = current_data[17];
      const auto ax_0 = current_data[41];
      const auto ay_0 = current_data[42];
      const auto az_0 = current_data[45];
      const auto axx_0 = current_data[72];
      const auto axy_0 = current_data[73];
      const auto ayy_0 = current_data[74];
      const auto axz_0 = current_data[77];
      const auto ayz_0 = current_data[78];
      const auto azz_0 = current_data[81];
      const auto axxx_0 = current_data[111];
      const auto axxy_0 = current_data[112];
      const auto axyy_0 = current_data[113];
      const auto ayyy_0 = current_data[114];
      const auto axxz_0 = current_data[117];
      const auto axyz_0 = current_data[118];
      const auto ayyz_0 = current_data[119];
      const auto axzz_0 = current_data[122];
      const auto ayzz_0 = current_data[123];
      const auto azzz_0 = current_data[126];
      const auto axxxx_0 = current_data[159];
      const auto axxxy_0 = current_data[160];
      const auto axxyy_0 = current_data[161];
      const auto axyyy_0 = current_data[162];
      const auto ayyyy_0 = current_data[163];
      const auto axxxz_0 = current_data[166];
      const auto axxyz_0 = current_data[167];
      const auto axyyz_0 = current_data[168];
      const auto ayyyz_0 = current_data[169];
      const auto axxzz_0 = current_data[172];
      const auto axyzz_0 = current_data[173];
      const auto ayyzz_0 = current_data[174];
      const auto axzzz_0 = current_data[177];
      const auto ayzzz_0 = current_data[178];
      const auto azzzz_0 = current_data[181];
      const auto axxxxx_0 = current_data[217];
      const auto axxxxy_0 = current_data[218];
      const auto axxxyy_0 = current_data[219];
      const auto axxyyy_0 = current_data[220];
      const auto axyyyy_0 = current_data[221];
      const auto ayyyyy_0 = current_data[222];
      const auto axxxxz_0 = current_data[225];
      const auto axxxyz_0 = current_data[226];
      const auto axxyyz_0 = current_data[227];
      const auto axyyyz_0 = current_data[228];
      const auto ayyyyz_0 = current_data[229];
      const auto axxxzz_0 = current_data[232];
      const auto axxyzz_0 = current_data[233];
      const auto axyyzz_0 = current_data[234];
      const auto ayyyzz_0 = current_data[235];
      const auto axxzzz_0 = current_data[238];
      const auto axyzzz_0 = current_data[239];
      const auto ayyzzz_0 = current_data[240];
      const auto axzzzz_0 = current_data[243];
      const auto ayzzzz_0 = current_data[244];
      const auto azzzzz_0 = current_data[247];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[357] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[358] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[359] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[360] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[361] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[362] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[363] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[364] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[365] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[366] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[367] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[368] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[369] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[370] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[371] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[372] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[373] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[374] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[375] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[376] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[377] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: xzzzz
      const auto a0_0 = current_data[18];
      const auto ax_0 = current_data[43];
      const auto ay_0 = current_data[44];
      const auto az_0 = current_data[46];
      const auto axx_0 = current_data[75];
      const auto axy_0 = current_data[76];
      const auto ayy_0 = current_data[77];
      const auto axz_0 = current_data[79];
      const auto ayz_0 = current_data[80];
      const auto azz_0 = current_data[82];
      const auto axxx_0 = current_data[115];
      const auto axxy_0 = current_data[116];
      const auto axyy_0 = current_data[117];
      const auto ayyy_0 = current_data[118];
      const auto axxz_0 = current_data[120];
      const auto axyz_0 = current_data[121];
      const auto ayyz_0 = current_data[122];
      const auto axzz_0 = current_data[124];
      const auto ayzz_0 = current_data[125];
      const auto azzz_0 = current_data[127];
      const auto axxxx_0 = current_data[164];
      const auto axxxy_0 = current_data[165];
      const auto axxyy_0 = current_data[166];
      const auto axyyy_0 = current_data[167];
      const auto ayyyy_0 = current_data[168];
      const auto axxxz_0 = current_data[170];
      const auto axxyz_0 = current_data[171];
      const auto axyyz_0 = current_data[172];
      const auto ayyyz_0 = current_data[173];
      const auto axxzz_0 = current_data[175];
      const auto axyzz_0 = current_data[176];
      const auto ayyzz_0 = current_data[177];
      const auto axzzz_0 = current_data[179];
      const auto ayzzz_0 = current_data[180];
      const auto azzzz_0 = current_data[182];
      const auto axxxxx_0 = current_data[223];
      const auto axxxxy_0 = current_data[224];
      const auto axxxyy_0 = current_data[225];
      const auto axxyyy_0 = current_data[226];
      const auto axyyyy_0 = current_data[227];
      const auto ayyyyy_0 = current_data[228];
      const auto axxxxz_0 = current_data[230];
      const auto axxxyz_0 = current_data[231];
      const auto axxyyz_0 = current_data[232];
      const auto axyyyz_0 = current_data[233];
      const auto ayyyyz_0 = current_data[234];
      const auto axxxzz_0 = current_data[236];
      const auto axxyzz_0 = current_data[237];
      const auto axyyzz_0 = current_data[238];
      const auto ayyyzz_0 = current_data[239];
      const auto axxzzz_0 = current_data[241];
      const auto axyzzz_0 = current_data[242];
      const auto ayyzzz_0 = current_data[243];
      const auto axzzzz_0 = current_data[245];
      const auto ayzzzz_0 = current_data[246];
      const auto azzzzz_0 = current_data[248];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[378] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[379] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[380] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[381] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[382] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[383] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[384] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[385] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[386] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[387] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[388] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[389] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[390] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[391] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[392] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[393] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[394] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[395] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[396] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[397] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[398] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: yzzzz
      const auto a0_0 = current_data[19];
      const auto ax_0 = current_data[44];
      const auto ay_0 = current_data[45];
      const auto az_0 = current_data[47];
      const auto axx_0 = current_data[76];
      const auto axy_0 = current_data[77];
      const auto ayy_0 = current_data[78];
      const auto axz_0 = current_data[80];
      const auto ayz_0 = current_data[81];
      const auto azz_0 = current_data[83];
      const auto axxx_0 = current_data[116];
      const auto axxy_0 = current_data[117];
      const auto axyy_0 = current_data[118];
      const auto ayyy_0 = current_data[119];
      const auto axxz_0 = current_data[121];
      const auto axyz_0 = current_data[122];
      const auto ayyz_0 = current_data[123];
      const auto axzz_0 = current_data[125];
      const auto ayzz_0 = current_data[126];
      const auto azzz_0 = current_data[128];
      const auto axxxx_0 = current_data[165];
      const auto axxxy_0 = current_data[166];
      const auto axxyy_0 = current_data[167];
      const auto axyyy_0 = current_data[168];
      const auto ayyyy_0 = current_data[169];
      const auto axxxz_0 = current_data[171];
      const auto axxyz_0 = current_data[172];
      const auto axyyz_0 = current_data[173];
      const auto ayyyz_0 = current_data[174];
      const auto axxzz_0 = current_data[176];
      const auto axyzz_0 = current_data[177];
      const auto ayyzz_0 = current_data[178];
      const auto axzzz_0 = current_data[180];
      const auto ayzzz_0 = current_data[181];
      const auto azzzz_0 = current_data[183];
      const auto axxxxx_0 = current_data[224];
      const auto axxxxy_0 = current_data[225];
      const auto axxxyy_0 = current_data[226];
      const auto axxyyy_0 = current_data[227];
      const auto axyyyy_0 = current_data[228];
      const auto ayyyyy_0 = current_data[229];
      const auto axxxxz_0 = current_data[231];
      const auto axxxyz_0 = current_data[232];
      const auto axxyyz_0 = current_data[233];
      const auto axyyyz_0 = current_data[234];
      const auto ayyyyz_0 = current_data[235];
      const auto axxxzz_0 = current_data[237];
      const auto axxyzz_0 = current_data[238];
      const auto axyyzz_0 = current_data[239];
      const auto ayyyzz_0 = current_data[240];
      const auto axxzzz_0 = current_data[242];
      const auto axyzzz_0 = current_data[243];
      const auto ayyzzz_0 = current_data[244];
      const auto axzzzz_0 = current_data[246];
      const auto ayzzzz_0 = current_data[247];
      const auto azzzzz_0 = current_data[249];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[399] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[400] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[401] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[402] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[403] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[404] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[405] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[406] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[407] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[408] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[409] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[410] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[411] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[412] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[413] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[414] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[415] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[416] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[417] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[418] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[419] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
   {
     //current index a: zzzzz
      const auto a0_0 = current_data[20];
      const auto ax_0 = current_data[46];
      const auto ay_0 = current_data[47];
      const auto az_0 = current_data[48];
      const auto axx_0 = current_data[79];
      const auto axy_0 = current_data[80];
      const auto ayy_0 = current_data[81];
      const auto axz_0 = current_data[82];
      const auto ayz_0 = current_data[83];
      const auto azz_0 = current_data[84];
      const auto axxx_0 = current_data[120];
      const auto axxy_0 = current_data[121];
      const auto axyy_0 = current_data[122];
      const auto ayyy_0 = current_data[123];
      const auto axxz_0 = current_data[124];
      const auto axyz_0 = current_data[125];
      const auto ayyz_0 = current_data[126];
      const auto axzz_0 = current_data[127];
      const auto ayzz_0 = current_data[128];
      const auto azzz_0 = current_data[129];
      const auto axxxx_0 = current_data[170];
      const auto axxxy_0 = current_data[171];
      const auto axxyy_0 = current_data[172];
      const auto axyyy_0 = current_data[173];
      const auto ayyyy_0 = current_data[174];
      const auto axxxz_0 = current_data[175];
      const auto axxyz_0 = current_data[176];
      const auto axyyz_0 = current_data[177];
      const auto ayyyz_0 = current_data[178];
      const auto axxzz_0 = current_data[179];
      const auto axyzz_0 = current_data[180];
      const auto ayyzz_0 = current_data[181];
      const auto axzzz_0 = current_data[182];
      const auto ayzzz_0 = current_data[183];
      const auto azzzz_0 = current_data[184];
      const auto axxxxx_0 = current_data[230];
      const auto axxxxy_0 = current_data[231];
      const auto axxxyy_0 = current_data[232];
      const auto axxyyy_0 = current_data[233];
      const auto axyyyy_0 = current_data[234];
      const auto ayyyyy_0 = current_data[235];
      const auto axxxxz_0 = current_data[236];
      const auto axxxyz_0 = current_data[237];
      const auto axxyyz_0 = current_data[238];
      const auto axyyyz_0 = current_data[239];
      const auto ayyyyz_0 = current_data[240];
      const auto axxxzz_0 = current_data[241];
      const auto axxyzz_0 = current_data[242];
      const auto axyyzz_0 = current_data[243];
      const auto ayyyzz_0 = current_data[244];
      const auto axxzzz_0 = current_data[245];
      const auto axyzzz_0 = current_data[246];
      const auto ayyzzz_0 = current_data[247];
      const auto axzzzz_0 = current_data[248];
      const auto ayzzzz_0 = current_data[249];
      const auto azzzzz_0 = current_data[250];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      current_out[420] = ax_xxxx + AB[0] * a0_xxxx; // a0_xxxxx
      current_out[421] = ax_xxxy + AB[0] * a0_xxxy; // a0_xxxxy
      current_out[422] = ax_xxyy + AB[0] * a0_xxyy; // a0_xxxyy
      current_out[423] = ax_xyyy + AB[0] * a0_xyyy; // a0_xxyyy
      current_out[424] = ax_yyyy + AB[0] * a0_yyyy; // a0_xyyyy
      current_out[425] = ay_yyyy + AB[1] * a0_yyyy; // a0_yyyyy
      current_out[426] = ax_xxxz + AB[0] * a0_xxxz; // a0_xxxxz
      current_out[427] = ax_xxyz + AB[0] * a0_xxyz; // a0_xxxyz
      current_out[428] = ax_xyyz + AB[0] * a0_xyyz; // a0_xxyyz
      current_out[429] = ax_yyyz + AB[0] * a0_yyyz; // a0_xyyyz
      current_out[430] = ay_yyyz + AB[1] * a0_yyyz; // a0_yyyyz
      current_out[431] = ax_xxzz + AB[0] * a0_xxzz; // a0_xxxzz
      current_out[432] = ax_xyzz + AB[0] * a0_xyzz; // a0_xxyzz
      current_out[433] = ax_yyzz + AB[0] * a0_yyzz; // a0_xyyzz
      current_out[434] = ay_yyzz + AB[1] * a0_yyzz; // a0_yyyzz
      current_out[435] = ax_xzzz + AB[0] * a0_xzzz; // a0_xxzzz
      current_out[436] = ax_yzzz + AB[0] * a0_yzzz; // a0_xyzzz
      current_out[437] = ay_yzzz + AB[1] * a0_yzzz; // a0_yyzzz
      current_out[438] = ax_zzzz + AB[0] * a0_zzzz; // a0_xzzzz
      current_out[439] = ay_zzzz + AB[1] * a0_zzzz; // a0_yzzzz
      current_out[440] = az_zzzz + AB[2] * a0_zzzz; // a0_zzzzz

    }
  }
}

