% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqlData.R
\name{sqlData}
\alias{sqlData}
\title{Convert a data frame into form suitable for upload to an SQL database}
\usage{
sqlData(con, value, row.names = NA, ...)
}
\arguments{
\item{con}{A database connection.}

\item{value}{A data frame}

\item{row.names}{Either \code{TRUE}, \code{FALSE}, \code{NA} or a string.

If \code{TRUE}, always translate row names to a column called "row_names".
If \code{FALSE}, never translate row names. If \code{NA}, translate
rownames only if they're a character vector.

A string is equivalent to \code{TRUE}, but allows you to override the
default name.

For backward compatibility, \code{NULL} is equivalent to \code{FALSE}.}

\item{...}{Other arguments used by individual methods.}
}
\description{
This is a generic method that coerces R objects into vectors suitable for
upload to the database. The output will vary a little from method to
method depending on whether the main upload device is through a single
SQL string or multiple parameterized queries.
This method is mostly useful for backend implementers.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("sqlData")}
}
\details{
The default method:
\itemize{
\item Converts factors to characters
\item Quotes all strings with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}
\item Converts all columns to strings with \code{\link[=dbQuoteLiteral]{dbQuoteLiteral()}}
\item Replaces NA with NULL
}
}
\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

sqlData(con, head(iris))
sqlData(con, head(mtcars))

dbDisconnect(con)
}
