// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*************************************************************************
 * @file String.cpp
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#include "String.h"

#include <fastcdr/Cdr.h>


#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

#include <utility>

String::String()
{
    m_index = 0;
    m_message = "";
}

String::~String()
{
}

String::String(const String &x)
{
    m_index = x.m_index;
    m_message = x.m_message;
}

String::String(String &&x)
{
    m_index = x.m_index;
    m_message = std::move(x.m_message);
}

String& String::operator=(const String &x)
{
    m_index = x.m_index;
    m_message = x.m_message;
    
    return *this;
}

String& String::operator=(String &&x)
{
    m_index = x.m_index;
    m_message = std::move(x.m_message);
    
    return *this;
}

bool String::operator==(const String &x) const
{
    if(m_index == x.m_index &&
            m_message == x.m_message)
        return true;

    return false;
}

size_t String::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 10000 + 1;

    return current_alignment - initial_alignment;
}

size_t String::getCdrSerializedSize(const String& data, size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
            
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + data.m_message.size() + 1;

    return current_alignment - initial_alignment;
}

size_t String::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            

    return current_align;
}

bool String::isKeyDefined()
{
 return false;
}

void String::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_index;
    scdr << m_message;
}

void String::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_index;
    dcdr >> m_message;
}

void String::serializeKey(eprosima::fastcdr::Cdr &/*scdr*/) const
{
	 
	 
}
