/*
 ==============================================================================
 This file is part of the IEM plug-in suite.
 Author: Daniel Rudrich
 Copyright (c) 2017 - Institute of Electronic Music and Acoustics (IEM)
 https://iem.at

 The IEM plug-in suite is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 The IEM plug-in suite is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this software.  If not, see <https://www.gnu.org/licenses/>.
 ==============================================================================
 */

#pragma once

static const unsigned char WarningSignData[] = {
    110, 109, 248, 99,  240, 67,  117, 51,  149, 67,  98,  8,   12,  242, 67,  117, 115, 149, 67,
    135, 54,  243, 67,  68,  91,  150, 67,  115, 24,  244, 67,  205, 188, 151, 67,  108, 203, 241,
    7,   68,  125, 175, 202, 67,  98,  240, 215, 8,   68,  68,  251, 205, 67,  152, 166, 7,   68,
    0,   0,   210, 67,  4,   198, 5,   68,  0,   0,   210, 67,  108, 227, 245, 211, 67,  0,   0,
    210, 67,  98,  221, 52,  208, 67,  0,   0,   210, 67,  45,  210, 205, 67,  68,  251, 205, 67,
    119, 158, 207, 67,  125, 175, 202, 67,  108, 121, 105, 235, 67,  205, 188, 151, 67,  98,  182,
    51,  236, 67,  231, 91,  150, 67,  227, 133, 237, 67,  174, 103, 149, 67,  244, 29,  239, 67,
    117, 51,  149, 67,  98,  186, 137, 239, 67,  129, 37,  149, 67,  76,  247, 239, 67,  117, 51,
    149, 67,  248, 99,  240, 67,  117, 51,  149, 67,  99,  109, 33,  80,  243, 67,  23,  105, 195,
    67,  108, 39,  193, 236, 67,  23,  105, 195, 67,  108, 39,  193, 236, 67,  23,  41,  201, 67,
    108, 33,  80,  243, 67,  23,  41,  201, 67,  108, 33,  80,  243, 67,  23,  105, 195, 67,  99,
    109, 33,  80,  243, 67,  31,  117, 168, 67,  108, 39,  193, 236, 67,  31,  117, 168, 67,  108,
    39,  193, 236, 67,  143, 226, 189, 67,  108, 33,  80,  243, 67,  143, 226, 189, 67,  108, 33,
    80,  243, 67,  31,  117, 168, 67,  99,  101, 0,   0
};

static const unsigned char BinauralPathData[] = {
    110, 109, 90,  164, 139, 66,  0,   0,   147, 67,  108, 90,  164, 139, 66,  0,   0,   240, 67,
    108, 0,   0,   208, 65,  0,   0,   240, 67,  98,  152, 110, 102, 65,  0,   0,   240, 67,  0,
    0,   160, 64,  139, 76,  235, 67,  0,   0,   160, 64,  0,   128, 229, 67,  108, 0,   0,   160,
    64,  0,   128, 157, 67,  98,  0,   0,   160, 64,  117, 179, 151, 67,  152, 110, 102, 65,  0,
    0,   147, 67,  0,   0,   208, 65,  0,   0,   147, 67,  108, 90,  164, 139, 66,  0,   0,   147,
    67,  99,  109, 0,   0,   200, 66,  0,   128, 124, 67,  98,  211, 205, 176, 66,  0,   128, 124,
    67,  0,   0,   158, 66,  117, 243, 130, 67,  0,   0,   158, 66,  0,   192, 136, 67,  108, 0,
    0,   158, 66,  0,   64,  250, 67,  98,  0,   0,   158, 66,  70,  6,   0,   68,  211, 205, 176,
    66,  0,   96,  2,   68,  0,   0,   200, 66,  0,   96,  2,   68,  108, 0,   0,   220, 66,  0,
    96,  2,   68,  98,  45,  50,  243, 66,  0,   96,  2,   68,  0,   0,   3,   67,  70,  6,   0,
    68,  0,   0,   3,   67,  0,   64,  250, 67,  108, 0,   0,   3,   67,  0,   192, 136, 67,  98,
    0,   0,   3,   67,  117, 243, 130, 67,  45,  50,  243, 66,  0,   128, 124, 67,  0,   0,   220,
    66,  0,   128, 124, 67,  108, 0,   0,   200, 66,  0,   128, 124, 67,  99,  109, 0,   0,   150,
    67,  0,   0,   128, 65,  98,  10,  119, 18,  67,  0,   0,   128, 65,  0,   0,   176, 65,  10,
    119, 12,  67,  0,   0,   176, 65,  0,   0,   147, 67,  108, 0,   0,   80,  66,  0,   0,   147,
    67,  98,  0,   0,   80,  66,  115, 8,   29,  67,  115, 8,   35,  67,  0,   0,   56,  66,  0,
    0,   150, 67,  0,   0,   56,  66,  108, 0,   0,   150, 67,  0,   0,   128, 65,  99,  109, 0,
    0,   150, 67,  0,   0,   128, 65,  98,  123, 196, 226, 67,  0,   0,   128, 65,  0,   128, 16,
    68,  10,  119, 12,  67,  0,   128, 16,  68,  0,   0,   147, 67,  108, 0,   0,   9,   68,  0,
    0,   147, 67,  98,  0,   0,   9,   68,  115, 8,   29,  67,  199, 123, 218, 67,  0,   0,   56,
    66,  0,   0,   150, 67,  0,   0,   56,  66,  108, 0,   0,   150, 67,  0,   0,   128, 65,  99,
    109, 78,  106, 4,   68,  0,   0,   240, 67,  108, 78,  106, 4,   68,  0,   0,   147, 67,  108,
    201, 94,  15,  68,  0,   0,   147, 67,  98,  14,  69,  18,  68,  0,   0,   147, 67,  201, 158,
    20,  68,  117, 179, 151, 67,  201, 158, 20,  68,  0,   128, 157, 67,  108, 201, 158, 20,  68,
    0,   128, 229, 67,  98,  201, 158, 20,  68,  139, 76,  235, 67,  14,  69,  18,  68,  0,   0,
    240, 67,  201, 94,  15,  68,  0,   0,   240, 67,  108, 78,  106, 4,   68,  0,   0,   240, 67,
    99,  109, 145, 189, 249, 67,  0,   96,  2,   68,  108, 145, 189, 244, 67,  0,   96,  2,   68,
    98,  6,   241, 238, 67,  0,   96,  2,   68,  145, 61,  234, 67,  70,  6,   0,   68,  145, 61,
    234, 67,  0,   64,  250, 67,  108, 145, 61,  234, 67,  0,   192, 136, 67,  98,  145, 61,  234,
    67,  117, 243, 130, 67,  6,   241, 238, 67,  0,   128, 124, 67,  145, 189, 244, 67,  0,   128,
    124, 67,  108, 145, 189, 249, 67,  0,   128, 124, 67,  98,  29,  138, 255, 67,  0,   128, 124,
    67,  201, 30,  2,   68,  117, 243, 130, 67,  201, 30,  2,   68,  0,   192, 136, 67,  108, 201,
    30,  2,   68,  0,   64,  250, 67,  98,  201, 30,  2,   68,  70,  6,   0,   68,  29,  138, 255,
    67,  0,   96,  2,   68,  145, 189, 249, 67,  0,   96,  2,   68,  99,  101, 0,   0
};

static const unsigned char DirectivityPathData[] = {
    110, 109, 170, 65,  173, 67,  18,  131, 220, 66,  98,  227, 181, 174, 67,  213, 248, 223, 66,
    139, 44,  176, 67,  35,  91,  227, 66,  139, 140, 177, 67,  242, 82,  231, 66,  108, 14,  253,
    172, 67,  158, 239, 219, 66,  98,  68,  107, 142, 67,  88,  249, 152, 66,  195, 149, 93,  67,
    23,  89,  187, 66,  43,  199, 58,  67,  100, 91,  24,  67,  98,  236, 241, 33,  67,  248, 51,
    67,  67,  70,  182, 49,  67,  199, 43,  118, 67,  137, 129, 77,  67,  129, 197, 141, 67,  98,
    94,  154, 67,  67,  70,  22,  136, 67,  180, 40,  40,  67,  182, 19,  113, 67,  61,  42,  26,
    67,  94,  218, 131, 67,  98,  100, 123, 10,  67,  27,  111, 145, 67,  90,  164, 86,  67,  94,
    218, 154, 67,  90,  164, 86,  67,  94,  218, 154, 67,  98,  90,  164, 86,  67,  94,  218, 154,
    67,  172, 220, 22,  67,  225, 122, 149, 67,  53,  126, 26,  67,  2,   27,  161, 67,  98,  100,
    91,  30,  67,  68,  123, 173, 67,  94,  26,  85,  67,  205, 156, 160, 67,  29,  26,  85,  67,
    172, 156, 160, 67,  98,  94,  26,  85,  67,  205, 156, 160, 67,  70,  246, 14,  67,  10,  231,
    183, 67,  74,  76,  57,  67,  215, 179, 195, 67,  98,  2,   203, 94,  67,  10,  39,  206, 67,
    57,  148, 102, 67,  225, 26,  165, 67,  57,  148, 102, 67,  225, 26,  165, 67,  98,  57,  148,
    102, 67,  225, 26,  165, 67,  182, 147, 103, 67,  88,  201, 194, 67,  63,  101, 129, 67,  0,
    240, 190, 67,  98,  147, 136, 138, 67,  39,  161, 187, 67,  72,  1,   131, 67,  201, 102, 175,
    67,  211, 13,  112, 67,  254, 52,  161, 67,  98,  225, 250, 139, 67,  213, 72,  186, 67,  174,
    183, 154, 67,  39,  97,  181, 67,  70,  86,  156, 67,  119, 110, 174, 67,  98,  27,  31,  158,
    67,  61,  138, 164, 67,  43,  39,  142, 67,  176, 18,  161, 67,  102, 102, 135, 67,  217, 158,
    159, 67,  98,  178, 141, 153, 67,  39,  225, 161, 67,  178, 77,  174, 67,  96,  229, 156, 67,
    35,  171, 187, 67,  158, 239, 143, 67,  98,  14,  189, 190, 67,  162, 245, 140, 67,  227, 53,
    193, 67,  119, 158, 137, 67,  98,  112, 195, 67,  244, 253, 133, 67,  98,  2,   107, 210, 67,
    135, 246, 84,  67,  158, 127, 202, 67,  10,  183, 23,  67,  139, 140, 177, 67,  242, 82,  231,
    66,  98,  250, 78,  174, 67,  164, 240, 222, 66,  162, 213, 175, 67,  51,  179, 226, 66,  14,
    253, 172, 67,  158, 239, 219, 66,  108, 170, 65,  173, 67,  18,  131, 220, 66,  99,  101, 0,
    0
};

static const unsigned char AmbiLogoPathData[] = {
    110, 109, 252, 201, 149, 67,  217, 206, 87,  63,  108, 47,  221, 147, 67,  29,  90,  100, 63,
    98,  152, 78,  86,  67,  68,  139, 124, 64,  117, 115, 23,  67,  102, 38,  137, 66,  199, 107,
    22,  67,  0,   0,   22,  67,  108, 152, 110, 22,  67,  160, 218, 22,  67,  108, 145, 109, 25,
    67,  90,  228, 22,  67,  98,  225, 26,  50,  67,  27,  175, 24,  67,  158, 15,  74,  67,  184,
    158, 30,  67,  178, 125, 95,  67,  100, 59,  43,  67,  98,  215, 195, 73,  67,  152, 110, 56,
    67,  172, 60,  55,  67,  31,  101, 74,  67,  195, 117, 42,  67,  238, 124, 96,  67,  98,  254,
    84,  70,  67,  4,   246, 134, 67,  209, 226, 116, 67,  70,  54,  149, 67,  100, 91,  149, 67,
    176, 146, 149, 67,  108, 20,  94,  149, 67,  0,   0,   150, 67,  108, 172, 92,  149, 67,  80,
    109, 150, 67,  98,  213, 216, 117, 67,  10,  231, 150, 67,  236, 49,  69,  67,  150, 227, 164,
    67,  98,  144, 42,  67,  76,  215, 187, 67,  98,  154, 217, 55,  67,  70,  198, 198, 67,  127,
    202, 73,  67,  150, 35,  208, 67,  39,  17,  96,  67,  27,  143, 214, 67,  98,  188, 20,  73,
    67,  203, 225, 220, 67,  53,  222, 48,  67,  29,  154, 224, 67,  152, 110, 22,  67,  176, 146,
    224, 67,  108, 199, 107, 22,  67,  0,   0,   225, 67,  98,  182, 51,  23,  67,  188, 44,  5,
    68,  66,  0,   86,  67,  4,   190, 20,  68,  47,  221, 147, 67,  233, 198, 21,  68,  108, 252,
    201, 149, 67,  12,  202, 21,  68,  108, 201, 182, 151, 67,  233, 198, 21,  68,  98,  238, 108,
    192, 67,  100, 3,   21,  68,  252, 217, 223, 67,  51,  219, 4,   68,  20,  94,  224, 67,  0,
    0,   225, 67,  108, 113, 93,  224, 67,  240, 199, 224, 67,  98,  0,   128, 211, 67,  254, 116,
    224, 67,  160, 154, 198, 67,  6,   65,  221, 67,  176, 130, 187, 67,  123, 148, 214, 67,  98,
    225, 122, 198, 67,  94,  234, 207, 67,  168, 230, 207, 67,  254, 244, 198, 67,  135, 86,  214,
    67,  195, 197, 187, 67,  98,  84,  115, 200, 67,  96,  5,   165, 67,  113, 29,  177, 67,  55,
    201, 150, 67,  76,  55,  150, 67,  80,  109, 150, 67,  108, 4,   54,  150, 67,  0,   0,   150,
    67,  108, 76,  55,  150, 67,  176, 146, 149, 67,  98,  141, 167, 176, 67,  213, 24,  149, 67,
    2,   251, 200, 67,  106, 28,  135, 67,  231, 75,  214, 67,  104, 81,  96,  67,  98,  76,  167,
    207, 67,  117, 115, 74,  67,  217, 174, 198, 67,  213, 184, 55,  67,  133, 139, 187, 67,  203,
    225, 42,  67,  98,  154, 9,   199, 67,  41,  60,  30,  67,  254, 36,  211, 67,  199, 203, 22,
    67,  172, 92,  224, 67,  160, 218, 22,  67,  108, 20,  94,  224, 67,  0,   0,   22,  67,  98,
    94,  250, 223, 67,  29,  154, 134, 66,  182, 147, 192, 67,  244, 253, 160, 64,  201, 182, 151,
    67,  29,  90,  100, 63,  108, 252, 201, 149, 67,  217, 206, 87,  63,  98,  86,  110, 150, 67,
    109, 231, 91,  63,  143, 18,  151, 67,  137, 65,  96,  63,  201, 182, 151, 67,  29,  90,  100,
    63,  98,  201, 182, 151, 67,  29,  90,  100, 63,  201, 182, 151, 67,  29,  90,  100, 63,  201,
    182, 151, 67,  29,  90,  100, 63,  98,  45,  82,  232, 67,  129, 149, 3,   64,  219, 41,  21,
    68,  152, 142, 7,   67,  248, 171, 21,  68,  51,  19,  148, 67,  98,  248, 171, 21,  68,  51,
    19,  148, 67,  248, 171, 21,  68,  51,  19,  148, 67,  248, 171, 21,  68,  51,  19,  148, 67,
    98,  254, 172, 21,  68,  109, 183, 148, 67,  4,   174, 21,  68,  199, 91,  149, 67,  10,  175,
    21,  68,  0,   0,   150, 67,  108, 254, 228, 21,  68,  0,   0,   150, 67,  98,  102, 230, 21,
    68,  182, 179, 153, 67,  170, 193, 21,  68,  37,  102, 157, 67,  45,  122, 21,  68,  184, 14,
    161, 67,  98,  74,  108, 19,  68,  236, 209, 237, 67,  51,  131, 227, 67,  25,  76,  21,  68,
    201, 182, 151, 67,  233, 198, 21,  68,  98,  201, 182, 151, 67,  233, 198, 21,  68,  201, 182,
    151, 67,  233, 198, 21,  68,  201, 182, 151, 67,  233, 198, 21,  68,  98,  143, 18,  151, 67,
    240, 199, 21,  68,  86,  110, 150, 67,  6,   201, 21,  68,  252, 201, 149, 67,  12,  202, 21,
    68,  98,  195, 37,  149, 67,  6,   201, 21,  68,  137, 129, 148, 67,  240, 199, 21,  68,  80,
    221, 147, 67,  233, 198, 21,  68,  98,  47,  221, 147, 67,  233, 198, 21,  68,  47,  221, 147,
    67,  233, 198, 21,  68,  47,  221, 147, 67,  233, 198, 21,  68,  98,  123, 148, 2,   67,  121,
    73,  21,  68,  238, 124, 31,  64,  242, 210, 231, 67,  80,  141, 215, 62,  0,   0,   150, 67,
    108, 68,  139, 236, 62,  49,  104, 148, 67,  98,  123, 20,  238, 62,  231, 75,  148, 67,  160,
    26,  239, 62,  125, 47,  148, 67,  215, 163, 240, 62,  51,  19,  148, 67,  98,  215, 163, 240,
    62,  51,  19,  148, 67,  215, 163, 240, 62,  51,  19,  148, 67,  215, 163, 240, 62,  51,  19,
    148, 67,  98,  233, 38,  209, 63,  223, 239, 6,   67,  209, 34,  7,   67,  209, 34,  59,  64,
    47,  221, 147, 67,  29,  90,  100, 63,  98,  47,  221, 147, 67,  29,  90,  100, 63,  47,  221,
    147, 67,  29,  90,  100, 63,  80,  221, 147, 67,  29,  90,  100, 63,  98,  137, 129, 148, 67,
    137, 65,  96,  63,  195, 37,  149, 67,  109, 231, 91,  63,  252, 201, 149, 67,  217, 206, 87,
    63,  99,  109, 252, 201, 224, 67,  207, 215, 22,  67,  108, 172, 92,  224, 67,  160, 218, 22,
    67,  98,  252, 9,   224, 67,  96,  165, 48,  67,  80,  205, 220, 67,  152, 238, 73,  67,  231,
    75,  214, 67,  104, 81,  96,  67,  98,  80,  45,  221, 67,  10,  247, 118, 67,  74,  124, 224,
    67,  6,   209, 136, 67,  25,  148, 224, 67,  0,   0,   150, 67,  98,  88,  105, 224, 67,  72,
    49,  163, 67,  4,   54,  221, 67,  94,  106, 176, 67,  135, 86,  214, 67,  195, 197, 187, 67,
    98,  248, 19,  221, 67,  131, 208, 198, 67,  193, 42,  224, 67,  45,  242, 211, 67,  113, 93,
    224, 67,  240, 199, 224, 67,  108, 0,   0,   225, 67,  252, 201, 224, 67,  98,  59,  215, 2,
    68,  23,  233, 224, 67,  164, 184, 18,  68,  25,  36,  197, 67,  45,  122, 21,  68,  184, 14,
    161, 67,  98,  39,  177, 21,  68,  84,  147, 152, 67,  238, 164, 21,  68,  51,  67,  156, 67,
    10,  175, 21,  68,  0,   0,   150, 67,  108, 248, 171, 21,  68,  51,  19,  148, 67,  98,  115,
    232, 20,  68,  160, 186, 86,  67,  49,  192, 4,   68,  125, 223, 23,  67,  252, 201, 224, 67,
    207, 215, 22,  67,  99,  109, 248, 147, 21,  67,  207, 215, 22,  67,  98,  143, 194, 133, 66,
    125, 159, 23,  67,  238, 124, 147, 64,  139, 108, 86,  67,  215, 163, 240, 62,  51,  19,  148,
    67,  108, 68,  139, 236, 62,  49,  104, 148, 67,  108, 80,  141, 215, 62,  0,   0,   150, 67,
    98,  98,  16,  216, 62,  66,  48,  191, 67,  233, 102, 134, 66,  25,  148, 224, 67,  248, 147,
    21,  67,  25,  148, 224, 67,  108, 152, 110, 22,  67,  176, 146, 224, 67,  98,  57,  20,  23,
    67,  80,  173, 211, 67,  145, 141, 29,  67,  180, 8,   199, 67,  98,  144, 42,  67,  76,  215,
    187, 67,  98,  211, 205, 28,  67,  123, 132, 176, 67,  92,  47,  22,  67,  27,  47,  163, 67,
    0,   0,   22,  67,  0,   0,   150, 67,  98,  63,  85,  22,  67,  131, 208, 136, 67,  94,  186,
    28,  67,  104, 49,  119, 67,  195, 117, 42,  67,  238, 124, 96,  67,  98,  164, 208, 29,  67,
    131, 128, 73,  67,  190, 95,  22,  67,  252, 73,  49,  67,  152, 110, 22,  67,  160, 218, 22,
    67,  108, 248, 147, 21,  67,  207, 215, 22,  67,  99,  109, 252, 201, 149, 67,  231, 107, 150,
    67,  108, 172, 92,  149, 67,  80,  109, 150, 67,  98,  131, 0,   149, 67,  207, 87,  177, 67,
    98,  192, 134, 67,  250, 158, 200, 67,  39,  17,  96,  67,  27,  143, 214, 67,  98,  162, 197,
    118, 67,  238, 108, 221, 67,  127, 154, 136, 67,  59,  159, 224, 67,  252, 201, 149, 67,  252,
    201, 224, 67,  98,  219, 233, 162, 67,  217, 174, 224, 67,  2,   59,  176, 67,  59,  111, 221,
    67,  176, 130, 187, 67,  123, 148, 214, 67,  98,  215, 163, 164, 67,  51,  51,  201, 67,  125,
    175, 150, 67,  248, 211, 176, 67,  76,  55,  150, 67,  80,  109, 150, 67,  108, 252, 201, 149,
    67,  231, 107, 150, 67,  99,  109, 252, 201, 149, 67,  199, 107, 22,  67,  98,  39,  129, 136,
    67,  223, 143, 22,  67,  180, 72,  118, 67,  78,  98,  29,  67,  178, 125, 95,  67,  100, 59,
    43,  67,  98,  66,  240, 134, 67,  84,  227, 68,  67,  238, 156, 148, 67,  18,  227, 118, 67,
    100, 91,  149, 67,  176, 146, 149, 67,  108, 252, 201, 149, 67,  25,  148, 149, 67,  108, 76,
    55,  150, 67,  176, 146, 149, 67,  98,  117, 147, 150, 67,  164, 80,  117, 67,  182, 211, 164,
    67,  137, 193, 70,  67,  133, 139, 187, 67,  203, 225, 42,  67,  98,  72,  49,  176, 67,  37,
    38,  29,  67,  121, 249, 162, 67,  137, 193, 22,  67,  252, 201, 149, 67,  199, 107, 22,  67,
    99,  101, 0,   0
};

static const unsigned char IEMpathData[] = {
    110, 109, 199, 203, 118, 66,  117, 147, 213, 66,  108, 94,  186, 124, 66,  66,  224, 213, 66,
    98,  160, 154, 133, 66,  119, 254, 215, 66,  72,  97,  137, 66,  158, 239, 220, 66,  190, 31,
    138, 66,  80,  77,  228, 66,  98,  190, 31,  138, 66,  152, 110, 236, 66,  43,  135, 131, 66,
    174, 7,   243, 66,  199, 203, 118, 66,  174, 7,   243, 66,  98,  61,  138, 102, 66,  174, 7,
    243, 66,  16,  88,  89,  66,  152, 110, 236, 66,  10,  87,  89,  66,  80,  77,  228, 66,  98,
    16,  88,  89,  66,  139, 44,  220, 66,  61,  138, 102, 66,  117, 147, 213, 66,  199, 203, 118,
    66,  117, 147, 213, 66,  99,  109, 162, 37,  92,  67,  117, 147, 213, 66,  98,  63,  21,  88,
    67,  117, 147, 213, 66,  246, 200, 84,  67,  139, 44,  220, 66,  180, 200, 84,  67,  80,  77,
    228, 66,  98,  246, 200, 84,  67,  152, 110, 236, 66,  63,  21,  88,  67,  174, 7,   243, 66,
    162, 37,  92,  67,  174, 7,   243, 66,  98,  70,  54,  96,  67,  174, 7,   243, 66,  209, 130,
    99,  67,  152, 110, 236, 66,  209, 130, 99,  67,  80,  77,  228, 66,  98,  209, 130, 99,  67,
    139, 44,  220, 66,  70,  54,  96,  67,  117, 147, 213, 66,  162, 37,  92,  67,  117, 147, 213,
    66,  99,  109, 39,  49,  237, 65,  117, 147, 213, 66,  98,  90,  100, 204, 65,  109, 103, 214,
    66,  154, 153, 179, 65,  45,  178, 219, 66,  174, 71,  178, 65,  80,  77,  228, 66,  98,  174,
    71,  178, 65,  152, 110, 236, 66,  252, 169, 204, 65,  174, 7,   243, 66,  39,  49,  237, 65,
    174, 7,   243, 66,  98,  29,  218, 6,   66,  174, 7,   243, 66,  74,  12,  20,  66,  152, 110,
    236, 66,  74,  12,  20,  66,  80,  77,  228, 66,  98,  92,  143, 18,  66,  158, 239, 220, 66,
    12,  2,   11,  66,  119, 254, 215, 66,  86,  14,  249, 65,  66,  224, 213, 66,  108, 39,  49,
    237, 65,  117, 147, 213, 66,  99,  109, 111, 50,  124, 67,  117, 147, 213, 66,  98,  12,  34,
    120, 67,  117, 147, 213, 66,  195, 213, 116, 67,  139, 44,  220, 66,  195, 213, 116, 67,  80,
    77,  228, 66,  98,  195, 213, 116, 67,  152, 110, 236, 66,  12,  34,  120, 67,  174, 7,   243,
    66,  111, 50,  124, 67,  174, 7,   243, 66,  98,  170, 33,  128, 67,  174, 7,   243, 66,  207,
    199, 129, 67,  152, 110, 236, 66,  207, 199, 129, 67,  80,  77,  228, 66,  98,  49,  152, 129,
    67,  158, 239, 220, 66,  135, 166, 128, 67,  119, 254, 215, 66,  86,  174, 125, 67,  66,  224,
    213, 66,  108, 111, 50,  124, 67,  117, 147, 213, 66,  99,  109, 76,  183, 23,  67,  117, 147,
    213, 66,  98,  233, 166, 19,  67,  117, 147, 213, 66,  94,  90,  16,  67,  139, 44,  220, 66,
    94,  90,  16,  67,  80,  77,  228, 66,  98,  94,  90,  16,  67,  152, 110, 236, 66,  233, 166,
    19,  67,  174, 7,   243, 66,  76,  183, 23,  67,  174, 7,   243, 66,  98,  240, 199, 27,  67,
    174, 7,   243, 66,  123, 20,  31,  67,  152, 110, 236, 66,  123, 20,  31,  67,  80,  77,  228,
    66,  98,  123, 20,  31,  67,  139, 44,  220, 66,  240, 199, 27,  67,  117, 147, 213, 66,  76,
    183, 23,  67,  117, 147, 213, 66,  99,  109, 39,  177, 7,   67,  117, 147, 213, 66,  98,  197,
    160, 3,   67,  117, 147, 213, 66,  57,  84,  0,   67,  139, 44,  220, 66,  57,  84,  0,   67,
    80,  77,  228, 66,  98,  57,  84,  0,   67,  152, 110, 236, 66,  197, 160, 3,   67,  174, 7,
    243, 66,  39,  177, 7,   67,  174, 7,   243, 66,  98,  203, 193, 11,  67,  174, 7,   243, 66,
    86,  14,  15,  67,  152, 110, 236, 66,  86,  14,  15,  67,  80,  77,  228, 66,  98,  27,  175,
    14,  67,  158, 239, 220, 66,  133, 203, 12,  67,  119, 254, 215, 66,  205, 44,  9,   67,  66,
    224, 213, 66,  108, 39,  177, 7,   67,  117, 147, 213, 66,  99,  109, 213, 24,  60,  67,  117,
    147, 213, 66,  98,  115, 8,   56,  67,  117, 147, 213, 66,  231, 187, 52,  67,  139, 44,  220,
    66,  231, 187, 52,  67,  80,  77,  228, 66,  98,  231, 187, 52,  67,  152, 110, 236, 66,  115,
    8,   56,  67,  174, 7,   243, 66,  213, 24,  60,  67,  174, 7,   243, 66,  98,  121, 41,  64,
    67,  174, 7,   243, 66,  70,  118, 67,  67,  152, 110, 236, 66,  4,   118, 67,  67,  80,  77,
    228, 66,  98,  70,  118, 67,  67,  139, 44,  220, 66,  121, 41,  64,  67,  117, 147, 213, 66,
    213, 24,  60,  67,  117, 147, 213, 66,  99,  109, 254, 84,  239, 66,  117, 147, 213, 66,  98,
    188, 52,  231, 66,  117, 147, 213, 66,  166, 155, 224, 66,  139, 44,  220, 66,  35,  155, 224,
    66,  80,  77,  228, 66,  98,  166, 155, 224, 66,  152, 110, 236, 66,  188, 52,  231, 66,  174,
    7,   243, 66,  254, 84,  239, 66,  174, 7,   243, 66,  98,  201, 118, 247, 66,  174, 7,   243,
    66,  223, 15,  254, 66,  152, 110, 236, 66,  223, 15,  254, 66,  80,  77,  228, 66,  98,  223,
    15,  254, 66,  139, 44,  220, 66,  201, 118, 247, 66,  117, 147, 213, 66,  254, 84,  239, 66,
    117, 147, 213, 66,  99,  109, 45,  178, 54,  66,  117, 147, 213, 66,  98,  164, 112, 38,  66,
    117, 147, 213, 66,  119, 62,  25,  66,  139, 44,  220, 66,  113, 61,  25,  66,  80,  77,  228,
    66,  98,  119, 62,  25,  66,  152, 110, 236, 66,  164, 112, 38,  66,  174, 7,   243, 66,  45,
    178, 54,  66,  174, 7,   243, 66,  98,  182, 243, 70,  66,  174, 7,   243, 66,  227, 37,  84,
    66,  152, 110, 236, 66,  227, 37,  84,  66,  80,  77,  228, 66,  98,  227, 37,  84,  66,  139,
    44,  220, 66,  182, 243, 70,  66,  117, 147, 213, 66,  45,  178, 54,  66,  117, 147, 213, 66,
    99,  109, 0,   64,  210, 66,  66,  224, 213, 66,  108, 180, 72,  207, 66,  117, 147, 213, 66,
    98,  240, 39,  199, 66,  117, 147, 213, 66,  217, 142, 192, 66,  139, 44,  220, 66,  217, 142,
    192, 66,  80,  77,  228, 66,  98,  217, 142, 192, 66,  152, 110, 236, 66,  240, 39,  199, 66,
    174, 7,   243, 66,  180, 72,  207, 66,  174, 7,   243, 66,  98,  252, 105, 215, 66,  174, 7,
    243, 66,  150, 3,   222, 66,  152, 110, 236, 66,  18,  3,   222, 66,  80,  77,  228, 66,  98,
    31,  69,  221, 66,  158, 239, 220, 66,  113, 125, 217, 66,  119, 254, 215, 66,  0,   64,  210,
    66,  66,  224, 213, 66,  99,  109, 231, 59,  175, 66,  53,  222, 181, 66,  108, 231, 59,  175,
    66,  53,  222, 181, 66,  98,  35,  27,  167, 66,  53,  222, 181, 66,  143, 130, 160, 66,  76,
    119, 188, 66,  12,  130, 160, 66,  16,  152, 196, 66,  98,  143, 130, 160, 66,  88,  185, 204,
    66,  35,  27,  167, 66,  111, 82,  211, 66,  231, 59,  175, 66,  111, 82,  211, 66,  98,  178,
    93,  183, 66,  111, 82,  211, 66,  70,  246, 189, 66,  88,  185, 204, 66,  70,  246, 189, 66,
    16,  152, 196, 66,  98,  70,  246, 189, 66,  76,  119, 188, 66,  178, 93,  183, 66,  53,  222,
    181, 66,  231, 59,  175, 66,  53,  222, 181, 66,  99,  109, 45,  178, 54,  66,  53,  222, 181,
    66,  108, 45,  178, 54,  66,  53,  222, 181, 66,  98,  164, 112, 38,  66,  53,  222, 181, 66,
    119, 62,  25,  66,  76,  119, 188, 66,  113, 61,  25,  66,  16,  152, 196, 66,  98,  119, 62,
    25,  66,  88,  185, 204, 66,  164, 112, 38,  66,  111, 82,  211, 66,  45,  178, 54,  66,  111,
    82,  211, 66,  98,  182, 243, 70,  66,  111, 82,  211, 66,  227, 37,  84,  66,  88,  185, 204,
    66,  227, 37,  84,  66,  16,  152, 196, 66,  98,  227, 37,  84,  66,  76,  119, 188, 66,  182,
    243, 70,  66,  53,  222, 181, 66,  45,  178, 54,  66,  53,  222, 181, 66,  99,  109, 162, 37,
    92,  67,  178, 221, 181, 66,  108, 162, 37,  92,  67,  178, 221, 181, 66,  98,  63,  21,  88,
    67,  178, 221, 181, 66,  246, 200, 84,  67,  201, 118, 188, 66,  180, 200, 84,  67,  141, 151,
    196, 66,  98,  246, 200, 84,  67,  213, 184, 204, 66,  63,  21,  88,  67,  236, 81,  211, 66,
    162, 37,  92,  67,  236, 81,  211, 66,  98,  70,  54,  96,  67,  236, 81,  211, 66,  209, 130,
    99,  67,  213, 184, 204, 66,  209, 130, 99,  67,  141, 151, 196, 66,  98,  209, 130, 99,  67,
    201, 118, 188, 66,  70,  54,  96,  67,  178, 221, 181, 66,  162, 37,  92,  67,  178, 221, 181,
    66,  99,  109, 213, 24,  60,  67,  178, 221, 181, 66,  108, 213, 24,  60,  67,  178, 221, 181,
    66,  98,  115, 8,   56,  67,  178, 221, 181, 66,  231, 187, 52,  67,  201, 118, 188, 66,  231,
    187, 52,  67,  141, 151, 196, 66,  98,  231, 187, 52,  67,  213, 184, 204, 66,  115, 8,   56,
    67,  236, 81,  211, 66,  213, 24,  60,  67,  236, 81,  211, 66,  98,  121, 41,  64,  67,  236,
    81,  211, 66,  70,  118, 67,  67,  213, 184, 204, 66,  4,   118, 67,  67,  141, 151, 196, 66,
    98,  70,  118, 67,  67,  201, 118, 188, 66,  121, 41,  64,  67,  178, 221, 181, 66,  213, 24,
    60,  67,  178, 221, 181, 66,  99,  109, 111, 50,  124, 67,  178, 221, 181, 66,  108, 111, 50,
    124, 67,  178, 221, 181, 66,  98,  12,  34,  120, 67,  178, 221, 181, 66,  195, 213, 116, 67,
    201, 118, 188, 66,  195, 213, 116, 67,  141, 151, 196, 66,  98,  195, 213, 116, 67,  213, 184,
    204, 66,  12,  34,  120, 67,  236, 81,  211, 66,  111, 50,  124, 67,  236, 81,  211, 66,  98,
    170, 33,  128, 67,  236, 81,  211, 66,  207, 199, 129, 67,  213, 184, 204, 66,  207, 199, 129,
    67,  141, 151, 196, 66,  98,  207, 199, 129, 67,  201, 118, 188, 66,  170, 33,  128, 67,  178,
    221, 181, 66,  111, 50,  124, 67,  178, 221, 181, 66,  99,  109, 111, 50,  124, 67,  240, 39,
    150, 66,  98,  12,  34,  120, 67,  240, 39,  150, 66,  195, 213, 116, 67,  6,   193, 156, 66,
    195, 213, 116, 67,  203, 225, 164, 66,  98,  195, 213, 116, 67,  18,  3,   173, 66,  12,  34,
    120, 67,  41,  156, 179, 66,  111, 50,  124, 67,  41,  156, 179, 66,  98,  170, 33,  128, 67,
    41,  156, 179, 66,  207, 199, 129, 67,  18,  3,   173, 66,  207, 199, 129, 67,  203, 225, 164,
    66,  98,  49,  152, 129, 67,  25,  132, 157, 66,  135, 166, 128, 67,  242, 146, 152, 66,  86,
    174, 125, 67,  188, 116, 150, 66,  108, 111, 50,  124, 67,  240, 39,  150, 66,  99,  109, 254,
    84,  239, 66,  240, 39,  150, 66,  98,  188, 52,  231, 66,  240, 39,  150, 66,  166, 155, 224,
    66,  6,   193, 156, 66,  35,  155, 224, 66,  203, 225, 164, 66,  98,  166, 155, 224, 66,  18,
    3,   173, 66,  188, 52,  231, 66,  41,  156, 179, 66,  254, 84,  239, 66,  41,  156, 179, 66,
    98,  201, 118, 247, 66,  41,  156, 179, 66,  223, 15,  254, 66,  18,  3,   173, 66,  223, 15,
    254, 66,  203, 225, 164, 66,  98,  223, 15,  254, 66,  6,   193, 156, 66,  201, 118, 247, 66,
    240, 39,  150, 66,  254, 84,  239, 66,  240, 39,  150, 66,  99,  109, 180, 72,  207, 66,  240,
    39,  150, 66,  98,  240, 39,  199, 66,  240, 39,  150, 66,  217, 142, 192, 66,  6,   193, 156,
    66,  217, 142, 192, 66,  203, 225, 164, 66,  98,  217, 142, 192, 66,  18,  3,   173, 66,  240,
    39,  199, 66,  41,  156, 179, 66,  180, 72,  207, 66,  41,  156, 179, 66,  98,  252, 105, 215,
    66,  41,  156, 179, 66,  150, 3,   222, 66,  18,  3,   173, 66,  18,  3,   222, 66,  203, 225,
    164, 66,  98,  31,  69,  221, 66,  25,  132, 157, 66,  113, 125, 217, 66,  242, 146, 152, 66,
    0,   64,  210, 66,  188, 116, 150, 66,  108, 180, 72,  207, 66,  240, 39,  150, 66,  99,  109,
    162, 37,  92,  67,  240, 39,  150, 66,  98,  63,  21,  88,  67,  240, 39,  150, 66,  246, 200,
    84,  67,  6,   193, 156, 66,  180, 200, 84,  67,  203, 225, 164, 66,  98,  246, 200, 84,  67,
    18,  3,   173, 66,  63,  21,  88,  67,  41,  156, 179, 66,  162, 37,  92,  67,  41,  156, 179,
    66,  98,  70,  54,  96,  67,  41,  156, 179, 66,  209, 130, 99,  67,  18,  3,   173, 66,  209,
    130, 99,  67,  203, 225, 164, 66,  98,  209, 130, 99,  67,  6,   193, 156, 66,  70,  54,  96,
    67,  240, 39,  150, 66,  162, 37,  92,  67,  240, 39,  150, 66,  99,  109, 231, 59,  175, 66,
    240, 39,  150, 66,  98,  35,  27,  167, 66,  240, 39,  150, 66,  143, 130, 160, 66,  6,   193,
    156, 66,  12,  130, 160, 66,  203, 225, 164, 66,  98,  143, 130, 160, 66,  18,  3,   173, 66,
    35,  27,  167, 66,  41,  156, 179, 66,  231, 59,  175, 66,  41,  156, 179, 66,  98,  178, 93,
    183, 66,  41,  156, 179, 66,  70,  246, 189, 66,  18,  3,   173, 66,  70,  246, 189, 66,  203,
    225, 164, 66,  98,  70,  246, 189, 66,  6,   193, 156, 66,  178, 93,  183, 66,  240, 39,  150,
    66,  231, 59,  175, 66,  240, 39,  150, 66,  99,  109, 76,  183, 23,  67,  240, 39,  150, 66,
    98,  233, 166, 19,  67,  240, 39,  150, 66,  94,  90,  16,  67,  6,   193, 156, 66,  94,  90,
    16,  67,  203, 225, 164, 66,  98,  94,  90,  16,  67,  18,  3,   173, 66,  233, 166, 19,  67,
    41,  156, 179, 66,  76,  183, 23,  67,  41,  156, 179, 66,  98,  240, 199, 27,  67,  41,  156,
    179, 66,  123, 20,  31,  67,  18,  3,   173, 66,  123, 20,  31,  67,  203, 225, 164, 66,  98,
    123, 20,  31,  67,  6,   193, 156, 66,  240, 199, 27,  67,  240, 39,  150, 66,  76,  183, 23,
    67,  240, 39,  150, 66,  99,  109, 45,  178, 54,  66,  240, 39,  150, 66,  98,  164, 112, 38,
    66,  240, 39,  150, 66,  119, 62,  25,  66,  6,   193, 156, 66,  113, 61,  25,  66,  203, 225,
    164, 66,  98,  119, 62,  25,  66,  18,  3,   173, 66,  164, 112, 38,  66,  41,  156, 179, 66,
    45,  178, 54,  66,  41,  156, 179, 66,  98,  182, 243, 70,  66,  41,  156, 179, 66,  227, 37,
    84,  66,  18,  3,   173, 66,  227, 37,  84,  66,  203, 225, 164, 66,  98,  227, 37,  84,  66,
    6,   193, 156, 66,  182, 243, 70,  66,  240, 39,  150, 66,  45,  178, 54,  66,  240, 39,  150,
    66,  99,  109, 213, 24,  60,  67,  240, 39,  150, 66,  98,  115, 8,   56,  67,  240, 39,  150,
    66,  231, 187, 52,  67,  6,   193, 156, 66,  231, 187, 52,  67,  203, 225, 164, 66,  98,  231,
    187, 52,  67,  18,  3,   173, 66,  115, 8,   56,  67,  41,  156, 179, 66,  213, 24,  60,  67,
    41,  156, 179, 66,  98,  121, 41,  64,  67,  41,  156, 179, 66,  70,  118, 67,  67,  18,  3,
    173, 66,  4,   118, 67,  67,  203, 225, 164, 66,  98,  70,  118, 67,  67,  6,   193, 156, 66,
    121, 41,  64,  67,  240, 39,  150, 66,  213, 24,  60,  67,  240, 39,  150, 66,  99,  109, 39,
    177, 7,   67,  240, 39,  150, 66,  98,  197, 160, 3,   67,  240, 39,  150, 66,  57,  84,  0,
    67,  6,   193, 156, 66,  57,  84,  0,   67,  203, 225, 164, 66,  98,  57,  84,  0,   67,  18,
    3,   173, 66,  197, 160, 3,   67,  41,  156, 179, 66,  39,  177, 7,   67,  41,  156, 179, 66,
    98,  203, 193, 11,  67,  41,  156, 179, 66,  86,  14,  15,  67,  18,  3,   173, 66,  86,  14,
    15,  67,  203, 225, 164, 66,  98,  27,  175, 14,  67,  25,  132, 157, 66,  133, 203, 12,  67,
    242, 146, 152, 66,  205, 44,  9,   67,  188, 116, 150, 66,  108, 39,  177, 7,   67,  240, 39,
    150, 66,  99,  109, 213, 24,  60,  67,  90,  228, 108, 66,  108, 213, 24,  60,  67,  90,  228,
    108, 66,  98,  115, 8,   56,  67,  90,  228, 108, 66,  231, 187, 52,  67,  135, 22,  122, 66,
    231, 187, 52,  67,  8,   44,  133, 66,  98,  231, 187, 52,  67,  80,  77,  141, 66,  115, 8,
    56,  67,  102, 230, 147, 66,  213, 24,  60,  67,  102, 230, 147, 66,  98,  121, 41,  64,  67,
    102, 230, 147, 66,  70,  118, 67,  67,  80,  77,  141, 66,  4,   118, 67,  67,  8,   44,  133,
    66,  98,  70,  118, 67,  67,  135, 22,  122, 66,  121, 41,  64,  67,  90,  228, 108, 66,  213,
    24,  60,  67,  90,  228, 108, 66,  99,  109, 231, 59,  175, 66,  90,  228, 108, 66,  108, 231,
    59,  175, 66,  90,  228, 108, 66,  98,  35,  27,  167, 66,  90,  228, 108, 66,  143, 130, 160,
    66,  135, 22,  122, 66,  12,  130, 160, 66,  8,   44,  133, 66,  98,  143, 130, 160, 66,  80,
    77,  141, 66,  35,  27,  167, 66,  102, 230, 147, 66,  231, 59,  175, 66,  102, 230, 147, 66,
    98,  178, 93,  183, 66,  102, 230, 147, 66,  70,  246, 189, 66,  80,  77,  141, 66,  70,  246,
    189, 66,  8,   44,  133, 66,  98,  70,  246, 189, 66,  135, 22,  122, 66,  178, 93,  183, 66,
    90,  228, 108, 66,  231, 59,  175, 66,  90,  228, 108, 66,  99,  109, 76,  183, 23,  67,  90,
    228, 108, 66,  108, 76,  183, 23,  67,  90,  228, 108, 66,  98,  233, 166, 19,  67,  90,  228,
    108, 66,  94,  90,  16,  67,  135, 22,  122, 66,  94,  90,  16,  67,  8,   44,  133, 66,  98,
    94,  90,  16,  67,  80,  77,  141, 66,  233, 166, 19,  67,  102, 230, 147, 66,  76,  183, 23,
    67,  102, 230, 147, 66,  98,  240, 199, 27,  67,  102, 230, 147, 66,  123, 20,  31,  67,  80,
    77,  141, 66,  123, 20,  31,  67,  8,   44,  133, 66,  98,  123, 20,  31,  67,  135, 22,  122,
    66,  240, 199, 27,  67,  90,  228, 108, 66,  76,  183, 23,  67,  90,  228, 108, 66,  99,  109,
    111, 50,  124, 67,  90,  228, 108, 66,  108, 111, 50,  124, 67,  90,  228, 108, 66,  98,  12,
    34,  120, 67,  90,  228, 108, 66,  195, 213, 116, 67,  135, 22,  122, 66,  195, 213, 116, 67,
    8,   44,  133, 66,  98,  195, 213, 116, 67,  80,  77,  141, 66,  12,  34,  120, 67,  102, 230,
    147, 66,  111, 50,  124, 67,  102, 230, 147, 66,  98,  170, 33,  128, 67,  102, 230, 147, 66,
    207, 199, 129, 67,  80,  77,  141, 66,  207, 199, 129, 67,  8,   44,  133, 66,  98,  207, 199,
    129, 67,  135, 22,  122, 66,  170, 33,  128, 67,  90,  228, 108, 66,  111, 50,  124, 67,  90,
    228, 108, 66,  99,  109, 162, 37,  92,  67,  90,  228, 108, 66,  108, 162, 37,  92,  67,  90,
    228, 108, 66,  98,  63,  21,  88,  67,  90,  228, 108, 66,  246, 200, 84,  67,  135, 22,  122,
    66,  180, 200, 84,  67,  8,   44,  133, 66,  98,  246, 200, 84,  67,  80,  77,  141, 66,  63,
    21,  88,  67,  102, 230, 147, 66,  162, 37,  92,  67,  102, 230, 147, 66,  98,  70,  54,  96,
    67,  102, 230, 147, 66,  209, 130, 99,  67,  80,  77,  141, 66,  209, 130, 99,  67,  8,   44,
    133, 66,  98,  209, 130, 99,  67,  135, 22,  122, 66,  70,  54,  96,  67,  90,  228, 108, 66,
    162, 37,  92,  67,  90,  228, 108, 66,  99,  109, 45,  178, 54,  66,  90,  228, 108, 66,  108,
    45,  178, 54,  66,  90,  228, 108, 66,  98,  164, 112, 38,  66,  90,  228, 108, 66,  119, 62,
    25,  66,  135, 22,  122, 66,  113, 61,  25,  66,  8,   44,  133, 66,  98,  119, 62,  25,  66,
    80,  77,  141, 66,  164, 112, 38,  66,  102, 230, 147, 66,  45,  178, 54,  66,  102, 230, 147,
    66,  98,  182, 243, 70,  66,  102, 230, 147, 66,  227, 37,  84,  66,  80,  77,  141, 66,  227,
    37,  84,  66,  8,   44,  133, 66,  98,  227, 37,  84,  66,  135, 22,  122, 66,  182, 243, 70,
    66,  90,  228, 108, 66,  45,  178, 54,  66,  90,  228, 108, 66,  99,  109, 59,  31,  76,  67,
    207, 119, 45,  66,  98,  27,  15,  72,  67,  207, 119, 45,  66,  143, 194, 68,  67,  252, 169,
    58,  66,  143, 194, 68,  67,  133, 235, 74,  66,  98,  143, 194, 68,  67,  20,  46,  91,  66,
    27,  15,  72,  67,  66,  96,  104, 66,  59,  31,  76,  67,  66,  96,  104, 66,  98,  33,  48,
    80,  67,  66,  96,  104, 66,  106, 124, 83,  67,  20,  46,  91,  66,  106, 124, 83,  67,  133,
    235, 74,  66,  98,  47,  29,  83,  67,  33,  48,  60,  66,  219, 57,  81,  67,  211, 77,  50,
    66,  35,  155, 77,  67,  104, 17,  46,  66,  108, 59,  31,  76,  67,  207, 119, 45,  66,  99,
    109, 254, 84,  239, 66,  207, 119, 45,  66,  98,  188, 52,  231, 66,  207, 119, 45,  66,  166,
    155, 224, 66,  252, 169, 58,  66,  35,  155, 224, 66,  133, 235, 74,  66,  98,  166, 155, 224,
    66,  20,  46,  91,  66,  188, 52,  231, 66,  66,  96,  104, 66,  254, 84,  239, 66,  66,  96,
    104, 66,  98,  201, 118, 247, 66,  66,  96,  104, 66,  223, 15,  254, 66,  20,  46,  91,  66,
    223, 15,  254, 66,  133, 235, 74,  66,  98,  223, 15,  254, 66,  252, 169, 58,  66,  201, 118,
    247, 66,  207, 119, 45,  66,  254, 84,  239, 66,  207, 119, 45,  66,  99,  109, 45,  178, 54,
    66,  207, 119, 45,  66,  108, 207, 119, 54,  66,  244, 125, 45,  66,  108, 113, 61,  54,  66,
    207, 119, 45,  66,  98,  225, 250, 37,  66,  207, 119, 45,  66,  174, 199, 24,  66,  252, 169,
    58,  66,  174, 199, 24,  66,  133, 235, 74,  66,  98,  174, 199, 24,  66,  20,  46,  91,  66,
    225, 250, 37,  66,  66,  96,  104, 66,  113, 61,  54,  66,  66,  96,  104, 66,  108, 207, 119,
    54,  66,  29,  90,  104, 66,  108, 45,  178, 54,  66,  66,  96,  104, 66,  98,  182, 243, 70,
    66,  66,  96,  104, 66,  227, 37,  84,  66,  20,  46,  91,  66,  227, 37,  84,  66,  133, 235,
    74,  66,  98,  227, 37,  84,  66,  252, 169, 58,  66,  182, 243, 70,  66,  207, 119, 45,  66,
    45,  178, 54,  66,  207, 119, 45,  66,  99,  109, 8,   44,  108, 67,  207, 119, 45,  66,  108,
    113, 29,  108, 67,  244, 125, 45,  66,  108, 152, 14,  108, 67,  207, 119, 45,  66,  98,  53,
    254, 103, 67,  207, 119, 45,  66,  236, 177, 100, 67,  252, 169, 58,  66,  236, 177, 100, 67,
    133, 235, 74,  66,  98,  236, 177, 100, 67,  20,  46,  91,  66,  53,  254, 103, 67,  66,  96,
    104, 66,  152, 14,  108, 67,  66,  96,  104, 66,  108, 113, 29,  108, 67,  29,  90,  104, 66,
    108, 8,   44,  108, 67,  66,  96,  104, 66,  98,  238, 60,  112, 67,  66,  96,  104, 66,  55,
    137, 115, 67,  20,  46,  91,  66,  55,  137, 115, 67,  133, 235, 74,  66,  98,  55,  137, 115,
    67,  252, 169, 58,  66,  238, 60,  112, 67,  207, 119, 45,  66,  8,   44,  108, 67,  207, 119,
    45,  66,  99,  109, 180, 72,  207, 66,  207, 119, 45,  66,  98,  240, 39,  199, 66,  207, 119,
    45,  66,  217, 142, 192, 66,  252, 169, 58,  66,  217, 142, 192, 66,  133, 235, 74,  66,  98,
    217, 142, 192, 66,  20,  46,  91,  66,  240, 39,  199, 66,  66,  96,  104, 66,  180, 72,  207,
    66,  66,  96,  104, 66,  98,  252, 105, 215, 66,  66,  96,  104, 66,  150, 3,   222, 66,  20,
    46,  91,  66,  18,  3,   222, 66,  133, 235, 74,  66,  98,  31,  69,  221, 66,  33,  48,  60,
    66,  113, 125, 217, 66,  211, 77,  50,  66,  0,   64,  210, 66,  104, 17,  46,  66,  108, 180,
    72,  207, 66,  207, 119, 45,  66,  99,  109, 162, 37,  92,  67,  207, 119, 45,  66,  98,  63,
    21,  88,  67,  207, 119, 45,  66,  246, 200, 84,  67,  252, 169, 58,  66,  180, 200, 84,  67,
    133, 235, 74,  66,  98,  246, 200, 84,  67,  20,  46,  91,  66,  63,  21,  88,  67,  66,  96,
    104, 66,  162, 37,  92,  67,  66,  96,  104, 66,  98,  70,  54,  96,  67,  66,  96,  104, 66,
    209, 130, 99,  67,  20,  46,  91,  66,  209, 130, 99,  67,  133, 235, 74,  66,  98,  209, 130,
    99,  67,  252, 169, 58,  66,  70,  54,  96,  67,  207, 119, 45,  66,  162, 37,  92,  67,  207,
    119, 45,  66,  99,  109, 39,  177, 7,   67,  207, 119, 45,  66,  108, 143, 162, 7,   67,  244,
    125, 45,  66,  108, 182, 147, 7,   67,  207, 119, 45,  66,  98,  150, 131, 3,   67,  207, 119,
    45,  66,  201, 54,  0,   67,  252, 169, 58,  66,  201, 54,  0,   67,  133, 235, 74,  66,  98,
    201, 54,  0,   67,  20,  46,  91,  66,  150, 131, 3,   67,  66,  96,  104, 66,  182, 147, 7,
    67,  66,  96,  104, 66,  108, 143, 162, 7,   67,  29,  90,  104, 66,  108, 39,  177, 7,   67,
    66,  96,  104, 66,  98,  203, 193, 11,  67,  66,  96,  104, 66,  86,  14,  15,  67,  20,  46,
    91,  66,  86,  14,  15,  67,  133, 235, 74,  66,  98,  86,  14,  15,  67,  252, 169, 58,  66,
    203, 193, 11,  67,  207, 119, 45,  66,  39,  177, 7,   67,  207, 119, 45,  66,  99,  109, 39,
    49,  237, 65,  207, 119, 45,  66,  98,  90,  100, 204, 65,  184, 30,  47,  66,  154, 153, 179,
    65,  63,  181, 57,  66,  174, 71,  178, 65,  133, 235, 74,  66,  98,  174, 71,  178, 65,  20,
    46,  91,  66,  252, 169, 204, 65,  66,  96,  104, 66,  39,  49,  237, 65,  66,  96,  104, 66,
    98,  29,  218, 6,   66,  66,  96,  104, 66,  74,  12,  20,  66,  20,  46,  91,  66,  74,  12,
    20,  66,  133, 235, 74,  66,  98,  92,  143, 18,  66,  33,  48,  60,  66,  12,  2,   11,  66,
    211, 77,  50,  66,  86,  14,  249, 65,  104, 17,  46,  66,  108, 39,  49,  237, 65,  207, 119,
    45,  66,  99,  109, 123, 148, 61,  67,  104, 17,  46,  66,  108, 213, 24,  60,  67,  207, 119,
    45,  66,  98,  115, 8,   56,  67,  207, 119, 45,  66,  231, 187, 52,  67,  252, 169, 58,  66,
    231, 187, 52,  67,  133, 235, 74,  66,  98,  231, 187, 52,  67,  20,  46,  91,  66,  115, 8,
    56,  67,  66,  96,  104, 66,  213, 24,  60,  67,  66,  96,  104, 66,  98,  121, 41,  64,  67,
    66,  96,  104, 66,  70,  118, 67,  67,  20,  46,  91,  66,  4,   118, 67,  67,  133, 235, 74,
    66,  98,  10,  23,  67,  67,  33,  48,  60,  66,  117, 51,  65,  67,  211, 77,  50,  66,  123,
    148, 61,  67,  104, 17,  46,  66,  99,  109, 45,  178, 54,  66,  147, 24,  141, 65,  108, 45,
    178, 54,  66,  147, 24,  141, 65,  98,  164, 112, 38,  66,  147, 24,  141, 65,  119, 62,  25,
    66,  238, 124, 167, 65,  113, 61,  25,  66,  0,   0,   200, 65,  98,  119, 62,  25,  66,  31,
    133, 232, 65,  164, 112, 38,  66,  188, 116, 1,   66,  45,  178, 54,  66,  188, 116, 1,   66,
    98,  182, 243, 70,  66,  188, 116, 1,   66,  227, 37,  84,  66,  31,  133, 232, 65,  227, 37,
    84,  66,  0,   0,   200, 65,  98,  227, 37,  84,  66,  238, 124, 167, 65,  182, 243, 70,  66,
    147, 24,  141, 65,  45,  178, 54,  66,  147, 24,  141, 65,  99,  101, 0,   0
};

static const unsigned char WaveformPathData[] = {
    110, 109, 135, 86,  64,  67,  242, 114, 59,  67,  108, 135, 86,  64,  67,  254, 212, 177, 67,
    108, 223, 111, 52,  67,  254, 212, 177, 67,  108, 223, 111, 52,  67,  242, 114, 59,  67,  108,
    135, 86,  64,  67,  242, 114, 59,  67,  99,  109, 68,  43,  141, 67,  100, 251, 74,  67,  108,
    16,  56,  135, 67,  100, 251, 74,  67,  108, 16,  56,  135, 67,  197, 16,  170, 67,  108, 68,
    43,  141, 67,  197, 16,  170, 67,  108, 68,  43,  141, 67,  100, 251, 74,  67,  99,  109, 135,
    86,  124, 67,  119, 222, 96,  67,  108, 223, 111, 112, 67,  119, 222, 96,  67,  108, 223, 111,
    112, 67,  59,  31,  159, 67,  108, 135, 86,  124, 67,  59,  31,  159, 67,  108, 135, 86,  124,
    67,  119, 222, 96,  67,  99,  109, 135, 86,  34,  67,  225, 26,  101, 67,  108, 223, 111, 22,
    67,  225, 26,  101, 67,  108, 223, 111, 22,  67,  6,   1,   157, 67,  108, 135, 86,  34,  67,
    6,   1,   157, 67,  108, 135, 86,  34,  67,  225, 26,  101, 67,  99,  109, 68,  43,  156, 67,
    250, 222, 108, 67,  108, 16,  56,  150, 67,  250, 222, 108, 67,  108, 16,  56,  150, 67,  217,
    30,  153, 67,  108, 68,  43,  156, 67,  217, 30,  153, 67,  108, 68,  43,  156, 67,  250, 222,
    108, 67,  99,  109, 135, 86,  94,  67,  205, 12,  118, 67,  108, 223, 111, 82,  67,  205, 12,
    118, 67,  108, 223, 111, 82,  67,  16,  136, 148, 67,  108, 135, 86,  94,  67,  16,  136, 148,
    67,  108, 135, 86,  94,  67,  205, 12,  118, 67,  99,  109, 135, 86,  4,   67,  41,  28,  125,
    67,  108, 66,  224, 240, 66,  41,  28,  125, 67,  108, 66,  224, 240, 66,  98,  0,   145, 67,
    108, 135, 86,  4,   67,  98,  0,   145, 67,  108, 135, 86,  4,   67,  41,  28,  125, 67,  99,
    109, 68,  43,  171, 67,  25,  52,  132, 67,  108, 16,  56,  165, 67,  25,  52,  132, 67,  108,
    16,  56,  165, 67,  94,  90,  139, 67,  108, 68,  43,  171, 67,  94,  90,  139, 67,  108, 68,
    43,  171, 67,  25,  52,  132, 67,  99,  109, 14,  173, 204, 66,  25,  52,  132, 67,  108, 190,
    223, 180, 66,  25,  52,  132, 67,  108, 190, 223, 180, 66,  94,  90,  139, 67,  108, 14,  173,
    204, 66,  94,  90,  139, 67,  108, 14,  173, 204, 66,  25,  52,  132, 67,  99,  101, 0,   0
};
