/*
 * Copyright (C) 2018-2020 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#pragma once
#include "../execution_model/device_enqueue.h"

// Uncomment this macro to build "empty" schedulers
//#define WA_DISABLE_SCHEDULERS 1

#define OCLRT_GPGPU_WALKER_CMD_DEVICE_CMD_G11 (15 * sizeof(uint))
#define OCLRT_PIPE_CONTROL_CMD_DEVICE_CMD_G11 (6 * sizeof(uint))

#define OCLRT_PIPE_CONTROL_CMD_DEVICE_CMD_G11_DWORD_OFFSET (6)
#define OCLRT_GPGPU_WALKER_CMD_DEVICE_CMD_G11_DWORD_OFFSET (15)

#define SLB_SPACE_FOR_EACH_ENQUEUE_UNALIGNED_GEN11 (OCLRT_SIZEOF_MEDIA_STATE_FLUSH + OCLRT_SIZEOF_MEDIA_INTERFACE_DESCRIPTOR_LOAD_DEVICE_CMD + OCLRT_PIPE_CONTROL_CMD_DEVICE_CMD_G11 + OCLRT_GPGPU_WALKER_CMD_DEVICE_CMD_G11 + OCLRT_SIZEOF_MEDIA_STATE_FLUSH + OCLRT_PIPE_CONTROL_CMD_DEVICE_CMD_G11)
#define SLB_SIZE_ALIGNEMENT_WA_GEN11 52

#define SECOND_LEVEL_BUFFER_SPACE_FOR_EACH_ENQUEUE_GEN11 (SLB_SPACE_FOR_EACH_ENQUEUE_UNALIGNED_GEN11 + SLB_SIZE_ALIGNEMENT_WA_GEN11 + CS_PREFETCH_SIZE)

#define SECOND_LEVEL_BUFFER_NUMBER_OF_ENQUEUES_GEN11 (128)
