/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DataType;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DataTypes {
    private static DataType[] dataTypeDescription;
    static final int tds71CharDataExtrasLen = 5;
    static final int SHORT_VARTYPE_MAX_CHARS = 4000;
    static final int SHORT_VARTYPE_MAX_BYTES = 8000;
    static final int NTEXT_MAX_CHARS = 0x3FFFFFFF;
    static final int IMAGE_TEXT_MAX_BYTES = Integer.MAX_VALUE;
    static final int MAX_VARTYPE_MAX_CHARS = 0x3FFFFFFD;
    static final int MAX_VARTYPE_MAX_BYTES = 0x7FFFFFFD;
    private static Logger stmtDT;
    static final int UNKNOWN_NATIVE_TYPE = 0;
    static final int UNKNOWN_JDBC_TYPE = 999;
    static final int TYPE_BIT1 = 50;
    static final int TYPE_INT8 = 127;
    static final int TYPE_INT4 = 56;
    static final int TYPE_INT2 = 52;
    static final int TYPE_INT1 = 48;
    static final int TYPE_FLOAT8 = 62;
    static final int TYPE_FLOAT4 = 59;
    static final int TYPE_DATETIME4 = 58;
    static final int TYPE_DATETIME8 = 61;
    static final int TYPE_MONEY4 = 122;
    static final int TYPE_MONEY8 = 60;
    static final int TYPE_BIT = 104;
    static final int TYPE_INT = 38;
    static final int TYPE_CHAR = 175;
    static final int TYPE_BINARY = 173;
    static final int TYPE_IMAGE = 34;
    static final int TYPE_TEXT = 35;
    static final int TYPE_DECIMAL = 106;
    static final int TYPE_NUMERIC = 108;
    static final int TYPE_MONEY = 110;
    static final int TYPE_FLOAT = 109;
    static final int TYPE_DATETIME = 111;
    static final int TYPE_NCHAR = 239;
    static final int TYPE_NVARCHAR = 231;
    static final int TYPE_GUID = 36;
    static final int TYPE_NTEXT = 99;
    static final int TYPE_VARCHAR = 167;
    static final int TYPE_VARBINARY = 165;
    static final int TYPE_TINYINT = 10;
    static final int TYPE_SMALLINT = 11;
    static final int TYPE_SMALLDATETIME = 12;
    static final int TYPE_SMALLMONEY = 14;
    static final int TYPE_REAL = 16;
    static final int TYPE_SQL_VARIANT = 98;
    static final int TYPE_UDT = 240;
    static final int TYPE_XML = 241;
    static final int MAXTYPE_LENGTH = 65535;
    static final int CLASS_COMPLEX = 0;
    static final int CLASS_NUMERIC = 1;
    static final int CLASS_TEMPORAL = 2;
    static final int CLASS_TEXTUAL = 3;
    static final int CLASS_BINARY = 4;
    static final boolean[][] classConverts;
    static final int USER_TYPE_UTCDATETIME = 80;
    private static final String timeStamp = "timestamp";

    DataTypes() {
    }

    static void fillTypes() {
        int n = 256;
        int n2 = 4;
        dataTypeDescription = new DataType[n];
        int[] nArray = new int[]{4};
        DataTypes.dataTypeDescription[38] = new DataType("int", "int", "java.lang.Integer", nArray, new Integer(4), 1);
        int[] nArray2 = new int[]{-6};
        DataTypes.dataTypeDescription[10] = new DataType("tinyint", "tinyint", "java.lang.Short", nArray2, new Integer(-6), 1);
        int[] nArray3 = new int[]{5};
        DataTypes.dataTypeDescription[11] = new DataType("smallint", "smallint", "java.lang.Short", nArray3, new Integer(5), 1);
        int[] nArray4 = new int[]{-4, 2004};
        DataTypes.dataTypeDescription[34] = new DataType("longvarbinary", "image", "[B", nArray4, new Integer(-4), 4);
        DataTypes.dataTypeDescription[34].bSearchable = false;
        int[] nArray5 = new int[]{-1, 2005};
        DataTypes.dataTypeDescription[35] = new DataType("longvarchar", "text", "java.lang.String", nArray5, new Integer(-1), 3);
        DataTypes.dataTypeDescription[35].bSearchable = false;
        int[] nArray6 = new int[]{-1, 2005};
        DataTypes.dataTypeDescription[99] = new DataType("longvarchar", "ntext", "java.lang.String", nArray6, null, 3);
        DataTypes.dataTypeDescription[99].bSearchable = false;
        int[] nArray7 = new int[]{1};
        DataTypes.dataTypeDescription[175] = new DataType("char", "char", "java.lang.String", nArray7, new Integer(1), 3);
        int[] nArray8 = new int[]{12, 2005};
        DataTypes.dataTypeDescription[167] = new DataType("varchar", "varchar", "java.lang.String", nArray8, new Integer(12), 3);
        int[] nArray9 = new int[]{1};
        DataTypes.dataTypeDescription[239] = new DataType("char", "nchar", "java.lang.String", nArray9, null, 3);
        int[] nArray10 = new int[]{12, 2005};
        DataTypes.dataTypeDescription[231] = new DataType("varchar", "nvarchar", "java.lang.String", nArray10, null, 3);
        int[] nArray11 = new int[]{-2};
        DataTypes.dataTypeDescription[173] = new DataType("binary", "binary", "[B", nArray11, new Integer(-2), 4);
        int[] nArray12 = new int[]{-3, 2004};
        DataTypes.dataTypeDescription[165] = new DataType("varbinary", "varbinary", "[B", nArray12, new Integer(-3), 4);
        int[] nArray13 = new int[]{-7};
        DataTypes.dataTypeDescription[104] = new DataType("bit", "bit", "java.lang.Boolean", nArray13, new Integer(-7), 1);
        int[] nArray14 = new int[]{7};
        DataTypes.dataTypeDescription[16] = new DataType("real", "real", "java.lang.Float", nArray14, new Integer(7), 1);
        int[] nArray15 = new int[]{93};
        DataTypes.dataTypeDescription[111] = new DataType(timeStamp, "datetime", "java.sql.Timestamp", nArray15, new Integer(93), 2);
        DataTypes.dataTypeDescription[12] = new DataType(timeStamp, "smalldatetime", "java.sql.Timestamp", nArray15, null, 2);
        int[] nArray16 = new int[]{3};
        DataTypes.dataTypeDescription[106] = new DataType("decimal", "decimal", "java.math.BigDecimal", nArray16, new Integer(3), 1);
        int[] nArray17 = new int[]{3};
        DataTypes.dataTypeDescription[110] = new DataType("decimal", "money", "java.math.BigDecimal", nArray17, null, 1);
        int[] nArray18 = new int[]{2};
        DataTypes.dataTypeDescription[108] = new DataType("numeric", "numeric", "java.math.BigDecimal", nArray18, new Integer(2), 1);
        int[] nArray19 = new int[]{8};
        DataTypes.dataTypeDescription[109] = new DataType("float", "float", "java.lang.Double", nArray19, new Integer(8), 1);
        DataTypes.dataTypeDescription[14] = new DataType("decimal", "smallmoney", "java.math.BigDecimal", nArray17, null, 1);
        int[] nArray20 = new int[]{1};
        DataTypes.dataTypeDescription[36] = new DataType("binary", "uniqueidentifier", "java.lang.String", nArray20, null, 4);
        int[] nArray21 = new int[]{-3};
        DataTypes.dataTypeDescription[240] = new DataType("binary", "UDT", "[B", nArray21, null, 4);
        DataTypes.dataTypeDescription[240].bSearchable = false;
        int[] nArray22 = new int[]{-1, 1, 2005, -2, -4, 2004};
        DataTypes.dataTypeDescription[241] = new DataType("longvarchar", "xml", "java.lang.String", nArray22, null, 0);
        DataTypes.dataTypeDescription[241].bSearchable = false;
        int[] nArray23 = new int[]{-5};
        DataTypes.dataTypeDescription[DataTypes.dataTypeDescription.length - 1] = new DataType("bigint", "bigint", "java.lang.Long", nArray23, new Integer(-5), 1);
    }

    static final boolean canConvertFromNativeTypeToJDBCType(int n, int n2, int n3) {
        DataType dataType = DataTypes.getDataType(n, n2);
        if (classConverts[dataType.typeClass][DataTypes.getUserTypeClass(n3)]) {
            return true;
        }
        for (int i = 0; i < dataType.jdbcTypes.length; ++i) {
            if (n3 != dataType.jdbcTypes[i]) continue;
            return true;
        }
        return false;
    }

    static final int getUserTypeClass(int n) {
        switch (n) {
            case -5: {
                return 1;
            }
            case -2: {
                return 4;
            }
            case -7: {
                return 1;
            }
            case 2004: {
                return 0;
            }
            case 16: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 2005: {
                return 0;
            }
            case 91: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 8: {
                return 1;
            }
            case 6: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case -4: {
                return 4;
            }
            case -1: {
                return 3;
            }
            case 2: {
                return 1;
            }
            case 7: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 92: {
                return 2;
            }
            case 93: {
                return 2;
            }
            case -6: {
                return 1;
            }
            case -3: {
                return 4;
            }
            case 12: {
                return 3;
            }
        }
        return 0;
    }

    static final int getObjectJDBCType(Object object, int n) throws SQLServerException {
        int n2 = String.class.isInstance(object) ? 1 : (Clob.class.isInstance(object) ? 2005 : (Byte.class.isInstance(object) ? -6 : (Integer.class.isInstance(object) ? 4 : (Time.class.isInstance(object) ? 92 : (Date.class.isInstance(object) ? 91 : (Timestamp.class.isInstance(object) ? 93 : (Float.class.isInstance(object) ? 7 : (Double.class.isInstance(object) ? 8 : (BigDecimal.class.isInstance(object) ? 3 : (Long.class.isInstance(object) ? -5 : (Short.class.isInstance(object) ? 5 : (Boolean.class.isInstance(object) ? -7 : ([B.class.isInstance(object) ? -2 : (Blob.class.isInstance(object) ? 2004 : (InputStream.class.isInstance(object) ? (1 == n || 12 == n || -1 == n ? n : -2) : (Reader.class.isInstance(object) ? -1 : n))))))))))))))));
        return n2;
    }

    static final boolean canConvertFromJDBCTypeToJDBCType(int n, int n2) {
        if (n == n2) {
            return true;
        }
        int n3 = dataTypeDescription.length;
        DataType dataType = null;
        switch (n2) {
            case 6: {
                n2 = 8;
                break;
            }
            case 2005: {
                n2 = -1;
                break;
            }
            case 2004: {
                n2 = -4;
            }
        }
        if (classConverts[DataTypes.getUserTypeClass(n2)][DataTypes.getUserTypeClass(n)]) {
            return true;
        }
        for (int i = 0; i < n3; ++i) {
            if (null == dataTypeDescription[i] || null == DataTypes.dataTypeDescription[i].conversionJDBCType || DataTypes.dataTypeDescription[i].conversionJDBCType != n2) continue;
            dataType = dataTypeDescription[i];
            break;
        }
        if (null == dataType) {
            return false;
        }
        for (n3 = 0; n3 < dataType.jdbcTypes.length; ++n3) {
            if (n != dataType.jdbcTypes[n3]) continue;
            return true;
        }
        return false;
    }

    static final boolean canConvertToNativeTypeFromJDBCType(int n, int n2, int n3) {
        DataType dataType = DataTypes.getDataType(n, n2);
        if (classConverts[dataType.typeClass][DataTypes.getUserTypeClass(n3)]) {
            return true;
        }
        for (int i = 0; i < dataType.jdbcTypes.length; ++i) {
            if (n3 != dataType.jdbcTypes[i]) continue;
            return true;
        }
        return false;
    }

    static final boolean canConvertFromNativeTypeToAsciiStream(TypeInfo typeInfo) {
        int n = typeInfo.getNativeType();
        if (36 == n || 240 == n) {
            return false;
        }
        if (173 == n && 80 == typeInfo.getTDSType()) {
            return false;
        }
        DataType dataType = DataTypes.getDataType(n, typeInfo.getMaxLength());
        return 3 == dataType.typeClass || 4 == dataType.typeClass;
    }

    static final boolean canConvertFromNativeTypeToBinaryStream(TypeInfo typeInfo) {
        int n = typeInfo.getNativeType();
        if (165 == n || 34 == n || 241 == n || 240 == n) {
            return true;
        }
        if (173 == n) {
            return 80 != typeInfo.getTDSType();
        }
        return false;
    }

    static final boolean canConvertFromNativeTypeToCharStream(TypeInfo typeInfo) {
        int n = typeInfo.getNativeType();
        if (36 == n || 240 == n) {
            return false;
        }
        if (241 == n) {
            return true;
        }
        if (173 == n && 80 == typeInfo.getTDSType()) {
            return false;
        }
        DataType dataType = DataTypes.getDataType(n, typeInfo.getMaxLength());
        return 3 == dataType.typeClass || 4 == dataType.typeClass;
    }

    static DataType getDataType(int n, int n2) {
        DataType dataType;
        if (n == 38 && n2 == 8) {
            n = dataTypeDescription.length - 1;
        }
        if ((dataType = dataTypeDescription[n]) != null) {
            return dataType;
        }
        return new DataType();
    }

    static String getDataTypeSQLServerName(int n, int n2, int n3) {
        DataType dataType;
        if (n == 38 && n2 == 8) {
            n = dataTypeDescription.length - 1;
        }
        if ((dataType = dataTypeDescription[n]) != null) {
            if (173 == n && 80 == n3) {
                return timeStamp;
            }
            return dataType.sTypeNameSQLServer;
        }
        if (stmtDT.isLoggable(Level.INFO)) {
            stmtDT.info("Type not found" + n);
        }
        return new String("");
    }

    static int dataTypeFromJDBCType(int n) {
        if (6 == n) {
            n = 8;
        }
        int n2 = dataTypeDescription.length;
        for (int i = 0; i < n2; ++i) {
            if (dataTypeDescription[i] == null || DataTypes.dataTypeDescription[i].jdbcTypes[0] != n) continue;
            return i;
        }
        return 0;
    }

    static String classNameFromJDBCType(int n) {
        if (6 == n) {
            n = 8;
        }
        int n2 = dataTypeDescription.length;
        for (int i = 0; i < n2; ++i) {
            if (dataTypeDescription[i] == null || DataTypes.dataTypeDescription[i].jdbcTypes[0] != n) continue;
            return DataTypes.dataTypeDescription[i].sClassName;
        }
        return "";
    }

    static int deriveType(int n, int n2) {
        if (n == 56) {
            return 38;
        }
        if (n == 127) {
            return 38;
        }
        if (n == 52) {
            return 11;
        }
        if (n == 48) {
            return 10;
        }
        if (n == 58) {
            return 12;
        }
        if (n == 61) {
            return 111;
        }
        if (n == 122) {
            return 14;
        }
        if (n == 60) {
            return 110;
        }
        if (n == 59) {
            return 16;
        }
        if (n == 62) {
            return 109;
        }
        if (n == 50) {
            return 104;
        }
        if (n == 38) {
            if (n2 == 1) {
                return 10;
            }
            if (n2 == 2) {
                return 11;
            }
        }
        if (n == 111 && n2 == 4) {
            return 12;
        }
        if (n == 110 && n2 == 4) {
            return 14;
        }
        if (n == 109 && n2 == 4) {
            return 16;
        }
        return n;
    }

    static String sqlNativeTypeToString(int n) {
        switch (n) {
            case 10: {
                return "tinyint";
            }
            case 11: {
                return "smallint";
            }
            case 16: {
                return "real";
            }
            case 12: {
                return "smalldatetime";
            }
            case 127: {
                return "int";
            }
            case 56: {
                return "int";
            }
            case 52: {
                return "int";
            }
            case 48: {
                return "int";
            }
            case 58: {
                return "datetime";
            }
            case 61: {
                return "datetime";
            }
            case 62: {
                return "float";
            }
            case 59: {
                return "float";
            }
            case 60: {
                return "money";
            }
            case 122: {
                return "money";
            }
            case 104: {
                return "bit";
            }
            case 38: {
                return "int";
            }
            case 14: {
                return "smallmoney";
            }
            case 110: {
                return "money";
            }
            case 167: {
                return "varchar";
            }
            case 109: {
                return "float";
            }
            case 111: {
                return "datetime";
            }
            case 35: {
                return "text";
            }
            case 99: {
                return "ntext";
            }
            case 175: {
                return "char";
            }
            case 34: {
                return "image";
            }
            case 165: {
                return "varbinary";
            }
            case 173: {
                return "binary";
            }
            case 106: {
                return "decimal";
            }
            case 108: {
                return "numeric";
            }
            case 239: {
                return "nchar";
            }
            case 231: {
                return "varchar";
            }
            case 36: {
                return "uniqueidentifier";
            }
            case 98: {
                return "sql_variant";
            }
            case 240: {
                return "udt";
            }
            case 241: {
                return "xml";
            }
        }
        return "unknown " + n;
    }

    static int getStreamLengthSize(int n) {
        switch (n) {
            case 240: 
            case 241: {
                return 0;
            }
            case 34: 
            case 35: 
            case 99: {
                return 4;
            }
            case 98: 
            case 165: 
            case 167: 
            case 173: 
            case 175: 
            case 231: 
            case 239: {
                return 2;
            }
        }
        return 1;
    }

    static int getStreamByteLength(int n) {
        switch (n) {
            case 127: {
                return 8;
            }
            case 56: {
                return 4;
            }
            case 52: {
                return 2;
            }
            case 48: {
                return 1;
            }
            case 104: {
                return 1;
            }
            case 50: {
                return 1;
            }
            case 62: 
            case 109: {
                return 8;
            }
            case 59: {
                return 4;
            }
            case 58: {
                return 4;
            }
            case 61: 
            case 111: {
                return 8;
            }
            case 122: {
                return 4;
            }
            case 60: 
            case 110: {
                return 8;
            }
            case 14: {
                return 4;
            }
        }
        return 0;
    }

    static int nativeTypeToJdbcType(SQLServerConnection sQLServerConnection, int n, int n2) throws SQLServerException {
        DataType dataType = DataTypes.getDataType(n, n2);
        if (dataType == null) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unknownNativeType"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(sQLServerConnection, null, messageFormat.format(objectArray), null, true);
        }
        if (65535 == n2) {
            switch (dataType.jdbcTypes[0]) {
                case 12: {
                    return -1;
                }
                case -3: {
                    return -4;
                }
            }
        }
        return dataType.jdbcTypes[0];
    }

    static boolean isSigned(int n) {
        if (dataTypeDescription.length - 1 == n) {
            return true;
        }
        switch (n) {
            case 38: {
                return true;
            }
            case 127: {
                return true;
            }
            case 11: {
                return true;
            }
            case 16: {
                return true;
            }
            case 109: {
                return true;
            }
            case 106: {
                return true;
            }
            case 108: {
                return true;
            }
            case 110: {
                return true;
            }
            case 14: {
                return true;
            }
        }
        return false;
    }

    static boolean isBinary(int n) {
        switch (n) {
            case 173: {
                return true;
            }
            case 165: {
                return true;
            }
            case 34: {
                return true;
            }
            case 36: {
                return true;
            }
            case 240: {
                return true;
            }
        }
        return false;
    }

    static boolean isNonUnicode(int n) {
        switch (n) {
            case 35: 
            case 167: 
            case 175: {
                return true;
            }
        }
        return false;
    }

    static boolean isTemporal(int n) {
        switch (n) {
            case 12: 
            case 111: {
                return true;
            }
        }
        return false;
    }

    static boolean isBinaryJDBCType(int n) {
        switch (n) {
            case -2: {
                return true;
            }
            case -3: {
                return true;
            }
            case -4: {
                return true;
            }
        }
        return false;
    }

    static boolean isUnsupportedJDBCType(int n) {
        return 2000 == n || 1111 == n || 2006 == n || 2002 == n;
    }

    static boolean isFixedLength(SQLServerConnection sQLServerConnection, int n) throws SQLServerException {
        switch (n) {
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 48: 
            case 50: 
            case 52: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 122: 
            case 127: {
                return true;
            }
            case 14: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 98: 
            case 99: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 165: 
            case 167: 
            case 173: 
            case 175: 
            case 231: 
            case 239: 
            case 240: 
            case 241: {
                return false;
            }
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unrecognizedColumnType"));
        Object[] objectArray = new Object[]{new Integer(n)};
        SQLServerException.makeFromDriverError(sQLServerConnection, null, messageFormat.format(objectArray), null, true);
        return false;
    }

    static {
        classConverts = new boolean[][]{{false, false, false, false, false}, {false, true, false, true, true}, {false, false, true, true, true}, {false, true, true, true, true}, {false, false, false, true, true}};
        stmtDT = Logger.getLogger("com.microsoft.sqlserver.jdbc.DataTypes");
        if (dataTypeDescription == null) {
            DataTypes.fillTypes();
        }
    }
}

