
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCameraImageCapture.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCameraImageCapture>
#include <QChildEvent>
#include <QEvent>
#include <QImage>
#include <QImageEncoderSettings>
#include <QMediaObject>
#include <QMetaMethod>
#include <QObject>
#include <QSize>
#include <QThread>
#include <QTimerEvent>
#include <QVideoFrame>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCameraImageCapture

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCameraImageCapture::staticMetaObject);
}


// QMultimedia::AvailabilityStatus QCameraImageCapture::availability()


static void _init_f_availability_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ();
}

static void _call_f_availability_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ((qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type)qt_gsi::CppToQtAdaptor<QMultimedia::AvailabilityStatus>(((QCameraImageCapture *)cls)->availability ()));
}


// QVideoFrame::PixelFormat QCameraImageCapture::bufferFormat()


static void _init_f_bufferFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type > ();
}

static void _call_f_bufferFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type > ((qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type)qt_gsi::CppToQtAdaptor<QVideoFrame::PixelFormat>(((QCameraImageCapture *)cls)->bufferFormat ()));
}


// void QCameraImageCapture::bufferFormatChanged(QVideoFrame::PixelFormat)


static void _init_f_bufferFormatChanged_2758 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_bufferFormatChanged_2758 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture *)cls)->bufferFormatChanged (qt_gsi::QtToCppAdaptor<QVideoFrame::PixelFormat>(arg1).cref());
}


// void QCameraImageCapture::cancelCapture()


static void _init_f_cancelCapture_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_cancelCapture_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture *)cls)->cancelCapture ();
}


// int QCameraImageCapture::capture(const QString &location)


static void _init_f_capture_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("location", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_capture_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<int > ((int)((QCameraImageCapture *)cls)->capture (arg1));
}


// QFlags<QCameraImageCapture::CaptureDestination> QCameraImageCapture::captureDestination()


static void _init_f_captureDestination_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QCameraImageCapture::CaptureDestination> > ();
}

static void _call_f_captureDestination_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QCameraImageCapture::CaptureDestination> > ((QFlags<QCameraImageCapture::CaptureDestination>)((QCameraImageCapture *)cls)->captureDestination ());
}


// void QCameraImageCapture::captureDestinationChanged(QFlags<QCameraImageCapture::CaptureDestination>)


static void _init_f_captureDestinationChanged_4999 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFlags<QCameraImageCapture::CaptureDestination> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_captureDestinationChanged_4999 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCameraImageCapture::CaptureDestination> arg1 = gsi::arg_reader<QFlags<QCameraImageCapture::CaptureDestination> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture *)cls)->captureDestinationChanged (arg1);
}


// QImageEncoderSettings QCameraImageCapture::encodingSettings()


static void _init_f_encodingSettings_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QImageEncoderSettings > ();
}

static void _call_f_encodingSettings_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QImageEncoderSettings > ((QImageEncoderSettings)((QCameraImageCapture *)cls)->encodingSettings ());
}


// QCameraImageCapture::Error QCameraImageCapture::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCameraImageCapture::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCameraImageCapture::Error>::target_type > ((qt_gsi::Converter<QCameraImageCapture::Error>::target_type)qt_gsi::CppToQtAdaptor<QCameraImageCapture::Error>(((QCameraImageCapture *)cls)->error ()));
}


// void QCameraImageCapture::error(int id, QCameraImageCapture::Error error, const QString &errorString)


static void _init_f_error_5523 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("error");
  decl->add_arg<const qt_gsi::Converter<QCameraImageCapture::Error>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("errorString");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_error_5523 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QCameraImageCapture::Error>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QCameraImageCapture::Error>::target_type & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture *)cls)->error (arg1, qt_gsi::QtToCppAdaptor<QCameraImageCapture::Error>(arg2).cref(), arg3);
}


// QString QCameraImageCapture::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QCameraImageCapture *)cls)->errorString ());
}


// void QCameraImageCapture::imageAvailable(int id, const QVideoFrame &image)


static void _init_f_imageAvailable_3047 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("image");
  decl->add_arg<const QVideoFrame & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_imageAvailable_3047 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QVideoFrame &arg2 = gsi::arg_reader<const QVideoFrame & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture *)cls)->imageAvailable (arg1, arg2);
}


// void QCameraImageCapture::imageCaptured(int id, const QImage &preview)


static void _init_f_imageCaptured_2536 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("preview");
  decl->add_arg<const QImage & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_imageCaptured_2536 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QImage &arg2 = gsi::arg_reader<const QImage & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture *)cls)->imageCaptured (arg1, arg2);
}


// QString QCameraImageCapture::imageCodecDescription(const QString &codecName)


static void _init_f_imageCodecDescription_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("codecName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_imageCodecDescription_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)((QCameraImageCapture *)cls)->imageCodecDescription (arg1));
}


// void QCameraImageCapture::imageExposed(int id)


static void _init_f_imageExposed_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_imageExposed_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture *)cls)->imageExposed (arg1);
}


// void QCameraImageCapture::imageMetadataAvailable(int id, const QString &key, const QVariant &value)


static void _init_f_imageMetadataAvailable_4695 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("key");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_imageMetadataAvailable_4695 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QVariant &arg3 = gsi::arg_reader<const QVariant & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture *)cls)->imageMetadataAvailable (arg1, arg2, arg3);
}


// void QCameraImageCapture::imageSaved(int id, const QString &fileName)


static void _init_f_imageSaved_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("fileName");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_imageSaved_2684 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture *)cls)->imageSaved (arg1, arg2);
}


// bool QCameraImageCapture::isAvailable()


static void _init_f_isAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCameraImageCapture *)cls)->isAvailable ());
}


// bool QCameraImageCapture::isCaptureDestinationSupported(QFlags<QCameraImageCapture::CaptureDestination> destination)


static void _init_f_isCaptureDestinationSupported_c4999 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destination");
  decl->add_arg<QFlags<QCameraImageCapture::CaptureDestination> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isCaptureDestinationSupported_c4999 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCameraImageCapture::CaptureDestination> arg1 = gsi::arg_reader<QFlags<QCameraImageCapture::CaptureDestination> >() (args, heap);
  ret.write<bool > ((bool)((QCameraImageCapture *)cls)->isCaptureDestinationSupported (arg1));
}


// bool QCameraImageCapture::isReadyForCapture()


static void _init_f_isReadyForCapture_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isReadyForCapture_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCameraImageCapture *)cls)->isReadyForCapture ());
}


// QMediaObject *QCameraImageCapture::mediaObject()


static void _init_f_mediaObject_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaObject * > ();
}

static void _call_f_mediaObject_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaObject * > ((QMediaObject *)((QCameraImageCapture *)cls)->mediaObject ());
}


// void QCameraImageCapture::readyForCaptureChanged(bool)


static void _init_f_readyForCaptureChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_readyForCaptureChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture *)cls)->readyForCaptureChanged (arg1);
}


// void QCameraImageCapture::setBufferFormat(const QVideoFrame::PixelFormat format)


static void _init_f_setBufferFormat_3453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBufferFormat_3453 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QVideoFrame::PixelFormat>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture *)cls)->setBufferFormat (qt_gsi::QtToCppAdaptor<QVideoFrame::PixelFormat>(arg1).cref());
}


// void QCameraImageCapture::setCaptureDestination(QFlags<QCameraImageCapture::CaptureDestination> destination)


static void _init_f_setCaptureDestination_4999 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destination");
  decl->add_arg<QFlags<QCameraImageCapture::CaptureDestination> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCaptureDestination_4999 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCameraImageCapture::CaptureDestination> arg1 = gsi::arg_reader<QFlags<QCameraImageCapture::CaptureDestination> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture *)cls)->setCaptureDestination (arg1);
}


// void QCameraImageCapture::setEncodingSettings(const QImageEncoderSettings &settings)


static void _init_f_setEncodingSettings_3430 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("settings");
  decl->add_arg<const QImageEncoderSettings & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodingSettings_3430 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QImageEncoderSettings &arg1 = gsi::arg_reader<const QImageEncoderSettings & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture *)cls)->setEncodingSettings (arg1);
}


// QList<QVideoFrame::PixelFormat> QCameraImageCapture::supportedBufferFormats()


static void _init_f_supportedBufferFormats_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QVideoFrame::PixelFormat> > ();
}

static void _call_f_supportedBufferFormats_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QVideoFrame::PixelFormat> > ((QList<QVideoFrame::PixelFormat>)((QCameraImageCapture *)cls)->supportedBufferFormats ());
}


// QStringList QCameraImageCapture::supportedImageCodecs()


static void _init_f_supportedImageCodecs_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_supportedImageCodecs_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QCameraImageCapture *)cls)->supportedImageCodecs ());
}


// QList<QSize> QCameraImageCapture::supportedResolutions(const QImageEncoderSettings &settings, bool *continuous)


static void _init_f_supportedResolutions_c4372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("settings", true, "QImageEncoderSettings()");
  decl->add_arg<const QImageEncoderSettings & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("continuous", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<QList<QSize> > ();
}

static void _call_f_supportedResolutions_c4372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QImageEncoderSettings &arg1 = args ? gsi::arg_reader<const QImageEncoderSettings & >() (args, heap) : gsi::arg_maker<const QImageEncoderSettings & >() (QImageEncoderSettings(), heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<QList<QSize> > ((QList<QSize>)((QCameraImageCapture *)cls)->supportedResolutions (arg1, arg2));
}


// static QString QCameraImageCapture::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraImageCapture::tr (arg1, arg2, arg3));
}


// static QString QCameraImageCapture::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraImageCapture::trUtf8 (arg1, arg2, arg3));
}


//  base class cast for QObject

static void _init_f_QCameraImageCapture_as_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject *> ();
}

static void _call_f_QCameraImageCapture_as_QObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QObject *> ((QObject *)(QCameraImageCapture *)cls);
}

static void _init_f_QCameraImageCapture_as_const_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QObject *> ();
}

static void _call_f_QCameraImageCapture_as_const_QObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QObject *> ((const QObject *)(const QCameraImageCapture *)cls);
}

//  base class cast for QMediaBindableInterface

static void _init_f_QCameraImageCapture_as_QMediaBindableInterface (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaBindableInterface *> ();
}

static void _call_f_QCameraImageCapture_as_QMediaBindableInterface (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QMediaBindableInterface *> ((QMediaBindableInterface *)(QCameraImageCapture *)cls);
}

static void _init_f_QCameraImageCapture_as_const_QMediaBindableInterface (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QMediaBindableInterface *> ();
}

static void _call_f_QCameraImageCapture_as_const_QMediaBindableInterface (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMediaBindableInterface *> ((const QMediaBindableInterface *)(const QCameraImageCapture *)cls);
}


namespace gsi
{

static gsi::Methods methods_QCameraImageCapture () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("availability", "@brief Method QMultimedia::AvailabilityStatus QCameraImageCapture::availability()\n", true, &_init_f_availability_c0, &_call_f_availability_c0);
  methods += new qt_gsi::GenericMethod (":bufferFormat", "@brief Method QVideoFrame::PixelFormat QCameraImageCapture::bufferFormat()\n", true, &_init_f_bufferFormat_c0, &_call_f_bufferFormat_c0);
  methods += new qt_gsi::GenericMethod ("bufferFormatChanged", "@brief Method void QCameraImageCapture::bufferFormatChanged(QVideoFrame::PixelFormat)\n", false, &_init_f_bufferFormatChanged_2758, &_call_f_bufferFormatChanged_2758);
  methods += new qt_gsi::GenericMethod ("cancelCapture", "@brief Method void QCameraImageCapture::cancelCapture()\n", false, &_init_f_cancelCapture_0, &_call_f_cancelCapture_0);
  methods += new qt_gsi::GenericMethod ("capture", "@brief Method int QCameraImageCapture::capture(const QString &location)\n", false, &_init_f_capture_2025, &_call_f_capture_2025);
  methods += new qt_gsi::GenericMethod (":captureDestination", "@brief Method QFlags<QCameraImageCapture::CaptureDestination> QCameraImageCapture::captureDestination()\n", true, &_init_f_captureDestination_c0, &_call_f_captureDestination_c0);
  methods += new qt_gsi::GenericMethod ("captureDestinationChanged", "@brief Method void QCameraImageCapture::captureDestinationChanged(QFlags<QCameraImageCapture::CaptureDestination>)\n", false, &_init_f_captureDestinationChanged_4999, &_call_f_captureDestinationChanged_4999);
  methods += new qt_gsi::GenericMethod (":encodingSettings", "@brief Method QImageEncoderSettings QCameraImageCapture::encodingSettings()\n", true, &_init_f_encodingSettings_c0, &_call_f_encodingSettings_c0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QCameraImageCapture::Error QCameraImageCapture::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("error_sig", "@brief Method void QCameraImageCapture::error(int id, QCameraImageCapture::Error error, const QString &errorString)\n", false, &_init_f_error_5523, &_call_f_error_5523);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QCameraImageCapture::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("imageAvailable", "@brief Method void QCameraImageCapture::imageAvailable(int id, const QVideoFrame &image)\n", false, &_init_f_imageAvailable_3047, &_call_f_imageAvailable_3047);
  methods += new qt_gsi::GenericMethod ("imageCaptured", "@brief Method void QCameraImageCapture::imageCaptured(int id, const QImage &preview)\n", false, &_init_f_imageCaptured_2536, &_call_f_imageCaptured_2536);
  methods += new qt_gsi::GenericMethod ("imageCodecDescription", "@brief Method QString QCameraImageCapture::imageCodecDescription(const QString &codecName)\n", true, &_init_f_imageCodecDescription_c2025, &_call_f_imageCodecDescription_c2025);
  methods += new qt_gsi::GenericMethod ("imageExposed", "@brief Method void QCameraImageCapture::imageExposed(int id)\n", false, &_init_f_imageExposed_767, &_call_f_imageExposed_767);
  methods += new qt_gsi::GenericMethod ("imageMetadataAvailable", "@brief Method void QCameraImageCapture::imageMetadataAvailable(int id, const QString &key, const QVariant &value)\n", false, &_init_f_imageMetadataAvailable_4695, &_call_f_imageMetadataAvailable_4695);
  methods += new qt_gsi::GenericMethod ("imageSaved", "@brief Method void QCameraImageCapture::imageSaved(int id, const QString &fileName)\n", false, &_init_f_imageSaved_2684, &_call_f_imageSaved_2684);
  methods += new qt_gsi::GenericMethod ("isAvailable?", "@brief Method bool QCameraImageCapture::isAvailable()\n", true, &_init_f_isAvailable_c0, &_call_f_isAvailable_c0);
  methods += new qt_gsi::GenericMethod ("isCaptureDestinationSupported?", "@brief Method bool QCameraImageCapture::isCaptureDestinationSupported(QFlags<QCameraImageCapture::CaptureDestination> destination)\n", true, &_init_f_isCaptureDestinationSupported_c4999, &_call_f_isCaptureDestinationSupported_c4999);
  methods += new qt_gsi::GenericMethod ("isReadyForCapture?|:readyForCapture", "@brief Method bool QCameraImageCapture::isReadyForCapture()\n", true, &_init_f_isReadyForCapture_c0, &_call_f_isReadyForCapture_c0);
  methods += new qt_gsi::GenericMethod ("mediaObject", "@brief Method QMediaObject *QCameraImageCapture::mediaObject()\nThis is a reimplementation of QMediaBindableInterface::mediaObject", true, &_init_f_mediaObject_c0, &_call_f_mediaObject_c0);
  methods += new qt_gsi::GenericMethod ("readyForCaptureChanged", "@brief Method void QCameraImageCapture::readyForCaptureChanged(bool)\n", false, &_init_f_readyForCaptureChanged_864, &_call_f_readyForCaptureChanged_864);
  methods += new qt_gsi::GenericMethod ("setBufferFormat|bufferFormat=", "@brief Method void QCameraImageCapture::setBufferFormat(const QVideoFrame::PixelFormat format)\n", false, &_init_f_setBufferFormat_3453, &_call_f_setBufferFormat_3453);
  methods += new qt_gsi::GenericMethod ("setCaptureDestination|captureDestination=", "@brief Method void QCameraImageCapture::setCaptureDestination(QFlags<QCameraImageCapture::CaptureDestination> destination)\n", false, &_init_f_setCaptureDestination_4999, &_call_f_setCaptureDestination_4999);
  methods += new qt_gsi::GenericMethod ("setEncodingSettings|encodingSettings=", "@brief Method void QCameraImageCapture::setEncodingSettings(const QImageEncoderSettings &settings)\n", false, &_init_f_setEncodingSettings_3430, &_call_f_setEncodingSettings_3430);
  methods += new qt_gsi::GenericMethod ("supportedBufferFormats", "@brief Method QList<QVideoFrame::PixelFormat> QCameraImageCapture::supportedBufferFormats()\n", true, &_init_f_supportedBufferFormats_c0, &_call_f_supportedBufferFormats_c0);
  methods += new qt_gsi::GenericMethod ("supportedImageCodecs", "@brief Method QStringList QCameraImageCapture::supportedImageCodecs()\n", true, &_init_f_supportedImageCodecs_c0, &_call_f_supportedImageCodecs_c0);
  methods += new qt_gsi::GenericMethod ("supportedResolutions", "@brief Method QList<QSize> QCameraImageCapture::supportedResolutions(const QImageEncoderSettings &settings, bool *continuous)\n", true, &_init_f_supportedResolutions_c4372, &_call_f_supportedResolutions_c4372);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCameraImageCapture::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCameraImageCapture::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  methods += new qt_gsi::GenericMethod ("asQObject", "@brief Delivers the base class interface QObject of QCameraImageCapture\nClass QCameraImageCapture is derived from multiple base classes. This method delivers the QObject base class aspect.", false, &_init_f_QCameraImageCapture_as_QObject, &_call_f_QCameraImageCapture_as_QObject);
  methods += new qt_gsi::GenericMethod ("asConstQObject", "@brief Delivers the base class interface QObject of QCameraImageCapture\nClass QCameraImageCapture is derived from multiple base classes. This method delivers the QObject base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QCameraImageCapture_as_const_QObject, &_call_f_QCameraImageCapture_as_const_QObject);
  methods += new qt_gsi::GenericMethod ("asQMediaBindableInterface", "@brief Delivers the base class interface QMediaBindableInterface of QCameraImageCapture\nClass QCameraImageCapture is derived from multiple base classes. This method delivers the QMediaBindableInterface base class aspect.", false, &_init_f_QCameraImageCapture_as_QMediaBindableInterface, &_call_f_QCameraImageCapture_as_QMediaBindableInterface);
  methods += new qt_gsi::GenericMethod ("asConstQMediaBindableInterface", "@brief Delivers the base class interface QMediaBindableInterface of QCameraImageCapture\nClass QCameraImageCapture is derived from multiple base classes. This method delivers the QMediaBindableInterface base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QCameraImageCapture_as_const_QMediaBindableInterface, &_call_f_QCameraImageCapture_as_const_QMediaBindableInterface);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QCameraImageCapture> decl_QCameraImageCapture (qtdecl_QObject (), "QtMultimedia", "QCameraImageCapture_Native",
  methods_QCameraImageCapture (),
  "@hide\n@alias QCameraImageCapture");

//  Additional base classes

gsi::Class<QMediaBindableInterface> &qtdecl_QMediaBindableInterface ();

gsi::ClassExt<QCameraImageCapture> base_class_QMediaBindableInterface_in_QCameraImageCapture (qtdecl_QMediaBindableInterface ());

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QCameraImageCapture> &qtdecl_QCameraImageCapture () { return decl_QCameraImageCapture; }

}


class QCameraImageCapture_Adaptor : public QCameraImageCapture, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCameraImageCapture_Adaptor();

  //  [adaptor ctor] QCameraImageCapture::QCameraImageCapture(QMediaObject *mediaObject, QObject *parent)
  QCameraImageCapture_Adaptor(QMediaObject *mediaObject) : QCameraImageCapture(mediaObject)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCameraImageCapture::QCameraImageCapture(QMediaObject *mediaObject, QObject *parent)
  QCameraImageCapture_Adaptor(QMediaObject *mediaObject, QObject *parent) : QCameraImageCapture(mediaObject, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QCameraImageCapture::isSignalConnected(const QMetaMethod &signal)
  bool fp_QCameraImageCapture_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QCameraImageCapture::isSignalConnected(signal);
  }

  //  [expose] int QCameraImageCapture::receivers(const char *signal)
  int fp_QCameraImageCapture_receivers_c1731 (const char *signal) const {
    return QCameraImageCapture::receivers(signal);
  }

  //  [expose] QObject *QCameraImageCapture::sender()
  QObject * fp_QCameraImageCapture_sender_c0 () const {
    return QCameraImageCapture::sender();
  }

  //  [expose] int QCameraImageCapture::senderSignalIndex()
  int fp_QCameraImageCapture_senderSignalIndex_c0 () const {
    return QCameraImageCapture::senderSignalIndex();
  }

  //  [adaptor impl] bool QCameraImageCapture::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QCameraImageCapture::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCameraImageCapture_Adaptor, bool, QEvent *>(&QCameraImageCapture_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QCameraImageCapture::event(arg1);
    }
  }

  //  [adaptor impl] bool QCameraImageCapture::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QCameraImageCapture::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCameraImageCapture_Adaptor, bool, QObject *, QEvent *>(&QCameraImageCapture_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QCameraImageCapture::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QMediaObject *QCameraImageCapture::mediaObject()
  QMediaObject * cbs_mediaObject_c0_0() const
  {
    return QCameraImageCapture::mediaObject();
  }

  virtual QMediaObject * mediaObject() const
  {
    if (cb_mediaObject_c0_0.can_issue()) {
      return cb_mediaObject_c0_0.issue<QCameraImageCapture_Adaptor, QMediaObject *>(&QCameraImageCapture_Adaptor::cbs_mediaObject_c0_0);
    } else {
      return QCameraImageCapture::mediaObject();
    }
  }

  //  [adaptor impl] void QCameraImageCapture::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QCameraImageCapture::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCameraImageCapture_Adaptor, QChildEvent *>(&QCameraImageCapture_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QCameraImageCapture::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QCameraImageCapture::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QCameraImageCapture::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCameraImageCapture_Adaptor, QEvent *>(&QCameraImageCapture_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QCameraImageCapture::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QCameraImageCapture::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QCameraImageCapture::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QCameraImageCapture_Adaptor, const QMetaMethod &>(&QCameraImageCapture_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QCameraImageCapture::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QCameraImageCapture::setMediaObject(QMediaObject *)
  bool cbs_setMediaObject_1782_0(QMediaObject *arg1)
  {
    return QCameraImageCapture::setMediaObject(arg1);
  }

  virtual bool setMediaObject(QMediaObject *arg1)
  {
    if (cb_setMediaObject_1782_0.can_issue()) {
      return cb_setMediaObject_1782_0.issue<QCameraImageCapture_Adaptor, bool, QMediaObject *>(&QCameraImageCapture_Adaptor::cbs_setMediaObject_1782_0, arg1);
    } else {
      return QCameraImageCapture::setMediaObject(arg1);
    }
  }

  //  [adaptor impl] void QCameraImageCapture::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QCameraImageCapture::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCameraImageCapture_Adaptor, QTimerEvent *>(&QCameraImageCapture_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QCameraImageCapture::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_mediaObject_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_setMediaObject_1782_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QCameraImageCapture_Adaptor::~QCameraImageCapture_Adaptor() { }

//  Constructor QCameraImageCapture::QCameraImageCapture(QMediaObject *mediaObject, QObject *parent) (adaptor class)

static void _init_ctor_QCameraImageCapture_Adaptor_2976 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mediaObject");
  decl->add_arg<QMediaObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QCameraImageCapture_Adaptor> ();
}

static void _call_ctor_QCameraImageCapture_Adaptor_2976 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMediaObject *arg1 = gsi::arg_reader<QMediaObject * >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QCameraImageCapture_Adaptor *> (new QCameraImageCapture_Adaptor (arg1, arg2));
}


// void QCameraImageCapture::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCapture_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QCameraImageCapture::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCapture_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QCameraImageCapture::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCapture_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QCameraImageCapture::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraImageCapture_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCapture_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QCameraImageCapture::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraImageCapture_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCapture_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QCameraImageCapture::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QCameraImageCapture_Adaptor *)cls)->fp_QCameraImageCapture_isSignalConnected_c2394 (arg1));
}


// QMediaObject *QCameraImageCapture::mediaObject()

static void _init_cbs_mediaObject_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaObject * > ();
}

static void _call_cbs_mediaObject_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaObject * > ((QMediaObject *)((QCameraImageCapture_Adaptor *)cls)->cbs_mediaObject_c0_0 ());
}

static void _set_callback_cbs_mediaObject_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCapture_Adaptor *)cls)->cb_mediaObject_c0_0 = cb;
}


// exposed int QCameraImageCapture::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QCameraImageCapture_Adaptor *)cls)->fp_QCameraImageCapture_receivers_c1731 (arg1));
}


// exposed QObject *QCameraImageCapture::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QCameraImageCapture_Adaptor *)cls)->fp_QCameraImageCapture_sender_c0 ());
}


// exposed int QCameraImageCapture::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCameraImageCapture_Adaptor *)cls)->fp_QCameraImageCapture_senderSignalIndex_c0 ());
}


// bool QCameraImageCapture::setMediaObject(QMediaObject *)

static void _init_cbs_setMediaObject_1782_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMediaObject * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_setMediaObject_1782_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMediaObject *arg1 = args.read<QMediaObject * > (heap);
  ret.write<bool > ((bool)((QCameraImageCapture_Adaptor *)cls)->cbs_setMediaObject_1782_0 (arg1));
}

static void _set_callback_cbs_setMediaObject_1782_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCapture_Adaptor *)cls)->cb_setMediaObject_1782_0 = cb;
}


// void QCameraImageCapture::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraImageCapture_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraImageCapture_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QCameraImageCapture> &qtdecl_QCameraImageCapture ();

static gsi::Methods methods_QCameraImageCapture_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCameraImageCapture::QCameraImageCapture(QMediaObject *mediaObject, QObject *parent)\nThis method creates an object of class QCameraImageCapture.", &_init_ctor_QCameraImageCapture_Adaptor_2976, &_call_ctor_QCameraImageCapture_Adaptor_2976);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCameraImageCapture::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCameraImageCapture::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCameraImageCapture::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QCameraImageCapture::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QCameraImageCapture::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QCameraImageCapture::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("mediaObject", "@brief Virtual method QMediaObject *QCameraImageCapture::mediaObject()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mediaObject_c0_0, &_call_cbs_mediaObject_c0_0);
  methods += new qt_gsi::GenericMethod ("mediaObject", "@hide", true, &_init_cbs_mediaObject_c0_0, &_call_cbs_mediaObject_c0_0, &_set_callback_cbs_mediaObject_c0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QCameraImageCapture::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QCameraImageCapture::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QCameraImageCapture::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setMediaObject", "@brief Virtual method bool QCameraImageCapture::setMediaObject(QMediaObject *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setMediaObject_1782_0, &_call_cbs_setMediaObject_1782_0);
  methods += new qt_gsi::GenericMethod ("*setMediaObject", "@hide", false, &_init_cbs_setMediaObject_1782_0, &_call_cbs_setMediaObject_1782_0, &_set_callback_cbs_setMediaObject_1782_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCameraImageCapture::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QCameraImageCapture_Adaptor> decl_QCameraImageCapture_Adaptor (qtdecl_QCameraImageCapture (), "QtMultimedia", "QCameraImageCapture",
  methods_QCameraImageCapture_Adaptor (),
  "@qt\n@brief Binding of QCameraImageCapture");

}


//  Implementation of the enum wrapper class for QCameraImageCapture::CaptureDestination
namespace qt_gsi
{

static gsi::Enum<QCameraImageCapture::CaptureDestination> decl_QCameraImageCapture_CaptureDestination_Enum ("QtMultimedia", "QCameraImageCapture_CaptureDestination",
    gsi::enum_const ("CaptureToFile", QCameraImageCapture::CaptureToFile, "@brief Enum constant QCameraImageCapture::CaptureToFile") +
    gsi::enum_const ("CaptureToBuffer", QCameraImageCapture::CaptureToBuffer, "@brief Enum constant QCameraImageCapture::CaptureToBuffer"),
  "@qt\n@brief This class represents the QCameraImageCapture::CaptureDestination enum");

static gsi::QFlagsClass<QCameraImageCapture::CaptureDestination > decl_QCameraImageCapture_CaptureDestination_Enums ("QtMultimedia", "QCameraImageCapture_QFlags_CaptureDestination",
  "@qt\n@brief This class represents the QFlags<QCameraImageCapture::CaptureDestination> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCameraImageCapture> inject_QCameraImageCapture_CaptureDestination_Enum_in_parent (decl_QCameraImageCapture_CaptureDestination_Enum.defs ());
static gsi::ClassExt<QCameraImageCapture> decl_QCameraImageCapture_CaptureDestination_Enum_as_child (decl_QCameraImageCapture_CaptureDestination_Enum, "CaptureDestination");
static gsi::ClassExt<QCameraImageCapture> decl_QCameraImageCapture_CaptureDestination_Enums_as_child (decl_QCameraImageCapture_CaptureDestination_Enums, "QFlags_CaptureDestination");

}


//  Implementation of the enum wrapper class for QCameraImageCapture::DriveMode
namespace qt_gsi
{

static gsi::Enum<QCameraImageCapture::DriveMode> decl_QCameraImageCapture_DriveMode_Enum ("QtMultimedia", "QCameraImageCapture_DriveMode",
    gsi::enum_const ("SingleImageCapture", QCameraImageCapture::SingleImageCapture, "@brief Enum constant QCameraImageCapture::SingleImageCapture"),
  "@qt\n@brief This class represents the QCameraImageCapture::DriveMode enum");

static gsi::QFlagsClass<QCameraImageCapture::DriveMode > decl_QCameraImageCapture_DriveMode_Enums ("QtMultimedia", "QCameraImageCapture_QFlags_DriveMode",
  "@qt\n@brief This class represents the QFlags<QCameraImageCapture::DriveMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCameraImageCapture> inject_QCameraImageCapture_DriveMode_Enum_in_parent (decl_QCameraImageCapture_DriveMode_Enum.defs ());
static gsi::ClassExt<QCameraImageCapture> decl_QCameraImageCapture_DriveMode_Enum_as_child (decl_QCameraImageCapture_DriveMode_Enum, "DriveMode");
static gsi::ClassExt<QCameraImageCapture> decl_QCameraImageCapture_DriveMode_Enums_as_child (decl_QCameraImageCapture_DriveMode_Enums, "QFlags_DriveMode");

}


//  Implementation of the enum wrapper class for QCameraImageCapture::Error
namespace qt_gsi
{

static gsi::Enum<QCameraImageCapture::Error> decl_QCameraImageCapture_Error_Enum ("QtMultimedia", "QCameraImageCapture_Error",
    gsi::enum_const ("NoError", QCameraImageCapture::NoError, "@brief Enum constant QCameraImageCapture::NoError") +
    gsi::enum_const ("NotReadyError", QCameraImageCapture::NotReadyError, "@brief Enum constant QCameraImageCapture::NotReadyError") +
    gsi::enum_const ("ResourceError", QCameraImageCapture::ResourceError, "@brief Enum constant QCameraImageCapture::ResourceError") +
    gsi::enum_const ("OutOfSpaceError", QCameraImageCapture::OutOfSpaceError, "@brief Enum constant QCameraImageCapture::OutOfSpaceError") +
    gsi::enum_const ("NotSupportedFeatureError", QCameraImageCapture::NotSupportedFeatureError, "@brief Enum constant QCameraImageCapture::NotSupportedFeatureError") +
    gsi::enum_const ("FormatError", QCameraImageCapture::FormatError, "@brief Enum constant QCameraImageCapture::FormatError"),
  "@qt\n@brief This class represents the QCameraImageCapture::Error enum");

static gsi::QFlagsClass<QCameraImageCapture::Error > decl_QCameraImageCapture_Error_Enums ("QtMultimedia", "QCameraImageCapture_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QCameraImageCapture::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCameraImageCapture> inject_QCameraImageCapture_Error_Enum_in_parent (decl_QCameraImageCapture_Error_Enum.defs ());
static gsi::ClassExt<QCameraImageCapture> decl_QCameraImageCapture_Error_Enum_as_child (decl_QCameraImageCapture_Error_Enum, "Error");
static gsi::ClassExt<QCameraImageCapture> decl_QCameraImageCapture_Error_Enums_as_child (decl_QCameraImageCapture_Error_Enums, "QFlags_Error");

}

