# Jasmine Core 5.11.0 Release Notes

## New features

* `detectLateRejectionHandling` works in `beforeAll` and `afterAll` as well as 
  in specs.
* Clicking a link in the HTML reporter does exact filtering rather than a 
  substring match.

  If you use jasmine-browser-runner or load boot1.js directly from jasmine-core,
  you'll get the new filtering behavior automatically. Otherwise, it requires 
  several changes to boot1.js:
  
  1. Add `queryString` to the options object passed to `HtmlReporter`, and 
     remove `filterSpecs`.
  2. Instantiate a `jasmine.HtmlExactSpecFilter` instead of a
     `jasmine.HtmlSpecFilter`.
  2. Change the body of `config.specFilter` from
     `return specFilter.matches(spec.getFullName());` to
     `return specFilter.matches(spec)`

  For a working example, see lib/jasmine-core/boot1.js in this package.
  Old boot1.js files will still work, but you'll get the old filtering behavior.

## Bug fixes

* Fixed global error handling when the env is executed repeatedly

## Changes to supported environments

* Safari 15 is no longer supported.

## Documentation improvements

* Added API reference docs for classes used in browser boot files
* Documented the order properties of `jasmineStarted` and `jasmineDone` events

## Internal improvements

* Unified top suite and regular suite execution
* Converted `Spec`, `Suite`, and `QueryString` to ES6 classes
* Extracted configuration out of `Env`
* Updated tests to characterize suite/spec reporting more completely
* Adopted `forbidDuplicateNames: true` in jasmine-core's own tests

## Supported environments

This version has been tested in the following environments.

| Environment       | Supported versions             |
|-------------------|--------------------------------|
| Node              | 18.20.5**, 20, 22, 24          |
| Safari            | 16**, 17**                     |
| Chrome            | 140*                           |
| Firefox           | 102**, 115**, 128**, 140, 143* |
| Edge              | 140*                           |

\* Evergreen browser. Each version of Jasmine is tested against the latest
version available at release time.<br>
\** Supported on a best-effort basis. Support for these versions may be dropped
if it becomes impractical, and bugs affecting only these versions may not be
treated as release blockers.

------

_Release Notes generated with _[Anchorman](http://github.com/infews/anchorman)_
