/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.comp;

import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.TextLimitFinder;
import net.sourceforge.plantuml.ugraphic.UBackground;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicNo;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UParamNull;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UShapeIgnorableForCompression;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.comp.CompressionMode;
import net.sourceforge.plantuml.ugraphic.comp.SlotSet;

public class SlotFinder
extends UGraphicNo
implements UGraphic {
    private final SlotSet slot;
    private final StringBounder stringBounder;
    private final UTranslate translate;
    private final CompressionMode mode;

    @Override
    public boolean matchesProperty(String propertyName) {
        return false;
    }

    public double dpiFactor() {
        return 1.0;
    }

    @Override
    public UGraphic apply(UChange change) {
        if (change instanceof UTranslate) {
            return new SlotFinder(this.mode, this.stringBounder, this.slot, this.translate.compose((UTranslate)change));
        }
        if (change instanceof UStroke) {
            return new SlotFinder(this);
        }
        if (change instanceof UBackground) {
            return new SlotFinder(this);
        }
        if (change instanceof HColor) {
            return new SlotFinder(this);
        }
        throw new UnsupportedOperationException();
    }

    public SlotFinder(CompressionMode mode, StringBounder stringBounder) {
        this(mode, stringBounder, new SlotSet(), new UTranslate());
    }

    private SlotFinder(CompressionMode mode, StringBounder stringBounder, SlotSet slot, UTranslate translate) {
        this.stringBounder = stringBounder;
        this.slot = slot;
        this.translate = translate;
        this.mode = mode;
    }

    private SlotFinder(SlotFinder other) {
        this(other.mode, other.stringBounder, other.slot, other.translate);
    }

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    @Override
    public UParam getParam() {
        return new UParamNull();
    }

    @Override
    public void draw(UShape sh) {
        UShapeIgnorableForCompression shape;
        double x = this.translate.getDx();
        double y = this.translate.getDy();
        if (sh instanceof UShapeIgnorableForCompression && (shape = (UShapeIgnorableForCompression)sh).isIgnoreForCompressionOn(this.mode)) {
            shape.drawWhenCompressed(this, this.mode);
            return;
        }
        if (sh instanceof URectangle) {
            this.drawRectangle(x, y, (URectangle)sh);
        } else if (sh instanceof UPath) {
            this.drawPath(x, y, (UPath)sh);
        } else if (sh instanceof UPolygon) {
            this.drawPolygon(x, y, (UPolygon)sh);
        } else if (sh instanceof UEllipse) {
            this.drawEllipse(x, y, (UEllipse)sh);
        } else if (sh instanceof UText) {
            UText text = (UText)sh;
            this.drawText(x, y, text);
        } else if (sh instanceof UEmpty) {
            this.drawEmpty(x, y, (UEmpty)sh);
        }
    }

    private void drawPath(double x, double y, UPath shape) {
        if (this.mode == CompressionMode.ON_X) {
            this.slot.addSlot(x + shape.getMinX(), x + shape.getMaxX());
        } else {
            this.slot.addSlot(y + shape.getMinY(), y + shape.getMaxY());
        }
    }

    private void drawEmpty(double x, double y, UEmpty shape) {
        if (this.mode == CompressionMode.ON_X) {
            this.slot.addSlot(x, x + shape.getWidth());
        } else {
            this.slot.addSlot(y, y + shape.getHeight());
        }
    }

    private void drawText(double x, double y, UText shape) {
        TextLimitFinder finder = new TextLimitFinder(this.stringBounder, false);
        finder.apply(new UTranslate(x, y)).draw(shape);
        if (this.mode == CompressionMode.ON_X) {
            this.slot.addSlot(finder.getMinX(), finder.getMaxX());
        } else {
            this.slot.addSlot(finder.getMinY(), finder.getMaxY());
        }
    }

    private void drawEllipse(double x, double y, UEllipse shape) {
        if (this.mode == CompressionMode.ON_X) {
            this.slot.addSlot(x, x + shape.getWidth());
        } else {
            this.slot.addSlot(y, y + shape.getHeight());
        }
    }

    private void drawPolygon(double x, double y, UPolygon shape) {
        if (this.mode == shape.getCompressionMode()) {
            return;
        }
        if (this.mode == CompressionMode.ON_X) {
            this.slot.addSlot(x + shape.getMinX(), x + shape.getMaxX());
        } else {
            this.slot.addSlot(y + shape.getMinY(), y + shape.getMaxY());
        }
    }

    private void drawRectangle(double x, double y, URectangle shape) {
        if (this.mode == CompressionMode.ON_X) {
            this.slot.addSlot(x, x + shape.getWidth());
        } else {
            this.slot.addSlot(y, y + shape.getHeight());
        }
    }

    @Override
    public ColorMapper getColorMapper() {
        return new ColorMapperIdentity();
    }

    public SlotSet getSlotSet() {
        return this.slot;
    }

    @Override
    public void flushUg() {
    }
}

