# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.redis.aio import RedisManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestRedisManagementRedisOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(RedisManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_redis_check_name_availability(self, resource_group):
        response = await self.client.redis.check_name_availability(
            parameters={"name": "str", "type": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_redis_list_upgrade_notifications(self, resource_group):
        response = self.client.redis.list_upgrade_notifications(
            resource_group_name=resource_group.name,
            name="str",
            history=0.0,
            api_version="2024-11-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_redis_begin_create(self, resource_group):
        response = await (
            await self.client.redis.begin_create(
                resource_group_name=resource_group.name,
                name="str",
                parameters={
                    "location": "str",
                    "sku": {"capacity": 0, "family": "str", "name": "str"},
                    "disableAccessKeyAuthentication": False,
                    "enableNonSslPort": False,
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "minimumTlsVersion": "str",
                    "publicNetworkAccess": "Enabled",
                    "redisConfiguration": {
                        "aad-enabled": "str",
                        "aof-backup-enabled": "str",
                        "aof-storage-connection-string-0": "str",
                        "aof-storage-connection-string-1": "str",
                        "authnotrequired": "str",
                        "maxclients": "str",
                        "maxfragmentationmemory-reserved": "str",
                        "maxmemory-delta": "str",
                        "maxmemory-policy": "str",
                        "maxmemory-reserved": "str",
                        "notify-keyspace-events": "str",
                        "preferred-data-archive-auth-method": "str",
                        "preferred-data-persistence-auth-method": "str",
                        "rdb-backup-enabled": "str",
                        "rdb-backup-frequency": "str",
                        "rdb-backup-max-snapshot-count": "str",
                        "rdb-storage-connection-string": "str",
                        "storage-subscription-id": "str",
                        "zonal-configuration": "str",
                    },
                    "redisVersion": "str",
                    "replicasPerMaster": 0,
                    "replicasPerPrimary": 0,
                    "shardCount": 0,
                    "staticIP": "str",
                    "subnetId": "str",
                    "tags": {"str": "str"},
                    "tenantSettings": {"str": "str"},
                    "updateChannel": "str",
                    "zonalAllocationPolicy": "str",
                    "zones": ["str"],
                },
                api_version="2024-11-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_redis_begin_update(self, resource_group):
        response = await (
            await self.client.redis.begin_update(
                resource_group_name=resource_group.name,
                name="str",
                parameters={
                    "disableAccessKeyAuthentication": False,
                    "enableNonSslPort": False,
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "minimumTlsVersion": "str",
                    "publicNetworkAccess": "Enabled",
                    "redisConfiguration": {
                        "aad-enabled": "str",
                        "aof-backup-enabled": "str",
                        "aof-storage-connection-string-0": "str",
                        "aof-storage-connection-string-1": "str",
                        "authnotrequired": "str",
                        "maxclients": "str",
                        "maxfragmentationmemory-reserved": "str",
                        "maxmemory-delta": "str",
                        "maxmemory-policy": "str",
                        "maxmemory-reserved": "str",
                        "notify-keyspace-events": "str",
                        "preferred-data-archive-auth-method": "str",
                        "preferred-data-persistence-auth-method": "str",
                        "rdb-backup-enabled": "str",
                        "rdb-backup-frequency": "str",
                        "rdb-backup-max-snapshot-count": "str",
                        "rdb-storage-connection-string": "str",
                        "storage-subscription-id": "str",
                        "zonal-configuration": "str",
                    },
                    "redisVersion": "str",
                    "replicasPerMaster": 0,
                    "replicasPerPrimary": 0,
                    "shardCount": 0,
                    "sku": {"capacity": 0, "family": "str", "name": "str"},
                    "tags": {"str": "str"},
                    "tenantSettings": {"str": "str"},
                    "updateChannel": "str",
                    "zonalAllocationPolicy": "str",
                },
                api_version="2024-11-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_redis_begin_delete(self, resource_group):
        response = await (
            await self.client.redis.begin_delete(
                resource_group_name=resource_group.name,
                name="str",
                api_version="2024-11-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_redis_get(self, resource_group):
        response = await self.client.redis.get(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_redis_list_by_resource_group(self, resource_group):
        response = self.client.redis.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-11-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_redis_list_by_subscription(self, resource_group):
        response = self.client.redis.list_by_subscription(
            api_version="2024-11-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_redis_list_keys(self, resource_group):
        response = await self.client.redis.list_keys(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_redis_regenerate_key(self, resource_group):
        response = await self.client.redis.regenerate_key(
            resource_group_name=resource_group.name,
            name="str",
            parameters={"keyType": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_redis_force_reboot(self, resource_group):
        response = await self.client.redis.force_reboot(
            resource_group_name=resource_group.name,
            name="str",
            parameters={"ports": [0], "rebootType": "str", "shardId": 0},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_redis_begin_import_data(self, resource_group):
        response = await (
            await self.client.redis.begin_import_data(
                resource_group_name=resource_group.name,
                name="str",
                parameters={
                    "files": ["str"],
                    "format": "str",
                    "preferred-data-archive-auth-method": "str",
                    "storage-subscription-id": "str",
                },
                api_version="2024-11-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_redis_begin_export_data(self, resource_group):
        response = await (
            await self.client.redis.begin_export_data(
                resource_group_name=resource_group.name,
                name="str",
                parameters={
                    "container": "str",
                    "prefix": "str",
                    "format": "str",
                    "preferred-data-archive-auth-method": "str",
                    "storage-subscription-id": "str",
                },
                api_version="2024-11-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_redis_begin_flush_cache(self, resource_group):
        response = await (
            await self.client.redis.begin_flush_cache(
                resource_group_name=resource_group.name,
                cache_name="str",
                api_version="2024-11-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
