# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
*** system environment, resource control and configuration details

** Author: Ralph Amissah
  [ralph@amissah.com]
  [ralph.amissah@gmail.com]

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see [http://www.gnu.org/licenses/].

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  [http://www.fsf.org/licensing/licenses/gpl.html]
  [http://www.gnu.org/licenses/gpl.html]

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  [http://www.jus.uio.no/sisu]
  [http://www.sisudoc.org]

** Git
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary]
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/se_clear.rb;hb=HEAD]

=end
module SiSU_Clear
  require_relative 'constants'                             # constants.rb
  require_relative 'utils'                                 # utils.rb
  require_relative 'se_info_env'                           # se_info_env.rb
  begin
    require 'singleton'
  rescue LoadError
    SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
      error('singleton NOT FOUND (LoadError)')
  end
  class Clear < SiSU_Info_Env::InfoEnv                     # se_info_env.rb
    #todo unify with FileOp
    def initialize(cmd,fns,operation='')
      @cmd=cmd
      begin
        super(fns)
        @env=SiSU_Env::InfoEnv.new(fns)
        SiSU_Env::InfoVersion.instance
        if operation.class.inspect =~/SiSU_Param/
          @md=operation
        end
        case operation #watch
        when /pdf/                 then @env_out=''
        when /sql/
        when /xml|plaintext|ascii/ then @env_out=@env.path.output + @fnb #check change of name to plaintext from ascii
        else
          if defined? @md.sfx_src \
          and @md.sfx_src =~/ss[ftsumc]/
            @env_out_root=@env.path.output
            @env_out="#{@env.path.output}/#{@fnb}"
            @@publisher='SiSU http://www.jus.uio.no/sisu'
            @env_pdf="#{@env_out_root}/pdf"
          end
        end
      rescue
        SiSU_Screen::Ansi.new(@cmd,$!,$@).rescue do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    def param_instantiate
      @cX||=SiSU_Screen::Ansi.new(@cmd)
      @@date=SiSU_Env::InfoDate.new
      @@publisher='SiSU scribe'
    end
  end
end
__END__
