# Release Notes for SPDX License List

## version 3.21 - 2023-06-18

New licenses/exceptions added: 28

1.  Asterisk-exception
2. ASWF-Digital-Assets-1.0
3. ASWF-Digital-Assets-1.1
4. Autoconf-exception-macro
5. Boehm-GC
6. CC-BY-SA-3.0-IGO
7. cryptsetup-OpenSSL-exception
8. dtoa
9. GPL-3.0-interface-exception
10. Inner-Net-2.0
11. Latex2e-translated-notice
12. libpri-OpenH323-exception
13. Linux-man-pages-1-para
14. Linux-man-pages-copyleft-2-para
15. Linux-man-pages-copyleft-var
16. LLGPL
17. metamail
18. MIT-Festival
19. NIST-Software
20. OLFL-1.3
21. OPL-UK-3.0
22. SGP4
23. TermReadKey
24. UnixCrypt
25. vsftpd-openssl-exception
26. Widget-Workshop
27. Xdebug-1.03
28. Xfig

Added documentation for inclusion principles for exceptions on the SPDX Exceptions List.

Removed `isDeprecated` field from licenses and exceptions in favor of `deprecatedVersion` alone.

Added and improved markup for many licenses and many minor improvements to other documentation.

Updated to latest version of the License List Publisher and GitHub Actions dependencies.

Designated current license list XML schema as version 1.0.0.

See all PRs for 3.21 here: https://github.com/spdx/license-list-XML/pulls?page=1&q=is%3Apr+milestone%3A%223.21%22+is%3Aclosed

See comparision of changes from 3.20 to 3.21: https://github.com/spdx/license-list-XML/compare/v3.20...v3.21

## version 3.20 - 2023-02-17

New licenses/exceptions added: 40

1.  AdaCore-doc
2.  Autoconf-exception-generic
3.  BSD-4.3RENO
4.  BSD-4.3TAHOE
5.  BSD-Advertising-Acknowledgement
6.  BSD-Attribution-HPND-disclaimer
7.  Bitstream-Charter
8.  Brian-Gladman-3-Clause
9.  CC-BY-NC-SA-2.0-DE
10. CFITSIO
11. CMU-Mach
12. Clips
13. Cornell-Lossless-JPEG
14. GNAT-exception
15. Graphics-Gems
16. HP-1986
17. HPND-Markus-Kuhn
18. HPND-export-US
19. HPND-sell-variant-MIT-disclaimer
20. IEC-Code-Components-EULA
21. IJG-short
22. JPL-image
23. Kazlib
24. LOOP
25. MIT-Wu
26. Martin-Birgmeier
27. OFFIS
28. OpenPBS-2.3
29. QPL-1.0-INRIA-2004
30. QPL-1.0-INRIA-2004-exception
31. snprintf
32. SunPro
33. SWI-exception
34. Symlinks
35. TPDL
36. TPL-1.0
37. TTWL
38. UCAR
39. w3m
40. xlock

Added historical timeline for the license list.

Recorded and made available links to videos showing two different processes for creating license XML files, and improved related process documentation.

Added and improved markup for many licenses and many minor improvements to other documentation.

Adjusted ListedLicense XSD schema to remove directly-nested lists that had resulted in invalid HTML, and made corresponding fixes to XML for many licenses.

Fixed broken validate-schema CI check and simplified test-one-license script.

Updated to latest version of the License List Publisher.

See all PRs for 3.20 here: https://github.com/spdx/license-list-XML/pulls?page=1&q=is%3Apr+milestone%3A%223.20%22+is%3Aclosed

See comparision of changes from 3.19 to 3.20: https://github.com/spdx/license-list-XML/compare/v3.19...v3.20

## version 3.19 - 2022-11-30

New licenses/exceptions added: 5

1. checkmk
2. FSFULLRWD
3. Knuth-CTAN
4. libutil-David-Nugent
5. x11vnc-openssl-exception

Many improvements to documentation, including new docs on XML template fields and license list release process, and a rework of the FAQs.

Improvements to documentation and requested fields for online license request tool.

Renamed `master` branch to `main` and made conforming edits.

Cleanup of markup for many licenses and other minor changes.

See all PRs for 3.19 here: https://github.com/spdx/license-list-XML/pulls?page=1&q=is%3Apr+milestone%3A%223.19%22+is%3Aclosed

See comparision of changes from 3.18 to 3.19: https://github.com/spdx/license-list-XML/compare/v3.18...v3.19

## version 3.18 - 2022-08-11

New licenses/exceptions added: 10

1. CC-BY-3.0-IGO
2. GStreamer-exception-2005
3. GStreamer-exception-2008
4. LZMA-SDK-9.11-to-9.20
5. LZMA-SDK-9.22
6. MS-LPL
7. Minpack
8. mpi-permissive
9. NICTA-1.0
10. Python-2.0.1

Corrected designation of KiCad-libraries-exception (added in 3.17) as an exception rather than a license.

Implemented license decision template for improved clarity on legal team decisions regarding license submission requests.

Updates to various documentation, adjustments to markup for various licenses and other minor changes.

See all PRs for 3.18 here: https://github.com/spdx/license-list-XML/pulls?page=1&q=is%3Apr+milestone%3A%223.18%22+is%3Aclosed

See comparision of changes from 3.17 to 3.18: https://github.com/spdx/license-list-XML/compare/v3.17...v3.18

## version 3.17 - 2022-05-08

New licenses/exceptions added: 5

1. Arphic-1999
2. Baekmuk
3. Bitstream-Vera
4. KiCad-libraries-exception
5. mplus

For the LGPL-3.0 collection of licenses, added GPL-3.0 text as optional inclusion at end of license text.

Migrated SPDX License List FAQs from SPDX website into license-list-XML repo in MarkDown format.

Updates to various documentation, adjustments to markup for various licenses and other minor changes.

Updated to latest version of the License List Publisher.

See all PRs for 3.17 here: https://github.com/spdx/license-list-XML/pulls?page=1&q=is%3Apr+milestone%3A%223.17%22+is%3Aclosed

See comparision of changes from 3.16 to 3.17: https://github.com/spdx/license-list-XML/compare/v3.16...v3.17

## version 3.16 - 2022-02-06

New licenses/exceptions added: 6

1. App-s2p
2. DL-DE-BY-2.0
3. Elastic-2.0
4. Jam
5. SchemeReport
6. X11-distribute-modifications-variant

Deprecated licenses/exceptions: 1

1. bzip2-1.0.5

Added documentation describing how to use the Git command line to create and test new license XML files. See [DOCS/git-usage.md](DOCS/git-usage.md) for more information.

Updates to various documentation, adjustments to markup for various licenses and other minor changes.

Updated to latest version of the License List Publisher.

See all PRs for 3.16 here: https://github.com/spdx/license-list-XML/pulls?page=1&q=is%3Apr+milestone%3A%223.16%22+is%3Aclosed

See comparision of changes from 3.15 to 3.16: https://github.com/spdx/license-list-XML/compare/v3.15...v3.16

## version 3.15 - 2021-11-14

New licenses/exceptions added: 4

1. COIL-1.0
2. Community-Spec-1.0
3. FDK-AAC
4. Linux-man-pages-copyleft

Note that "Linux-man-pages-copyleft" was initially merged as "Verbatim-man-pages", but at the community's request the ID was updated prior to inclusion in the release. See https://github.com/spdx/license-list-XML/issues/1310 for more details.

Added template for reviews of new license requests, to evaluate against the license inclusion principles. See [DOCS/template-license-review-checklist.md](DOCS/template-license-review-checklist.md) for the review template.

Updates to various documentation, adjustments to markup for various licenses and other minor changes.

Updated to latest version of the License List Publisher.

See all PRs for 3.15 here: https://github.com/spdx/license-list-XML/pulls?page=1&q=is%3Apr+milestone%3A%223.15%22+is%3Aclosed

See comparision of changes from 3.14 to 3.15: https://github.com/spdx/license-list-XML/compare/v3.14...v3.15

## version 3.14 - 2021-08-08

New licenses/exceptions added: 13

1. CC-BY-NC-SA-2.0-FR
2. CC-BY-NC-SA-2.0-UK
3. CC-BY-2.5-AU
4. CC-BY-3.0-NL
5. CC-BY-3.0-DE
6. CC-BY-NC-3.0-DE
7. CC-BY-NC-ND-3.0-DE
8. CC-BY-NC-SA-3.0-DE
9. CC-BY-ND-3.0-DE
10. CC-BY-SA-3.0-DE
11. CDLA-Permissive-2.0
12. NLOD-2.0
13. OPUBL-1.0

Updates to various documentation, adjustments to markup for various licenses and other minor changes.

See all PRs for 3.14 here: https://github.com/spdx/license-list-XML/pulls?page=1&q=is%3Apr+milestone%3A%223.14%22+is%3Aclosed

See comparision of changes from 3.13 to 3.14: https://github.com/spdx/license-list-XML/compare/v3.13...v3.14

## version 3.13 - 2021-05-15

New licenses/exceptions added: 2

1. BSD-3-Clause-No-Military-License
2. CDL-1.0

Updates to various documentation, adjustments to markup for various licenses and other minor changes.

See all PRs for 3.13 here: https://github.com/spdx/license-list-XML/pulls?page=1&q=is%3Apr+milestone%3A%223.13%22+is%3Aclosed

See comparision of changes from 3.12 to 3.13: https://github.com/spdx/license-list-XML/compare/v3.12...v3.13

## version 3.12 - 2021-03-07

New licenses/exceptions added: 10

1. BSD-3-Clause-Modification
2. BSD-4-Clause-Shortened
3. CC-BY-SA-2.1-JP
4. C-UDA-1.0
5. DRL-1.0
6. FreeBSD-DOC
7. GD
8. MIT-Modern-Variant
9. NAIST-2003
10. OGDL-Taiwan-1.0

The test / build / deploy CI system has been migrated from Travis to GitHub Actions.

Updates to various documentation, cleanup of markup for various licenses and other minor changes.

See all PRs for 3.12 here: https://github.com/spdx/license-list-XML/pulls?page=1&q=is%3Apr+milestone%3A%223.12+release%22+is%3Aclosed

See comparision of changes from 3.11 to 3.12: https://github.com/spdx/license-list-XML/compare/v3.11...v3.12

## version 3.11 - 2020-11-25

New licenses/exceptions added: 6

1. ANTLR-PD-fallback
1. BUSL-1.1
1. CC-BY-3.0-US
1. CC-BY-SA-2.0-UK
1. HTMLTIDY
1. MIT-open-group

Update several licenses to note that they have become OSI-approved.

Updates and cleanup of markup for various licenses and other minor changes.

See all PRs for 3.11 here: https://github.com/spdx/license-list-XML/pulls?page=1&q=is%3Apr+milestone%3A%223.11+release%22+is%3Aclosed

See comparision of changes from 3.10 to 3.11: https://github.com/spdx/license-list-XML/compare/v3.10...v3.11

## version 3.10 - 2020-08-03

New licenses/exceptions added: 20

1. BSD-2-Clause-Views
1. CC-BY-NC-ND-3.0-IGO
1. CC-BY-SA-3.0-AT
1. CC-BY-3.0-AT
1. EPICS
1. GFDL-1.1-invariants-only
1. GFDL-1.1-invariants-or-later
1. GFDL-1.1-no-invariants-only
1. GFDL-1.1-no-invariants-or-later
1. GFDL-1.2-invariants-only
1. GFDL-1.2-invariants-or-later
1. GFDL-1.2-no-invariants-only
1. GFDL-1.2-no-invariants-or-later
1. GFDL-1.3-invariants-only
1. GFDL-1.3-invariants-or-later
1. GFDL-1.3-no-invariants-only
1. GFDL-1.3-no-invariants-or-later
1. GLWTPL
1. NIST-PD
1. NIST-PD-fallback

Extensive updates to documentation for workflow to add new licenses.

Deprecate BSD-2-Clause-FreeBSD as substantively identical to BSD-2-Clause-Views.

Updates and cleanup of markup for various licenses and other minor changes.

See all PRs for 3.10 here: https://github.com/spdx/license-list-XML/pulls?page=1&q=is%3Apr+milestone%3A%223.10+release%22+is%3Aclosed

See comparision of changes from 3.9 to 3.10: https://github.com/spdx/license-list-XML/compare/v3.9...v3.10

## version 3.9 - 2020-05-15

New licenses/exceptions added: 16

1. CAL-1.0
1. CAL-1.0-Combined-Work-Exception
1. CERN-OHL-P-2.0
1. CERN-OHL-S-2.0
1. CERN-OHL-W-2.0
1. Hippocratic-2.1
1. LGPL-3.0-linking-exception
1. MulanPSL-2.0
1. NCGL-UK-2.0
1. O-UDA-1.0
1. OGC-1.0
1. Parity-7.0.0
1. PolyForm-Noncommercial-1.0.0
1. PolyForm-Small-Business-1.0.0
1. SHL-2.0
1. SHL-2.1

Deprecate BSD-2-Clause-NetBSD as substantively identical to BSD-2-Clause.

Update and expand license inclusion principles.

Update matching guidelines to v2.1.

Add and update various documentation and legal team meeting details.

Add helper script to enable renaming licenses for use in preparing XML and test
files.

Updates and cleanup of markup for various licenses and other minor changes.

See all PRs for 3.9 here: https://github.com/spdx/license-list-XML/pulls?page=1&q=is%3Apr+milestone%3A%223.9+release%22+is%3Aclosed

See comparision of changes from 3.8 to 3.9: https://github.com/spdx/license-list-XML/compare/v3.8...v3.9

## version 3.8 - 2020-02-09

New licenses/exceptions added: 9

1. GPL-3.0-linking-exception
1. GPL-3.0-linking-source-exception
1. libselinux-1.0
1. NTP-0
1. OFL-1.0-RFN
1. OFL-1.0-no-RFN
1. OFL-1.1-RFN
1. OFL-1.1-no-RFN
1. PSF-2.0

Updates and cleanup of markup for various licenses and other minor changes.

Add machine-readable copy of "equivalent words" from matching guidelines.

See all PRs for 3.8 here: https://github.com/spdx/license-list-XML/pulls?page=1&q=is%3Apr+milestone%3A%223.8+release%22+is%3Aclosed

See comparision of changes from 3.7 to 3.8: https://github.com/spdx/license-list-XML/compare/v3.7...v3.8

## version 3.7 - 2019-10-22

New licenses/exceptions added: 6

1. etalab-2.0
1. MulanPSL-1.0
1. OGL-Canada-2.0
1. SSH-OpenSSH
1. SSH-short
1. UCL-1.0

Updates and cleanup of markup for various licenses and other minor changes.

Add and update documentation regarding the history of the SPDX License List and
development of license inclusion guidelines.

Technical fixes to license list publisher to handle appropriate display of
optional text fields.

Add helper script to enable testing a single license XML file rather than
requiring re-test of entire repo.

See all PRs for 3.7 here: https://github.com/spdx/license-list-XML/pulls?page=1&q=is%3Apr+milestone%3A%223.7+release%22+is%3Aclosed

See comparision of changes from 3.6 to 3.7: https://github.com/spdx/license-list-XML/compare/v3.6...v3.7

## version 3.6 - 2019-07-10

New licenses/exceptions added: 10

1. blessing
1. BlueOak-1.0.0
1. BSD-3-Clause-Open-MPI
1. CC-PDDC
1. Parity-6.0.0
1. SHL-0.5
1. SHL-0.51
1. SSPL-1.0
1. Swift-exception
1. Universal-FOSS-exception-1.0

Addition of markup to various licenses and other minor updates.

Add and update documentation originating from SPDX website, including:
* About the SPDX License List
* Explanation of SPDX License List Fields
* License Inclusion Principles

Technical fixes to schema and license markup for handling of spacing and other updates.

Cleanup of stray whitespace across the repository.

See all PRs for 3.6 here: https://github.com/spdx/license-list-XML/pulls?page=1&q=is%3Apr+milestone%3A%223.6+release%22+is%3Aclosed

See comparision of changes from 3.5 to 3.6: https://github.com/spdx/license-list-XML/compare/v3.5...v3.6

## version 3.5 - 2019-04-02

New licenses/exceptions added: 7

1. JPNIC
1. libpng-2.0
1. HPND-sell-variant
1. GPL-CC-1.0
1. TAPR-OHL-1.0
1. CERN-OHL-1.1
1. CERN-OHL-1.2

Addition of markup to various licenses and other minor updates.

Add page describing internal workflow for adding a new license in /DOCS directory.

See all PRs for 3.5 here: https://github.com/spdx/license-list-XML/pulls?utf8=%E2%9C%93&q=is%3Apr+milestone%3A%223.5+release%22+

See comparison of changes from 3.4 to 3.5:

## version 3.4 - 2018-12-20

New licenses/exceptions added: 1

1. copyleft-next-0.3.0

Various minor updates to license matching markup and tools.

Updated CONTRIBUTING page and links for "Request New License" (previously a webpage) to point here

See all PRs for 3.4 here: https://github.com/spdx/license-list-XML/pulls?utf8=%E2%9C%93&q=milestone%3A%223.4+release%22+

See comparision of changes from 3.3 and 3.4: https://github.com/spdx/license-list-XML/compare/v3.3...v3.4

## version 3.3 - 2018-10-24

New licenses/exceptions added: 6
1. OGL-UK-1.0
1. OGL-UK-2.0
1. OGL-UK-3.0
1. copyleft-next-0.3.1
1. OCaml-LGPL-linking-exception
1. Sendmail-8.23

Updated or added license info for source files associated with SPDX License List (.json, scheme, .js files) with CC0-1.0

See all PRs for 3.3 here: https://github.com/spdx/license-list-XML/pulls?q=is%3Apr+is%3Aclosed+milestone%3A%223.3+release%22

See comparision of changes from 3.2 and 3.3: https://github.com/spdx/license-list-XML/compare/v3.2...v3.3
