'\"
'\" Generated from file 'ntext\&.man' by tcllib/doctools with format 'nroff'
'\"
.TH "ntext" n 1\&.0 tklib "Alternative Bindings for the Text Widget"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
ntext \- Alternative Bindings for the Text Widget
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBTk  8\&.5\fR
.sp
package require \fBntext  ?1\&.0?\fR
.sp
\fB::ntext::new_textCopy\fR \fIpathName\fR
.sp
\fB::ntext::new_textCut\fR \fIpathName\fR
.sp
\fB::ntext::new_textPaste\fR \fIpathName\fR
.sp
\fB::ntext::syncIndentColor\fR \fIpathName\fR
.sp
.BE
.SH DESCRIPTION
The purpose of the \fBntext\fR package is to make the text widget behave more like other text-editing applications\&. It makes the text widget more useful for implementing a text editor, and makes it behave in a way that will be more familiar to most users\&.
.PP
The package provides a binding tag named \fINtext\fR for use by text widgets in place of the default \fIText\fR binding tag\&.
.PP
Package \fBntext\fR 's functions and variables are contained entirely in the \fB::ntext\fR namespace; its other code is contained in the binding tag \fINtext\fR\&.  \fBntext\fR has no exports to the global or other namespaces, and no new widget commands\&.  It uses modified copies of the \fBTk\fR code, leaving the original code, and the \fIText\fR binding tag, unchanged\&.
.PP
The differences between the \fINtext\fR binding tag and the default \fIText\fR binding tag are in three categories:
.IP \(bu
Some \fIText\fR bindings behave differently from most text-editing applications\&.  \fINtext\fR gives these bindings more familiar behaviour\&.  For details see \fIntextBindings\fR\&.
.IP \(bu
When a logical line with leading whitespace is word-wrapped onto more than one display line, the wrapped display lines begin further to the left than the first display line, which can make the text layout untidy and difficult to read\&.  \fINtext\fR can indent the wrapped lines to match the leading whitespace of the first display line (this facility is switched off by default)\&.  For details see \fIntextIndent\fR\&.
.IP \(bu
When the user navigates or selects text, \fBTcl/Tk\fR sometimes needs to detect word boundaries\&.  \fINtext\fR provides improved rules for word boundary detection\&.  For details see \fIntextWordBreak\fR\&.
.PP
The remainder of this page describes the basic use and configuration of all three aspects of \fINtext\fR\&.  For more detailed information on the different facilities of \fINtext\fR, see the pages \fIntextBindings\fR, \fIntextIndent\fR, and \fIntextWordBreak\fR\&.
.PP
See Section \fBEXAMPLE\fR for how to apply the \fINtext\fR binding tag in place of the \fIText\fR binding tag\&.
.SH COMMANDS
.TP
\fB::ntext::new_textCopy\fR \fIpathName\fR
Replacement for ::tk_textCopy\&.
.TP
\fB::ntext::new_textCut\fR \fIpathName\fR
Replacement for ::tk_textCut that also maintains \fINtext\fR indentation (see \fIntextIndent\fR)\&.
.TP
\fB::ntext::new_textPaste\fR \fIpathName\fR
Replacement for ::tk_textPaste that also maintains \fINtext\fR indentation (see \fIntextIndent\fR)\&.
.TP
\fB::ntext::syncIndentColor\fR \fIpathName\fR
Command to apply the current value of the variable \fB::ntext::indentColor\fR to existing lines in a text widget\&.  This command is useful if a text widget has been created, text has been inserted in the widget, \fIand then\fR the value of \fB::ntext::indentColor\fR is changed (see \fIntextIndent\fR)\&.
.PP
.SH "CONFIGURATION OPTIONS"
\fINtext\fR provides alternatives to a number of behaviours of the classic \fIText\fR binding tag\&.  Where there is an option, the \fINtext\fR behaviour (except for display-line indentation) is switched on by default\&.
.PP
The behaviour of \fINtext\fR may be configured application-wide by setting the values of a number of namespace variables:
.PP
\fB::ntext::classicAnchor\fR
.IP \(bu
\fB0\fR - (default value) selects \fINtext\fR behaviour, i\&.e\&. the anchor point is fixed
.IP \(bu
\fB1\fR - selects classic \fIText\fR behaviour, i\&.e\&. the anchor point is variable
.IP \(bu
For more information see \fIntextBindings\fR
.PP
.PP
\fB::ntext::classicExtras\fR
.IP \(bu
\fB0\fR - (default value) selects \fINtext\fR behaviour, i\&.e\&. several traditional \fIText\fR bindings are de-activated
.IP \(bu
\fB1\fR - selects classic \fIText\fR behaviour, i\&.e\&. all \fIText\fR bindings are activated
.IP \(bu
For more information see \fIntextBindings\fR
.PP
.PP
\fB::ntext::classicMouseSelect\fR
.IP \(bu
\fB0\fR - (default value) selects \fINtext\fR behaviour, i\&.e\&. the anchor point for mouse selection operations is moved by keyboard navigation
.IP \(bu
\fB1\fR - selects classic \fIText\fR behaviour
.IP \(bu
For more information see \fIntextBindings\fR
.PP
.PP
\fB::ntext::classicParagraphs\fR
.IP \(bu
\fB0\fR - (default value) on macOS Aqua, certain keyboard bindings are made to behave in the same way as the Mac application TextEdit\&.  The bindings involve vertical scrolling of the screen and are <?Shift-?Option-(Up|Down)>\&.
.IP \(bu
\fB1\fR - on macOS Aqua, certain keyboard bindings are made to behave in the same way as classic \fIText\fR, ignoring the conventions of Aqua\&.  The bindings involve vertical scrolling of the screen and are <?Shift-?Option-(Up|Down)>\&.
.IP \(bu
For more information see \fIntextBindings\fR
.PP
.PP
\fB::ntext::classicSelection\fR
.IP \(bu
\fB0\fR - (default value on macOS Aqua) selects Mac-like behaviour, i\&.e\&. when a navigation keystroke cancels a selection, the insert mark first moves to the end of the selection determined by the navigation direction of the keystroke, and then the keystroke is applied\&.
.IP \(bu
\fB1\fR - (default value except on macOS Aqua) selects PC-like behaviour (the same as classic \fIText\fR), i\&.e\&. when a navigation keystroke cancels a selection, the insert mark is not moved before the keystroke is applied\&.
.IP \(bu
For more information see \fIntextBindings\fR
.PP
.PP
\fB::ntext::classicWordBreak\fR
.IP \(bu
\fB0\fR - (default value) selects \fINtext\fR behaviour, i\&.e\&. platform-independent, two classes of word characters and one class of non-word characters\&.
.IP \(bu
\fB1\fR - selects classic \fIText\fR behaviour, i\&.e\&. platform-dependent, one class of word characters and one class of non-word characters
.IP \(bu
After changing this value, the matching patterns should be recalculated\&.  See \fIntextWordBreak\fR for details and advanced configuration options\&.
.PP
.PP
\fB::ntext::classicWrap\fR
.IP \(bu
\fB0\fR - selects \fINtext\fR behaviour, i\&.e\&. display lines of text widgets in \fI-wrap\fR \fIword\fR mode are indented to match the initial whitespace of the first display line of a logical line\&.  If the widget already holds text when this value is set, a function call may be necessary\&.  See \fIntextIndent\fR for detailed instructions on the use of \fINtext\fR 's indentation\&.
.IP \(bu
\fB1\fR - (default value) selects classic \fIText\fR behaviour, i\&.e\&. no indentation
.IP \(bu
For more information see \fIntextIndent\fR
.PP
.PP
\fB::ntext::indentColor\fR
.IP \(bu
\fB{}\fR - if the value is the empty string, then the indent of wrapped display lines has the same color as the widget background\&.
.IP \(bu
\fIcolor\fR - a valid \fBTk\fR color to use for the indent of wrapped display lines (default value \fI#d9d9d9\fR)\&.
.sp
Coloring is implemented with the text widget tag option \fI-lmargincolor\fR, which is available from \fBTk\fR 8\&.6\&.6 onwards\&.  \fINtext\fR indent coloring has no effect in earlier versions of \fBTk\fR\&.
.sp
The value of \fB::ntext::indentColor\fR will often be set at startup\&.  If the value is changed when text widgets already exist and contain text, those widgets can be updated by calling command \fB::ntext::syncIndentColor\fR\&.
.IP \(bu
For more information see \fIntextIndent\fR
.PP
.PP
\fB::ntext::overwrite\fR
.IP \(bu
\fB0\fR - (initial value) text typed at the keyboard is inserted into the widget
.IP \(bu
\fB1\fR - text typed at the keyboard overwrites text already in the widget
.IP \(bu
The value is toggled by the \fIInsert\fR key (except on macOS Aqua where there is no such key)\&.
.IP \(bu
For more information see \fIntextBindings\fR
.PP
.PP
\fB::ntext::useBlockCursor\fR
.IP \(bu
\fB0\fR - the block cursor will not be used\&.  When the widget is in \fIoverwrite\fR mode (see \fB::ntext::overwrite\fR), the ordinary cursor will change color instead\&.
.IP \(bu
\fB1\fR - the block cursor will be used when the widget is in \fIoverwrite\fR mode (see \fB::ntext::overwrite\fR)\&.
.IP \(bu
The default value depends on the version of \fBTk\fR\&.  In versions of \fBTk\fR earlier than \fB8\&.5\&.12\fR, the sizing of the block cursor had a bug, and \fB::ntext::useBlockCursor\fR defaults to \fB0\fR\&.  From \fB8\&.5\&.12\fR onwards the bug is fixed, and \fB::ntext::useBlockCursor\fR defaults to \fB1\fR\&.
.IP \(bu
For more information see \fIntextBindings\fR
.PP
.SH BUGS
This version of \fBntext\fR is intended to be compatible with all releases of \fBTk\fR 8\&.5 and 8\&.6, and with the branches \fIcore-8-5-branch\fR, \fIcore-8-6-branch\fR, and \fItrunk\fR in the source code repository for \fBTk\fR\&.  Any incompatibility with any of these versions, for any \fBTk\fR windowing system, should be reported as a bug\&. Please report such in the category \fIntext\fR of the \fITklib Trackers\fR [http://core\&.tcl\&.tk/tklib/reportlist]\&.
.SH EXAMPLE
To create a text widget \&.t and use the \fINtext\fR bindings:
.CS


package require ntext
text \&.t
bindtags \&.t {\&.t Ntext \&. all}

.CE
See bindtags for more information\&.
.SH "SEE ALSO"
bindtags, ntextBindings, ntextIndent, ntextWordBreak, re_syntax, regexp, text
.SH KEYWORDS
bindtags, re_syntax, regexp, text
