/*
 * ABOUTME: SPF resource record parsing and formatting.
 * ABOUTME: Uses txtlike infrastructure for implementation.
 *
 * Part of DNS zone file validator `validns`.
 *
 * Copyright 2025 OARC, Inc.
 * Copyright 2011-2025 Anton Berezin <tobez@tobez.org>
 * Modified BSD license.
 * (See LICENSE file in the distribution.)
 *
 */
#include <sys/types.h>
#include <stdio.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "textparse.h"
#include "rr.h"
#include "txtlike.h"

/* XXX
 * We need to add the following spf-specific policy checks:
 *  - record not too long (DNS name + length of SPF+TXT < 450) - rfc4408, 3.1.4
 *  - record should match /^v=spf1( |$)/  - rfc4408, 4.5
 *  - maybe check for other syntax features
 *  - there should be an identical TXT record - rfc4408, 3.1.1
 *  - there should only be one SPF per DNS name - rfc4408, 4.5
 */

static struct rr *spf_parse(char *name, long ttl, int type, char *s)
{
    return txtlike_parse(name, ttl, type, s, "SPF");
}

struct rr_methods spf_methods = { spf_parse, txtlike_human, txtlike_wirerdata, NULL, NULL };
