// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SMLSL2_4S_TRACE_AARCH64_H_
#define VIXL_SIM_SMLSL2_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_smlsl2_4S[] = {
  0xc002fff7, 0xc001fffd, 0xc0010001, 0x00000020,
  0xc0027ffa, 0xc0017fff, 0x00000002, 0x00000020,
  0xc001fffd, 0x00000001, 0xffff8003, 0x00000020,
  0x00000000, 0xffff8003, 0xffff0004, 0x00000020,
  0xffff8003, 0xffff0005, 0xfff80012, 0x00000020,
  0xffff0006, 0xfff80021, 0xffc1807f, 0x00000020,
  0xfff80030, 0xffc180fb, 0xffc10080, 0x00000020,
  0xffc18177, 0xffc100fd, 0xffc08081, 0x00000020,
  0xffc1017a, 0xffc080ff, 0xe666b335, 0x00000020,
  0xffc0817d, 0xe666e667, 0xd555d557, 0x00000020,
  0xe6671999, 0xd5562aab, 0xc001ffff, 0x00000020,
  0xd5567fff, 0xc0027ffb, 0xc0018000, 0x00000020,
  0xc002fff7, 0xc001fffd, 0xc0010001, 0x00000020,
  0xc0027ffa, 0xc0017fff, 0x3fff8002, 0x00000020,
  0xc001fffd, 0x3fff0001, 0x3fff0003, 0x00000020,
  0x3ffe8000, 0x3ffe8003, 0x2aaaaaac, 0x00000020,
  0x3ffe0003, 0x2aaa5555, 0x1999ccce, 0x00000020,
  0x2aa9fffe, 0x19999999, 0x003fff82, 0x00000020,
  0x19996664, 0x003fff01, 0x003f7f83, 0x00000020,
  0x003ffe80, 0x003f7f03, 0x003eff84, 0x00000020,
  0x003f7e83, 0x003eff05, 0x003e7f85, 0x00000020,
  0x003efe86, 0x003e7f07, 0x0007fff2, 0x00000020,
  0x003e7e89, 0x0007ffe1, 0x00017fff, 0x00000020,
  0x0007ffd0, 0x00017ffb, 0x00010000, 0x00000020,
  0x00017ffa, 0x0000ffff, 0x00000002, 0x00000020,
  0x0000fffc, 0x00008000, 0x00000002, 0x0000001f,
  0x00007ffe, 0x00000001, 0x00000002, 0x0000001e,
  0x00000000, 0xffff8002, 0x00000002, 0x00000010,
  0xffff8002, 0xffff0003, 0x00000002, 0xffffffa3,
  0xffff0004, 0xfff80011, 0x00000002, 0xffffffa2,
  0xfff80020, 0xffc1807e, 0x00000002, 0xffffffa1,
  0xffc180fa, 0xffc1007f, 0x00000002, 0xffffcced,
  0xffc100fc, 0xffc08080, 0x00000002, 0xffffaacb,
  0xffc080fe, 0xe666b334, 0x00000002, 0xffff8023,
  0xe666e666, 0xd555d556, 0x00000002, 0xffff8022,
  0xd5562aaa, 0xc001fffe, 0x00000002, 0xffff8021,
  0xc0027ffa, 0xc0017fff, 0x00000002, 0x00008020,
  0xc001fffc, 0xc0010000, 0x00000002, 0x0000801f,
  0xc0017ffe, 0x3fff8001, 0x00000002, 0x00005576,
  0x3fff0000, 0x3fff0002, 0x00000002, 0x00003354,
  0x3ffe8002, 0x2aaaaaab, 0x00000002, 0x000000a0,
  0x2aaa5554, 0x1999cccd, 0x00000002, 0x0000009f,
  0x19999998, 0x003fff81, 0x00000002, 0x0000009e,
  0x003fff00, 0x003f7f82, 0x00000002, 0x0000009d,
  0x003f7f02, 0x003eff83, 0x00000002, 0x00000030,
  0x003eff04, 0x003e7f84, 0x00000002, 0x00000023,
  0x003e7f06, 0x0007fff1, 0x00000002, 0x00000022,
  0x0007ffe0, 0x00017ffe, 0x00000002, 0x00000021,
  0x00017ffd, 0x00000001, 0x00000003, 0x00000020,
  0x0000fffe, 0x00000001, 0x00000002, 0x0000001e,
  0x00007fff, 0x00000001, 0x00000001, 0x0000001c,
  0x00000000, 0x00000001, 0x00000000, 0x00000000,
  0xffff8001, 0x00000001, 0xfffffff2, 0xffffff26,
  0xffff0002, 0x00000001, 0xffffff85, 0xffffff24,
  0xfff80010, 0x00000001, 0xffffff84, 0xffffff22,
  0xffc1807d, 0x00000001, 0xffffff83, 0xffff99ba,
  0xffc1007e, 0x00000001, 0xffffcccf, 0xffff5576,
  0xffc0807f, 0x00000001, 0xffffaaad, 0xffff0026,
  0xe666b333, 0x00000001, 0xffff8005, 0xffff0024,
  0xd555d555, 0x00000001, 0xffff8004, 0xffff0022,
  0xc001fffd, 0x00000001, 0xffff8003, 0x00010020,
  0xc0017ffe, 0x00000001, 0x00008002, 0x0001001e,
  0xc000ffff, 0x00000001, 0x00008001, 0x0000aacc,
  0x3fff8000, 0x00000001, 0x00005558, 0x00006688,
  0x3fff0001, 0x00000001, 0x00003336, 0x00000120,
  0x2aaaaaaa, 0x00000001, 0x00000082, 0x0000011e,
  0x1999cccc, 0x00000001, 0x00000081, 0x0000011c,
  0x003fff80, 0x00000001, 0x00000080, 0x0000011a,
  0x003f7f81, 0x00000001, 0x0000007f, 0x00000040,
  0x003eff82, 0x00000001, 0x00000012, 0x00000026,
  0x003e7f83, 0x00000001, 0x00000005, 0x00000024,
  0x0007fff0, 0x00000001, 0x00000004, 0x00000022,
  0x00000000, 0x00000003, 0x00000004, 0x00000020,
  0x00000000, 0x00000002, 0x00000002, 0x00000010,
  0x00000000, 0x00000001, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0xfffffffe, 0xffffff20,
  0x00000000, 0xffffffff, 0xffffffe2, 0xfffff850,
  0x00000000, 0xfffffff1, 0xffffff08, 0xfffff840,
  0x00000000, 0xffffff84, 0xffffff06, 0xfffff830,
  0x00000000, 0xffffff83, 0xffffff04, 0xfffcccf0,
  0x00000000, 0xffffff82, 0xffff999c, 0xfffaaad0,
  0x00000000, 0xffffccce, 0xffff5558, 0xfff80050,
  0x00000000, 0xffffaaac, 0xffff0008, 0xfff80040,
  0x00000000, 0xffff8004, 0xffff0006, 0xfff80030,
  0x00000000, 0xffff8003, 0xffff0004, 0x00080020,
  0x00000000, 0xffff8002, 0x00010002, 0x00080010,
  0x00000000, 0x00008001, 0x00010000, 0x00055580,
  0x00000000, 0x00008000, 0x0000aaae, 0x00033360,
  0x00000000, 0x00005557, 0x0000666a, 0x00000820,
  0x00000000, 0x00003335, 0x00000102, 0x00000810,
  0x00000000, 0x00000081, 0x00000100, 0x00000800,
  0x00000000, 0x00000080, 0x000000fe, 0x000007f0,
  0x00000000, 0x0000007f, 0x000000fc, 0x00000120,
  0x00000000, 0x0000007e, 0x00000022, 0x00000050,
  0x00000000, 0x00000011, 0x00000008, 0x00000040,
  0x00000000, 0x00000004, 0x00000006, 0x00000030,
  0x00000003, 0x00000005, 0x00000012, 0x00000020,
  0x00000002, 0x00000003, 0x00000002, 0xffffffa3,
  0x00000001, 0x00000001, 0xfffffff2, 0xffffff26,
  0x00000000, 0xffffffff, 0xffffffe2, 0xfffff850,
  0xffffffff, 0xfffffffd, 0xffffff02, 0xffffc317,
  0xfffffffe, 0xffffffe1, 0xfffff832, 0xffffc29a,
  0xfffffff0, 0xffffff07, 0xfffff822, 0xffffc21d,
  0xffffff83, 0xffffff05, 0xfffff812, 0xffe70039,
  0xffffff82, 0xffffff03, 0xfffcccd2, 0xffd6559f,
  0xffffff81, 0xffff999b, 0xfffaaab2, 0xffc18197,
  0xffffcccd, 0xffff5557, 0xfff80032, 0xffc1811a,
  0xffffaaab, 0xffff0007, 0xfff80022, 0xffc1809d,
  0xffff8003, 0xffff0005, 0xfff80012, 0x003e8020,
  0xffff8002, 0xffff0003, 0x00080002, 0x003e7fa3,
  0xffff8001, 0x00010001, 0x0007fff2, 0x0029ab1e,
  0x00008000, 0x0000ffff, 0x00055562, 0x00190084,
  0x00007fff, 0x0000aaad, 0x00033342, 0x00003ea0,
  0x00005556, 0x00006669, 0x00000802, 0x00003e23,
  0x00003334, 0x00000101, 0x000007f2, 0x00003da6,
  0x00000080, 0x000000ff, 0x000007e2, 0x00003d29,
  0x0000007f, 0x000000fd, 0x000007d2, 0x000007f0,
  0x0000007e, 0x000000fb, 0x00000102, 0x00000197,
  0x0000007d, 0x00000021, 0x00000032, 0x0000011a,
  0x00000010, 0x00000007, 0x00000022, 0x0000009d,
  0x00000006, 0x00000021, 0x0000007f, 0x00000020,
  0x00000004, 0x00000011, 0x00000002, 0xffffffa2,
  0x00000002, 0x00000001, 0xffffff85, 0xffffff24,
  0x00000000, 0xfffffff1, 0xffffff08, 0xfffff840,
  0xfffffffe, 0xffffffe1, 0xfffff832, 0xffffc29a,
  0xfffffffc, 0xffffff01, 0xffffc2f9, 0xffffc21c,
  0xffffffe0, 0xfffff831, 0xffffc27c, 0xffffc19e,
  0xffffff06, 0xfffff821, 0xffffc1ff, 0xffe6cd06,
  0xffffff04, 0xfffff811, 0xffe7001b, 0xffd6004a,
  0xffffff02, 0xfffcccd1, 0xffd65581, 0xffc1019a,
  0xffff999a, 0xfffaaab1, 0xffc18179, 0xffc1011c,
  0xffff5556, 0xfff80031, 0xffc180fc, 0xffc1009e,
  0xffff0006, 0xfff80021, 0xffc1807f, 0x003f0020,
  0xffff0004, 0xfff80011, 0x003e8002, 0x003effa2,
  0xffff0002, 0x00080001, 0x003e7f85, 0x002a0074,
  0x00010000, 0x0007fff1, 0x0029ab00, 0x001933b8,
  0x0000fffe, 0x00055561, 0x00190066, 0x00003f20,
  0x0000aaac, 0x00033341, 0x00003e82, 0x00003ea2,
  0x00006668, 0x00000801, 0x00003e05, 0x00003e24,
  0x00000100, 0x000007f1, 0x00003d88, 0x00003da6,
  0x000000fe, 0x000007e1, 0x00003d0b, 0x00000800,
  0x000000fc, 0x000007d1, 0x000007d2, 0x0000019a,
  0x000000fa, 0x00000101, 0x00000179, 0x0000011c,
  0x00000020, 0x00000031, 0x000000fc, 0x0000009e,
  0x00000030, 0x000000fb, 0x00000080, 0x00000020,
  0x00000020, 0x0000007e, 0x00000002, 0xffffffa1,
  0x00000010, 0x00000001, 0xffffff84, 0xffffff22,
  0x00000000, 0xffffff84, 0xffffff06, 0xfffff830,
  0xfffffff0, 0xffffff07, 0xfffff822, 0xffffc21d,
  0xffffffe0, 0xfffff831, 0xffffc27c, 0xffffc19e,
  0xffffff00, 0xffffc2f8, 0xffffc1fe, 0xffffc11f,
  0xfffff830, 0xffffc27b, 0xffffc180, 0xffe699d3,
  0xfffff820, 0xffffc1fe, 0xffe6cce8, 0xffd5aaf5,
  0xfffff810, 0xffe7001a, 0xffd6002c, 0xffc0819d,
  0xfffcccd0, 0xffd65580, 0xffc1017c, 0xffc0811e,
  0xfffaaab0, 0xffc18178, 0xffc100fe, 0xffc0809f,
  0xfff80030, 0xffc180fb, 0xffc10080, 0x003f8020,
  0xfff80020, 0xffc1807e, 0x003f0002, 0x003f7fa1,
  0xfff80010, 0x003e8001, 0x003eff84, 0x002a55ca,
  0x00080000, 0x003e7f84, 0x002a0056, 0x001966ec,
  0x0007fff0, 0x0029aaff, 0x0019339a, 0x00003fa0,
  0x00055560, 0x00190065, 0x00003f02, 0x00003f21,
  0x00033340, 0x00003e81, 0x00003e84, 0x00003ea2,
  0x00000800, 0x00003e04, 0x00003e06, 0x00003e23,
  0x000007f0, 0x00003d87, 0x00003d88, 0x00000810,
  0x000007e0, 0x00003d0a, 0x000007e2, 0x0000019d,
  0x000007d0, 0x000007d1, 0x0000017c, 0x0000011e,
  0x00000100, 0x00000178, 0x000000fe, 0x0000009f,
  0x00000177, 0x000000fd, 0x00000081, 0x00000020,
  0x000000fa, 0x0000007f, 0x00000002, 0xffffcced,
  0x0000007d, 0x00000001, 0xffffff83, 0xffff99ba,
  0x00000000, 0xffffff83, 0xffffff04, 0xfffcccf0,
  0xffffff83, 0xffffff05, 0xfffff812, 0xffe70039,
  0xffffff06, 0xfffff821, 0xffffc1ff, 0xffe6cd06,
  0xfffff830, 0xffffc27b, 0xffffc180, 0xffe699d3,
  0xffffc2f7, 0xffffc1fd, 0xffffc101, 0xf5c2a3f7,
  0xffffc27a, 0xffffc17f, 0xffe699b5, 0xeeef1131,
  0xffffc1fd, 0xffe6cce7, 0xffd5aad7, 0xe66719b9,
  0xffe70019, 0xffd6002b, 0xffc0817f, 0xe666e686,
  0xffd6557f, 0xffc1017b, 0xffc08100, 0xe666b353,
  0xffc18177, 0xffc100fd, 0xffc08081, 0x19998020,
  0xffc180fa, 0xffc1007f, 0x003f8002, 0x19994ced,
  0xffc1807d, 0x003f0001, 0x003f7f83, 0x11112242,
  0x003e8000, 0x003eff83, 0x002a55ac, 0x0a3d8f7c,
  0x003e7f83, 0x002a0055, 0x001966ce, 0x001999a0,
  0x0029aafe, 0x00193399, 0x00003f82, 0x0019666d,
  0x00190064, 0x00003f01, 0x00003f03, 0x0019333a,
  0x00003e80, 0x00003e83, 0x00003e84, 0x00190007,
  0x00003e03, 0x00003e05, 0x00003e05, 0x00033350,
  0x00003d86, 0x00003d87, 0x000007f2, 0x000099b9,
  0x00003d09, 0x000007e1, 0x0000017f, 0x00006686,
  0x000007d0, 0x0000017b, 0x00000100, 0x00003353,
  0x0000017a, 0x000000ff, 0x00003335, 0x00000020,
  0x000000fc, 0x00000080, 0x00000002, 0xffffaacb,
  0x0000007e, 0x00000001, 0xffffcccf, 0xffff5576,
  0x00000000, 0xffffff82, 0xffff999c, 0xfffaaad0,
  0xffffff82, 0xffffff03, 0xfffcccd2, 0xffd6559f,
  0xffffff04, 0xfffff811, 0xffe7001b, 0xffd6004a,
  0xfffff820, 0xffffc1fe, 0xffe6cce8, 0xffd5aaf5,
  0xffffc27a, 0xffffc17f, 0xffe699b5, 0xeeef1131,
  0xffffc1fc, 0xffffc100, 0xf5c2a3d9, 0xe38e71e7,
  0xffffc17e, 0xffe699b4, 0xeeef1113, 0xd556801f,
  0xffe6cce6, 0xffd5aad6, 0xe667199b, 0xd5562aca,
  0xffd6002a, 0xffc0817e, 0xe666e668, 0xd555d575,
  0xffc1017a, 0xffc080ff, 0xe666b335, 0x2aaa8020,
  0xffc100fc, 0xffc08080, 0x19998002, 0x2aaa2acb,
  0xffc1007e, 0x003f8001, 0x19994ccf, 0x1c71e3ae,
  0x003f0000, 0x003f7f82, 0x11112224, 0x11114464,
  0x003eff82, 0x002a55ab, 0x0a3d8f5e, 0x002aaaa0,
  0x002a0054, 0x001966cd, 0x00199982, 0x002a554b,
  0x00193398, 0x00003f81, 0x0019664f, 0x0029fff6,
  0x00003f00, 0x00003f02, 0x0019331c, 0x0029aaa1,
  0x00003e82, 0x00003e83, 0x0018ffe9, 0x00055570,
  0x00003e04, 0x00003e04, 0x00033332, 0x0001001f,
  0x00003d86, 0x000007f1, 0x0000999b, 0x0000aaca,
  0x000007e0, 0x0000017e, 0x00006668, 0x00005575,
  0x0000017d, 0x00006667, 0x00005557, 0x00000020,
  0x000000fe, 0x00003334, 0x00000002, 0xffff8023,
  0x0000007f, 0x00000001, 0xffffaaad, 0xffff0026,
  0x00000000, 0xffffccce, 0xffff5558, 0xfff80050,
  0xffffff81, 0xffff999b, 0xfffaaab2, 0xffc18197,
  0xffffff02, 0xfffcccd1, 0xffd65581, 0xffc1019a,
  0xfffff810, 0xffe7001a, 0xffd6002c, 0xffc0819d,
  0xffffc1fd, 0xffe6cce7, 0xffd5aad7, 0xe66719b9,
  0xffffc17e, 0xffe699b4, 0xeeef1113, 0xd556801f,
  0xffffc0ff, 0xf5c2a3d8, 0xe38e71c9, 0xc0030017,
  0xffe699b3, 0xeeef1112, 0xd5568001, 0xc002801a,
  0xffd5aad5, 0xe667199a, 0xd5562aac, 0xc002001d,
  0xffc0817d, 0xe666e667, 0xd555d557, 0x3ffe8020,
  0xffc080fe, 0xe666b334, 0x2aaa8002, 0x3ffe0023,
  0xffc0807f, 0x19998001, 0x2aaa2aad, 0x2aaa001e,
  0x003f8000, 0x19994cce, 0x1c71e390, 0x19996684,
  0x003f7f81, 0x11112223, 0x11114446, 0x003ffea0,
  0x002a55aa, 0x0a3d8f5d, 0x002aaa82, 0x003f7ea3,
  0x001966cc, 0x00199981, 0x002a552d, 0x003efea6,
  0x00003f80, 0x0019664e, 0x0029ffd8, 0x003e7ea9,
  0x00003f01, 0x0019331b, 0x0029aa83, 0x0007fff0,
  0x00003e82, 0x0018ffe8, 0x00055552, 0x00018017,
  0x00003e03, 0x00033331, 0x00010001, 0x0001001a,
  0x000007f0, 0x0000999a, 0x0000aaac, 0x0000801d,
  0x00009999, 0x0000aaab, 0x00007fff, 0x00000020,
  0x00006666, 0x00005556, 0x00000002, 0xffff8022,
  0x00003333, 0x00000001, 0xffff8005, 0xffff0024,
  0x00000000, 0xffffaaac, 0xffff0008, 0xfff80040,
  0xffffcccd, 0xffff5557, 0xfff80032, 0xffc1811a,
  0xffff999a, 0xfffaaab1, 0xffc18179, 0xffc1011c,
  0xfffcccd0, 0xffd65580, 0xffc1017c, 0xffc0811e,
  0xffe70019, 0xffd6002b, 0xffc0817f, 0xe666e686,
  0xffe6cce6, 0xffd5aad6, 0xe667199b, 0xd5562aca,
  0xffe699b3, 0xeeef1112, 0xd5568001, 0xc002801a,
  0xf5c2a3d7, 0xe38e71c8, 0xc002fff9, 0xc002001c,
  0xeeef1111, 0xd5568000, 0xc0027ffc, 0xc001801e,
  0xe6671999, 0xd5562aab, 0xc001ffff, 0x3fff0020,
  0xe666e666, 0xd555d556, 0x3ffe8002, 0x3ffe8022,
  0xe666b333, 0x2aaa8001, 0x3ffe0005, 0x2aaa5574,
  0x19998000, 0x2aaa2aac, 0x2aaa0000, 0x199999b8,
  0x19994ccd, 0x1c71e38f, 0x19996666, 0x003fff20,
  0x11112222, 0x11114445, 0x003ffe82, 0x003f7f22,
  0x0a3d8f5c, 0x002aaa81, 0x003f7e85, 0x003eff24,
  0x00199980, 0x002a552c, 0x003efe88, 0x003e7f26,
  0x0019664d, 0x0029ffd7, 0x003e7e8b, 0x00080000,
  0x0019331a, 0x0029aa82, 0x0007ffd2, 0x0001801a,
  0x0018ffe7, 0x00055551, 0x00017ff9, 0x0001001c,
  0x00033330, 0x00010000, 0x0000fffc, 0x0000801e,
  0x0000ffff, 0x0000fffb, 0x00008000, 0x00000020,
  0x0000aaaa, 0x00007ffe, 0x00000002, 0xffff8021,
  0x00005555, 0x00000001, 0xffff8004, 0xffff0022,
  0x00000000, 0xffff8004, 0xffff0006, 0xfff80030,
  0xffffaaab, 0xffff0007, 0xfff80022, 0xffc1809d,
  0xffff5556, 0xfff80031, 0xffc180fc, 0xffc1009e,
  0xfffaaab0, 0xffc18178, 0xffc100fe, 0xffc0809f,
  0xffd6557f, 0xffc1017b, 0xffc08100, 0xe666b353,
  0xffd6002a, 0xffc0817e, 0xe666e668, 0xd555d575,
  0xffd5aad5, 0xe667199a, 0xd5562aac, 0xc002001d,
  0xeeef1111, 0xd5568000, 0xc0027ffc, 0xc001801e,
  0xe38e71c7, 0xc002fff8, 0xc001fffe, 0xc001001f,
  0xd5567fff, 0xc0027ffb, 0xc0018000, 0x3fff8020,
  0xd5562aaa, 0xc001fffe, 0x3fff0002, 0x3fff0021,
  0xd555d555, 0x3ffe8001, 0x3ffe8004, 0x2aaaaaca,
  0x2aaa8000, 0x3ffe0004, 0x2aaa5556, 0x1999ccec,
  0x2aaa2aab, 0x2aa9ffff, 0x1999999a, 0x003fffa0,
  0x1c71e38e, 0x19996665, 0x003fff02, 0x003f7fa1,
  0x11114444, 0x003ffe81, 0x003f7f04, 0x003effa2,
  0x002aaa80, 0x003f7e84, 0x003eff06, 0x003e7fa3,
  0x002a552b, 0x003efe87, 0x003e7f08, 0x00080010,
  0x0029ffd6, 0x003e7e8a, 0x0007ffe2, 0x0001801d,
  0x0029aa81, 0x0007ffd1, 0x00017ffc, 0x0001001e,
  0x00055550, 0x00017ff8, 0x0000fffe, 0x0000801f,
  0x00017ff7, 0x0000fffd, 0x00008001, 0x00000020,
  0x0000fffa, 0x00007fff, 0x00000002, 0x00008020,
  0x00007ffd, 0x00000001, 0xffff8003, 0x00010020,
  0x00000000, 0xffff8003, 0xffff0004, 0x00080020,
  0xffff8003, 0xffff0005, 0xfff80012, 0x003e8020,
  0xffff0006, 0xfff80021, 0xffc1807f, 0x003f0020,
  0xfff80030, 0xffc180fb, 0xffc10080, 0x003f8020,
  0xffc18177, 0xffc100fd, 0xffc08081, 0x19998020,
  0xffc1017a, 0xffc080ff, 0xe666b335, 0x2aaa8020,
  0xffc0817d, 0xe666e667, 0xd555d557, 0x3ffe8020,
  0xe6671999, 0xd5562aab, 0xc001ffff, 0x3fff0020,
  0xd5567fff, 0xc0027ffb, 0xc0018000, 0x3fff8020,
  0xc002fff7, 0xc001fffd, 0xc0010001, 0xc0000020,
  0xc0027ffa, 0xc0017fff, 0x3fff8002, 0xc0008020,
  0xc001fffd, 0x3fff0001, 0x3fff0003, 0xd5550020,
  0x3ffe8000, 0x3ffe8003, 0x2aaaaaac, 0xe6660020,
  0x3ffe0003, 0x2aaa5555, 0x1999ccce, 0xffc00020,
  0x2aa9fffe, 0x19999999, 0x003fff82, 0xffc08020,
  0x19996664, 0x003fff01, 0x003f7f83, 0xffc10020,
  0x003ffe80, 0x003f7f03, 0x003eff84, 0xffc18020,
  0x003f7e83, 0x003eff05, 0x003e7f85, 0xfff80020,
  0x003efe86, 0x003e7f07, 0x0007fff2, 0xfffe8020,
  0x003e7e89, 0x0007ffe1, 0x00017fff, 0xffff0020,
  0x0007ffd0, 0x00017ffb, 0x00010000, 0xffff8020,
  0x00017ffa, 0x0000ffff, 0xffff8002, 0x00000020,
  0x0000fffc, 0x00008000, 0x00000002, 0x0000801f,
  0x00007ffe, 0x00000001, 0x00008002, 0x0001001e,
  0x00000000, 0xffff8002, 0x00010002, 0x00080010,
  0xffff8002, 0xffff0003, 0x00080002, 0x003e7fa3,
  0xffff0004, 0xfff80011, 0x003e8002, 0x003effa2,
  0xfff80020, 0xffc1807e, 0x003f0002, 0x003f7fa1,
  0xffc180fa, 0xffc1007f, 0x003f8002, 0x19994ced,
  0xffc100fc, 0xffc08080, 0x19998002, 0x2aaa2acb,
  0xffc080fe, 0xe666b334, 0x2aaa8002, 0x3ffe0023,
  0xe666e666, 0xd555d556, 0x3ffe8002, 0x3ffe8022,
  0xd5562aaa, 0xc001fffe, 0x3fff0002, 0x3fff0021,
  0xc0027ffa, 0xc0017fff, 0x3fff8002, 0xc0008020,
  0xc001fffc, 0xc0010000, 0xc0000002, 0xc001001f,
  0xc0017ffe, 0x3fff8001, 0xc0008002, 0xd5555576,
  0x3fff0000, 0x3fff0002, 0xd5550002, 0xe6663354,
  0x3ffe8002, 0x2aaaaaab, 0xe6660002, 0xffc000a0,
  0x2aaa5554, 0x1999cccd, 0xffc00002, 0xffc0809f,
  0x19999998, 0x003fff81, 0xffc08002, 0xffc1009e,
  0x003fff00, 0x003f7f82, 0xffc10002, 0xffc1809d,
  0x003f7f02, 0x003eff83, 0xffc18002, 0xfff80030,
  0x003eff04, 0x003e7f84, 0xfff80002, 0xfffe8023,
  0x003e7f06, 0x0007fff1, 0xfffe8002, 0xffff0022,
  0x0007ffe0, 0x00017ffe, 0xffff0002, 0xffff8021,
  0x00017ffd, 0xffff0001, 0xffff8003, 0x00000020,
  0x0000fffe, 0xffff8001, 0x00000002, 0x00005576,
  0x00007fff, 0x00000001, 0x00008001, 0x0000aacc,
  0x00000000, 0x00008001, 0x00010000, 0x00055580,
  0xffff8001, 0x00010001, 0x0007fff2, 0x0029ab1e,
  0xffff0002, 0x00080001, 0x003e7f85, 0x002a0074,
  0xfff80010, 0x003e8001, 0x003eff84, 0x002a55ca,
  0xffc1807d, 0x003f0001, 0x003f7f83, 0x11112242,
  0xffc1007e, 0x003f8001, 0x19994ccf, 0x1c71e3ae,
  0xffc0807f, 0x19998001, 0x2aaa2aad, 0x2aaa001e,
  0xe666b333, 0x2aaa8001, 0x3ffe0005, 0x2aaa5574,
  0xd555d555, 0x3ffe8001, 0x3ffe8004, 0x2aaaaaca,
  0xc001fffd, 0x3fff0001, 0x3fff0003, 0xd5550020,
  0xc0017ffe, 0x3fff8001, 0xc0008002, 0xd5555576,
  0xc000ffff, 0xc0000001, 0xc0010001, 0xe38dc73c,
  0x3fff8000, 0xc0008001, 0xd5555558, 0xeeee88a8,
  0x3fff0001, 0xd5550001, 0xe6663336, 0xffd55520,
  0x2aaaaaaa, 0xe6660001, 0xffc00082, 0xffd5aa76,
  0x1999cccc, 0xffc00001, 0xffc08081, 0xffd5ffcc,
  0x003fff80, 0xffc08001, 0xffc10080, 0xffd65522,
  0x003f7f81, 0xffc10001, 0xffc1807f, 0xfffaaac0,
  0x003eff82, 0xffc18001, 0xfff80012, 0xffff001e,
  0x003e7f83, 0xfff80001, 0xfffe8005, 0xffff5574,
  0x0007fff0, 0xfffe8001, 0xffff0004, 0xffffaaca,
  0xfffe8000, 0xffff0003, 0xffffaaac, 0x00000020,
  0xffff0000, 0xffff8002, 0x00000002, 0x00003354,
  0xffff8000, 0x00000001, 0x00005558, 0x00006688,
  0x00000000, 0x00008000, 0x0000aaae, 0x00033360,
  0x00008000, 0x0000ffff, 0x00055562, 0x00190084,
  0x00010000, 0x0007fff1, 0x0029ab00, 0x001933b8,
  0x00080000, 0x003e7f84, 0x002a0056, 0x001966ec,
  0x003e8000, 0x003eff83, 0x002a55ac, 0x0a3d8f7c,
  0x003f0000, 0x003f7f82, 0x11112224, 0x11114464,
  0x003f8000, 0x19994cce, 0x1c71e390, 0x19996684,
  0x19998000, 0x2aaa2aac, 0x2aaa0000, 0x199999b8,
  0x2aaa8000, 0x3ffe0004, 0x2aaa5556, 0x1999ccec,
  0x3ffe8000, 0x3ffe8003, 0x2aaaaaac, 0xe6660020,
  0x3fff0000, 0x3fff0002, 0xd5550002, 0xe6663354,
  0x3fff8000, 0xc0008001, 0xd5555558, 0xeeee88a8,
  0xc0000000, 0xc0010000, 0xe38dc71e, 0xf5c23d90,
  0xc0008000, 0xd5555557, 0xeeee888a, 0xffe66620,
  0xd5550000, 0xe6663335, 0xffd55502, 0xffe69954,
  0xe6660000, 0xffc00081, 0xffd5aa58, 0xffe6cc88,
  0xffc00000, 0xffc08080, 0xffd5ffae, 0xffe6ffbc,
  0xffc08000, 0xffc1007f, 0xffd65504, 0xfffccce0,
  0xffc10000, 0xffc1807e, 0xfffaaaa2, 0xffff6684,
  0xffc18000, 0xfff80011, 0xffff0000, 0xffff99b8,
  0xfff80000, 0xfffe8004, 0xffff5556, 0xffffccec,
  0xfffe8003, 0xffff5555, 0xffffccce, 0x00000020,
  0xffff0002, 0xffffaaab, 0x00000002, 0x000000a0,
  0xffff8001, 0x00000001, 0x00003336, 0x00000120,
  0x00000000, 0x00005557, 0x0000666a, 0x00000820,
  0x00007fff, 0x0000aaad, 0x00033342, 0x00003ea0,
  0x0000fffe, 0x00055561, 0x00190066, 0x00003f20,
  0x0007fff0, 0x0029aaff, 0x0019339a, 0x00003fa0,
  0x003e7f83, 0x002a0055, 0x001966ce, 0x001999a0,
  0x003eff82, 0x002a55ab, 0x0a3d8f5e, 0x002aaaa0,
  0x003f7f81, 0x11112223, 0x11114446, 0x003ffea0,
  0x19994ccd, 0x1c71e38f, 0x19996666, 0x003fff20,
  0x2aaa2aab, 0x2aa9ffff, 0x1999999a, 0x003fffa0,
  0x3ffe0003, 0x2aaa5555, 0x1999ccce, 0xffc00020,
  0x3ffe8002, 0x2aaaaaab, 0xe6660002, 0xffc000a0,
  0x3fff0001, 0xd5550001, 0xe6663336, 0xffd55520,
  0xc0008000, 0xd5555557, 0xeeee888a, 0xffe66620,
  0xc000ffff, 0xe38dc71d, 0xf5c23d72, 0xffffc020,
  0xd5555556, 0xeeee8889, 0xffe66602, 0xffffc0a0,
  0xe6663334, 0xffd55501, 0xffe69936, 0xffffc120,
  0xffc00080, 0xffd5aa57, 0xffe6cc6a, 0xffffc1a0,
  0xffc0807f, 0xffd5ffad, 0xffe6ff9e, 0xfffff820,
  0xffc1007e, 0xffd65503, 0xfffcccc2, 0xfffffea0,
  0xffc1807d, 0xfffaaaa1, 0xffff6666, 0xffffff20,
  0xfff80010, 0xfffeffff, 0xffff999a, 0xffffffa0,
  0xfffefffe, 0xffff9999, 0xffffff82, 0x00000020,
  0xffff5554, 0xffffcccd, 0x00000002, 0x0000009f,
  0xffffaaaa, 0x00000001, 0x00000082, 0x0000011e,
  0x00000000, 0x00003335, 0x00000102, 0x00000810,
  0x00005556, 0x00006669, 0x00000802, 0x00003e23,
  0x0000aaac, 0x00033341, 0x00003e82, 0x00003ea2,
  0x00055560, 0x00190065, 0x00003f02, 0x00003f21,
  0x0029aafe, 0x00193399, 0x00003f82, 0x0019666d,
  0x002a0054, 0x001966cd, 0x00199982, 0x002a554b,
  0x002a55aa, 0x0a3d8f5d, 0x002aaa82, 0x003f7ea3,
  0x11112222, 0x11114445, 0x003ffe82, 0x003f7f22,
  0x1c71e38e, 0x19996665, 0x003fff02, 0x003f7fa1,
  0x2aa9fffe, 0x19999999, 0x003fff82, 0xffc08020,
  0x2aaa5554, 0x1999cccd, 0xffc00002, 0xffc0809f,
  0x2aaaaaaa, 0xe6660001, 0xffc00082, 0xffd5aa76,
  0xd5550000, 0xe6663335, 0xffd55502, 0xffe69954,
  0xd5555556, 0xeeee8889, 0xffe66602, 0xffffc0a0,
  0xe38dc71c, 0xf5c23d71, 0xffffc002, 0xffffc11f,
  0xeeee8888, 0xffe66601, 0xffffc082, 0xffffc19e,
  0xffd55500, 0xffe69935, 0xffffc102, 0xffffc21d,
  0xffd5aa56, 0xffe6cc69, 0xffffc182, 0xfffff830,
  0xffd5ffac, 0xffe6ff9d, 0xfffff802, 0xfffffea3,
  0xffd65502, 0xfffcccc1, 0xfffffe82, 0xffffff22,
  0xfffaaaa0, 0xffff6665, 0xffffff02, 0xffffffa1,
  0xffff6664, 0xffffff01, 0xffffff83, 0x00000020,
  0xffff9998, 0xffffff81, 0x00000002, 0x0000009e,
  0xffffcccc, 0x00000001, 0x00000081, 0x0000011c,
  0x00000000, 0x00000081, 0x00000100, 0x00000800,
  0x00003334, 0x00000101, 0x000007f2, 0x00003da6,
  0x00006668, 0x00000801, 0x00003e05, 0x00003e24,
  0x00033340, 0x00003e81, 0x00003e84, 0x00003ea2,
  0x00190064, 0x00003f01, 0x00003f03, 0x0019333a,
  0x00193398, 0x00003f81, 0x0019664f, 0x0029fff6,
  0x001966cc, 0x00199981, 0x002a552d, 0x003efea6,
  0x0a3d8f5c, 0x002aaa81, 0x003f7e85, 0x003eff24,
  0x11114444, 0x003ffe81, 0x003f7f04, 0x003effa2,
  0x19996664, 0x003fff01, 0x003f7f83, 0xffc10020,
  0x19999998, 0x003fff81, 0xffc08002, 0xffc1009e,
  0x1999cccc, 0xffc00001, 0xffc08081, 0xffd5ffcc,
  0xe6660000, 0xffc00081, 0xffd5aa58, 0xffe6cc88,
  0xe6663334, 0xffd55501, 0xffe69936, 0xffffc120,
  0xeeee8888, 0xffe66601, 0xffffc082, 0xffffc19e,
  0xf5c23d70, 0xffffc001, 0xffffc101, 0xffffc21c,
  0xffe66600, 0xffffc081, 0xffffc180, 0xffffc29a,
  0xffe69934, 0xffffc101, 0xffffc1ff, 0xfffff840,
  0xffe6cc68, 0xffffc181, 0xfffff812, 0xfffffea6,
  0xffe6ff9c, 0xfffff801, 0xfffffe85, 0xffffff24,
  0xfffcccc0, 0xfffffe81, 0xffffff04, 0xffffffa2,
  0xfffffe80, 0xffffff03, 0xffffff84, 0x00000020,
  0xffffff00, 0xffffff82, 0x00000002, 0x0000009d,
  0xffffff80, 0x00000001, 0x00000080, 0x0000011a,
  0x00000000, 0x00000080, 0x000000fe, 0x000007f0,
  0x00000080, 0x000000ff, 0x000007e2, 0x00003d29,
  0x00000100, 0x000007f1, 0x00003d88, 0x00003da6,
  0x00000800, 0x00003e04, 0x00003e06, 0x00003e23,
  0x00003e80, 0x00003e83, 0x00003e84, 0x00190007,
  0x00003f00, 0x00003f02, 0x0019331c, 0x0029aaa1,
  0x00003f80, 0x0019664e, 0x0029ffd8, 0x003e7ea9,
  0x00199980, 0x002a552c, 0x003efe88, 0x003e7f26,
  0x002aaa80, 0x003f7e84, 0x003eff06, 0x003e7fa3,
  0x003ffe80, 0x003f7f03, 0x003eff84, 0xffc18020,
  0x003fff00, 0x003f7f82, 0xffc10002, 0xffc1809d,
  0x003fff80, 0xffc08001, 0xffc10080, 0xffd65522,
  0xffc00000, 0xffc08080, 0xffd5ffae, 0xffe6ffbc,
  0xffc00080, 0xffd5aa57, 0xffe6cc6a, 0xffffc1a0,
  0xffd55500, 0xffe69935, 0xffffc102, 0xffffc21d,
  0xffe66600, 0xffffc081, 0xffffc180, 0xffffc29a,
  0xffffc000, 0xffffc100, 0xffffc1fe, 0xffffc317,
  0xffffc080, 0xffffc17f, 0xffffc27c, 0xfffff850,
  0xffffc100, 0xffffc1fe, 0xfffff822, 0xfffffea9,
  0xffffc180, 0xfffff811, 0xfffffe88, 0xffffff26,
  0xfffff800, 0xfffffe84, 0xffffff06, 0xffffffa3,
  0xfffffe83, 0xffffff05, 0xffffff85, 0x00000020,
  0xffffff02, 0xffffff83, 0x00000002, 0x00000030,
  0xffffff81, 0x00000001, 0x0000007f, 0x00000040,
  0x00000000, 0x0000007f, 0x000000fc, 0x00000120,
  0x0000007f, 0x000000fd, 0x000007d2, 0x000007f0,
  0x000000fe, 0x000007e1, 0x00003d0b, 0x00000800,
  0x000007f0, 0x00003d87, 0x00003d88, 0x00000810,
  0x00003e03, 0x00003e05, 0x00003e05, 0x00033350,
  0x00003e82, 0x00003e83, 0x0018ffe9, 0x00055570,
  0x00003f01, 0x0019331b, 0x0029aa83, 0x0007fff0,
  0x0019664d, 0x0029ffd7, 0x003e7e8b, 0x00080000,
  0x002a552b, 0x003efe87, 0x003e7f08, 0x00080010,
  0x003f7e83, 0x003eff05, 0x003e7f85, 0xfff80020,
  0x003f7f02, 0x003eff83, 0xffc18002, 0xfff80030,
  0x003f7f81, 0xffc10001, 0xffc1807f, 0xfffaaac0,
  0xffc08000, 0xffc1007f, 0xffd65504, 0xfffccce0,
  0xffc0807f, 0xffd5ffad, 0xffe6ff9e, 0xfffff820,
  0xffd5aa56, 0xffe6cc69, 0xffffc182, 0xfffff830,
  0xffe69934, 0xffffc101, 0xffffc1ff, 0xfffff840,
  0xffffc080, 0xffffc17f, 0xffffc27c, 0xfffff850,
  0xffffc0ff, 0xffffc1fd, 0xffffc2f9, 0xffffff20,
  0xffffc17e, 0xffffc27b, 0xfffff832, 0xfffffff0,
  0xffffc1fd, 0xfffff821, 0xfffffe8b, 0x00000000,
  0xfffff810, 0xfffffe87, 0xffffff08, 0x00000010,
  0xfffffe86, 0xffffff07, 0xfffffff2, 0x00000020,
  0xffffff04, 0xffffff84, 0x00000002, 0x00000023,
  0xffffff82, 0x00000001, 0x00000012, 0x00000026,
  0x00000000, 0x0000007e, 0x00000022, 0x00000050,
  0x0000007e, 0x000000fb, 0x00000102, 0x00000197,
  0x000000fc, 0x000007d1, 0x000007d2, 0x0000019a,
  0x000007e0, 0x00003d0a, 0x000007e2, 0x0000019d,
  0x00003d86, 0x00003d87, 0x000007f2, 0x000099b9,
  0x00003e04, 0x00003e04, 0x00033332, 0x0001001f,
  0x00003e82, 0x0018ffe8, 0x00055552, 0x00018017,
  0x0019331a, 0x0029aa82, 0x0007ffd2, 0x0001801a,
  0x0029ffd6, 0x003e7e8a, 0x0007ffe2, 0x0001801d,
  0x003efe86, 0x003e7f07, 0x0007fff2, 0xfffe8020,
  0x003eff04, 0x003e7f84, 0xfff80002, 0xfffe8023,
  0x003eff82, 0xffc18001, 0xfff80012, 0xffff001e,
  0xffc10000, 0xffc1807e, 0xfffaaaa2, 0xffff6684,
  0xffc1007e, 0xffd65503, 0xfffcccc2, 0xfffffea0,
  0xffd5ffac, 0xffe6ff9d, 0xfffff802, 0xfffffea3,
  0xffe6cc68, 0xffffc181, 0xfffff812, 0xfffffea6,
  0xffffc100, 0xffffc1fe, 0xfffff822, 0xfffffea9,
  0xffffc17e, 0xffffc27b, 0xfffff832, 0xfffffff0,
  0xffffc1fc, 0xffffc2f8, 0xffffff02, 0x00000017,
  0xffffc27a, 0xfffff831, 0xffffffd2, 0x0000001a,
  0xfffff820, 0xfffffe8a, 0xffffffe2, 0x0000001d,
  0xfffffe89, 0xffffffe1, 0xffffffff, 0x00000020,
  0xffffff06, 0xfffffff1, 0x00000002, 0x00000022,
  0xffffff83, 0x00000001, 0x00000005, 0x00000024,
  0x00000000, 0x00000011, 0x00000008, 0x00000040,
  0x0000007d, 0x00000021, 0x00000032, 0x0000011a,
  0x000000fa, 0x00000101, 0x00000179, 0x0000011c,
  0x000007d0, 0x000007d1, 0x0000017c, 0x0000011e,
  0x00003d09, 0x000007e1, 0x0000017f, 0x00006686,
  0x00003d86, 0x000007f1, 0x0000999b, 0x0000aaca,
  0x00003e03, 0x00033331, 0x00010001, 0x0001001a,
  0x0018ffe7, 0x00055551, 0x00017ff9, 0x0001001c,
  0x0029aa81, 0x0007ffd1, 0x00017ffc, 0x0001001e,
  0x003e7e89, 0x0007ffe1, 0x00017fff, 0xffff0020,
  0x003e7f06, 0x0007fff1, 0xfffe8002, 0xffff0022,
  0x003e7f83, 0xfff80001, 0xfffe8005, 0xffff5574,
  0xffc18000, 0xfff80011, 0xffff0000, 0xffff99b8,
  0xffc1807d, 0xfffaaaa1, 0xffff6666, 0xffffff20,
  0xffd65502, 0xfffcccc1, 0xfffffe82, 0xffffff22,
  0xffe6ff9c, 0xfffff801, 0xfffffe85, 0xffffff24,
  0xffffc180, 0xfffff811, 0xfffffe88, 0xffffff26,
  0xffffc1fd, 0xfffff821, 0xfffffe8b, 0x00000000,
  0xffffc27a, 0xfffff831, 0xffffffd2, 0x0000001a,
  0xffffc2f7, 0xffffff01, 0xfffffff9, 0x0000001c,
  0xfffff830, 0xffffffd1, 0xfffffffc, 0x0000001e,
  0xffffffd0, 0xfffffffb, 0x00000000, 0x00000020,
  0xffffffe0, 0xfffffffe, 0x00000002, 0x00000021,
  0xfffffff0, 0x00000001, 0x00000004, 0x00000022,
  0x00000000, 0x00000004, 0x00000006, 0x00000030,
  0x00000010, 0x00000007, 0x00000022, 0x0000009d,
  0x00000020, 0x00000031, 0x000000fc, 0x0000009e,
  0x00000100, 0x00000178, 0x000000fe, 0x0000009f,
  0x000007d0, 0x0000017b, 0x00000100, 0x00003353,
  0x000007e0, 0x0000017e, 0x00006668, 0x00005575,
  0x000007f0, 0x0000999a, 0x0000aaac, 0x0000801d,
  0x00033330, 0x00010000, 0x0000fffc, 0x0000801e,
  0x00055550, 0x00017ff8, 0x0000fffe, 0x0000801f,
  0x0007ffd0, 0x00017ffb, 0x00010000, 0xffff8020,
  0x0007ffe0, 0x00017ffe, 0xffff0002, 0xffff8021,
  0x0007fff0, 0xfffe8001, 0xffff0004, 0xffffaaca,
  0xfff80000, 0xfffe8004, 0xffff5556, 0xffffccec,
  0xfff80010, 0xfffeffff, 0xffff999a, 0xffffffa0,
  0xfffaaaa0, 0xffff6665, 0xffffff02, 0xffffffa1,
  0xfffcccc0, 0xfffffe81, 0xffffff04, 0xffffffa2,
  0xfffff800, 0xfffffe84, 0xffffff06, 0xffffffa3,
  0xfffff810, 0xfffffe87, 0xffffff08, 0x00000010,
  0xfffff820, 0xfffffe8a, 0xffffffe2, 0x0000001d,
  0xfffff830, 0xffffffd1, 0xfffffffc, 0x0000001e,
  0xffffff00, 0xfffffff8, 0xfffffffe, 0x0000001f,
};
const unsigned kExpectedCount_NEON_smlsl2_4S = 576;

#endif  // VIXL_SIM_SMLSL2_4S_TRACE_AARCH64_H_
