/*
 * Copyright (C) 2015-2019 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#if ENABLE(MEDIA_STREAM)

#include <WebCore/CaptureDevice.h>
#include <WebCore/ContextDestructionObserver.h>
#include <WebCore/ScriptWrappable.h>
#include <wtf/text/WTFString.h>

namespace WebCore {

class MediaDeviceInfo : public RefCounted<MediaDeviceInfo>, public ScriptWrappable {
    WTF_MAKE_TZONE_ALLOCATED(MediaDeviceInfo);
public:
    enum class Kind { Audioinput, Audiooutput, Videoinput };

    static Ref<MediaDeviceInfo> create(const String&, const String&, const String&, Kind);
    virtual ~MediaDeviceInfo() = default;

    const String& label() const { return m_label; }
    const String& deviceId() const { return m_deviceId; }
    const String& groupId() const { return m_groupId; }
    Kind kind() const { return m_kind; }

    virtual bool isInputDeviceInfo() const { return false; }

protected:
    MediaDeviceInfo(const String&, const String&, const String&, Kind);

private:
    const String m_label;
    const String m_deviceId;
    const String m_groupId;
    const Kind m_kind;
};

MediaDeviceInfo::Kind toMediaDeviceInfoKind(CaptureDevice::DeviceType);

} // namespace WebCore

#endif
