-- WORDS, a Latin dictionary, by Colonel William Whitaker (USAF, Retired)
--
-- Copyright William A. Whitaker (1936–2010)
--
-- This is a free program, which means it is proper to copy it and pass
-- it on to your friends. Consider it a developmental item for which
-- there is no charge. However, just for form, it is Copyrighted
-- (c). Permission is hereby freely given for any and all use of program
-- and data. You can sell it as your own, but at least tell me.
--
-- This version is distributed without obligation, but the developer
-- would appreciate comments and suggestions.
--
-- All parts of the WORDS system, source code and data files, are made freely
-- available to anyone who wishes to use them, for whatever purpose.

with Latin_Utils.Dictionary_Package;

   ---------------------------------------------------------------------------
   -- The purpose of this package is to provide common functionality used across
   -- multiple main files that doesn't fit in other files due to dependency
   -- graphs and/or functionality.
   ---------------------------------------------------------------------------

package Latin_Utils.General is

   ---------------------------------------------------------------------------
   -- Interactively loads dictionary (either special or general)
   -- Used by makedict_main, makeewds, makestem
   procedure Load_Dictionary
      (Line : in out String;
       Last : in out Integer;
       D_K  :    out Latin_Utils.Dictionary_Package.Dictionary_Kind
      );

   ---------------------------------------------------------------------------

end Latin_Utils.General;
