/* SPDX-License-Identifier: (GPL-2.0 OR MIT) */
/*
 * Copyright (c) 2025 Collabora Ltd
 *                    AngeloGioacchino Del Regno <angelogioacchino.delregno@collabora.com>
 */

#ifndef _DT_BINDINGS_POWER_MT8196_POWER_H
#define _DT_BINDINGS_POWER_MT8196_POWER_H

/* SCPSYS Secure Power Manager - Direct Control */
#define MT8196_POWER_DOMAIN_MD				0
#define MT8196_POWER_DOMAIN_CONN			1
#define MT8196_POWER_DOMAIN_SSUSB_P0			2
#define MT8196_POWER_DOMAIN_SSUSB_DP_PHY_P0		3
#define MT8196_POWER_DOMAIN_SSUSB_P1			4
#define MT8196_POWER_DOMAIN_SSUSB_P23			5
#define MT8196_POWER_DOMAIN_SSUSB_PHY_P2		6
#define MT8196_POWER_DOMAIN_PEXTP_MAC0			7
#define MT8196_POWER_DOMAIN_PEXTP_MAC1			8
#define MT8196_POWER_DOMAIN_PEXTP_MAC2			9
#define MT8196_POWER_DOMAIN_PEXTP_PHY0			10
#define MT8196_POWER_DOMAIN_PEXTP_PHY1			11
#define MT8196_POWER_DOMAIN_PEXTP_PHY2			12
#define MT8196_POWER_DOMAIN_AUDIO			13
#define MT8196_POWER_DOMAIN_ADSP_TOP_DORMANT		14
#define MT8196_POWER_DOMAIN_ADSP_INFRA			15
#define MT8196_POWER_DOMAIN_ADSP_AO			16

/* SCPSYS Secure Power Manager - HW Voter */
#define MT8196_POWER_DOMAIN_MM_PROC_DORMANT		0
#define MT8196_POWER_DOMAIN_SSR				1

/* HFRPSYS MultiMedia Power Control (MMPC) - HW Voter */
#define MT8196_POWER_DOMAIN_VDE0			0
#define MT8196_POWER_DOMAIN_VDE1			1
#define MT8196_POWER_DOMAIN_VDE_VCORE0			2
#define MT8196_POWER_DOMAIN_VEN0			3
#define MT8196_POWER_DOMAIN_VEN1			4
#define MT8196_POWER_DOMAIN_VEN2			5
#define MT8196_POWER_DOMAIN_DISP_VCORE			6
#define MT8196_POWER_DOMAIN_DIS0_DORMANT		7
#define MT8196_POWER_DOMAIN_DIS1_DORMANT		8
#define MT8196_POWER_DOMAIN_OVL0_DORMANT		9
#define MT8196_POWER_DOMAIN_OVL1_DORMANT		10
#define MT8196_POWER_DOMAIN_DISP_EDPTX_DORMANT		11
#define MT8196_POWER_DOMAIN_DISP_DPTX_DORMANT		12
#define MT8196_POWER_DOMAIN_MML0_SHUTDOWN		13
#define MT8196_POWER_DOMAIN_MML1_SHUTDOWN		14
#define MT8196_POWER_DOMAIN_MM_INFRA0			15
#define MT8196_POWER_DOMAIN_MM_INFRA1			16
#define MT8196_POWER_DOMAIN_MM_INFRA_AO			17
#define MT8196_POWER_DOMAIN_CSI_BS_RX			18
#define MT8196_POWER_DOMAIN_CSI_LS_RX			19
#define MT8196_POWER_DOMAIN_DSI_PHY0			20
#define MT8196_POWER_DOMAIN_DSI_PHY1			21
#define MT8196_POWER_DOMAIN_DSI_PHY2			22

#endif /* _DT_BINDINGS_POWER_MT8196_POWER_H */
