/*****************************************************************************
 * crc32.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2007 Greg Hosler
 * ghosler ['at'] users.sourceforge.net
 *
 * This program based upon:
 *
 *  * efone - Distributed internet phone system.
 *  *
 *  * (c) 1999,2000 Krzysztof Dabrowski
 *  * (c) 1999,2000 ElysiuM deeZine
 *  *
 *  * This program is free software; you can redistribute it and/or
 *  * modify it under the terms of the GNU General Public License
 *  * as published by the Free Software Foundation; either version
 *  * 2 of the License, or (at your option) any later version.
 *  *
 *  */

/* based on implementation by Finn Yannick Jacobs */

#include "crc32.h"

/* crc_tab[] -- this crcTable is being build by chksum_crc32GenTab().
 *  *		so make sure, you call it before using the other
 *  *		functions!
 *  */
crc32_t crc_tab[256];
int     crc_tab_generated = 0;

/* forward declarations */
void chksum_crc32gentab();

/* chksum_crc() -- to a given block, this one calculates the
 *  *			crc32-checksum until the length is
 *  *			reached. the crc32-checksum will be
 *  *			the result.
 *  */
crc32_t gyachi_crc32_update(crc32_t crc, const unsigned char *block, size_t length)
{
	if (!crc_tab_generated) chksum_crc32gentab();

	for (; length>0; length--) {
		crc = ((crc >> 8) & 0x00FFFFFF) ^ crc_tab[(crc ^ *block++) & 0xFF];
	}
	return (crc);
}

crc32_t gyachi_crc32(const unsigned char *block, size_t length)
{
	crc32_t crc;
	crc = 0xFFFFFFFF;
	crc = gyachi_crc32_update(crc, block, length);
	return (crc ^ 0xFFFFFFFF);
}

/* chksum_crc32gentab() --      to a global crc_tab[256], this one will
 *  *				calculate the crcTable for crc32-checksums.
 *  *				it is generated to the polynom [..]
 *  */

void chksum_crc32gentab ()
{
	crc32_t crc, poly;
	int i, j;

	if (crc_tab_generated) return;

	poly = 0xEDB88320L;
	for (i = 0; i < 256; i++) {
		crc = i;
		for (j = 8; j > 0; j--) {
			if (crc & 1) {
				crc = (crc >> 1) ^ poly;
			}
			else {
				crc >>= 1;
			}
		}
		crc_tab[i] = crc;
	}

	crc_tab_generated = 1;
}


