# Copyright (C) 2009 Loell Anthony Erecre
#
# This script is free software; you can redistribute it and/or
# modify it under the terms of version 2.1 of the GNU Lesser General Public
# License as published by the Free Software Foundation.
#
# This script is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#!/usr/bin/env python


import pygtk
pygtk.require('2.0')
import gtk
import os
import gconf


class gyachi_encoder:

   
    def encode(self, widget, data=None):
	 
	
        path = self.dialog.get_current_folder_uri().replace('file://','')
	
	FramesPerSecond = self.spinbutton_frames.get_value()
	
	print  '>>', int(FramesPerSecond)
	
	os.chdir(path)
	StrCommand = 'mencoder -ovc lavc -mf fps='+ str( int(FramesPerSecond) ) +':type=jpg mf://*.jpg -o gyachi-webcam.avi'
	answer = os.system(StrCommand)
	if answer >0:
		msg =gtk.MessageDialog(self.window, gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE, "There was an error, Failed to encode the images")
		msg.show_all()
		msg.connect("response", lambda *a: msg.destroy())
	else:
		msg =gtk.MessageDialog(self.window, gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, "The images were encoded in "+ path +"/gyachi-webcam.avi file")
		msg.show_all()
		msg.connect("response", lambda *a: msg.destroy())
		
    def delete_jpegs(self, widget, data=None):
	path = self.dialog.get_current_folder_uri().replace('file://','')
	StrCommand = 'rm ' + path +'/*-*-*-*-*-*.jpg'
	answer = os.system(StrCommand)
	if answer >0:
		msg =gtk.MessageDialog(self.window, gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE, "There was an error, Failed to delete images")
		msg.show_all()
		msg.connect("response", lambda *a: msg.destroy())
	else:
		msg =gtk.MessageDialog(self.window, gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, "The images were were deleted")
		msg.show_all()
		msg.connect("response", lambda *a: msg.destroy())
    
    
    def folder_change(self, widget, data=None):
	    #print '>> trigger'
	    self.gconf_client.set_string("/apps/gyachi-encoder/default-path", self.dialog.get_current_folder_uri().replace('file://','') )
    
    
    
    
    def delete_event(self, widget, event, data=None):
        
        print "delete event occurred"

        
        return False

    def destroy(self, widget, data=None):
        print "destroy signal occurred"
        gtk.main_quit()

    def __init__(self):
      
	
		
		
		
	# create a new window
        self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
	self.window.set_resizable(False)
	self.window.set_title("Gyachi webcam encoder")
	
	#self.window.resize(300,50)
        self.vbox1 = gtk.VBox(True,0)
	self.hbox_dir = gtk.HBox(True,0)
	self.hbox_frames  = gtk.HBox(True,0)
	self.dialog = gtk.FileChooserDialog(action=gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER,buttons = (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL, gtk.STOCK_OPEN, gtk.RESPONSE_ACCEPT))
        self.button = gtk.FileChooserButton(self.dialog)
	self.dir_label = gtk.Label("Webcam Folder:")
	self.dir_label.justify = gtk.JUSTIFY_LEFT
	self.label_frames = gtk.Label("Frames Per Second:")
	self.label_frames.justify = gtk.JUSTIFY_LEFT
	
	self.spinbutton_frames =   gtk.SpinButton( gtk.Adjustment(3, 3, 30, 1) ,1,0)
	
	print '----', self.dialog.get_current_folder_uri()
	
	# get gconf settings
	self.gconf_client = gconf.client_get_default()
	self.default_folder = self.gconf_client.get_string("/apps/gyachi-encoder/default-path")
	if  not self.default_folder: 
		self.default_folder  = self.dialog.get_current_folder_uri().replace('file://','')
		self.gconf_client.set_string("/apps/gyachi-encoder/default-path", self.default_folder )
	else:
		
		self.button.set_current_folder(self.default_folder)
	
	#print '>>>', self.default_folder
	#print '>>>>>', self.dialog.get_current_folder()
	
	
        self.window.connect("delete_event", self.delete_event)
	
    
        
        self.window.connect("destroy", self.destroy)
    
        # Sets the border width of the window.
        self.window.set_border_width(10)
    
       
	self.button_encode = gtk.Button("Encode Frames to AVI")
	self.button_remove = gtk.Button("Remove Frames")
	self.button_encode.connect("clicked", self.encode)
	self.button_remove.connect("clicked", self.delete_jpegs)
        self.button.connect("current-folder-changed", self.folder_change)
    
        
        self.hbox_dir.pack_start(self.dir_label)
	self.hbox_dir.pack_start(self.button)
	
	self.hbox_frames.pack_start(self.label_frames)
	
	self.hbox_frames.pack_start(self.spinbutton_frames)
	
	self.vbox1.pack_start(self.hbox_dir)
	self.vbox1.pack_start(self.hbox_frames)
	self.vbox1.pack_start(self.button_encode)
	self.vbox1.pack_start(self.button_remove)
	self.window.add(self.vbox1)
      
   
        
        # The final step is to display this newly created widgets.
	self.dir_label.show()
	self.label_frames.show()
	self.spinbutton_frames.show()
	self.button_encode.show()
	self.button_remove.show()
        self.button.show()
	self.hbox_frames.show()
	self.hbox_dir.show()
	self.vbox1.show()
    
        # and the window
        self.window.show()

    def main(self):
        
        gtk.main()



if __name__ == "__main__":
    enc = gyachi_encoder()
    enc.main()
