/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#include <connectivity/virtualdbtools.hxx>
#include "staticdbtools_s.hxx"
#include <connectivity/dbconversion.hxx>
#include <connectivity/dbtools.hxx>
#include <com/sun/star/sdb/SQLContext.hpp>


namespace connectivity
{


    using namespace ::com::sun::star::util;
    using namespace ::com::sun::star::uno;
    using namespace ::com::sun::star::sdb;
    using namespace ::com::sun::star::lang;
    using namespace ::com::sun::star::sdbc;
    using namespace ::com::sun::star::beans;
    using namespace ::com::sun::star::container;


    //= ODataAccessStaticTools


    ODataAccessStaticTools::ODataAccessStaticTools()
    {
    }


    Date ODataAccessStaticTools::getStandardDate() const
    {
        return ::dbtools::DBTypeConversion::getStandardDate();
    }


    double ODataAccessStaticTools::getValue(const Reference< XColumn>& _rxVariant, const Date& rNullDate ) const
    {
        return ::dbtools::DBTypeConversion::getValue( _rxVariant, rNullDate );
    }


    OUString ODataAccessStaticTools::getFormattedValue(const Reference< XColumn >& _rxColumn, const Reference< XNumberFormatter >& _rxFormatter,
        const Date& _rNullDate, sal_Int32 _nKey, sal_Int16 _nKeyType) const
    {
        return ::dbtools::DBTypeConversion::getFormattedValue(_rxColumn, _rxFormatter, _rNullDate, _nKey, _nKeyType);
    }


    OUString ODataAccessStaticTools::getFormattedValue( const Reference< XPropertySet>& _rxColumn, const Reference< XNumberFormatter>& _rxFormatter,
        const Locale& _rLocale, const Date& _rNullDate ) const
    {
        return ::dbtools::DBTypeConversion::getFormattedValue( _rxColumn, _rxFormatter, _rLocale, _rNullDate );
    }


    Reference< XConnection> ODataAccessStaticTools::getConnection_withFeedback(const OUString& _rDataSourceName, const OUString& _rUser,
        const OUString& _rPwd, const Reference< XComponentContext>& _rxContext) const
    {
        return ::dbtools::getConnection_withFeedback(_rDataSourceName, _rUser, _rPwd, _rxContext);
    }


    Reference< XConnection> ODataAccessStaticTools::connectRowset(const Reference< XRowSet>& _rxRowSet, const Reference< XComponentContext >& _rxContext, bool _bSetAsActiveConnection) const
    {
        return ::dbtools::connectRowset( _rxRowSet, _rxContext, _bSetAsActiveConnection);
    }


    Reference< XConnection> ODataAccessStaticTools::getRowSetConnection(
                const Reference< XRowSet>& _rxRowSet)
                const
    {
        return ::dbtools::getConnection(_rxRowSet);
    }


    Reference< XNumberFormatsSupplier> ODataAccessStaticTools::getNumberFormats(const Reference< XConnection>& _rxConn, bool _bAllowDefault) const
    {
        return ::dbtools::getNumberFormats(_rxConn, _bAllowDefault);
    }


    sal_Int32 ODataAccessStaticTools::getDefaultNumberFormat( const Reference< XPropertySet >& _rxColumn, const Reference< XNumberFormatTypes >& _rxTypes,
        const Locale& _rLocale ) const
    {
        return ::dbtools::getDefaultNumberFormat( _rxColumn, _rxTypes, _rLocale );
    }


    void ODataAccessStaticTools::TransferFormComponentProperties(const Reference< XPropertySet>& _rxOld, const Reference< XPropertySet>& _rxNew, const Locale& _rLocale) const
    {
        ::dbtools::TransferFormComponentProperties(_rxOld, _rxNew, _rLocale);
    }


    OUString ODataAccessStaticTools::quoteName(const OUString& _rQuote, const OUString& _rName) const
    {
        return ::dbtools::quoteName(_rQuote, _rName);
    }


    OUString ODataAccessStaticTools::composeTableNameForSelect( const Reference< XConnection >& _rxConnection, const OUString& _rCatalog, const OUString& _rSchema, const OUString& _rName ) const
    {
        return ::dbtools::composeTableNameForSelect( _rxConnection, _rCatalog, _rSchema, _rName );
    }


    OUString ODataAccessStaticTools::composeTableNameForSelect( const Reference< XConnection >& _rxConnection, const Reference< XPropertySet>& _xTable ) const
    {
        return ::dbtools::composeTableNameForSelect( _rxConnection, _xTable );
    }


    SQLContext ODataAccessStaticTools::prependContextInfo(SQLException& _rException, const Reference< XInterface >& _rxContext,
        const OUString& _rContextDescription, const OUString& _rContextDetails) const
    {
        return ::dbtools::prependContextInfo(_rException, _rxContext, _rContextDescription, _rContextDetails);
    }


    Reference< XDataSource > ODataAccessStaticTools::getDataSource( const OUString& _rsRegisteredName, const Reference< XComponentContext>& _rxContext ) const
    {
        return ::dbtools::getDataSource( _rsRegisteredName, _rxContext );
    }


    bool ODataAccessStaticTools::canInsert(const Reference< XPropertySet>& _rxCursorSet) const
    {
        return ::dbtools::canInsert( _rxCursorSet );
    }


    bool ODataAccessStaticTools::canUpdate(const Reference< XPropertySet>& _rxCursorSet) const
    {
        return ::dbtools::canUpdate( _rxCursorSet );
    }


    bool ODataAccessStaticTools::canDelete(const Reference< XPropertySet>& _rxCursorSet) const
    {
        return ::dbtools::canDelete( _rxCursorSet );
    }


    Reference< XNameAccess > ODataAccessStaticTools::getFieldsByCommandDescriptor( const Reference< XConnection >& _rxConnection,
        const sal_Int32 _nCommandType, const OUString& _rCommand,
            Reference< XComponent >& _rxKeepFieldsAlive, ::dbtools::SQLExceptionInfo* _pErrorInfo )
    {
        return ::dbtools::getFieldsByCommandDescriptor( _rxConnection, _nCommandType, _rCommand,
            _rxKeepFieldsAlive, _pErrorInfo );
    }


    Sequence< OUString > ODataAccessStaticTools::getFieldNamesByCommandDescriptor(
        const Reference< XConnection >& _rxConnection, const sal_Int32 _nCommandType,
        const OUString& _rCommand, ::dbtools::SQLExceptionInfo* _pErrorInfo )
    {
        return ::dbtools::getFieldNamesByCommandDescriptor( _rxConnection, _nCommandType,
            _rCommand, _pErrorInfo );
    }


    bool ODataAccessStaticTools::isEmbeddedInDatabase( const Reference< XInterface >& _rxComponent, Reference< XConnection >& _rxActualConnection )
    {
        return ::dbtools::isEmbeddedInDatabase( _rxComponent, _rxActualConnection );
    }


}   // namespace connectivity


/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
