/* -*- Mode: vala; tab-width: 4; intend-tabs-mode: t -*- */
/* alm
 *
 * Copyright (C) 2012 Canonical
 *		  Authored by: Didier Roche <didrocks@ubuntu.com>
 *
 * alm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * alm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

using Gtk;

namespace Alm {

	public class SearchResultsWidget : Gtk.Box {

	private GLib.Settings gp_settings;
	private const string REMOTE_CONTENT_KEY = "remote-content-search";

	public enum RemoteContent
	{
		ALL,
		NONE,
	}

	Switch commercial_suggestion;

	public SearchResultsWidget () {
		Object (orientation: Orientation.VERTICAL);
		this.spacing = 0;
		this.set_border_width(12);

		this.gp_settings = new GLib.Settings ("com.canonical.Unity.Lenses");
		this.gp_settings.bind (REMOTE_CONTENT_KEY, this, "remote-content-search", SettingsBindFlags.DEFAULT);

		this.set_up_ui ();
	}

	public RemoteContent remote_content_search { get; set; default = RemoteContent.ALL; }


		public void set_up_ui () {
			var top_box = new Box(Orientation.HORIZONTAL, 21);
			top_box.set_margin_top(9);
			this.pack_start(top_box, false, false);

			var text_box = new Box(Orientation.VERTICAL, 0);
			var header = new Label("");
			header.set_markup("<b>%s</b>".printf(_("When searching in the Dash:")));
			header.set_alignment(0, (float)0.5);
			header.set_padding(0, 0);

			text_box.pack_start(header, false, false);

			var label = new Label(null);
			label.set_markup("%s".printf(_("Include online search results")));
			label.set_line_wrap(true);
			label.set_line_wrap_mode(Pango.WrapMode.WORD);
			label.set_alignment(0, 0.5f);
			text_box.pack_start(label, false, false, 6);
			top_box.pack_start(text_box, false, false);

			commercial_suggestion = new Switch();
			if (this.remote_content_search == RemoteContent.ALL)
				commercial_suggestion.set_active(true);
			commercial_suggestion.notify["active"].connect(on_commercial_suggestion_activated);

			var temp_box = new Box(Orientation.VERTICAL, 0);
			temp_box.pack_start(new Label(""), true, true);
			temp_box.pack_start(commercial_suggestion, false, false);
			temp_box.pack_start(new Label(""), true, true);
			top_box.pack_end(temp_box, false, false);

		}

	public void on_commercial_suggestion_activated() {
		if (this.commercial_suggestion.get_active())
		{
			this.remote_content_search = RemoteContent.ALL;
		}
		else
		{
			this.remote_content_search = RemoteContent.NONE;
		}
	}

	}
}
