/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2021 Marvell
 */

#ifndef TEST_CRYPTODEV_SECURITY_IPSEC_TEST_VECTORS_H_
#define TEST_CRYPTODEV_SECURITY_IPSEC_TEST_VECTORS_H_

#include <rte_crypto.h>
#include <rte_security.h>

#include "test_cryptodev_security_ipsec.h"

/*
 * Known vectors
 *
 * AES-GCM vectors are based on :
 * https://datatracker.ietf.org/doc/html/draft-mcgrew-gcm-test-01
 *
 * Vectors are updated to have corrected L4 checksum and sequence number 1.
 */

struct ipsec_test_data pkt_aes_128_gcm = {
	.key = {
		.data = {
			0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
			0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08
		},
	},
	.input_text = {
		.data = {
			/* IP */
			0x45, 0x00, 0x00, 0x3e, 0x69, 0x8f, 0x00, 0x00,
			0x80, 0x11, 0x4d, 0xcc, 0xc0, 0xa8, 0x01, 0x02,
			0xc0, 0xa8, 0x01, 0x01,

			/* UDP */
			0x0a, 0x98, 0x00, 0x35, 0x00, 0x2a, 0x23, 0x43,
			0xb2, 0xd0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x73, 0x69, 0x70,
			0x09, 0x63, 0x79, 0x62, 0x65, 0x72, 0x63, 0x69,
			0x74, 0x79, 0x02, 0x64, 0x6b, 0x00, 0x00, 0x01,
			0x00, 0x01,
		},
		.len = 62,
	},
	.output_text = {
		.data = {
			/* IP - outer header */
			0x45, 0x00, 0x00, 0x74, 0x69, 0x8f, 0x00, 0x00,
			0x80, 0x32, 0x4d, 0x75, 0xc0, 0xa8, 0x01, 0x02,
			0xc0, 0xa8, 0x01, 0x01,

			/* ESP */
			0x00, 0x00, 0xa5, 0xf8, 0x00, 0x00, 0x00, 0x01,

			/* IV */
			0xfa, 0xce, 0xdb, 0xad, 0xde, 0xca, 0xf8, 0x88,

			/* Data */
			0xde, 0xb2, 0x2c, 0xd9, 0xb0, 0x7c, 0x72, 0xc1,
			0x6e, 0x3a, 0x65, 0xbe, 0xeb, 0x8d, 0xf3, 0x04,
			0xa5, 0xa5, 0x89, 0x7d, 0x33, 0xae, 0x53, 0x0f,
			0x1b, 0xa7, 0x6d, 0x5d, 0x11, 0x4d, 0x2a, 0x5c,
			0x3d, 0xe8, 0x18, 0x27, 0xc1, 0x0e, 0x9a, 0x4f,
			0x51, 0x33, 0x0d, 0x0e, 0xec, 0x41, 0x66, 0x42,
			0xcf, 0xbb, 0x85, 0xa5, 0xb4, 0x7e, 0x48, 0xa4,
			0xec, 0x3b, 0x9b, 0xa9, 0x5d, 0x91, 0x8b, 0xd4,
			0x29, 0xc7, 0x37, 0x57, 0x9f, 0xf1, 0x9e, 0x58,
			0xcf, 0xfc, 0x60, 0x7a, 0x3b, 0xce, 0x89, 0x94,

		},
		.len = 116,
	},
	.salt = {
		.data = {
			0xca, 0xfe, 0xba, 0xbe
		},
		.len = 4,
	},

	.iv = {
		.data = {
			0xfa, 0xce, 0xdb, 0xad, 0xde, 0xca, 0xf8, 0x88
		},
	},

	.ipsec_xform = {
		.spi = 0xa5f8,
		.options.esn = 0,
		.options.udp_encap = 0,
		.options.copy_dscp = 0,
		.options.copy_flabel = 0,
		.options.copy_df = 0,
		.options.dec_ttl = 0,
		.options.ecn = 0,
		.options.stats = 0,
		.options.tunnel_hdr_verify = 0,
		.options.ip_csum_enable = 0,
		.options.l4_csum_enable = 0,
		.direction = RTE_SECURITY_IPSEC_SA_DIR_EGRESS,
		.proto = RTE_SECURITY_IPSEC_SA_PROTO_ESP,
		.mode = RTE_SECURITY_IPSEC_SA_MODE_TUNNEL,
		.tunnel.type = RTE_SECURITY_IPSEC_TUNNEL_IPV4,
		.replay_win_sz = 0,
	},

	.aead = true,

	.xform = {
		.aead = {
			.next = NULL,
			.type = RTE_CRYPTO_SYM_XFORM_AEAD,
			.aead = {
				.op = RTE_CRYPTO_AEAD_OP_ENCRYPT,
				.algo = RTE_CRYPTO_AEAD_AES_GCM,
				.key.length = 16,
				.iv.length = 12,
				.iv.offset = IV_OFFSET,
				.digest_length = 16,
				.aad_length = 12,
			},
		},
	},
};

struct ipsec_test_data pkt_aes_192_gcm = {
	.key = {
		.data = {
			0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,
			0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,
			0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c
		},
	},
	.input_text = {
		.data = {
			/* IP */
			0x45, 0x00, 0x00, 0x28, 0xa4, 0xad, 0x40, 0x00,
			0x40, 0x06, 0x78, 0x80, 0x0a, 0x01, 0x03, 0x8f,
			0x0a, 0x01, 0x06, 0x12,

			/* TCP */
			0x80, 0x23, 0x06, 0xb8, 0xcb, 0x71, 0x26, 0x02,
			0xdd, 0x6b, 0xb0, 0x3e, 0x50, 0x10, 0x16, 0xd0,
			0x75, 0x67, 0x00, 0x01
		},
		.len = 40,
	},
	.output_text = {
		.data = {
			/* IP - outer header */
			0x45, 0x00, 0x00, 0x60, 0x69, 0x8f, 0x00, 0x00,
			0x80, 0x32, 0x4d, 0x89, 0xc0, 0xa8, 0x01, 0x02,
			0xc0, 0xa8, 0x01, 0x01,

			/* ESP */
			0x00, 0x00, 0xa5, 0xf8, 0x00, 0x00, 0x00, 0x01,

			/* IV */
			0xfa, 0xce, 0xdb, 0xad, 0xde, 0xca, 0xf8, 0x88,

			/* Data */
			0xa5, 0xb1, 0xf8, 0x06, 0x60, 0x29, 0xae, 0xa4,
			0x0e, 0x59, 0x8b, 0x81, 0x22, 0xde, 0x02, 0x42,
			0x09, 0x38, 0xb3, 0xab, 0x33, 0xf8, 0x28, 0xe6,
			0x87, 0xb8, 0x85, 0x8b, 0x5b, 0xfb, 0xdb, 0xd0,
			0x31, 0x5b, 0x27, 0x45, 0x21, 0x4b, 0xcc, 0x77,
			0x82, 0xac, 0x91, 0x38, 0xf2, 0xbb, 0xbe, 0xe4,
			0xcf, 0x03, 0x36, 0x89, 0xdd, 0x40, 0xd3, 0x6e,
			0x54, 0x05, 0x22, 0x22,
		},
		.len = 96,
	},
	.salt = {
		.data = {
			0xca, 0xfe, 0xba, 0xbe
		},
		.len = 4,
	},

	.iv = {
		.data = {
			0xfa, 0xce, 0xdb, 0xad, 0xde, 0xca, 0xf8, 0x88
		},
	},

	.ipsec_xform = {
		.spi = 0xa5f8,
		.options.esn = 0,
		.options.udp_encap = 0,
		.options.copy_dscp = 0,
		.options.copy_flabel = 0,
		.options.copy_df = 0,
		.options.dec_ttl = 0,
		.options.ecn = 0,
		.options.stats = 0,
		.options.tunnel_hdr_verify = 0,
		.options.ip_csum_enable = 0,
		.options.l4_csum_enable = 0,
		.direction = RTE_SECURITY_IPSEC_SA_DIR_EGRESS,
		.proto = RTE_SECURITY_IPSEC_SA_PROTO_ESP,
		.mode = RTE_SECURITY_IPSEC_SA_MODE_TUNNEL,
		.tunnel.type = RTE_SECURITY_IPSEC_TUNNEL_IPV4,
		.replay_win_sz = 0,
	},

	.aead = true,

	.xform = {
		.aead = {
			.next = NULL,
			.type = RTE_CRYPTO_SYM_XFORM_AEAD,
			.aead = {
				.op = RTE_CRYPTO_AEAD_OP_ENCRYPT,
				.algo = RTE_CRYPTO_AEAD_AES_GCM,
				.key.length = 24,
				.iv.length = 12,
				.iv.offset = IV_OFFSET,
				.digest_length = 16,
				.aad_length = 12,
			},
		},
	},
};

struct ipsec_test_data pkt_aes_256_gcm = {
	.key = {
		.data = {
			0xab, 0xbc, 0xcd, 0xde, 0xf0, 0x01, 0x12, 0x23,
			0x34, 0x45, 0x56, 0x67, 0x78, 0x89, 0x9a, 0xab,
			0xab, 0xbc, 0xcd, 0xde, 0xf0, 0x01, 0x12, 0x23,
			0x34, 0x45, 0x56, 0x67, 0x78, 0x89, 0x9a, 0xab,
		},
	},
	.input_text = {
		.data = {
			/* IP */
			0x45, 0x00, 0x00, 0x30, 0x69, 0xa6, 0x40, 0x00,
			0x80, 0x06, 0x26, 0x90, 0xc0, 0xa8, 0x01, 0x02,
			0x93, 0x89, 0x15, 0x5e,

			/* TCP */
			0x0a, 0x9e, 0x00, 0x8b, 0x2d, 0xc5, 0x7e, 0xe0,
			0x00, 0x00, 0x00, 0x00, 0x70, 0x02, 0x40, 0x00,
			0x20, 0xbf, 0x00, 0x00, 0x02, 0x04, 0x05, 0xb4,
			0x01, 0x01, 0x04, 0x02,
		},
		.len = 48,
	},
	.output_text = {
		.data = {
			/* IP - outer header */
			0x45, 0x00, 0x00, 0x68, 0x69, 0x8f, 0x00, 0x00,
			0x80, 0x32, 0x4d, 0x81, 0xc0, 0xa8, 0x01, 0x02,
			0xc0, 0xa8, 0x01, 0x01,

			/* ESP */
			0x4a, 0x2c, 0xbf, 0xe3, 0x00, 0x00, 0x00, 0x01,

			/* IV */
			0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,

			/* Data */
			0xff, 0x42, 0x5c, 0x9b, 0x72, 0x45, 0x99, 0xdf,
			0x7a, 0x3b, 0xcd, 0x51, 0x01, 0x94, 0xe0, 0x0d,
			0x6a, 0x78, 0x10, 0x7f, 0x1b, 0x0b, 0x1c, 0xbf,
			0x06, 0xef, 0xae, 0x9d, 0x65, 0xa5, 0xd7, 0x63,
			0x74, 0x8a, 0x63, 0x79, 0x85, 0x77, 0x1d, 0x34,
			0x7f, 0x05, 0x45, 0x65, 0x9f, 0x14, 0xe9, 0x9d,
			0xef, 0x84, 0x2d, 0x8b, 0x00, 0x14, 0x4a, 0x1f,
			0xec, 0x6a, 0xdf, 0x0c, 0x9a, 0x92, 0x7f, 0xee,
			0xa6, 0xc5, 0x11, 0x60,
		},
		.len = 104,
	},
	.salt = {
		.data = {
			0x11, 0x22, 0x33, 0x44
		},
		.len = 4,
	},

	.iv = {
		.data = {
			0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08
		},
	},

	.ipsec_xform = {
		.spi = 0x4a2cbfe3,
		.options.esn = 0,
		.options.udp_encap = 0,
		.options.copy_dscp = 0,
		.options.copy_flabel = 0,
		.options.copy_df = 0,
		.options.dec_ttl = 0,
		.options.ecn = 0,
		.options.stats = 0,
		.options.tunnel_hdr_verify = 0,
		.options.ip_csum_enable = 0,
		.options.l4_csum_enable = 0,
		.direction = RTE_SECURITY_IPSEC_SA_DIR_EGRESS,
		.proto = RTE_SECURITY_IPSEC_SA_PROTO_ESP,
		.mode = RTE_SECURITY_IPSEC_SA_MODE_TUNNEL,
		.tunnel.type = RTE_SECURITY_IPSEC_TUNNEL_IPV4,
		.replay_win_sz = 0,
	},

	.aead = true,

	.xform = {
		.aead = {
			.next = NULL,
			.type = RTE_CRYPTO_SYM_XFORM_AEAD,
			.aead = {
				.op = RTE_CRYPTO_AEAD_OP_ENCRYPT,
				.algo = RTE_CRYPTO_AEAD_AES_GCM,
				.key.length = 32,
				.iv.length = 12,
				.iv.offset = IV_OFFSET,
				.digest_length = 16,
				.aad_length = 12,
			},
		},
	},
};

#endif /* TEST_CRYPTODEV_SECURITY_IPSEC_TEST_VECTORS_H_ */
