/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.history;

import vlcskineditor.Main;
import vlcskineditor.history.DummyEvent;
import vlcskineditor.history.HistoryEvent;

public class History {
    private HistoryEvent root;
    private HistoryEvent current;
    private Main m;

    public History(Main main) {
        this.m = main;
        this.m.setUndoEnabled(false);
        this.m.setRedoEnabled(false);
        this.current = this.root = new DummyEvent();
    }

    public void addEvent(HistoryEvent historyEvent) {
        this.current.setNext(historyEvent);
        historyEvent.setPrevious(this.current);
        this.current = this.current.getNext();
        this.m.setRedoEnabled(false);
        this.m.setRedoString("");
        this.m.setUndoEnabled(true);
        this.m.setUndoString(this.current.getDescription());
        HistoryEvent historyEvent2 = this.current.getPrevious();
        for (int i = 1; i < 50 && historyEvent2.getPrevious() != null; ++i) {
            historyEvent2 = historyEvent2.getPrevious();
        }
        if (historyEvent2 != this.root) {
            historyEvent2.setPrevious(this.root);
        }
    }

    public void redo() {
        if (this.current.getNext() == null) {
            return;
        }
        this.current.getNext().redo();
        this.current = this.current.getNext();
        this.m.setRedoEnabled(this.current.getNext() != null);
        if (this.current.getNext() != null) {
            this.m.setRedoString(this.current.getNext().getDescription());
        } else {
            this.m.setRedoString("");
        }
        this.m.setUndoEnabled(true);
        this.m.setUndoString(this.current.getDescription());
        String string = this.m.getSelectedResource();
        this.m.s.updateResources();
        this.m.s.expandResource(string);
        String string2 = this.m.getSelectedInWindows();
        this.m.s.updateWindows();
        this.m.s.expandLayout(string2);
        String string3 = this.m.getSelectedItem();
        this.m.s.updateItems();
        this.m.s.expandItem(string3);
    }

    public void undo() {
        if (this.current == this.root) {
            return;
        }
        this.current.undo();
        this.current = this.current.getPrevious();
        this.m.setRedoEnabled(true);
        this.m.setRedoString(this.current.getNext().getDescription());
        this.m.setUndoEnabled(this.current != this.root);
        this.m.setUndoString(this.current.getDescription());
        String string = this.m.getSelectedResource();
        this.m.s.updateResources();
        this.m.s.expandResource(string);
        String string2 = this.m.getSelectedInWindows();
        this.m.s.updateWindows();
        this.m.s.expandLayout(string2);
        String string3 = this.m.getSelectedItem();
        this.m.s.updateItems();
        this.m.s.expandItem(string3);
    }
}

