/****************************************************************************
** libebml : parse EBML files, see http://embl.sourceforge.net/
**
** <file/class description>
**
** Copyright (C) 2002-2003 Steve Lhomme.  All rights reserved.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding an other license may use this file in accordance with 
** the Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.matroska.org/license/qpl/ for QPL licensing information.
** See http://www.matroska.org/license/gpl/ for GPL licensing information.
**
** Contact license@matroska.org if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

/*!
	\file
	\version \$Id: WinIOCallback.cpp,v 1.3 2003/05/24 10:55:58 robux4 Exp $
	\author Steve Lhomme     <robux4 @ users.sf.net>
*/

#include <cassert>

#include "WinIOCallback.h"

#include "Debug.h"

START_LIBEBML_NAMESPACE

WinIOCallback::WinIOCallback(TCHAR* Path, const open_mode aMode) 
	:mFile(NULL)
{
	assert(Path!=0);

	DWORD AccessMode, ShareMode, Disposition;

	switch (aMode)
	{
	case MODE_READ:
		AccessMode = GENERIC_READ;
		ShareMode = FILE_SHARE_READ;
		Disposition = OPEN_EXISTING;
		break;
	case MODE_WRITE:
		AccessMode = GENERIC_WRITE;
		ShareMode = 0;
		Disposition = OPEN_ALWAYS;
		break;
	case MODE_CREATE:
		AccessMode = GENERIC_WRITE;
		ShareMode = 0;
		Disposition = CREATE_ALWAYS;
		break;
	default:
		assert(false);
	}

	mFile = CreateFile(Path, AccessMode, ShareMode, NULL, Disposition, 0, NULL);

	EBML_TRACE("Successfully opened file \"%hs\" in mode \"%hs\". The handle is %p\n", Path, aMode, mFile);
}

WinIOCallback::~WinIOCallback()
{
	close();
}

void WinIOCallback::close()
{
	if (mFile) {
		CloseHandle(mFile);
		mFile = NULL;
	}
}

uint64 WinIOCallback::getFilePointer()
{
	if (!mFile) {
		return 0;
	}
	LONG Dummy = 0;
	return SetFilePointer(mFile, 0, &Dummy, FILE_CURRENT);
}

void WinIOCallback::setFilePointer(int64 Offset, seek_mode Mode)
{
	DWORD Method;
	switch(Mode)
	{
	case seek_beginning:
		Method=FILE_BEGIN;
		break;
	case seek_current:
		Method=FILE_CURRENT;
		break;
	case seek_end:
		Method=FILE_END;
		break;
	default:
		assert(false);
		break;
	}

	LONG High=Offset>>32;
	SetFilePointer(mFile, Offset&0xffffffff, &High, Method);
}

uint32 WinIOCallback::read(void*Buffer,size_t Size)
{
	DWORD BytesRead;
	if (!ReadFile(mFile, Buffer, Size, &BytesRead, NULL)) {
		return 0;
	}
	return BytesRead;
}

size_t WinIOCallback::write(const void*Buffer,size_t Size)
{
	DWORD BytesWriten;
	if (!WriteFile(mFile, Buffer, Size, &BytesWriten, NULL)) {
		return 0;
	}
	return BytesWriten;
}

END_LIBEBML_NAMESPACE
