/*****************************************************************************
 * interface.c
 * Main functions that are use by interfaces
 *****************************************************************************
 * Copyright (C) 1998, 1999, 2000, 2001 VideoLAN
 * $Id: interface.c,v 1.8 2001/04/29 03:41:49 nitrox Exp $
 *
 * Authors: Damien Lucas <nitrox@via.ecp.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include <arpa/inet.h>                                            /* types.h */
#include <stdlib.h>                                          /* malloc, free */
#include <pthread.h>                                       /* pthread_create */
#include <semaphore.h>                                               /* db.h */
#include <ucd-snmp/asn1.h>                                  /* snmp_switch.h */
#include <ucd-snmp/snmp_impl.h>                             /* snmp_switch.h */
#include <ucd-snmp/snmp_api.h>                              /* snmp_switch.h */

#include "../types.h"
#include "../logger.h"

#include "../snmp/snmp_switch.h"                       /* struct SNMP_switch */
#include "../db/db.h"                                    /* DB_machines_lock */
#include "telnet.h"                                             /* IF_telnet */
#include "../server/server.h"                          /* VS_reinit_switches */
#include "../vlanserver.h"                                            /* vs  */


/*****************************************************************************
 * IF_start : Starts the interface module
 *****************************************************************************
 * Called from the main part without argument it will start the telnetd
 *****************************************************************************/
ERR_CODE IF_start(void)
{
  pthread_t iftelnet;
  
  VS_log(LOGINFO,IF,"Creating the Interface..");  
  if (pthread_create(&iftelnet,NULL,IF_telnet,NULL))
  {
      return VS_R_PTHREAD;
  }
  return 0;
}

/*****************************************************************************
 * IF_reload: Order for a reload of DB
 *****************************************************************************
 * Called from any of the interface submodules
 * Warning: no return values hace been defined !
 *****************************************************************************/
ERR_CODE IF_reload(void)
{
  VS_reinit_switchs(vs->info_poller); 
  return 0;
}

/*****************************************************************************
 * IF_info: Order for info request
 *****************************************************************************
 * Called from any of the interface submodules
 * Return value: the answer (char *)
 *****************************************************************************/
char* IF_info(VS_MachineId mMac)
{
  unsigned int rc;
  struct DB_machines_elt* machine_elt;
  char* sMessage;
  struct SNMP_switch * zwitch;
  struct DB_port * port;
      

  sMessage=malloc(256*sizeof(char));

  rc=DB_machines_lock(vs->db, mMac, &machine_elt);
  if(rc)
  {
    sprintf(sMessage,"Mac not found in database\r\n");
  }
  else
  {
    rc=DB_switchs_port_lock(vs->db, machine_elt->switch_ip,\
                                     machine_elt->port, &port, &zwitch);
    if(rc)
    {
      sprintf(sMessage,"Mac found on switch:%s port:%u\r\n but switch"\
                               "unknown\r\n",VS_SID2A(machine_elt->switch_ip),\
                                                  (unsigned)machine_elt->port);
    }
    else
    {
      if(zwitch->machines[(unsigned)machine_elt->port]->next!=NULL)
      {
        sprintf(sMessage,"Mac found on switch:%s port:%u\r\n"\
                                           "mac is NOT alone on this port\r\n"\
                                                   " current VLAN is: %u\r\n",\
                                             VS_SID2A(machine_elt->switch_ip),\
                                                  (unsigned)machine_elt->port,\
                          (unsigned int)zwitch->ports[machine_elt->port].vlan);
            
      }
      else
      {
        sprintf(sMessage,"Mac found on switch:%s port:%u\r\n"\
                                               "mac is alone on this port\r\n"\
                                                   " current VLAN is: %u\r\n",\
                                             VS_SID2A(machine_elt->switch_ip),\
                                                  (unsigned)machine_elt->port,\
                          (unsigned int)zwitch->ports[machine_elt->port].vlan);
        
      }
    }
    
    
    
  }
  return sMessage; 
}
