/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.common;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Random;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDbPool;
import org.jrobin.core.RrdException;
import org.jrobin.core.Sample;
import org.videolan.vlma.common.VlServer;

public class VlServerFake
extends VlServer {
    public VlServerFake(String name, InetAddress ip) {
        super(name, ip);
    }

    public void updateSnmpData() {
        String rrdFile = this.createRrdFileIfNecessary();
        Random r = new Random();
        this.currentCpuLoad = (double)r.nextFloat() * 1.5;
        this.currentTrafficIn = r.nextInt(10000000);
        this.currentTrafficOut = r.nextInt(10000000);
        this.currentVlcCpu = r.nextFloat();
        this.currentVlcMem = r.nextFloat();
        try {
            RrdDbPool rrdPool = RrdDbPool.getInstance();
            RrdDb rrdDb = rrdPool.requestRrdDb(rrdFile);
            Sample sample = rrdDb.createSample();
            sample.setValue("cpu_load", this.currentCpuLoad);
            sample.setValue("traffic_in", (double)this.currentTrafficIn);
            sample.setValue("traffic_out", (double)this.currentTrafficOut);
            sample.setValue("vlc_cpu", this.currentVlcCpu);
            sample.setValue("vlc_mem", this.currentVlcMem);
            sample.update();
            rrdPool.release(rrdDb);
        }
        catch (RrdException e) {
            logger.error("Error while updating RRD data of " + this.getName(), e);
        }
        catch (IOException e) {
            logger.error("Error while updating RRD data of " + this.getName(), e);
        }
    }

    public boolean checkVLC() {
        return true;
    }
}

