/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.util.StringTokenizer;
import org.jrobin.core.RrdException;

class RpnCalculator {
    static final String VAR_PLACEHOLDER = "value";
    private static final byte TOK_VAR = 0;
    private static final byte TOK_NUM = 1;
    private static final byte TOK_PLUS = 2;
    private static final byte TOK_MINUS = 3;
    private static final byte TOK_MULT = 4;
    private static final byte TOK_DIV = 5;
    private static final byte TOK_MOD = 6;
    private static final byte TOK_SIN = 7;
    private static final byte TOK_COS = 8;
    private static final byte TOK_LOG = 9;
    private static final byte TOK_EXP = 10;
    private static final byte TOK_FLOOR = 11;
    private static final byte TOK_CEIL = 12;
    private static final byte TOK_ROUND = 13;
    private static final byte TOK_POW = 14;
    private static final byte TOK_ABS = 15;
    private static final byte TOK_SQRT = 16;
    private static final byte TOK_RANDOM = 17;
    private static final byte TOK_LT = 18;
    private static final byte TOK_LE = 19;
    private static final byte TOK_GT = 20;
    private static final byte TOK_GE = 21;
    private static final byte TOK_EQ = 22;
    private static final byte TOK_IF = 23;
    private static final byte TOK_MIN = 24;
    private static final byte TOK_MAX = 25;
    private static final byte TOK_LIMIT = 26;
    private static final byte TOK_DUP = 27;
    private static final byte TOK_EXC = 28;
    private static final byte TOK_POP = 29;
    private static final byte TOK_UN = 30;
    private static final byte TOK_UNKN = 31;
    private static final byte TOK_PI = 34;
    private static final byte TOK_E = 35;
    private static final byte TOK_AND = 36;
    private static final byte TOK_OR = 37;
    private static final byte TOK_XOR = 38;
    private String[] tokens;
    private byte[] tokenCodes;
    private double[] parsedDoubles;
    private RpnStack stack = new RpnStack();
    private String rpnExpression;
    private double value;

    RpnCalculator(String string) throws RrdException {
        this.rpnExpression = string;
        this.createTokens();
    }

    void setValue(double d) {
        this.value = d;
    }

    private void createTokens() throws RrdException {
        StringTokenizer stringTokenizer = new StringTokenizer(this.rpnExpression, ",");
        int n = stringTokenizer.countTokens();
        this.tokens = new String[n];
        this.tokenCodes = new byte[n];
        this.parsedDoubles = new double[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            byte by;
            String string;
            this.tokens[n2] = string = stringTokenizer.nextToken();
            this.tokenCodes[n2] = by = this.findTokenCode(string);
            if (by == 1) {
                this.parsedDoubles[n2] = Double.parseDouble(string);
            }
            ++n2;
        }
    }

    private byte findTokenCode(String string) throws RrdException {
        if (RpnCalculator.isVariable(string)) {
            return 0;
        }
        if (RpnCalculator.isNumber(string)) {
            return 1;
        }
        if (string.equals("+")) {
            return 2;
        }
        if (string.equals("-")) {
            return 3;
        }
        if (string.equals("*")) {
            return 4;
        }
        if (string.equals("/")) {
            return 5;
        }
        if (string.equals("%")) {
            return 6;
        }
        if (string.equals("SIN")) {
            return 7;
        }
        if (string.equals("COS")) {
            return 8;
        }
        if (string.equals("LOG")) {
            return 9;
        }
        if (string.equals("EXP")) {
            return 10;
        }
        if (string.equals("FLOOR")) {
            return 11;
        }
        if (string.equals("CEIL")) {
            return 12;
        }
        if (string.equals("ROUND")) {
            return 13;
        }
        if (string.equals("POW")) {
            return 14;
        }
        if (string.equals("ABS")) {
            return 15;
        }
        if (string.equals("SQRT")) {
            return 16;
        }
        if (string.equals("RANDOM")) {
            return 17;
        }
        if (string.equals("LT")) {
            return 18;
        }
        if (string.equals("LE")) {
            return 19;
        }
        if (string.equals("GT")) {
            return 20;
        }
        if (string.equals("GE")) {
            return 21;
        }
        if (string.equals("EQ")) {
            return 22;
        }
        if (string.equals("IF")) {
            return 23;
        }
        if (string.equals("MIN")) {
            return 24;
        }
        if (string.equals("MAX")) {
            return 25;
        }
        if (string.equals("LIMIT")) {
            return 26;
        }
        if (string.equals("DUP")) {
            return 27;
        }
        if (string.equals("EXC")) {
            return 28;
        }
        if (string.equals("POP")) {
            return 29;
        }
        if (string.equals("UN")) {
            return 30;
        }
        if (string.equals("UNKN")) {
            return 31;
        }
        if (string.equals("PI")) {
            return 34;
        }
        if (string.equals("E")) {
            return 35;
        }
        if (string.equals("AND")) {
            return 36;
        }
        if (string.equals("OR")) {
            return 37;
        }
        if (string.equals("XOR")) {
            return 38;
        }
        throw new RrdException("Unknown RPN token encountered: " + string);
    }

    private static boolean isNumber(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean isVariable(String string) {
        return string.equals(VAR_PLACEHOLDER);
    }

    double calculate() throws RrdException {
        this.resetCalculator();
        block39: for (int i = 0; i < this.tokenCodes.length; ++i) {
            byte by = this.tokenCodes[i];
            switch (by) {
                case 1: {
                    this.push(this.parsedDoubles[i]);
                    continue block39;
                }
                case 0: {
                    this.push(this.value);
                    continue block39;
                }
                case 2: {
                    this.push(this.pop() + this.pop());
                    continue block39;
                }
                case 3: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 - d3);
                    continue block39;
                }
                case 4: {
                    this.push(this.pop() * this.pop());
                    continue block39;
                }
                case 5: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 / d3);
                    continue block39;
                }
                case 6: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 % d3);
                    continue block39;
                }
                case 7: {
                    this.push(Math.sin(this.pop()));
                    continue block39;
                }
                case 8: {
                    this.push(Math.cos(this.pop()));
                    continue block39;
                }
                case 9: {
                    this.push(Math.log(this.pop()));
                    continue block39;
                }
                case 10: {
                    this.push(Math.exp(this.pop()));
                    continue block39;
                }
                case 11: {
                    this.push(Math.floor(this.pop()));
                    continue block39;
                }
                case 12: {
                    this.push(Math.ceil(this.pop()));
                    continue block39;
                }
                case 13: {
                    this.push(Math.round(this.pop()));
                    continue block39;
                }
                case 14: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(Math.pow(d2, d3));
                    continue block39;
                }
                case 15: {
                    this.push(Math.abs(this.pop()));
                    continue block39;
                }
                case 16: {
                    this.push(Math.sqrt(this.pop()));
                    continue block39;
                }
                case 17: {
                    this.push(Math.random());
                    continue block39;
                }
                case 18: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 < d3 ? 1.0 : 0.0);
                    continue block39;
                }
                case 19: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 <= d3 ? 1.0 : 0.0);
                    continue block39;
                }
                case 20: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 > d3 ? 1.0 : 0.0);
                    continue block39;
                }
                case 21: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 >= d3 ? 1.0 : 0.0);
                    continue block39;
                }
                case 22: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 == d3 ? 1.0 : 0.0);
                    continue block39;
                }
                case 23: {
                    double d = this.pop();
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 != 0.0 ? d3 : d);
                    continue block39;
                }
                case 24: {
                    this.push(Math.min(this.pop(), this.pop()));
                    continue block39;
                }
                case 25: {
                    this.push(Math.max(this.pop(), this.pop()));
                    continue block39;
                }
                case 26: {
                    double d = this.pop();
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 < d3 || d2 > d ? Double.NaN : d2);
                    continue block39;
                }
                case 27: {
                    double d2 = this.pop();
                    this.push(d2);
                    this.push(d2);
                    continue block39;
                }
                case 28: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d3);
                    this.push(d2);
                    continue block39;
                }
                case 29: {
                    this.pop();
                    continue block39;
                }
                case 30: {
                    this.push(Double.isNaN(this.pop()) ? 1.0 : 0.0);
                    continue block39;
                }
                case 31: {
                    this.push(Double.NaN);
                    continue block39;
                }
                case 34: {
                    this.push(Math.PI);
                    continue block39;
                }
                case 35: {
                    this.push(Math.E);
                    continue block39;
                }
                case 36: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 != 0.0 && d3 != 0.0 ? 1.0 : 0.0);
                    continue block39;
                }
                case 37: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 != 0.0 || d3 != 0.0 ? 1.0 : 0.0);
                    continue block39;
                }
                case 38: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 != 0.0 && d3 == 0.0 || d2 == 0.0 && d3 != 0.0 ? 1.0 : 0.0);
                    continue block39;
                }
                default: {
                    throw new RrdException("Unexpected RPN token encountered [" + by + "]");
                }
            }
        }
        double d = this.pop();
        if (!this.isStackEmpty()) {
            throw new RrdException("Stack not empty at the end of calculation. Probably bad RPN expression");
        }
        return d;
    }

    void push(double d) throws RrdException {
        this.stack.push(d);
    }

    double pop() throws RrdException {
        return this.stack.pop();
    }

    void resetCalculator() {
        this.stack.reset();
    }

    boolean isStackEmpty() {
        return this.stack.isEmpty();
    }

    class RpnStack {
        static final int MAX_STACK_SIZE = 1000;
        private double[] stack = new double[1000];
        private int pos = 0;

        RpnStack() {
        }

        void push(double d) throws RrdException {
            if (this.pos >= 1000) {
                throw new RrdException("PUSH failed, RPN stack full [1000]");
            }
            this.stack[this.pos++] = d;
        }

        double pop() throws RrdException {
            if (this.pos <= 0) {
                throw new RrdException("POP failed, RPN stack is empty ");
            }
            return this.stack[--this.pos];
        }

        void reset() {
            this.pos = 0;
        }

        boolean isEmpty() {
            return this.pos == 0;
        }
    }
}

