/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.io.IOException;
import java.util.ArrayList;
import org.jrobin.core.FetchData;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.RrdBackendFactory;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdOpener;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.FetchSourceList;
import org.jrobin.graph.ValueExtractor;

class FetchSource {
    protected static final int AVG = 0;
    protected static final int MAX = 1;
    protected static final int MIN = 2;
    protected static final int LAST = 3;
    protected static final int MAX_CF = 4;
    protected static final String[] cfNames = new String[]{"AVERAGE", "MAX", "MIN", "LAST"};
    private RrdDb rrd;
    private RrdDef rrdDef;
    private String rrdFile;
    private String backendName;
    private int numSources = 0;
    private ArrayList[] datasources = new ArrayList[4];
    private FetchSourceList listReference = null;

    protected FetchSource(String string, FetchSourceList fetchSourceList) {
        this.rrdFile = string;
        this.listReference = fetchSourceList;
        for (int i = 0; i < this.datasources.length; ++i) {
            this.datasources[i] = new ArrayList(10);
        }
    }

    protected FetchSource(String string, String string2, String string3, String string4, FetchSourceList fetchSourceList) throws RrdException {
        this(string, fetchSourceList);
        this.addSource(string2, string3, string4);
    }

    protected FetchSource(String string, String string2, String string3, String string4, String string5, FetchSourceList fetchSourceList) throws RrdException {
        this(string, string2, string3, string4, fetchSourceList);
        this.setBackendFactory(string5);
    }

    protected void addSource(String string, String string2, String string3) throws RrdException {
        if (string.equalsIgnoreCase("AVERAGE") || string.equalsIgnoreCase("AVG")) {
            this.datasources[0].add(new String[]{string2, string3});
        } else if (string.equalsIgnoreCase("MAX") || string.equalsIgnoreCase("MAXIMUM")) {
            this.datasources[1].add(new String[]{string2, string3});
        } else if (string.equalsIgnoreCase("MIN") || string.equalsIgnoreCase("MINIMUM")) {
            this.datasources[2].add(new String[]{string2, string3});
        } else if (string.equalsIgnoreCase("LAST")) {
            this.datasources[3].add(new String[]{string2, string3});
        } else {
            throw new RrdException("Invalid consolidation function specified.");
        }
        ++this.numSources;
    }

    protected void setBackendFactory(String string) {
        this.backendName = string;
    }

    protected ValueExtractor fetch(long l, long l2, long l3, int n) throws IOException, RrdException {
        if (this.rrd == null) {
            this.openRrd();
        }
        int n2 = 0;
        long l4 = this.rrdDef.getStep();
        FetchData[] fetchDataArray = new FetchData[this.datasources.length];
        String[] stringArray = new String[this.numSources];
        int n3 = 0;
        for (int i = 0; i < this.datasources.length; ++i) {
            Object object;
            n2 = this.datasources[i].size();
            if (n2 <= 0) continue;
            String[] stringArray2 = new String[n2];
            String[] stringArray3 = new String[n2];
            for (int j = 0; j < n2; ++j) {
                object = (String[])this.datasources[i].get(j);
                stringArray2[j] = object[0];
                stringArray3[j] = object[1];
            }
            FetchRequest fetchRequest = this.rrd.createFetchRequest(cfNames[i], l, l2, l3);
            fetchRequest.setFilter(stringArray2);
            object = fetchRequest.fetchData();
            for (int j = 0; j < n2; ++j) {
                stringArray[((FetchData)object).getDsIndex((String)stringArray2[j]) + n3] = stringArray3[j];
            }
            n3 += n2;
            fetchDataArray[i] = object;
        }
        return new ValueExtractor(stringArray, fetchDataArray, n);
    }

    protected void openRrd() throws RrdException, IOException {
        if (this.rrd == null) {
            RrdOpener rrdOpener = this.listReference.getRrdOpener();
            if (rrdOpener == null) {
                throw new RrdException("No RrdOpener specified for RRD management.");
            }
            if (this.rrd == null) {
                this.rrd = rrdOpener.getRrd(this.rrdFile, this.getRrdBackendFactory());
            }
            this.rrdDef = this.rrd.getRrdDef();
        }
    }

    protected RrdDb getRrd() throws RrdException, IOException {
        if (this.rrd == null) {
            this.openRrd();
        }
        return this.rrd;
    }

    protected void release() throws RrdException, IOException {
        if (this.rrd != null) {
            RrdOpener rrdOpener = this.listReference.getRrdOpener();
            if (rrdOpener == null) {
                throw new RrdException("No RrdOpener specified for RRD management.");
            }
            rrdOpener.releaseRrd(this.rrd);
            this.rrd = null;
        }
    }

    protected long getLastSampleTime(long l, long l2, long l3) throws RrdException, IOException {
        if (this.rrd == null) {
            this.openRrd();
        }
        long l4 = Long.MAX_VALUE;
        long l5 = 0L;
        for (int i = 0; i < this.datasources.length; ++i) {
            if (this.datasources[i].size() <= 0 || (l5 = this.rrd.findStartMatchArchive(cfNames[i], l, l3).getEndTime()) >= l4) continue;
            l4 = l5;
        }
        return l4;
    }

    protected long[] getFetchStep(long l, long l2, long l3) throws RrdException, IOException {
        if (this.rrd == null) {
            this.openRrd();
        }
        long l4 = Long.MIN_VALUE;
        long l5 = Long.MAX_VALUE;
        long l6 = 0L;
        for (int i = 0; i < this.datasources.length; ++i) {
            if (this.datasources[i].size() <= 0) continue;
            FetchRequest fetchRequest = this.rrd.createFetchRequest(cfNames[i], l, l2, l3);
            l6 = this.rrd.findMatchingArchive(fetchRequest).getArcStep();
            if (l6 < l5) {
                l5 = l6;
            }
            if (l6 <= l4) continue;
            l4 = l6;
        }
        return new long[]{l5, l4};
    }

    protected String getRrdFile() {
        return this.rrdFile;
    }

    protected RrdBackendFactory getRrdBackendFactory() throws RrdException {
        if (this.backendName != null) {
            return RrdBackendFactory.getFactory(this.backendName);
        }
        return RrdBackendFactory.getDefaultFactory();
    }

    public void exportXml(XmlWriter xmlWriter) {
        for (int i = 0; i < this.datasources.length; ++i) {
            for (int j = 0; j < this.datasources[i].size(); ++j) {
                String[] stringArray = (String[])this.datasources[i].get(j);
                xmlWriter.startTag("def");
                xmlWriter.writeTag("name", stringArray[1]);
                xmlWriter.writeTag("rrd", this.rrdFile);
                xmlWriter.writeTag("source", stringArray[0]);
                xmlWriter.writeTag("cf", cfNames[i]);
                xmlWriter.closeTag();
            }
        }
    }
}

