/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.io.File;
import java.io.IOException;
import java.util.GregorianCalendar;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlTemplate;
import org.jrobin.graph.ExportData;
import org.jrobin.graph.RrdExportDef;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RrdExportDefTemplate
extends XmlTemplate {
    private RrdExportDef def;

    public RrdExportDefTemplate(InputSource inputSource) throws IOException, RrdException {
        super(inputSource);
    }

    public RrdExportDefTemplate(File file) throws IOException, RrdException {
        super(file);
    }

    public RrdExportDefTemplate(String string) throws IOException, RrdException {
        super(string);
    }

    public RrdExportDef getRrdExportDef() throws RrdException {
        if (!this.root.getTagName().equals("rrd_export_def")) {
            throw new RrdException("XML definition must start with <rrd_export_def>");
        }
        this.validateTagsOnlyOnce(this.root, new String[]{"span", "options", "datasources", "exports"});
        this.def = new RrdExportDef();
        Node[] nodeArray = RrdExportDefTemplate.getChildNodes(this.root);
        for (int i = 0; i < nodeArray.length; ++i) {
            String string = nodeArray[i].getNodeName();
            if (string.equals("span")) {
                this.resolveSpan(nodeArray[i]);
                continue;
            }
            if (string.equals("options")) {
                this.resolveOptions(nodeArray[i]);
                continue;
            }
            if (string.equals("datasources")) {
                this.resolveDatasources(nodeArray[i]);
                continue;
            }
            if (!string.equals("exports")) continue;
            this.resolveExports(nodeArray[i]);
        }
        return this.def;
    }

    private void resolveExports(Node node) throws RrdException {
        this.validateTagsOnlyOnce(node, new String[]{"export*"});
        Node[] nodeArray = RrdExportDefTemplate.getChildNodes(node, "export");
        for (int i = 0; i < nodeArray.length; ++i) {
            this.validateTagsOnlyOnce(nodeArray[i], new String[]{"datasource", "legend"});
            String string = this.getChildValue(nodeArray[i], "datasource");
            String string2 = this.getChildValue(nodeArray[i], "legend");
            this.def.export(string, string2);
        }
    }

    private void resolveDatasources(Node node) throws RrdException {
        String string;
        String string2;
        int n;
        this.validateTagsOnlyOnce(node, new String[]{"def*", "export_data*"});
        Node[] nodeArray = RrdExportDefTemplate.getChildNodes(node, "def");
        for (n = 0; n < nodeArray.length; ++n) {
            String string3;
            if (this.hasChildNode(nodeArray[n], "rrd")) {
                this.validateTagsOnlyOnce(nodeArray[n], new String[]{"name", "rrd", "source", "cf", "backend"});
                string2 = this.getChildValue(nodeArray[n], "name");
                string = this.getChildValue(nodeArray[n], "rrd");
                string3 = this.getChildValue(nodeArray[n], "source");
                String string4 = this.getChildValue(nodeArray[n], "cf");
                if (Util.Xml.hasChildNode(nodeArray[n], "backend")) {
                    String string5 = this.getChildValue(nodeArray[n], "backend");
                    this.def.datasource(string2, string, string3, string4, string5);
                    continue;
                }
                this.def.datasource(string2, string, string3, string4);
                continue;
            }
            if (this.hasChildNode(nodeArray[n], "rpn")) {
                this.validateTagsOnlyOnce(nodeArray[n], new String[]{"name", "rpn"});
                string2 = this.getChildValue(nodeArray[n], "name");
                string = this.getChildValue(nodeArray[n], "rpn");
                this.def.datasource(string2, string);
                continue;
            }
            if (this.hasChildNode(nodeArray[n], "cf") || this.hasChildNode(nodeArray[n], "datasource")) {
                this.validateTagsOnlyOnce(nodeArray[n], new String[]{"name", "datasource", "cf"});
                string2 = this.getChildValue(nodeArray[n], "name");
                string = this.getChildValue(nodeArray[n], "datasource");
                string3 = this.getChildValue(nodeArray[n], "cf");
                this.def.datasource(string2, string, string3);
                continue;
            }
            throw new RrdException("Unrecognized <def> format");
        }
        nodeArray = RrdExportDefTemplate.getChildNodes(node, "export_data");
        for (n = 0; n < nodeArray.length; ++n) {
            this.validateTagsOnlyOnce(nodeArray[n], new String[]{"file", "ds_name_prefix", "use_legend_names"});
            string2 = this.getChildValue(nodeArray[n], "file");
            string = "d";
            boolean bl = false;
            if (Util.Xml.hasChildNode(nodeArray[n], "ds_name_prefix")) {
                string = this.getChildValue(nodeArray[n], "ds_name_prefix");
            }
            if (Util.Xml.hasChildNode(nodeArray[n], "use_legend_names")) {
                bl = this.getChildValueAsBoolean(nodeArray[n], "use_legend_names");
            }
            try {
                if (!string.equals("d")) {
                    this.def.addExportData(new ExportData(new File(string2), string));
                    continue;
                }
                this.def.addExportData(new ExportData(new File(string2), bl));
                continue;
            }
            catch (IOException iOException) {
                throw new RrdException(iOException);
            }
        }
    }

    private void resolveOptions(Node node) throws RrdException {
        this.validateTagsOnlyOnce(node, new String[]{"resolution", "strict_export"});
        Node[] nodeArray = RrdExportDefTemplate.getChildNodes(node);
        for (int i = 0; i < nodeArray.length; ++i) {
            String string = nodeArray[i].getNodeName();
            Node node2 = nodeArray[i];
            if (string.equals("strict_export")) {
                this.def.setStrictExport(this.getValueAsBoolean(node2));
                continue;
            }
            if (!string.equals("resolution")) continue;
            this.def.setResolution(this.getValueAsInt(node2));
        }
    }

    private void resolveSpan(Node node) throws RrdException {
        this.validateTagsOnlyOnce(node, new String[]{"start", "end"});
        String string = this.getChildValue(node, "start");
        String string2 = this.getChildValue(node, "end");
        GregorianCalendar gregorianCalendar = Util.getGregorianCalendar(string);
        GregorianCalendar gregorianCalendar2 = Util.getGregorianCalendar(string2);
        this.def.setTimePeriod(gregorianCalendar, gregorianCalendar2);
    }
}

