/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 *
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.retriever;

import java.net.SocketException;

import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.videolan.vlma.model.Server;

import snmp.SNMPSequence;
import snmp.SNMPVarBindList;
import snmp.SNMPv1CommunicationInterface;

public class SnmpDataRetriever implements DataRetriever {

    private static final Logger logger = Logger.getLogger(SnmpDataRetriever.class);

    private Configuration configuration;

    public String retrieve(Server server, Data data) {
        SNMPv1CommunicationInterface comm;
        try {
            comm = new SNMPv1CommunicationInterface(0, server.getIp(), configuration.getString("vlc.snmp.community"));
        } catch (SocketException e) {
            logger.error("Cannot contact SNMP server of " + server);
            return null;
        }
        String[] oid = {
            configuration.getString("vlc.snmp.oid." + data.name().toLowerCase())
        };
        SNMPVarBindList varList;
        try {
            varList = comm.getMIBEntry(oid);
            SNMPSequence pair = (SNMPSequence) (varList.getSNMPObjectAt(0));
            return pair.getSNMPObjectAt(1).toString().trim();
        } catch (Exception e) {
            logger.error("Cannot retrieve data. OID: " + oid[0] + ", server: " + server.getName(), e);
            return null;
        }
    }

    /**
     * @param configuration the configuration to set
     */
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

}
